/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.configurationStore.schemeManager.SchemeListManagerKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0017\u0012\u0010\u0010\u0003\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u001b\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0002J\"\u0010\u001c\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013J3\u0010\u001f\u001a\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\b\u0010!\u001a\u0004\u0018\u00018\u00002\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010#\u00a2\u0006\u0002\u0010$R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u0003\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR@\u0010\u000f\u001a4\u00120\u0012.\u0012\f\u0012\n \u0011*\u0004\u0018\u00018\u00008\u0000 \u0011*\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00018\u00008\u00000\u0013\u00a2\u0006\u0002\b\u00120\f\u00a2\u0006\u0002\b\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeListManager;", "T", "", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "(Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;)V", "readOnlyExternalizableSchemes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl", "()Ljava/util/concurrent/ConcurrentHashMap;", "schemes", "", "getSchemes", "()Ljava/util/List;", "schemesRef", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "addScheme", "", "scheme", "replaceExisting", "", "(Ljava/lang/Object;Z)V", "collectExistingNames", "", "replaceSchemeList", "oldList", "newList", "setSchemes", "newSchemes", "newCurrentScheme", "removeCondition", "Ljava/util/function/Predicate;", "(Ljava/util/List;Ljava/lang/Object;Ljava/util/function/Predicate;)V", "intellij.platform.configurationStore.impl"})
public final class SchemeListManager<T> {
    private final AtomicReference<List<T>> schemesRef;
    @NotNull
    private final ConcurrentHashMap<String, T> readOnlyExternalizableSchemes;
    private final SchemeManagerImpl<T, ?> schemeManager;

    @NotNull
    public final ConcurrentHashMap<String, T> getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl() {
        return this.readOnlyExternalizableSchemes;
    }

    @NotNull
    public final List<T> getSchemes() {
        List<T> list = this.schemesRef.get();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"schemesRef.get()");
        return list;
    }

    public final void replaceSchemeList(@NotNull List<? extends T> oldList, @NotNull List<? extends T> newList) {
        Intrinsics.checkParameterIsNotNull(oldList, (String)"oldList");
        Intrinsics.checkParameterIsNotNull(newList, (String)"newList");
        if (!this.schemesRef.compareAndSet(oldList, ContainerUtil.createLockFreeCopyOnWriteList((Collection)newList))) {
            throw (Throwable)new IllegalStateException("Scheme list was modified");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addScheme(@NotNull T scheme2, boolean replaceExisting) {
        Intrinsics.checkParameterIsNotNull(scheme2, (String)"scheme");
        int toReplace = -1;
        List<T> schemes = this.getSchemes();
        SchemeProcessor processor2 = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl();
        ConcurrentMap<T, ExternalInfo> schemeToInfo = this.schemeManager.getSchemeToInfo$intellij_platform_configurationStore_impl();
        boolean bl = false;
        for (Object existing : (Iterable)schemes) {
            void index;
            if (!(Intrinsics.areEqual((Object)processor2.getSchemeKey(existing), (Object)processor2.getSchemeKey(scheme2)) ^ true)) {
                ExternalInfo oldInfo;
                toReplace = index;
                if (existing == scheme2) break;
                if (Intrinsics.areEqual(existing.getClass(), scheme2.getClass()) ^ true) {
                    ComponentStoreImplKt.getLOG().warn('\'' + processor2.getSchemeKey(scheme2) + "' " + existing.getClass().getSimpleName() + " replaced with " + scheme2.getClass().getSimpleName());
                }
                if (replaceExisting && processor2.isExternalizable(existing) && (oldInfo = (ExternalInfo)schemeToInfo.remove(existing)) != null && processor2.isExternalizable(scheme2) && !schemeToInfo.containsKey(scheme2)) {
                    schemeToInfo.put(scheme2, oldInfo);
                }
            }
            ++index;
        }
        if (toReplace == -1) {
            schemes.add(scheme2);
        } else if (replaceExisting || !processor2.isExternalizable(scheme2)) {
            if (schemes.get(toReplace) != scheme2) {
                schemes.set(toReplace, scheme2);
            }
        } else {
            ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme2;
            String string = UniqueNameGenerator.generateUniqueName((String)((ExternalizableScheme)scheme2).getName(), this.collectExistingNames((Collection)schemes));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UniqueNameGenerator.gene\u2026ctExistingNames(schemes))");
            SchemeListManagerKt.access$renameScheme(externalizableScheme, string);
            schemes.add(scheme2);
        }
        if (processor2.isExternalizable(scheme2)) {
            Object object = this.schemeManager.getFilesToDelete$intellij_platform_configurationStore_impl();
            boolean bl2 = false;
            if (!object.isEmpty()) {
                ExternalInfo externalInfo = (ExternalInfo)schemeToInfo.get(scheme2);
                if (externalInfo != null) {
                    object = externalInfo;
                    bl2 = false;
                    boolean bl3 = false;
                    Object it = object;
                    boolean bl4 = false;
                    this.schemeManager.getFilesToDelete$intellij_platform_configurationStore_impl().remove(((ExternalInfo)it).getFileName());
                }
            }
        }
        this.schemeManager.processPendingCurrentSchemeName$intellij_platform_configurationStore_impl(scheme2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSchemes(@NotNull List<? extends T> newSchemes, @Nullable T newCurrentScheme, @Nullable Predicate<T> removeCondition) {
        block11: {
            List list;
            AtomicReference<List<T>> atomicReference;
            block13: {
                List list2;
                void $this$filterSmart$iv;
                Collection collection;
                block12: {
                    Intrinsics.checkParameterIsNotNull(newSchemes, (String)"newSchemes");
                    collection = this.getSchemes();
                    boolean bl = false;
                    if (!(!collection.isEmpty())) break block11;
                    if (removeCondition != null) break block12;
                    this.getSchemes().clear();
                    break block11;
                }
                collection = this.getSchemes();
                atomicReference = this.schemesRef;
                boolean $i$f$filterSmart = false;
                switch ($this$filterSmart$iv.size()) {
                    case 1: {
                        list2 = (List)new SmartList();
                        break;
                    }
                    case 0: {
                        list = CollectionsKt.emptyList();
                        break block13;
                    }
                    default: {
                        list2 = new ArrayList();
                    }
                }
                List result$iv = list2;
                Iterable $this$filterTo$iv$iv = (Iterable)$this$filterSmart$iv;
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv;
                    Object it = element$iv$iv = iterator.next();
                    boolean bl = false;
                    if (!(!removeCondition.test(it))) continue;
                    ((Collection)result$iv).add(element$iv$iv);
                }
                list = result$iv;
            }
            List list3 = list;
            atomicReference.set((List<T>)ContainerUtil.createConcurrentList((Collection)list3));
        }
        this.getSchemes().addAll((Collection)newSchemes);
        Object oldCurrentScheme = this.schemeManager.getActiveScheme();
        this.schemeManager.retainExternalInfo$intellij_platform_configurationStore_impl(true);
        if (Intrinsics.areEqual(oldCurrentScheme, newCurrentScheme) ^ true) {
            Object newScheme = null;
            if (newCurrentScheme != null) {
                this.schemeManager.setActiveScheme$intellij_platform_configurationStore_impl(newCurrentScheme);
                newScheme = newCurrentScheme;
            } else if (oldCurrentScheme != null && !this.getSchemes().contains(oldCurrentScheme)) {
                newScheme = CollectionsKt.firstOrNull(this.getSchemes());
                this.schemeManager.setActiveScheme$intellij_platform_configurationStore_impl(newScheme);
            } else {
                newScheme = null;
            }
            if (Intrinsics.areEqual(oldCurrentScheme, newScheme) ^ true) {
                this.schemeManager.getProcessor$intellij_platform_configurationStore_impl().onCurrentSchemeSwitched(oldCurrentScheme, newScheme, false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> collectExistingNames(Collection<? extends T> schemes) {
        ObjectOpenHashSet result = new ObjectOpenHashSet(schemes.size());
        Iterable $this$mapTo$iv = schemes;
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv;
            Object t = item$iv = iterator.next();
            Collection collection = (Collection)result;
            boolean bl = false;
            String string = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey((Object)it);
            collection.add(string);
        }
        Collection cfr_ignored_0 = (Collection)result;
        return (Collection)result;
    }

    public SchemeListManager(@NotNull SchemeManagerImpl<T, ?> schemeManager) {
        Intrinsics.checkParameterIsNotNull(schemeManager, (String)"schemeManager");
        this.schemeManager = schemeManager;
        this.schemesRef = new AtomicReference<List>(ContainerUtil.createLockFreeCopyOnWriteList());
        this.readOnlyExternalizableSchemes = new ConcurrentHashMap();
    }
}

