/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.editor;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.ui.jcef.JBCefApp;
import com.jetbrains.rest.RestBundle;
import com.jetbrains.rest.editor.RestSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RestConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    public static final String ID = "restructured.text.topic";
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final ComboBox<String> myComboBox = new ComboBox();
    public static final String SWING = "Swing";
    public static final String JCEF = "JCEF";

    RestConfigurable() {
        if (JBCefApp.isSupported()) {
            this.myComboBox.addItem((Object)JCEF);
        }
        this.myComboBox.addItem((Object)SWING);
        this.myComboBox.setSelectedItem((Object)RestSettings.getInstance().getCurrentPanel());
        LabeledComponent component = new LabeledComponent();
        component.setComponent(this.myComboBox);
        component.setText(RestBundle.message("preview.panel", new Object[0]));
        component.setLabelLocation("West");
        this.myPanel.add((Component)component, "North");
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return RestBundle.message("configurable.RestConfigurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return ID;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public void reset() {
    }

    public boolean isModified() {
        return !RestSettings.getInstance().getCurrentPanel().equals(this.myComboBox.getSelectedItem());
    }

    public void apply() {
        String selectedItem = (String)this.myComboBox.getSelectedItem();
        if (selectedItem != null) {
            RestSettings.getInstance().setCurrentPanel(selectedItem);
        }
    }
}

