/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.PathUtil;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.LibraryOrderEntryBaseBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.ModifiableModuleLibraryTableBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.ModifiableRootModelBridgeKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.ModuleRootModelBridge;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BI\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012 \u0010\f\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a2\b\u0010\u001b\u001a\u0004\u0018\u0001H\u0018H\u0016\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\n\u0010(\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010)\u001a\u00020*H\u0016J\n\u0010+\u001a\u0004\u0018\u00010*H\u0016J\b\u0010,\u001a\u00020*H\u0016J\b\u0010-\u001a\u00020*H\u0002J\b\u0010.\u001a\u00020\u0007H\u0016J\b\u0010/\u001a\u00020%H\u0016J\b\u00100\u001a\u00020%H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00061"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/roots/LibraryOrderEntryBridge;", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/roots/LibraryOrderEntryBaseBridge;", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "Lcom/intellij/openapi/roots/impl/ClonableOrderEntry;", "rootModel", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/roots/ModuleRootModelBridge;", "index", "", "libraryDependencyItem", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleDependencyItem$Exportable$LibraryDependency;", "moduleLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "itemUpdater", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleDependencyItem;", "", "(Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/roots/ModuleRootModelBridge;ILcom/intellij/workspaceModel/storage/bridgeEntities/ModuleDependencyItem$Exportable$LibraryDependency;Lcom/intellij/openapi/roots/libraries/Library;Lkotlin/jvm/functions/Function1;)V", "getLibraryDependencyItem$intellij_platform_workspaceModel_ide", "()Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleDependencyItem$Exportable$LibraryDependency;", "rootProvider", "Lcom/intellij/openapi/roots/RootProvider;", "getRootProvider", "()Lcom/intellij/openapi/roots/RootProvider;", "accept", "R", "policy", "Lcom/intellij/openapi/roots/RootPolicy;", "initialValue", "(Lcom/intellij/openapi/roots/RootPolicy;Ljava/lang/Object;)Ljava/lang/Object;", "cloneEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "projectRootManager", "Lcom/intellij/openapi/roots/impl/ProjectRootManagerImpl;", "filePointerManager", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerManager;", "equals", "", "other", "", "getLibrary", "getLibraryLevel", "", "getLibraryName", "getPresentableName", "getPresentableNameForUnnamedLibrary", "hashCode", "isModuleLevel", "isSynthetic", "intellij.platform.workspaceModel.ide"})
public final class LibraryOrderEntryBridge
extends LibraryOrderEntryBaseBridge
implements LibraryOrderEntry,
ClonableOrderEntry {
    @NotNull
    private final ModuleDependencyItem.Exportable.LibraryDependency libraryDependencyItem;
    private final Library moduleLibrary;

    @NotNull
    public String getPresentableName() {
        String string = this.getLibraryName();
        if (string == null) {
            string = this.getPresentableNameForUnnamedLibrary();
        }
        return string;
    }

    private final String getPresentableNameForUnnamedLibrary() {
        String string;
        OrderRootType orderRootType = OrderRootType.CLASSES;
        Intrinsics.checkExpressionValueIsNotNull((Object)orderRootType, (String)"OrderRootType.CLASSES");
        String url = (String)ArraysKt.firstOrNull((Object[])this.getUrls(orderRootType));
        if (url != null) {
            String string2 = PathUtil.toPresentableUrl((String)url);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtil.toPresentableUrl(url)");
        } else {
            String string3 = ProjectModelBundle.message((String)"library.empty.library.item", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ProjectModelBundle.messa\u2026rary.empty.library.item\")");
        }
        return string;
    }

    @Override
    @Nullable
    protected RootProvider getRootProvider() {
        Library library = this.getLibrary();
        return library != null ? library.getRootProvider() : null;
    }

    @NotNull
    public String getLibraryLevel() {
        return this.libraryDependencyItem.getLibrary().getTableId().getLevel();
    }

    @Nullable
    public String getLibraryName() {
        return LibraryBridgeImpl.Companion.getLegacyLibraryName(this.libraryDependencyItem.getLibrary());
    }

    @Nullable
    public Library getLibrary() {
        Object object;
        LibraryId libraryId = this.libraryDependencyItem.getLibrary();
        Project project = this.getOwnerModuleBridge().getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ownerModuleBridge.project");
        Project project2 = project;
        LibraryTableId parentId = libraryId.getTableId();
        if (parentId instanceof LibraryTableId.ProjectLibraryTableId) {
            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel("project", project2);
            object = libraryTable != null ? libraryTable.getLibraryByName(libraryId.getName()) : null;
        } else if (parentId instanceof LibraryTableId.ModuleLibraryTableId) {
            object = this.moduleLibrary;
        } else if (parentId instanceof LibraryTableId.GlobalLibraryTableId) {
            LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
            object = libraryTablesRegistrar != null && (libraryTablesRegistrar = libraryTablesRegistrar.getLibraryTableByLevel(parentId.getLevel(), project2)) != null ? libraryTablesRegistrar.getLibraryByName(libraryId.getName()) : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Library library = object;
        return libraryId.getTableId() instanceof LibraryTableId.ModuleLibraryTableId ? library : this.getRootModel().getAccessor().getLibrary(library, this.getLibraryName(), this.getLibraryLevel());
    }

    public boolean isModuleLevel() {
        return Intrinsics.areEqual((Object)this.getLibraryLevel(), (Object)"module");
    }

    @Nullable
    public <R> R accept(@NotNull RootPolicy<R> policy, @Nullable R initialValue) {
        Intrinsics.checkParameterIsNotNull(policy, (String)"policy");
        return (R)policy.visitLibraryOrderEntry((LibraryOrderEntry)this, initialValue);
    }

    @Override
    @NotNull
    public OrderEntry cloneEntry(@NotNull ModifiableRootModel rootModel, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager) {
        LibraryBridgeImpl libraryBridgeImpl;
        LibraryTableId libraryTableId;
        Intrinsics.checkParameterIsNotNull((Object)rootModel, (String)"rootModel");
        Intrinsics.checkParameterIsNotNull((Object)((Object)projectRootManager), (String)"projectRootManager");
        Intrinsics.checkParameterIsNotNull((Object)filePointerManager, (String)"filePointerManager");
        if (Intrinsics.areEqual((Object)this.getLibraryLevel(), (Object)"module")) {
            Module module = rootModel.getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"rootModel.module");
            String string = module.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rootModel.module.name");
            libraryTableId = new LibraryTableId.ModuleLibraryTableId(new ModuleId(string));
        } else {
            libraryTableId = ModifiableRootModelBridgeKt.levelToLibraryTableId(this.getLibraryLevel());
        }
        LibraryTableId libraryTableId2 = libraryTableId;
        LibraryId libraryId = new LibraryId(this.libraryDependencyItem.getLibrary().getName(), libraryTableId2);
        ModuleDependencyItem.Exportable.LibraryDependency libraryDependencyItemCopy = ModuleDependencyItem.Exportable.LibraryDependency.copy$default(this.libraryDependencyItem, libraryId, false, null, 6, null);
        Library library = this.moduleLibrary;
        if (library != null) {
            Library library2 = library;
            boolean bl = false;
            boolean bl2 = false;
            Library it = library2;
            boolean bl3 = false;
            LibraryTable libraryTable = rootModel.getModuleLibraryTable();
            if (libraryTable == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.ModifiableModuleLibraryTableBridge");
            }
            ModifiableModuleLibraryTableBridge libraryTable2 = (ModifiableModuleLibraryTableBridge)libraryTable;
            Library library3 = it;
            if (library3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridgeImpl");
            }
            libraryBridgeImpl = libraryTable2.createLibraryCopy((LibraryBridgeImpl)library3);
        } else {
            libraryBridgeImpl = null;
        }
        LibraryBridgeImpl moduleLibraryCopy = libraryBridgeImpl;
        return new LibraryOrderEntryBridge((ModuleRootModelBridge)rootModel, this.getIndex(), libraryDependencyItemCopy, (Library)moduleLibraryCopy, null);
    }

    @Override
    public boolean isSynthetic() {
        return this.isModuleLevel();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LibraryOrderEntryBridge)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.moduleLibrary, (Object)((LibraryOrderEntryBridge)other).moduleLibrary) ^ true);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        Library library = this.moduleLibrary;
        result2 = 31 * result2 + (library != null ? library.hashCode() : 0);
        return result2;
    }

    @NotNull
    public final ModuleDependencyItem.Exportable.LibraryDependency getLibraryDependencyItem$intellij_platform_workspaceModel_ide() {
        return this.libraryDependencyItem;
    }

    public LibraryOrderEntryBridge(@NotNull ModuleRootModelBridge rootModel, int index, @NotNull ModuleDependencyItem.Exportable.LibraryDependency libraryDependencyItem, @Nullable Library moduleLibrary, @Nullable Function1<? super Function1<? super ModuleDependencyItem, ? extends ModuleDependencyItem>, Unit> itemUpdater) {
        Intrinsics.checkParameterIsNotNull((Object)rootModel, (String)"rootModel");
        Intrinsics.checkParameterIsNotNull((Object)libraryDependencyItem, (String)"libraryDependencyItem");
        super(rootModel, index, libraryDependencyItem, itemUpdater);
        this.libraryDependencyItem = libraryDependencyItem;
        this.moduleLibrary = moduleLibrary;
    }
}

