/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListSpeedSearch<T>
extends SpeedSearchBase<JList<T>> {
    @Nullable
    private final Function<? super T, String> myToStringConvertor;

    public ListSpeedSearch(@NotNull JList<T> list2) {
        if (list2 == null) {
            ListSpeedSearch.$$$reportNull$$$0(0);
        }
        super(list2);
        this.myToStringConvertor = null;
        this.registerSelectAll(list2);
    }

    public ListSpeedSearch(@NotNull JList<T> list2, @NotNull Function<? super T, String> convertor) {
        if (list2 == null) {
            ListSpeedSearch.$$$reportNull$$$0(1);
        }
        if (convertor == null) {
            ListSpeedSearch.$$$reportNull$$$0(2);
        }
        super(list2);
        this.myToStringConvertor = convertor;
        this.registerSelectAll(list2);
    }

    private void registerSelectAll(@NotNull JList<T> list2) {
        if (list2 == null) {
            ListSpeedSearch.$$$reportNull$$$0(3);
        }
        new MySelectAllAction<T>(list2, this).registerCustomShortcutSet(list2, null);
    }

    @Override
    protected void selectElement(Object element2, String selectedText) {
        if (element2 != null) {
            ScrollingUtil.selectItem((JList)((JList)this.myComponent), (Object)element2);
        } else {
            ((JList)this.myComponent).clearSelection();
        }
    }

    @Override
    protected int getSelectedIndex() {
        return ((JList)this.myComponent).getSelectedIndex();
    }

    @Override
    protected Object @NotNull [] getAllElements() {
        Object[] objectArray = ListSpeedSearch.getAllListElements((JList)this.myComponent);
        if (objectArray == null) {
            ListSpeedSearch.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    public static <T> Object[] getAllListElements(@NotNull JList<T> list2) {
        ListModel<T> model;
        if (list2 == null) {
            ListSpeedSearch.$$$reportNull$$$0(5);
        }
        if ((model = list2.getModel()) instanceof DefaultListModel) {
            return ((DefaultListModel)model).toArray();
        }
        Object[] elements2 = new Object[model.getSize()];
        for (int i2 = 0; i2 < elements2.length; ++i2) {
            elements2[i2] = model.getElementAt(i2);
        }
        return elements2;
    }

    @Override
    protected String getElementText(Object element2) {
        if (this.myToStringConvertor != null) {
            return (String)this.myToStringConvertor.fun(element2);
        }
        return element2 == null ? null : element2.toString();
    }

    @NotNull
    private TIntArrayList findAllFilteredElements(@NotNull String s) {
        if (s == null) {
            ListSpeedSearch.$$$reportNull$$$0(6);
        }
        TIntArrayList indices = new TIntArrayList();
        String _s = s.trim();
        Object[] elements2 = ListSpeedSearch.getAllListElements((JList)this.myComponent);
        for (int i2 = 0; i2 < elements2.length; ++i2) {
            Object element2 = elements2[i2];
            if (!this.isMatchingElement(element2, _s)) continue;
            indices.add(i2);
        }
        TIntArrayList tIntArrayList = indices;
        if (tIntArrayList == null) {
            ListSpeedSearch.$$$reportNull$$$0(7);
        }
        return tIntArrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ListSpeedSearch";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ListSpeedSearch";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllElements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllFilteredElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerSelectAll";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllListElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAllFilteredElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MySelectAllAction<T>
    extends DumbAwareAction {
        @NotNull
        private final JList<T> myList;
        @NotNull
        private final ListSpeedSearch<T> mySearch;

        MySelectAllAction(@NotNull JList<T> list2, @NotNull ListSpeedSearch<T> search2) {
            if (list2 == null) {
                MySelectAllAction.$$$reportNull$$$0(0);
            }
            if (search2 == null) {
                MySelectAllAction.$$$reportNull$$$0(1);
            }
            this.myList = list2;
            this.mySearch = search2;
            AnAction action2 = ActionManager.getInstance().getAction("$SelectAll");
            if (action2 != null) {
                this.copyShortcutFrom(action2);
            }
            this.setEnabledInModalContext(true);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myList.getSelectionModel().getSelectionMode() == 2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(3);
            }
            ListSelectionModel sm = this.myList.getSelectionModel();
            String query = this.mySearch.getEnteredPrefix();
            if (query == null) {
                return;
            }
            TIntArrayList filtered2 = ((ListSpeedSearch)this.mySearch).findAllFilteredElements(query);
            if (filtered2.isEmpty()) {
                return;
            }
            boolean alreadySelected = Arrays.equals(filtered2.toNativeArray(), this.myList.getSelectedIndices());
            if (alreadySelected) {
                int anchor2 = this.myList.getAnchorSelectionIndex();
                this.myList.setSelectedIndex(anchor2);
                sm.setAnchorSelectionIndex(anchor2);
                this.mySearch.findAndSelectElement(query);
            } else {
                int anchor3 = -1;
                Object currentElement = this.mySearch.findElement(query);
                if (currentElement != null) {
                    List<Object> elements2 = Arrays.asList(ListSpeedSearch.getAllListElements(this.myList));
                    anchor3 = ContainerUtil.indexOfIdentity(elements2, (Object)currentElement);
                }
                if (anchor3 == -1) {
                    anchor3 = filtered2.get(0);
                }
                this.myList.setSelectedIndices(filtered2.toNativeArray());
                sm.setAnchorSelectionIndex(anchor3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "search";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/ListSpeedSearch$MySelectAllAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

