/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundableProcessIndicator
extends ProgressWindow {
    protected StatusBarEx myStatusBar;
    private PerformInBackgroundOption myOption;
    private TaskInfo myInfo;
    private boolean myDidInitializeOnEdt;
    private boolean myDisposed;

    public BackgroundableProcessIndicator(@NotNull Task.Backgroundable task2) {
        if (task2 == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(0);
        }
        this(task2.getProject(), (TaskInfo)task2, (PerformInBackgroundOption)task2);
    }

    public BackgroundableProcessIndicator(@Nullable Project project, @NotNull TaskInfo info, @NotNull PerformInBackgroundOption option2) {
        if (info == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(1);
        }
        if (option2 == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(2);
        }
        this(project, info, option2, null);
    }

    @VisibleForTesting
    BackgroundableProcessIndicator(@Nullable Project project, @NotNull TaskInfo info, @NotNull PerformInBackgroundOption option2, @Nullable StatusBarEx statusBarOverride) {
        if (info == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(3);
        }
        if (option2 == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(4);
        }
        super(info.isCancellable(), true, project, null, info.getCancelText());
        this.myDidInitializeOnEdt = false;
        this.setOwnerTask(info);
        this.myOption = option2;
        this.myInfo = info;
        this.myStatusBar = statusBarOverride;
        this.myBackgrounded = this.shouldStartInBackground();
        UIUtil.invokeLaterIfNeeded(() -> this.initializeStatusBar());
    }

    @Override
    protected void initializeOnEdtIfNeeded() {
        super.initializeOnEdtIfNeeded();
        this.initializeStatusBar();
    }

    private void initializeStatusBar() {
        if (this.myDisposed || this.myDidInitializeOnEdt) {
            return;
        }
        this.myDidInitializeOnEdt = true;
        this.setTitle(this.myInfo.getTitle());
        if (this.myStatusBar == null) {
            Project nonDefaultProject = this.myProject == null || this.myProject.isDisposed() || this.myProject.isDefault() ? null : this.myProject;
            IdeFrameEx frame = WindowManagerEx.getInstanceEx().findFrameHelper(nonDefaultProject);
            this.myStatusBar = frame != null ? (StatusBarEx)frame.getStatusBar() : null;
        }
        this.myBackgrounded &= this.myStatusBar != null;
        if (this.myBackgrounded) {
            this.doBackground(this.myStatusBar);
        }
    }

    private boolean shouldStartInBackground() {
        return Registry.is((String)"ide.background.tasks") || this.myOption.shouldStartInBackground();
    }

    public BackgroundableProcessIndicator(@Nullable Project project, final @NlsContexts.ProgressTitle String progressTitle, @NotNull PerformInBackgroundOption option2, final @Nullable @NlsContexts.Button String cancelButtonText, final @NlsContexts.Tooltip String backgroundStopTooltip, final boolean cancellable) {
        if (option2 == null) {
            BackgroundableProcessIndicator.$$$reportNull$$$0(5);
        }
        this(project, new TaskInfo(){

            @NotNull
            public String getTitle() {
                String string = progressTitle;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public String getCancelText() {
                return cancelButtonText;
            }

            public String getCancelTooltipText() {
                return backgroundStopTooltip;
            }

            public boolean isCancellable() {
                return cancellable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/BackgroundableProcessIndicator$1", "getTitle"));
            }
        }, option2);
    }

    @Override
    protected void showDialog() {
        if (this.myDisposed) {
            return;
        }
        this.initializeOnEdtIfNeeded();
        if (this.shouldStartInBackground() && this.myStatusBar != null) {
            return;
        }
        super.showDialog();
    }

    @Override
    public void background() {
        if (this.myDisposed) {
            return;
        }
        assert (this.myDidInitializeOnEdt) : "Call to background action before showing dialog";
        this.myOption.processSentToBackground();
        this.doBackground(this.myStatusBar);
        super.background();
    }

    private void doBackground(@Nullable StatusBarEx statusBar) {
        if (statusBar != null) {
            statusBar.addProgress(this, this.myInfo);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myDisposed = true;
        this.myInfo = null;
        this.myStatusBar = null;
        this.myOption = null;
    }

    @Override
    public boolean isShowing() {
        return this.isModal() || !this.isBackgrounded();
    }

    @Override
    public String toString() {
        return super.toString() + "; task=" + this.myInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "task";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "option";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/progress/impl/BackgroundableProcessIndicator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

