/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.fileTypes.impl.FileTypePanel;
import com.intellij.openapi.fileTypes.impl.FileTypePatternDialog;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.fileTypes.impl.HashBangFileTypeDetector;
import com.intellij.openapi.fileTypes.impl.TypeEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePatterns;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileTypeConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final Insets TITLE_INSETS = JBUI.insetsTop((int)8);
    private RecognizedFileTypes myRecognizedFileType;
    private PatternsPanel myPatterns;
    private HashBangPanel myHashBangs;
    private FileTypePanel myFileTypePanel;
    private Set<FileType> myTempFileTypes;
    private FileTypeAssocTable<FileType> myTempPatternsTable;
    private FileTypeAssocTable<Language> myTempTemplateDataLanguages;
    private final Map<UserFileType, UserFileType> myOriginalToEditedMap = new HashMap<UserFileType, UserFileType>();

    public String getDisplayName() {
        return FileTypesBundle.message("filetype.settings.title", new Object[0]);
    }

    public JComponent createComponent() {
        this.myFileTypePanel = new FileTypePanel();
        this.myFileTypePanel.myIgnorePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"editbox.ignore.files.and.folders", (Object[])new Object[0]), (boolean)false, (Insets)TITLE_INSETS).setShowLine(false));
        this.myRecognizedFileType = new RecognizedFileTypes(this.myFileTypePanel.myRecognizedFileTypesPanel);
        this.myPatterns = new PatternsPanel(this.myFileTypePanel.myPatternsPanel);
        this.myHashBangs = new HashBangPanel(this.myFileTypePanel.myHashBangPanel);
        this.myRecognizedFileType.myFileTypesList.addListSelectionListener(__ -> this.updateExtensionList());
        this.myFileTypePanel.myIgnoreFilesField.setColumns(30);
        return this.myFileTypePanel.myWholePanel;
    }

    private void updateFileTypeList() {
        List types = ContainerUtil.filter(this.myTempFileTypes, fileType -> !fileType.isReadOnly());
        types.sort((o1, o2) -> o1.getDescription().compareToIgnoreCase(o2.getDescription()));
        this.myRecognizedFileType.setFileTypes(types.toArray(FileType.EMPTY_ARRAY));
    }

    @NotNull
    private static Set<FileType> getRegisteredFilesTypes() {
        Set set = ContainerUtil.set((Object[])FileTypeManager.getInstance().getRegisteredFileTypes());
        if (set == null) {
            FileTypeConfigurable.$$$reportNull$$$0(0);
        }
        return set;
    }

    public void apply() {
        Set<UserFileType> modifiedUserTypes = this.myOriginalToEditedMap.keySet();
        for (UserFileType oldType : modifiedUserTypes) {
            oldType.copyFrom(this.myOriginalToEditedMap.get(oldType));
        }
        this.myOriginalToEditedMap.clear();
        FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (!fileTypeManager.isIgnoredFilesListEqualToCurrent(this.myFileTypePanel.myIgnoreFilesField.getText())) {
                fileTypeManager.setIgnoredFilesList(this.myFileTypePanel.myIgnoreFilesField.getText());
            }
            fileTypeManager.setPatternsTable(this.myTempFileTypes, this.myTempPatternsTable);
            TemplateDataLanguagePatterns.getInstance().setAssocTable(this.myTempTemplateDataLanguages);
        });
    }

    public void reset() {
        FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
        this.myTempPatternsTable = fileTypeManager.getExtensionMap().copy();
        this.myTempTemplateDataLanguages = TemplateDataLanguagePatterns.getInstance().getAssocTable();
        this.myTempFileTypes = FileTypeConfigurable.getRegisteredFilesTypes();
        this.myOriginalToEditedMap.clear();
        this.updateFileTypeList();
        this.updateExtensionList();
        this.myFileTypePanel.myIgnoreFilesField.setText(fileTypeManager.getIgnoredFilesList());
    }

    public boolean isModified() {
        FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
        if (!fileTypeManager.isIgnoredFilesListEqualToCurrent(this.myFileTypePanel.myIgnoreFilesField.getText())) {
            return true;
        }
        return !this.myTempPatternsTable.equals(fileTypeManager.getExtensionMap()) || !this.myTempFileTypes.equals(FileTypeConfigurable.getRegisteredFilesTypes()) || !this.myOriginalToEditedMap.isEmpty() || !this.myTempTemplateDataLanguages.equals(TemplateDataLanguagePatterns.getInstance().getAssocTable());
    }

    public void disposeUIResources() {
        if (this.myFileTypePanel != null) {
            this.myRecognizedFileType.setFileTypes(FileType.EMPTY_ARRAY);
            this.myPatterns.clearList();
            this.myHashBangs.clearList();
        }
        this.myFileTypePanel = null;
        this.myRecognizedFileType = null;
        this.myPatterns = null;
        this.myHashBangs = null;
    }

    private void updateExtensionList() {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        ArrayList<String> extensions2 = new ArrayList<String>();
        for (FileNameMatcher assoc : this.myTempPatternsTable.getAssociations((Object)type)) {
            extensions2.add(assoc.getPresentableString());
        }
        this.myPatterns.refill(extensions2);
        this.myHashBangs.refill(this.myTempPatternsTable.getHashBangPatterns((Object)type));
    }

    private void editFileType() {
        TypeEditor<UserFileType> editor;
        FileType fileType = this.myRecognizedFileType.getSelectedFileType();
        if (!FileTypeConfigurable.canBeModified(fileType)) {
            return;
        }
        UserFileType userFileType = (UserFileType)fileType;
        UserFileType ftToEdit = this.myOriginalToEditedMap.get(userFileType);
        if (ftToEdit == null) {
            ftToEdit = userFileType.clone();
        }
        if ((editor = new TypeEditor<UserFileType>(this.myRecognizedFileType.myFileTypesList, ftToEdit, FileTypesBundle.message("filetype.edit.existing.title", new Object[0]))).showAndGet()) {
            this.myOriginalToEditedMap.put(userFileType, ftToEdit);
        }
    }

    private void removeFileType() {
        FileType fileType = this.myRecognizedFileType.getSelectedFileType();
        if (fileType == null) {
            return;
        }
        this.myTempFileTypes.remove(fileType);
        if (fileType instanceof UserFileType) {
            this.myOriginalToEditedMap.remove(fileType);
        }
        this.myTempPatternsTable.removeAllAssociations((Object)fileType);
        this.updateFileTypeList();
        this.updateExtensionList();
    }

    private static boolean canBeModified(FileType fileType) {
        return fileType instanceof AbstractFileType;
    }

    private void addFileType() {
        AbstractFileType type = new AbstractFileType(new SyntaxTable());
        TypeEditor<AbstractFileType> editor = new TypeEditor<AbstractFileType>(this.myRecognizedFileType.myFileTypesList, type, FileTypesBundle.message("filetype.edit.new.title", new Object[0]));
        if (editor.showAndGet()) {
            this.myTempFileTypes.add(type);
            this.updateFileTypeList();
            this.updateExtensionList();
            this.myRecognizedFileType.selectFileType(type);
        }
    }

    private void editPattern() {
        String item = this.myPatterns.getSelectedItem();
        if (item == null) {
            return;
        }
        this.editPattern(item);
    }

    private void editPattern(@Nullable String item) {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        String title = item == null ? FileTypesBundle.message("filetype.edit.add.pattern.title", new Object[0]) : FileTypesBundle.message("filetype.edit.edit.pattern.title", new Object[0]);
        Language oldLanguage = item == null ? null : (Language)this.myTempTemplateDataLanguages.findAssociatedFileType((CharSequence)item);
        FileTypePatternDialog dialog2 = new FileTypePatternDialog(item, type, oldLanguage);
        DialogBuilder builder2 = new DialogBuilder((Component)this.myPatterns.myList);
        builder2.setPreferredFocusComponent((JComponent)dialog2.getPatternField());
        builder2.setCenterPanel((JComponent)dialog2.getMainPanel());
        builder2.setTitle(title);
        builder2.showModal(true);
        if (builder2.getDialogWrapper().isOK()) {
            String pattern = dialog2.getPatternField().getText();
            if (StringUtil.isEmpty((String)pattern)) {
                return;
            }
            FileNameMatcher matcher = FileTypeManager.parseFromString((String)pattern);
            FileType registeredFileType = this.findExistingFileType(matcher);
            if (registeredFileType != null && registeredFileType != type) {
                if (registeredFileType.isReadOnly()) {
                    Messages.showMessageDialog((Component)this.myPatterns.myList, (String)FileTypesBundle.message("filetype.edit.add.pattern.exists.error", registeredFileType.getDescription()), (String)title, (Icon)Messages.getErrorIcon());
                    return;
                }
                int ret = Messages.showOkCancelDialog((Component)this.myPatterns.myList, (String)FileTypesBundle.message("filetype.edit.add.pattern.exists.message", registeredFileType.getDescription()), (String)FileTypesBundle.message("filetype.edit.add.pattern.exists.title", new Object[0]), (String)FileTypesBundle.message("filetype.edit.add.pattern.reassign.button", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
                if (ret == 0) {
                    this.myTempPatternsTable.removeAssociation(matcher, (Object)registeredFileType);
                    if (oldLanguage != null) {
                        this.myTempTemplateDataLanguages.removeAssociation(matcher, (Object)oldLanguage);
                    }
                } else {
                    return;
                }
            }
            if (item != null) {
                FileNameMatcher oldMatcher = FileTypeManager.parseFromString((String)item);
                this.myTempPatternsTable.removeAssociation(oldMatcher, (Object)type);
                if (oldLanguage != null) {
                    this.myTempTemplateDataLanguages.removeAssociation(oldMatcher, (Object)oldLanguage);
                }
            }
            this.myTempPatternsTable.addAssociation(matcher, (Object)type);
            Language language = dialog2.getTemplateDataLanguage();
            if (language != null) {
                this.myTempTemplateDataLanguages.addAssociation(matcher, (Object)language);
            }
            this.updateExtensionList();
            this.myPatterns.select(pattern);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myPatterns.myList, true));
        }
    }

    private void addPattern() {
        this.editPattern(null);
    }

    @Nullable
    private FileType findExistingFileType(@NotNull FileNameMatcher matcher) {
        FileType type;
        if (matcher == null) {
            FileTypeConfigurable.$$$reportNull$$$0(1);
        }
        if ((type = (FileType)this.myTempPatternsTable.findAssociatedFileType(matcher)) != null && type != FileTypes.UNKNOWN) {
            return type;
        }
        FileType registeredFileType = FileTypeManager.getInstance().getFileTypeByExtension(matcher.getPresentableString());
        if (registeredFileType != FileTypes.UNKNOWN && registeredFileType.isReadOnly()) {
            return registeredFileType;
        }
        return null;
    }

    private void removePattern() {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        String extension = this.myPatterns.removeSelected();
        if (extension == null) {
            return;
        }
        FileNameMatcher matcher = FileTypeManager.parseFromString((String)extension);
        this.myTempPatternsTable.removeAssociation(matcher, (Object)type);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myPatterns.myList, true));
    }

    private void removeHashBang() {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        String extension = this.myHashBangs.removeSelected();
        if (extension == null) {
            return;
        }
        this.myTempPatternsTable.removeHashBangPattern(extension, (Object)type);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myHashBangs.myList, true));
    }

    @NotNull
    public String getHelpTopic() {
        return "preferences.fileTypes";
    }

    private void editHashBang() {
        String item = this.myHashBangs.getSelectedItem();
        if (item == null) {
            return;
        }
        this.editHashBang(item);
    }

    private void editHashBang(@Nullable(value="null means new") @Nullable(value="null means new") String oldHashBang) {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        String title = FileTypesBundle.message("filetype.edit.hashbang.title", new Object[0]);
        Language oldLanguage = oldHashBang == null ? null : (Language)this.myTempTemplateDataLanguages.findAssociatedFileType((CharSequence)oldHashBang);
        String hashbang = Messages.showInputDialog((Component)this.myHashBangs.myList, (String)FileTypesBundle.message("filetype.edit.hashbang.prompt", new Object[0]), (String)title, null, (String)oldHashBang, null);
        if (StringUtil.isEmpty((String)hashbang)) {
            return;
        }
        HashBangConflict conflict = this.checkHashBangConflict(hashbang);
        if (conflict != null) {
            FileType existingFileType = conflict.fileType;
            if (existingFileType == type) {
                return;
            }
            if (!conflict.writeable) {
                String message = conflict.exact ? FileTypesBundle.message("filetype.edit.hashbang.exists.exact.error", existingFileType.getDescription()) : FileTypesBundle.message("filetype.edit.hashbang.exists.similar.error", existingFileType.getDescription(), conflict.existingHashBang);
                Messages.showMessageDialog((Component)this.myHashBangs.myList, (String)message, (String)title, (Icon)Messages.getErrorIcon());
                return;
            }
            String message = conflict.exact ? FileTypesBundle.message("filetype.edit.hashbang.exists.exact.message", existingFileType.getDescription()) : FileTypesBundle.message("filetype.edit.hashbang.exists.similar.message", existingFileType.getDescription(), conflict.existingHashBang);
            int ret = Messages.showOkCancelDialog((Component)this.myHashBangs.myList, (String)message, (String)FileTypesBundle.message("filetype.edit.hashbang.exists.title", new Object[0]), (String)FileTypesBundle.message("filetype.edit.hashbang.reassign.button", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
            if (ret != 0) {
                return;
            }
            this.myTempPatternsTable.removeHashBangPattern(hashbang, (Object)existingFileType);
            if (oldLanguage != null) {
                this.myTempTemplateDataLanguages.removeHashBangPattern(hashbang, (Object)oldLanguage);
            }
            this.myTempPatternsTable.removeHashBangPattern(conflict.existingHashBang, (Object)conflict.fileType);
        }
        if (oldHashBang != null) {
            this.myTempPatternsTable.removeHashBangPattern(oldHashBang, (Object)type);
            if (oldLanguage != null) {
                this.myTempTemplateDataLanguages.removeHashBangPattern(oldHashBang, (Object)oldLanguage);
            }
        }
        this.myTempPatternsTable.addHashBangPattern(hashbang, (Object)type);
        this.updateExtensionList();
        this.myHashBangs.select(hashbang);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myPatterns.myList, true));
    }

    private static boolean isStandardFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeConfigurable.$$$reportNull$$$0(2);
        }
        return FileTypeManager.getInstance().getStdFileType(fileType.getName()) == fileType;
    }

    private HashBangConflict checkHashBangConflict(@NotNull String hashbang) {
        if (hashbang == null) {
            FileTypeConfigurable.$$$reportNull$$$0(3);
        }
        HashBangConflict conflict = new HashBangConflict();
        for (Map.Entry entry : this.myTempPatternsTable.getAllHashBangPatterns().entrySet()) {
            String existingHashBang = (String)entry.getKey();
            if (!hashbang.contains(existingHashBang) && !existingHashBang.contains(hashbang)) continue;
            conflict.fileType = (FileType)entry.getValue();
            conflict.exact = existingHashBang.equals(hashbang);
            conflict.writeable = !conflict.fileType.isReadOnly() && !FileTypeConfigurable.isStandardFileType(conflict.fileType);
            conflict.existingHashBang = existingHashBang;
            return conflict;
        }
        List detectors = FileTypeRegistry.FileTypeDetector.EP_NAME.getExtensionList();
        for (FileTypeRegistry.FileTypeDetector detector : detectors) {
            String existingHashBang;
            if (!(detector instanceof HashBangFileTypeDetector) || !hashbang.contains(existingHashBang = ((HashBangFileTypeDetector)detector).getMarker()) && !existingHashBang.contains(hashbang)) continue;
            conflict.fileType = ((HashBangFileTypeDetector)detector).getFileType();
            conflict.exact = existingHashBang.equals(hashbang);
            conflict.writeable = false;
            conflict.existingHashBang = existingHashBang;
            return conflict;
        }
        return null;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            FileTypeConfigurable.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashbang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredFilesTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findExistingFileType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isStandardFileType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkHashBangConflict";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HashBangConflict {
        FileType fileType;
        boolean exact;
        boolean writeable;
        String existingHashBang;

        private HashBangConflict() {
        }
    }

    class HashBangPanel {
        private final JBList<String> myList;

        HashBangPanel(JPanel panel2) {
            if (panel2 == null) {
                HashBangPanel.$$$reportNull$$$0(0);
            }
            this.myList = new JBList(new DefaultListModel());
            panel2.setLayout(new BorderLayout());
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer((ListCellRenderer)new ExtensionRenderer(){

                @Override
                @NotNull
                public Component getListCellRendererComponent(@NotNull JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Component component2 = super.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
                    this.setText(" #!*" + value2 + "*");
                    Component component3 = component2;
                    if (component3 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return component3;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "list";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$HashBangPanel$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$HashBangPanel$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getListCellRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getListCellRendererComponent";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            this.myList.getEmptyText().setText(FileTypesBundle.message("filetype.settings.no.patterns", new Object[0]));
            ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).setAddAction(__ -> FileTypeConfigurable.this.editHashBang(null)).setAddActionName(LangBundle.message((String)"action.HashBangPanel.add.hashbang.pattern.text", (Object[])new Object[0])).setEditAction(__ -> FileTypeConfigurable.this.editHashBang()).setRemoveAction(__ -> FileTypeConfigurable.this.removeHashBang()).disableUpDownActions();
            panel2.add((Component)decorator.createPanel(), "Center");
            panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FileTypesBundle.message("filetype.hashbang.group", new Object[0]), (boolean)false, (Insets)TITLE_INSETS).setShowLine(false));
        }

        void clearList() {
            this.getListModel().clear();
            this.myList.clearSelection();
        }

        @NotNull
        private DefaultListModel<String> getListModel() {
            DefaultListModel defaultListModel = (DefaultListModel)this.myList.getModel();
            if (defaultListModel == null) {
                HashBangPanel.$$$reportNull$$$0(1);
            }
            return defaultListModel;
        }

        void select(@NotNull String pattern) {
            if (pattern == null) {
                HashBangPanel.$$$reportNull$$$0(2);
            }
            ScrollingUtil.selectItem(this.myList, (Object)pattern);
        }

        String removeSelected() {
            String selectedValue = this.getSelectedItem();
            if (selectedValue == null) {
                return null;
            }
            ListUtil.removeSelectedItems(this.myList);
            return selectedValue;
        }

        String getSelectedItem() {
            return (String)this.myList.getSelectedValue();
        }

        private void refill(@NotNull List<String> values2) {
            if (values2 == null) {
                HashBangPanel.$$$reportNull$$$0(3);
            }
            this.clearList();
            Collections.sort(values2);
            for (String extension : values2) {
                this.getListModel().addElement(extension);
            }
            ScrollingUtil.ensureSelectionExists(this.myList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$HashBangPanel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$HashBangPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "select";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "refill";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    class PatternsPanel {
        private final JBList<String> myList;

        PatternsPanel(JPanel panel2) {
            if (panel2 == null) {
                PatternsPanel.$$$reportNull$$$0(0);
            }
            this.myList = new JBList(new DefaultListModel());
            panel2.setLayout(new BorderLayout());
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer((ListCellRenderer)new ExtensionRenderer());
            this.myList.getEmptyText().setText(FileTypesBundle.message("filetype.settings.no.patterns", new Object[0]));
            ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).setAddAction(__ -> FileTypeConfigurable.this.addPattern()).setEditAction(__ -> FileTypeConfigurable.this.editPattern()).setRemoveAction(__ -> FileTypeConfigurable.this.removePattern()).disableUpDownActions();
            panel2.add((Component)decorator.createPanel(), "Center");
            panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FileTypesBundle.message("filetype.registered.patterns.group", new Object[0]), (boolean)false, (Insets)TITLE_INSETS).setShowLine(false));
        }

        void clearList() {
            this.getListModel().clear();
            this.myList.clearSelection();
        }

        @NotNull
        private DefaultListModel<String> getListModel() {
            DefaultListModel defaultListModel = (DefaultListModel)this.myList.getModel();
            if (defaultListModel == null) {
                PatternsPanel.$$$reportNull$$$0(1);
            }
            return defaultListModel;
        }

        void select(@NotNull String pattern) {
            if (pattern == null) {
                PatternsPanel.$$$reportNull$$$0(2);
            }
            for (int i2 = 0; i2 < this.myList.getItemsCount(); ++i2) {
                String at = (String)this.myList.getModel().getElementAt(i2);
                FileNameMatcher matcher = FileTypeManager.parseFromString((String)at);
                if (!matcher.acceptsCharSequence((CharSequence)pattern)) continue;
                ScrollingUtil.selectItem(this.myList, (int)i2);
                return;
            }
        }

        String removeSelected() {
            String selectedValue = this.getSelectedItem();
            if (selectedValue == null) {
                return null;
            }
            ListUtil.removeSelectedItems(this.myList);
            return selectedValue;
        }

        String getSelectedItem() {
            return (String)this.myList.getSelectedValue();
        }

        private void refill(@NotNull List<String> extensions2) {
            if (extensions2 == null) {
                PatternsPanel.$$$reportNull$$$0(3);
            }
            this.clearList();
            Collections.sort(extensions2);
            for (String extension : extensions2) {
                this.getListModel().addElement(extension);
            }
            ScrollingUtil.ensureSelectionExists(this.myList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$PatternsPanel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$PatternsPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "select";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "refill";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    class RecognizedFileTypes {
        private final JList<FileType> myFileTypesList;

        RecognizedFileTypes(JPanel panel2) {
            if (panel2 == null) {
                RecognizedFileTypes.$$$reportNull$$$0(0);
            }
            this.myFileTypesList = new JBList(new DefaultListModel());
            panel2.setLayout(new BorderLayout());
            this.myFileTypesList.setSelectionMode(0);
            this.myFileTypesList.setCellRenderer((ListCellRenderer<FileType>)((Object)new FileTypeRenderer(() -> {
                ArrayList<FileType> result2 = new ArrayList<FileType>();
                for (int i2 = 0; i2 < this.myFileTypesList.getModel().getSize(); ++i2) {
                    result2.add(this.myFileTypesList.getModel().getElementAt(i2));
                }
                return result2;
            })));
            new DoubleClickListener(){

                protected boolean onDoubleClick(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    FileTypeConfigurable.this.editFileType();
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$RecognizedFileTypes$1", "onDoubleClick"));
                }
            }.installOn(this.myFileTypesList);
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myFileTypesList).setAddAction(__ -> FileTypeConfigurable.this.addFileType()).setRemoveAction(__ -> FileTypeConfigurable.this.removeFileType()).setEditAction(__ -> FileTypeConfigurable.this.editFileType()).setEditActionUpdater(e -> {
                FileType fileType = this.getSelectedFileType();
                return FileTypeConfigurable.canBeModified(fileType);
            }).setRemoveActionUpdater(e -> FileTypeConfigurable.canBeModified(this.getSelectedFileType())).disableUpDownActions();
            panel2.add((Component)toolbarDecorator.createPanel(), "Center");
            panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FileTypesBundle.message("filetype.recognized.group", new Object[0]), (boolean)false, (Insets)TITLE_INSETS).setShowLine(false));
            new MySpeedSearch(this.myFileTypesList);
        }

        FileType getSelectedFileType() {
            return this.myFileTypesList.getSelectedValue();
        }

        void setFileTypes(FileType @NotNull [] types) {
            if (types == null) {
                RecognizedFileTypes.$$$reportNull$$$0(1);
            }
            DefaultListModel listModel = (DefaultListModel)this.myFileTypesList.getModel();
            listModel.clear();
            for (FileType type : types) {
                if (type == FileTypes.UNKNOWN) continue;
                listModel.addElement(type);
            }
            ScrollingUtil.ensureSelectionExists(this.myFileTypesList);
        }

        void selectFileType(@NotNull FileType fileType) {
            if (fileType == null) {
                RecognizedFileTypes.$$$reportNull$$$0(2);
            }
            this.myFileTypesList.setSelectedValue(fileType, true);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myFileTypesList, true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$RecognizedFileTypes";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setFileTypes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectFileType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MySpeedSearch
        extends SpeedSearchBase<JList<FileType>> {
            private final List<Condition<Pair<Object, String>>> myOrderedConverters;
            private Object myCurrentType;
            private String myExtension;

            private MySpeedSearch(JList<FileType> component2) {
                if (component2 == null) {
                    MySpeedSearch.$$$reportNull$$$0(0);
                }
                super(component2);
                this.myOrderedConverters = Arrays.asList(p -> {
                    String value2 = p.first.toString();
                    if (p.first instanceof FileType) {
                        value2 = ((FileType)p.first).getDescription();
                    }
                    return this.getComparator().matchingFragments((String)p.second, value2) != null;
                }, p -> p.first instanceof FileType && this.myCurrentType != null && this.myCurrentType.equals(p.first));
            }

            @Override
            protected boolean isMatchingElement(Object element2, String pattern) {
                for (Condition<Pair<Object, String>> convertor : this.myOrderedConverters) {
                    boolean matched = convertor.value((Object)Pair.pair((Object)element2, (Object)pattern));
                    if (!matched) continue;
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            protected final String getElementText(Object element2) {
                throw new IllegalStateException();
            }

            @Override
            protected int getSelectedIndex() {
                return ((JList)this.myComponent).getSelectedIndex();
            }

            @Override
            protected Object @NotNull [] getAllElements() {
                Object[] objectArray = ListSpeedSearch.getAllListElements((JList)this.myComponent);
                if (objectArray == null) {
                    MySpeedSearch.$$$reportNull$$$0(1);
                }
                return objectArray;
            }

            @Override
            protected void selectElement(Object element2, String selectedText) {
                if (element2 != null) {
                    ScrollingUtil.selectItem((JList)((JList)this.myComponent), (Object)((FileType)element2));
                    if (element2.equals(this.myCurrentType)) {
                        FileTypeConfigurable.this.myPatterns.select(this.myExtension);
                    }
                }
            }

            @Override
            protected void onSearchFieldUpdated(String s) {
                if (FileTypeConfigurable.this.myTempPatternsTable == null) {
                    return;
                }
                int index = s.lastIndexOf(46);
                if (index < 0) {
                    s = "." + s;
                }
                this.myCurrentType = FileTypeConfigurable.this.myTempPatternsTable.findAssociatedFileType((CharSequence)s);
                this.myExtension = this.myCurrentType != null ? s : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$RecognizedFileTypes$MySpeedSearch";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$RecognizedFileTypes$MySpeedSearch";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllElements";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class ExtensionRenderer
    extends DefaultListCellRenderer {
        private ExtensionRenderer() {
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            if (list2 == null) {
                ExtensionRenderer.$$$reportNull$$$0(0);
            }
            super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
            this.setText(" " + this.getText());
            ExtensionRenderer extensionRenderer = this;
            if (extensionRenderer == null) {
                ExtensionRenderer.$$$reportNull$$$0(1);
            }
            return extensionRenderer;
        }

        @Override
        public Dimension getPreferredSize() {
            return new JBDimension(0, 20);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$ExtensionRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$ExtensionRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getListCellRendererComponent";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

