/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileTextFieldUtil;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.LazyUiDisposable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTextFieldImpl
implements FileLookup,
Disposable,
FileTextField {
    private final Object myLock = new Object();
    private final JTextField myPathTextField;
    private CompletionResult myCurrentCompletion;
    private JBPopup myCurrentPopup;
    private JBPopup myNoSuggestionsPopup;
    private JList<FileLookup.LookupFile> myList;
    private MergingUpdateQueue myUiUpdater;
    private boolean myPathIsUpdating;
    private FileLookup.Finder myFinder;
    private FileLookup.LookupFilter myFilter;
    private String myFileSpitRegExp;
    protected boolean myAutopopup = false;
    private CancelAction myCancelAction;
    private final Set<Action> myDisabledTextActions;
    private Map<String, String> myMacroMap;

    public FileTextFieldImpl(JTextField field, FileLookup.Finder finder, FileLookup.LookupFilter filter2, Map<String, String> macroMap, Disposable parent) {
        this.myPathTextField = field;
        this.myMacroMap = new TreeMap<String, String>(macroMap);
        InputMap listMap = (InputMap)UIManager.getDefaults().get("List.focusInputMap");
        KeyStroke[] listKeys = listMap.keys();
        this.myDisabledTextActions = new HashSet<Action>();
        for (KeyStroke eachListStroke : listKeys) {
            Action textAction;
            Object textActionID;
            String listActionID = (String)listMap.get(eachListStroke);
            if (!"selectNextRow".equals(listActionID) && !"selectPreviousRow".equals(listActionID) || (textActionID = field.getInputMap().get(eachListStroke)) == null || (textAction = field.getActionMap().get(textActionID)) == null) continue;
            this.myDisabledTextActions.add(textAction);
        }
        FileTextFieldImpl assigned = (FileTextFieldImpl)this.myPathTextField.getClientProperty("fileTextField");
        if (assigned != null) {
            assigned.myFinder = finder;
            assigned.myFilter = filter2;
            return;
        }
        this.myPathTextField.putClientProperty("fileTextField", this);
        boolean headless = ApplicationManager.getApplication().isUnitTestMode();
        this.myUiUpdater = new MergingUpdateQueue("FileTextField.UiUpdater", 200, false, (JComponent)this.myPathTextField);
        if (!headless) {
            new UiNotifyConnector((Component)this.myPathTextField, (Activatable)this.myUiUpdater);
        }
        this.myFinder = finder;
        this.myFilter = filter2;
        this.myFileSpitRegExp = this.myFinder.getSeparator().replaceAll("\\\\", "\\\\\\\\");
        this.myPathTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileTextFieldImpl.this.processTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FileTextFieldImpl.this.processTextChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FileTextFieldImpl.this.processTextChanged();
            }
        });
        this.myPathTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                FileTextFieldImpl.this.processListSelection(e);
            }
        });
        this.myPathTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FileTextFieldImpl.this.closePopup();
            }
        });
        this.myCancelAction = new CancelAction();
        new LazyUiDisposable<FileTextFieldImpl>(parent, (JComponent)field, this){

            protected void initialize(@NotNull Disposable parent, @NotNull FileTextFieldImpl child2, @Nullable Project project) {
                if (parent == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (child2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                Disposer.register((Disposable)child2, (Disposable)FileTextFieldImpl.this.myUiUpdater);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "child";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/fileChooser/ex/FileTextFieldImpl$4";
                objectArray[2] = "initialize";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMacroMap(Map<String, String> macroMap) {
        Object object = this.myLock;
        synchronized (object) {
            this.myMacroMap = new TreeMap<String, String>(macroMap);
        }
    }

    public void dispose() {
        this.myUiUpdater = null;
    }

    private void processTextChanged() {
        if (this.myAutopopup && !this.isPathUpdating()) {
            this.hideCurrentPopup();
            this.suggestCompletion(false, false);
        }
        this.onTextChanged(this.getTextFieldText());
    }

    protected void onTextChanged(String newValue2) {
    }

    private void suggestCompletion(final boolean selectReplacedText, final boolean isExplicitCall) {
        int index;
        if (isExplicitCall) {
            this.myAutopopup = true;
        }
        if (!this.getField().isFocusOwner()) {
            return;
        }
        final CompletionResult result2 = new CompletionResult();
        if (this.myList != null && this.myCurrentCompletion != null && (index = this.myList.getSelectedIndex()) >= 0 && index < this.myList.getModel().getSize()) {
            result2.myPreselected = this.myList.getSelectedValue();
        }
        this.myUiUpdater.queue(new Update("textField.suggestCompletion"){

            public void run() {
                FileLookup.LookupFile file2;
                String completionBase = FileTextFieldImpl.this.getCompletionBase();
                if (completionBase != null && (file2 = FileTextFieldImpl.this.myFinder.find(completionBase)) != null && file2.exists() && !file2.isDirectory()) {
                    return;
                }
                result2.myCompletionBase = completionBase;
                if (result2.myCompletionBase == null) {
                    return;
                }
                result2.myFieldText = FileTextFieldImpl.this.myPathTextField.getText();
                EmptyProgressIndicator indicator = new EmptyProgressIndicator(ModalityState.stateForComponent((Component)FileTextFieldImpl.this.myPathTextField));
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    ProgressManager.getInstance().runProcess(() -> FileTextFieldImpl.this.processCompletion(result2), (ProgressIndicator)indicator);
                    SwingUtilities.invokeLater(() -> {
                        if (!result22.myCompletionBase.equals(FileTextFieldImpl.this.getCompletionBase())) {
                            return;
                        }
                        FileTextFieldImpl.this.selectCompletionRemoveText(result2, selectReplacedText);
                        FileTextFieldImpl.this.showCompletionPopup(result2, isExplicitCall);
                    });
                });
            }
        });
    }

    private int selectCompletionRemoveText(CompletionResult result2, boolean selectReplacedText) {
        int pos = this.myPathTextField.getCaretPosition();
        if (result2.myToComplete.size() > 0 && selectReplacedText) {
            this.myPathTextField.setCaretPosition(this.myPathTextField.getText().length());
            this.myPathTextField.moveCaretPosition(pos);
        }
        return pos;
    }

    @Nullable
    public static String getAdText(CompletionResult result2) {
        if (result2.myCompletionBase == null) {
            return null;
        }
        if (result2.myCompletionBase.length() == result2.myFieldText.length()) {
            return null;
        }
        String strokeText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("EditorChooseLookupItemReplace"));
        return IdeBundle.message((String)"file.chooser.completion.ad.text", (Object[])new Object[]{strokeText});
    }

    private void showCompletionPopup(CompletionResult result2, boolean isExplicit) {
        if (this.myList == null) {
            this.myList = new JBList();
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer(new GroupedItemsListRenderer(new ListItemDescriptorAdapter<FileLookup.LookupFile>(){

                public String getTextFor(FileLookup.LookupFile file2) {
                    return FileTextFieldUtil.getLookupString(file2, FileTextFieldImpl.this.myFinder, FileTextFieldImpl.this.myCurrentCompletion);
                }

                public Icon getIconFor(FileLookup.LookupFile value2) {
                    return value2.getIcon();
                }

                @Nullable
                private Separator getSeparatorAboveOf(Object value2) {
                    FileLookup.LookupFile prev;
                    if (FileTextFieldImpl.this.myCurrentCompletion == null) {
                        return null;
                    }
                    FileLookup.LookupFile file2 = (FileLookup.LookupFile)value2;
                    int fileIndex = ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myToComplete.indexOf(file2);
                    if (fileIndex > 0 && !((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myMacros.contains(file2) && ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myMacros.contains(prev = ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myToComplete.get(fileIndex - 1))) {
                        return new Separator("");
                    }
                    if (((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myKidsAfterSeparator.indexOf(file2) == 0 && ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.mySiblings.size() > 0) {
                        FileLookup.LookupFile parent = file2.getParent();
                        return parent == null ? new Separator("") : new Separator(parent.getName());
                    }
                    if (((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myMacros.size() > 0 && fileIndex == 0) {
                        return new Separator(FileTextFieldImpl.this.getPathVariablesSeparatorText());
                    }
                    return null;
                }

                public boolean hasSeparatorAboveOf(FileLookup.LookupFile value2) {
                    return this.getSeparatorAboveOf(value2) != null;
                }

                public String getCaptionAboveOf(FileLookup.LookupFile value2) {
                    Separator separator = this.getSeparatorAboveOf(value2);
                    return separator != null ? separator.getText() : null;
                }
            }));
        }
        if (this.myCurrentPopup != null) {
            this.closePopup();
        }
        this.myCurrentCompletion = result2;
        if (this.myCurrentCompletion.myToComplete.size() == 0) {
            this.showNoSuggestions(isExplicit);
            return;
        }
        this.myList.setModel((ListModel<FileLookup.LookupFile>)new AbstractListModel<FileLookup.LookupFile>(){

            @Override
            public int getSize() {
                return ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myToComplete.size();
            }

            @Override
            public FileLookup.LookupFile getElementAt(int index) {
                return ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myToComplete.get(index);
            }
        });
        this.myList.getSelectionModel().clearSelection();
        PopupChooserBuilder builder2 = JBPopupFactory.getInstance().createListPopupBuilder(this.myList);
        builder2.addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    8.$$$reportNull$$$0(0);
                }
                FileTextFieldImpl.this.myPathTextField.registerKeyboardAction(FileTextFieldImpl.this.myCancelAction, KeyStroke.getKeyStroke(27, 0), 2);
                for (Action each : FileTextFieldImpl.this.myDisabledTextActions) {
                    each.setEnabled(false);
                }
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    8.$$$reportNull$$$0(1);
                }
                FileTextFieldImpl.this.myPathTextField.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
                for (Action each : FileTextFieldImpl.this.myDisabledTextActions) {
                    each.setEnabled(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/fileChooser/ex/FileTextFieldImpl$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeShown";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myCurrentPopup = builder2.setRequestFocus(false).setAdText(FileTextFieldImpl.getAdText(this.myCurrentCompletion)).setAutoSelectIfEmpty(false).setResizable(false).setCancelCallback(() -> {
            int caret = this.myPathTextField.getCaretPosition();
            this.myPathTextField.setSelectionStart(caret);
            this.myPathTextField.setSelectionEnd(caret);
            this.myPathTextField.setFocusTraversalKeysEnabled(true);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getField(), true));
            return Boolean.TRUE;
        }).setItemChoosenCallback(() -> this.processChosenFromCompletion(false)).setCancelKeyEnabled(false).setAlpha(0.1f).setFocusOwners(new Component[]{this.myPathTextField}).createPopup();
        if (result2.myPreselected != null) {
            this.myList.setSelectedValue(result2.myPreselected, false);
        }
        this.myPathTextField.setFocusTraversalKeysEnabled(false);
        this.myCurrentPopup.showInScreenCoordinates((Component)this.getField(), FileTextFieldImpl.getLocationForCaret(this.myPathTextField));
    }

    private void processChosenFromCompletion(boolean nameOnly) {
        FileTextFieldUtil.processChosenFromCompletion(this.getSelectedFileFromCompletionPopup(), new FileTextFieldUtil.TextFieldDocumentOwner(this.myPathTextField, this::setTextToFile), this.myFinder, nameOnly);
    }

    @NotNull
    protected String getPathVariablesSeparatorText() {
        String string = IdeBundle.message((String)"file.chooser.completion.path.variables.text", (Object[])new Object[0]);
        if (string == null) {
            FileTextFieldImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void showNoSuggestions(boolean isExplicit) {
        this.hideCurrentPopup();
        if (!isExplicit) {
            return;
        }
        JComponent message = HintUtil.createErrorLabel(IdeBundle.message((String)"file.chooser.completion.no.suggestions", (Object[])new Object[0]));
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder(message, message);
        builder2.setRequestFocus(false).setResizable(false).setAlpha(0.1f).setFocusOwners(new Component[]{this.myPathTextField});
        this.myNoSuggestionsPopup = builder2.createPopup();
        this.myNoSuggestionsPopup.showInScreenCoordinates((Component)this.getField(), FileTextFieldImpl.getLocationForCaret(this.myPathTextField));
    }

    private void hideCurrentPopup() {
        if (this.myCurrentPopup != null) {
            this.myCurrentPopup.cancel();
            this.myCurrentPopup = null;
        }
        if (this.myNoSuggestionsPopup != null) {
            this.myNoSuggestionsPopup.cancel();
            this.myNoSuggestionsPopup = null;
        }
    }

    private static Point getLocationForCaret(JTextComponent pathTextField) {
        Point point;
        int position = pathTextField.getCaretPosition();
        try {
            Rectangle rec = pathTextField.modelToView(position);
            point = new Point((int)rec.getMaxX(), (int)rec.getMaxY());
        }
        catch (BadLocationException e) {
            point = pathTextField.getCaret().getMagicCaretPosition();
        }
        SwingUtilities.convertPointToScreen(point, pathTextField);
        point.y += 2;
        return point;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCompletion(CompletionResult result2) {
        Map<String, String> macroMap;
        Object object = this.myLock;
        synchronized (object) {
            macroMap = this.myMacroMap;
        }
        FileTextFieldUtil.processCompletion(result2, this.myFinder, this.myFilter, this.myFileSpitRegExp, macroMap);
    }

    static void addMacroPaths(CompletionResult result2, String typedText, @NotNull FileLookup.Finder finder, Map<String, String> macroMap) {
        if (finder == null) {
            FileTextFieldImpl.$$$reportNull$$$0(1);
        }
        result2.myMacros = new ArrayList<FileLookup.LookupFile>();
        MinusculeMatcher matcher = FileTextFieldUtil.createMatcher(typedText);
        for (String eachMacro : macroMap.keySet()) {
            FileLookup.LookupFile macroFile;
            String eachPath;
            if (!matcher.matches(eachMacro) || (eachPath = macroMap.get(eachMacro)) == null || (macroFile = finder.find(eachPath)) == null || !macroFile.exists()) continue;
            result2.myMacros.add(macroFile);
            result2.myToComplete.add(macroFile);
            macroFile.setMacro(eachMacro);
        }
    }

    @Nullable
    public FileLookup.LookupFile getFile() {
        String text = this.getTextFieldText();
        if (text == null) {
            return null;
        }
        return this.myFinder.find(text);
    }

    protected void setTextToFile(FileLookup.LookupFile file2) {
        String text = file2.getAbsolutePath();
        if (file2.isDirectory() && !text.endsWith(this.myFinder.getSeparator())) {
            text = text + this.myFinder.getSeparator();
        }
        this.myPathTextField.setText(text);
    }

    private void processListSelection(KeyEvent e) {
        Action action2;
        Object object;
        if (this.togglePopup(e)) {
            return;
        }
        if (!this.isPopupShowing()) {
            return;
        }
        InputMap map2 = this.myPathTextField.getInputMap(2);
        if (map2 != null && (object = map2.get(KeyStroke.getKeyStrokeForEvent(e))) instanceof Action && (action2 = (Action)object).isEnabled()) {
            action2.actionPerformed(new ActionEvent(this, 1001, "action"));
            e.consume();
            return;
        }
        Object action3 = FileTextFieldImpl.getAction(e, this.myList);
        if ("selectNextRow".equals(action3)) {
            if (this.ensureSelectionExists()) {
                ScrollingUtil.moveDown(this.myList, (int)e.getModifiersEx());
                e.consume();
            }
        } else if ("selectPreviousRow".equals(action3)) {
            ScrollingUtil.moveUp(this.myList, (int)e.getModifiersEx());
            e.consume();
        } else if ("scrollDown".equals(action3)) {
            ScrollingUtil.movePageDown(this.myList);
            e.consume();
        } else if ("scrollUp".equals(action3)) {
            ScrollingUtil.movePageUp(this.myList);
            e.consume();
        } else if (this.getSelectedFileFromCompletionPopup() != null && (e.getKeyCode() == 10 || e.getKeyCode() == 9) && e.getModifiers() == 0) {
            this.hideCurrentPopup();
            e.consume();
            this.processChosenFromCompletion(e.getKeyCode() == 9);
        }
    }

    @Nullable
    private FileLookup.LookupFile getSelectedFileFromCompletionPopup() {
        if (this.myList == null) {
            return null;
        }
        return this.myList.getSelectedValue();
    }

    private boolean ensureSelectionExists() {
        if ((this.myList.getSelectedIndex() < 0 || this.myList.getSelectedIndex() >= this.myList.getModel().getSize()) && this.myList.getModel().getSize() >= 0) {
            this.myList.setSelectedIndex(0);
            return false;
        }
        return true;
    }

    private boolean togglePopup(KeyEvent e) {
        KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        Object action2 = ((InputMap)UIManager.get("ComboBox.ancestorInputMap")).get(stroke);
        if ("selectNext".equals(action2)) {
            return !this.isPopupShowing();
        }
        if ("togglePopup".equals(action2)) {
            if (this.isPopupShowing()) {
                this.closePopup();
            } else {
                this.suggestCompletion(true, true);
            }
            return true;
        }
        Keymap active = KeymapManager.getInstance().getActiveKeymap();
        for (String id2 : active.getActionIds(stroke)) {
            if (!"CodeCompletion".equals(id2)) continue;
            this.suggestCompletion(true, true);
        }
        return false;
    }

    private static Object getAction(KeyEvent e, JComponent comp) {
        KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        return comp.getInputMap().get(stroke);
    }

    public JTextField getField() {
        return this.myPathTextField;
    }

    public boolean isPopupDisplayed() {
        return this.myCurrentPopup != null && this.myCurrentPopup.isVisible();
    }

    public FileLookup.Finder getFinder() {
        return this.myFinder;
    }

    private boolean isPopupShowing() {
        return this.myCurrentPopup != null && this.myList != null && this.myList.isShowing();
    }

    private void closePopup() {
        this.hideCurrentPopup();
        this.myCurrentCompletion = null;
    }

    @Nullable
    public String getTextFieldText() {
        String text = this.myPathTextField.getText();
        if (text == null) {
            return null;
        }
        return text;
    }

    public final void setText(final String text, boolean now, final @Nullable Runnable onDone) {
        Update update2 = new Update("pathFromTree"){

            public void run() {
                FileTextFieldImpl.this.myPathIsUpdating = true;
                FileTextFieldImpl.this.getField().setText(text);
                FileTextFieldImpl.this.myPathIsUpdating = false;
                if (onDone != null) {
                    onDone.run();
                }
            }
        };
        if (now) {
            update2.run();
        } else {
            this.myUiUpdater.queue(update2);
        }
    }

    public boolean isPathUpdating() {
        return this.myPathIsUpdating;
    }

    @Nullable
    public String getCompletionBase() {
        String text = this.getTextFieldText();
        if (text == null) {
            return null;
        }
        int pos = this.myPathTextField.getCaretPosition();
        return pos < text.length() ? text.substring(0, pos) : text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/ex/FileTextFieldImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathVariablesSeparatorText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/ex/FileTextFieldImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addMacroPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FileTextFieldImpl.this.myCurrentPopup != null) {
                FileTextFieldImpl.this.myAutopopup = false;
                FileTextFieldImpl.this.hideCurrentPopup();
            }
        }
    }

    public static class Vfs
    extends FileTextFieldImpl {
        public Vfs(JTextField field, Map<String, String> macroMap, Disposable parent, FileLookup.LookupFilter chooserFilter) {
            super(field, new LocalFsFinder(), chooserFilter, macroMap, parent);
        }

        public Vfs(Map<String, String> macroMap, Disposable parent, FileLookup.LookupFilter chooserFilter) {
            this(new JTextField(), macroMap, parent, chooserFilter);
        }

        public VirtualFile getSelectedFile() {
            FileLookup.LookupFile lookupFile = this.getFile();
            return lookupFile != null ? ((LocalFsFinder.VfsFile)lookupFile).getFile() : null;
        }
    }

    private static class Separator {
        private final String myText;

        private Separator(String text) {
            this.myText = text;
        }

        public String getText() {
            return this.myText;
        }
    }

    public static class CompletionResult {
        public List<FileLookup.LookupFile> myMacros;
        public List<FileLookup.LookupFile> myToComplete;
        public List<FileLookup.LookupFile> mySiblings;
        public List<FileLookup.LookupFile> myKidsAfterSeparator;
        public String myCompletionBase;
        public FileLookup.LookupFile myClosestParent;
        public FileLookup.LookupFile myPreselected;
        public FileLookup.LookupFile current;
        public boolean currentParentMatch;
        public String effectivePrefix;
        public FileLookup.LookupFile currentGrandparent;
        public String grandparentPrefix;
        public boolean closedPath;
        public String myFieldText;
    }
}

