/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.EventLog;
import com.intellij.notification.EventLogToolWindowFactory;
import com.intellij.notification.LogModel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EventLogConsole {
    private static final Key<String> GROUP_ID = Key.create((String)"GROUP_ID");
    private static final Key<String> NOTIFICATION_ID = Key.create((String)"NOTIFICATION_ID");
    private final EditorEx myLogEditor;
    private final NotNullLazyValue<EditorHyperlinkSupport> myHyperlinkSupport;
    private final LogModel myProjectModel;
    private String myLastDate;
    private List<RangeHighlighter> myNMoreHighlighters;

    EventLogConsole(@NotNull LogModel model, @NotNull Disposable parentDisposable) {
        if (model == null) {
            EventLogConsole.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            EventLogConsole.$$$reportNull$$$0(1);
        }
        this.myHyperlinkSupport = new NotNullLazyValue<EditorHyperlinkSupport>(){

            @NotNull
            protected EditorHyperlinkSupport compute() {
                EditorHyperlinkSupport editorHyperlinkSupport = EditorHyperlinkSupport.get(EventLogConsole.this.getConsoleEditor());
                if (editorHyperlinkSupport == null) {
                    1.$$$reportNull$$$0(0);
                }
                return editorHyperlinkSupport;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/EventLogConsole$1", "compute"));
            }
        };
        this.myProjectModel = model;
        Project project = this.myProjectModel.getProject();
        this.myLogEditor = ConsoleViewUtil.setupConsoleEditor(project, false, false);
        Disposer.register((Disposable)parentDisposable, () -> EditorFactory.getInstance().releaseEditor((Editor)this.myLogEditor));
        this.myLogEditor.getSettings().setWhitespacesShown(false);
        EventLogConsole.installNotificationsFont(this.myLogEditor, parentDisposable);
        ((EditorMarkupModel)((Object)this.myLogEditor.getMarkupModel())).setErrorStripeVisible(true);
        final ClearLogAction clearLog = new ClearLogAction(this);
        clearLog.registerCustomShortcutSet(ActionManager.getInstance().getAction("ConsoleView.ClearAll").getShortcutSet(), this.myLogEditor.getContentComponent());
        this.myLogEditor.installPopupHandler(new ContextMenuPopupHandler(){

            @Override
            public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                return EventLogConsole.createPopupActions(ActionManager.getInstance(), clearLog, EventLogConsole.this.myLogEditor, event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/EventLogConsole$2", "getActionGroup"));
            }
        });
    }

    private static void installNotificationsFont(final @NotNull EditorEx editor, @NotNull Disposable parentDisposable) {
        if (editor == null) {
            EventLogConsole.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            EventLogConsole.$$$reportNull$$$0(3);
        }
        final DelegateColorScheme globalScheme = new DelegateColorScheme(EditorColorsManager.getInstance().getGlobalScheme()){

            @Override
            public String getEditorFontName() {
                return this.getConsoleFontName();
            }

            @Override
            public int getEditorFontSize() {
                return this.getConsoleFontSize();
            }

            @Override
            public String getConsoleFontName() {
                String name = NotificationsUtil.getFontName();
                return name == null ? super.getConsoleFontName() : name;
            }

            @Override
            public int getConsoleFontSize() {
                Integer size = NotificationsUtil.getFontSize();
                return size == null ? super.getConsoleFontSize() : size.intValue();
            }

            @Override
            public void setEditorFontName(String fontName) {
            }

            @Override
            public void setConsoleFontName(String fontName) {
            }

            @Override
            public void setEditorFontSize(int fontSize) {
            }

            @Override
            public void setConsoleFontSize(int fontSize) {
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                globalScheme.setDelegate(EditorColorsManager.getInstance().getGlobalScheme());
                editor.reinitSettings();
            }
        });
        editor.setColorsScheme(ConsoleViewUtil.updateConsoleColorScheme(editor.createBoundColorSchemeDelegate(globalScheme)));
        if (editor instanceof EditorImpl) {
            ((EditorImpl)editor).setUseEditorAntialiasing(false);
        }
    }

    private static DefaultActionGroup createPopupActions(ActionManager actionManager, ClearLogAction action2, EditorEx editor, EditorMouseEvent event) {
        AnAction[] children2 = ((ActionGroup)actionManager.getAction("ConsoleEditorPopupMenu")).getChildren(null);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new EventLogToolWindowFactory.ToggleSoftWraps(editor));
        group.add((AnAction)new ScrollToTheEndToolbarAction(editor));
        group.addSeparator();
        EventLogConsole.addConfigureNotificationAction(editor, event, group);
        group.addAll(children2);
        group.addSeparator();
        group.add((AnAction)action2);
        return group;
    }

    private static void addConfigureNotificationAction(@NotNull EditorEx editor, @NotNull EditorMouseEvent event, @NotNull DefaultActionGroup actions) {
        LogicalPosition position;
        if (editor == null) {
            EventLogConsole.$$$reportNull$$$0(4);
        }
        if (event == null) {
            EventLogConsole.$$$reportNull$$$0(5);
        }
        if (actions == null) {
            EventLogConsole.$$$reportNull$$$0(6);
        }
        if (EditorUtil.inVirtualSpace(editor, position = editor.xyToLogicalPosition(event.getMouseEvent().getPoint()))) {
            return;
        }
        int offset = editor.logicalPositionToOffset(position);
        editor.getMarkupModel().processRangeHighlightersOverlappingWith(offset, offset, (Processor<? super RangeHighlighterEx>)((Processor)rangeHighlighter -> {
            String groupId2 = (String)GROUP_ID.get((UserDataHolder)rangeHighlighter);
            if (groupId2 != null) {
                EventLogConsole.addConfigureNotificationAction(actions, groupId2);
                return false;
            }
            return true;
        }));
    }

    private static void addConfigureNotificationAction(@NotNull DefaultActionGroup actions, @NotNull String groupId2) {
        if (actions == null) {
            EventLogConsole.$$$reportNull$$$0(7);
        }
        if (groupId2 == null) {
            EventLogConsole.$$$reportNull$$$0(8);
        }
        DefaultActionGroup displayTypeGroup = DefaultActionGroup.createPopupGroup(() -> IdeBundle.message((String)"popup.title.notification.display.type", (Object[])new Object[0]));
        NotificationSettings settings = NotificationsConfigurationImpl.getSettings(groupId2);
        NotificationDisplayType current2 = settings.getDisplayType();
        for (NotificationDisplayType type : NotificationDisplayType.values()) {
            if (type == NotificationDisplayType.TOOL_WINDOW && !NotificationsConfigurationImpl.getInstanceImpl().hasToolWindowCapability(groupId2)) continue;
            displayTypeGroup.add((AnAction)new DisplayTypeAction(settings, type, current2));
        }
        actions.add((AnAction)displayTypeGroup);
        actions.addSeparator();
    }

    void doPrintNotification(@NotNull Notification notification) {
        boolean scroll;
        Editor editor;
        if (notification == null) {
            EventLogConsole.$$$reportNull$$$0(9);
        }
        if ((editor = this.getConsoleEditor()).isDisposed()) {
            return;
        }
        Document document = editor.getDocument();
        boolean bl = scroll = document.getTextLength() == editor.getCaretModel().getOffset() || !editor.getContentComponent().hasFocus();
        if (document.getTextLength() > 0) {
            EventLogConsole.append(document, "\n");
        }
        String lastDate = DateFormatUtil.formatDate((long)notification.getTimestamp());
        if (document.getTextLength() == 0 || !lastDate.equals(this.myLastDate)) {
            this.myLastDate = lastDate;
            EventLogConsole.append(document, lastDate + "\n");
        }
        int startDateOffset = document.getTextLength();
        String date = DateFormatUtil.formatTime((long)notification.getTimestamp()) + "\t";
        EventLogConsole.append(document, date);
        int tabs = EventLogConsole.calculateTabs(editor, startDateOffset);
        int titleStartOffset = document.getTextLength();
        int startLine = document.getLineCount() - 1;
        EventLog.LogEntry pair = EventLog.formatForLog(notification, StringUtil.repeatSymbol((char)'\t', (int)tabs));
        NotificationType type = notification.getType();
        TextAttributesKey key = type == NotificationType.ERROR ? ConsoleViewContentType.LOG_ERROR_OUTPUT_KEY : (type == NotificationType.INFORMATION ? ConsoleViewContentType.NORMAL_OUTPUT_KEY : ConsoleViewContentType.LOG_WARNING_OUTPUT_KEY);
        int msgStart = document.getTextLength();
        EventLogConsole.append(document, pair.message);
        int layer = 2001;
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(key, msgStart, document.getTextLength(), layer, HighlighterTargetArea.LINES_IN_RANGE);
        GROUP_ID.set((UserDataHolder)highlighter, (Object)notification.getGroupId());
        NOTIFICATION_ID.set((UserDataHolder)highlighter, (Object)notification.id);
        for (Pair<TextRange, HyperlinkInfo> link : pair.links) {
            RangeHighlighter rangeHighlighter = ((EditorHyperlinkSupport)this.myHyperlinkSupport.getValue()).createHyperlink(((TextRange)link.first).getStartOffset() + msgStart, ((TextRange)link.first).getEndOffset() + msgStart, null, (HyperlinkInfo)link.second);
            if (!(link.second instanceof EventLog.ShowBalloon)) continue;
            ((EventLog.ShowBalloon)link.second).setRangeHighlighter(rangeHighlighter);
        }
        EventLogConsole.append(document, "\n");
        if (scroll) {
            editor.getCaretModel().moveToOffset(document.getTextLength());
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        if (notification.isImportant()) {
            this.highlightNotification(notification, pair.status, startLine, document.getLineCount() - 1, titleStartOffset, pair.titleLength);
        }
    }

    private static int calculateTabs(@NotNull Editor editor, int startDateOffset) {
        if (editor == null) {
            EventLogConsole.$$$reportNull$$$0(10);
        }
        Document document = editor.getDocument();
        int startOffset = document.getTextLength();
        Point dateStartPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(startDateOffset));
        Point dateEndPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(startOffset));
        int width = dateEndPoint.x - dateStartPoint.x;
        document.insertString(startOffset, (CharSequence)"\n");
        Point startPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(startOffset + 1));
        int count = 1;
        while (true) {
            document.insertString(startOffset + count, (CharSequence)"\t");
            Point endPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(document.getTextLength()));
            int tabWidth = endPoint.x - startPoint.x;
            if (width <= tabWidth) {
                document.deleteString(startOffset, document.getTextLength());
                return count;
            }
            ++count;
        }
    }

    private void highlightNotification(Notification notification, String message, int startLine, int endLine, int titleOffset, int titleLength) {
        MarkupModel markupModel = this.getConsoleEditor().getMarkupModel();
        TextAttributes bold = new TextAttributes(null, null, null, null, 1);
        RangeHighlighter colorHighlighter = markupModel.addRangeHighlighter(titleOffset, titleOffset + titleLength, 2001, bold, HighlighterTargetArea.EXACT_RANGE);
        JBColor color = notification.getType() == NotificationType.ERROR ? JBColor.RED : (notification.getType() == NotificationType.WARNING ? JBColor.YELLOW : JBColor.GREEN);
        colorHighlighter.setErrorStripeMarkColor((Color)color);
        colorHighlighter.setErrorStripeTooltip((Object)message);
        Runnable removeHandler = () -> {
            if (colorHighlighter.isValid()) {
                markupModel.removeHighlighter(colorHighlighter);
            }
            TextAttributes italic = new TextAttributes((Color)Gray.x80, null, null, null, 0);
            for (int line = startLine; line < endLine; ++line) {
                for (RangeHighlighter highlighter : ((EditorHyperlinkSupport)this.myHyperlinkSupport.getValue()).findAllHyperlinksOnLine(line)) {
                    markupModel.addRangeHighlighter(highlighter.getStartOffset(), highlighter.getEndOffset(), 2002, italic, HighlighterTargetArea.EXACT_RANGE);
                    ((EditorHyperlinkSupport)this.myHyperlinkSupport.getValue()).removeHyperlink(highlighter);
                }
            }
        };
        if (!notification.isExpired()) {
            this.myProjectModel.removeHandlers.put(notification, removeHandler);
        } else {
            removeHandler.run();
        }
    }

    @NotNull
    public Editor getConsoleEditor() {
        EditorEx editorEx = this.myLogEditor;
        if (editorEx == null) {
            EventLogConsole.$$$reportNull$$$0(11);
        }
        return editorEx;
    }

    public void clearNMore() {
        if (this.myNMoreHighlighters != null) {
            MarkupModel model = this.getConsoleEditor().getMarkupModel();
            for (RangeHighlighter highlighter : this.myNMoreHighlighters) {
                model.removeHighlighter(highlighter);
            }
            this.myNMoreHighlighters = null;
        }
    }

    public void showNotification(@NotNull List<String> ids) {
        if (ids == null) {
            EventLogConsole.$$$reportNull$$$0(12);
        }
        this.clearNMore();
        this.myNMoreHighlighters = new ArrayList<RangeHighlighter>();
        EditorEx editor = (EditorEx)this.getConsoleEditor();
        List highlighters = ContainerUtil.mapNotNull(ids, this::findHighlighter);
        if (!highlighters.isEmpty()) {
            editor.getCaretModel().moveToOffset(((RangeHighlighterEx)highlighters.get(0)).getStartOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_UP);
            ArrayList<Point> ranges = new ArrayList<Point>();
            Point currentRange = null;
            DocumentEx document = editor.getDocument();
            for (RangeHighlighterEx highlighter : highlighters) {
                int startLine = document.getLineNumber(highlighter.getStartOffset());
                int endLine = document.getLineNumber(highlighter.getEndOffset()) + 1;
                if (currentRange != null && startLine - 1 == currentRange.y) {
                    currentRange.y = endLine;
                    continue;
                }
                currentRange = new Point(startLine, endLine);
                ranges.add(currentRange);
            }
            TextAttributes attributes = new TextAttributes(null, ColorUtil.mix((Color)editor.getBackgroundColor(), (Color)new Color(0x808080), (double)0.1), null, EffectType.BOXED, 0);
            MarkupModelEx markupModel = editor.getMarkupModel();
            for (Point range2 : ranges) {
                int start2 = document.getLineStartOffset(range2.x);
                int end = document.getLineStartOffset(range2.y);
                this.myNMoreHighlighters.add(markupModel.addRangeHighlighter(start2, end, 2002, attributes, HighlighterTargetArea.EXACT_RANGE));
            }
        }
    }

    @Nullable
    private RangeHighlighterEx findHighlighter(@NotNull String id2) {
        if (id2 == null) {
            EventLogConsole.$$$reportNull$$$0(13);
        }
        EditorEx editor = (EditorEx)this.getConsoleEditor();
        Ref highlighter = new Ref();
        editor.getMarkupModel().processRangeHighlightersOverlappingWith(0, editor.getDocument().getTextLength(), (Processor<? super RangeHighlighterEx>)((Processor)rangeHighlighter -> {
            if (id2.equals(NOTIFICATION_ID.get((UserDataHolder)rangeHighlighter))) {
                highlighter.set(rangeHighlighter);
                return false;
            }
            return true;
        }));
        return (RangeHighlighterEx)highlighter.get();
    }

    @Nullable
    public RelativePoint getRangeHighlighterLocation(RangeHighlighter range2) {
        Editor editor = this.getConsoleEditor();
        Project project = editor.getProject();
        Window window = NotificationsManagerImpl.findWindowForBalloon(project);
        if (range2 != null && window != null) {
            Point point = editor.visualPositionToXY(editor.offsetToVisualPosition(range2.getStartOffset()));
            return new RelativePoint((Component)window, SwingUtilities.convertPoint(editor.getContentComponent(), point, window));
        }
        return null;
    }

    private static void append(@NotNull Document document, @NotNull String s) {
        if (document == null) {
            EventLogConsole.$$$reportNull$$$0(14);
        }
        if (s == null) {
            EventLogConsole.$$$reportNull$$$0(15);
        }
        document.insertString(document.getTextLength(), (CharSequence)s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/EventLogConsole";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/EventLogConsole";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installNotificationsFont";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addConfigureNotificationAction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doPrintNotification";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculateTabs";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findHighlighter";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ClearLogAction
    extends DumbAwareAction {
        private final EventLogConsole myConsole;

        public ClearLogAction(EventLogConsole console) {
            super(IdeBundle.message((String)"action.text.clear.all", (Object[])new Object[0]), IdeBundle.message((String)"action.description.clear.the.contents.of.the.event.log", (Object[])new Object[0]), AllIcons.Actions.GC);
            this.myConsole = console;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearLogAction.$$$reportNull$$$0(0);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            e.getPresentation().setEnabled(editor != null && editor.getDocument().getTextLength() > 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearLogAction.$$$reportNull$$$0(1);
            }
            LogModel model = this.myConsole.myProjectModel;
            for (Notification notification : model.getNotifications()) {
                notification.expire();
                model.removeNotification(notification);
            }
            model.setStatusMessage(null, 0L);
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != null) {
                editor.getDocument().deleteString(0, editor.getDocument().getTextLength());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/notification/EventLogConsole$ClearLogAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DisplayTypeAction
    extends ToggleAction {
        private final NotificationSettings mySettings;
        private final NotificationDisplayType myType;
        private final NotificationDisplayType myCurrent;

        DisplayTypeAction(@NotNull NotificationSettings settings, @NotNull NotificationDisplayType type, @NotNull NotificationDisplayType current2) {
            if (settings == null) {
                DisplayTypeAction.$$$reportNull$$$0(0);
            }
            if (type == null) {
                DisplayTypeAction.$$$reportNull$$$0(1);
            }
            if (current2 == null) {
                DisplayTypeAction.$$$reportNull$$$0(2);
            }
            super(type.getTitle());
            this.mySettings = settings;
            this.myType = type;
            this.myCurrent = current2;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                DisplayTypeAction.$$$reportNull$$$0(3);
            }
            return this.myType == this.myCurrent;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                DisplayTypeAction.$$$reportNull$$$0(4);
            }
            if (state) {
                NotificationsConfigurationImpl.getInstanceImpl().changeSettings(this.mySettings.withDisplayType(this.myType));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/notification/EventLogConsole$DisplayTypeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

