/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageSchemaDescriptor;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsagesCollector;
import com.intellij.internal.statistic.eventLog.EventField;
import com.intellij.internal.statistic.eventLog.EventFields;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.EventPair;
import com.intellij.internal.statistic.eventLog.VarargEventId;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.ArrayUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeUsageCounterCollector
extends CounterUsagesCollector {
    private static final Logger LOG = Logger.getInstance(FileTypeUsageCounterCollector.class);
    private static final ExtensionPointName<FileTypeUsageSchemaDescriptorEP<FileTypeUsageSchemaDescriptor>> EP = ExtensionPointName.create((String)"com.intellij.fileTypeUsageSchemaDescriptor");
    private static final EventLogGroup GROUP = new EventLogGroup("file.types.usage", FeatureUsageLogger.INSTANCE.getConfig().getVersion());
    private static final EventField<String> FILE_TYPE = EventFields.String((String)"file_type").withCustomRule("file_type");
    private static final EventField<String> SCHEMA = EventFields.String((String)"schema").withCustomRule("file_type_schema");
    private static final EventField<Boolean> IS_WRITABLE = EventFields.Boolean((String)"is_writable");
    private static final VarargEventId SELECT = FileTypeUsageCounterCollector.registerFileTypeEvent("select", new EventField[0]);
    private static final VarargEventId EDIT = FileTypeUsageCounterCollector.registerFileTypeEvent("edit", new EventField[0]);
    private static final VarargEventId OPEN = FileTypeUsageCounterCollector.registerFileTypeEvent("open", IS_WRITABLE);
    private static final VarargEventId CLOSE = FileTypeUsageCounterCollector.registerFileTypeEvent("close", IS_WRITABLE);

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static VarargEventId registerFileTypeEvent(String eventId, EventField<?> ... extraFields) {
        Object[] baseFields = new EventField[]{EventFields.PluginInfoFromInstance, FILE_TYPE, EventFields.AnonymizedPath, SCHEMA};
        return GROUP.registerVarargEvent(eventId, (EventField[])ArrayUtil.mergeArrays((Object[])baseFields, (Object[])extraFields));
    }

    public static void triggerEdit(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(1);
        }
        FileTypeUsageCounterCollector.log(EDIT, project, file2);
    }

    public static void triggerSelect(@NotNull Project project, @Nullable VirtualFile file2) {
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(2);
        }
        if (file2 != null) {
            FileTypeUsageCounterCollector.log(SELECT, project, file2);
        } else {
            FileTypeUsageCounterCollector.logEmptyFile();
        }
    }

    public static void triggerOpen(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(4);
        }
        OPEN.log(project, (EventPair[])ArrayUtil.append((Object[])FileTypeUsageCounterCollector.buildCommonEventPairs(file2), (Object)IS_WRITABLE.with((Object)file2.isWritable())));
    }

    public static void triggerClosed(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(6);
        }
        CLOSE.log(project, (EventPair[])ArrayUtil.append((Object[])FileTypeUsageCounterCollector.buildCommonEventPairs(file2), (Object)IS_WRITABLE.with((Object)file2.isWritable())));
    }

    private static void log(@NotNull VarargEventId eventId, @NotNull Project project, @NotNull VirtualFile file2) {
        if (eventId == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(7);
        }
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(9);
        }
        eventId.log(project, FileTypeUsageCounterCollector.buildCommonEventPairs(file2));
    }

    private static EventPair<?> @NotNull [] buildCommonEventPairs(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(10);
        }
        FileType fileType = file2.getFileType();
        EventPair[] eventPairArray = new EventPair[]{EventFields.PluginInfoFromInstance.with((Object)fileType), FILE_TYPE.with((Object)FileTypeUsagesCollector.getSafeFileTypeName(fileType)), EventFields.AnonymizedPath.with((Object)file2.getPath()), SCHEMA.with((Object)FileTypeUsageCounterCollector.findSchema(file2))};
        if (eventPairArray == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(11);
        }
        return eventPairArray;
    }

    private static void logEmptyFile() {
        SELECT.log(new EventPair[]{EventFields.AnonymizedPath.with(null)});
    }

    @Nullable
    private static String findSchema(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(12);
        }
        for (FileTypeUsageSchemaDescriptorEP ext : EP.getExtensionList()) {
            FileTypeUsageSchemaDescriptor instance = (FileTypeUsageSchemaDescriptor)ext.getInstance();
            if (ext.schema == null) {
                LOG.warn("Extension " + ext.implementationClass + " should define a 'schema' attribute");
                continue;
            }
            if (!instance.describes(file2)) continue;
            return PluginInfoDetectorKt.getPluginInfo(instance.getClass()).isSafeToReport() ? ext.schema : "third.party";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommonEventPairs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "triggerEdit";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "triggerSelect";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "triggerOpen";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "triggerClosed";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildCommonEventPairs";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findSchema";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(1);
            }
            FileTypeUsageCounterCollector.triggerOpen(source.getProject(), file2);
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(3);
            }
            FileTypeUsageCounterCollector.triggerClosed(source.getProject(), file2);
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(4);
            }
            FileTypeUsageCounterCollector.triggerSelect(event.getManager().getProject(), event.getNewFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector$MyFileEditorManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileOpened";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileClosed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyAnActionListener
    implements AnActionListener {
        private static final Key<Long> LAST_EDIT_USAGE = Key.create((String)"LAST_EDIT_USAGE");

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
            if (action2 == null) {
                MyAnActionListener.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(1);
            }
            if (event == null) {
                MyAnActionListener.$$$reportNull$$$0(2);
            }
            if (action2 instanceof EditorAction && ((EditorAction)action2).getHandlerOfType(EditorWriteActionHandler.class) != null) {
                MyAnActionListener.onChange(dataContext);
            }
        }

        private static void onChange(DataContext dataContext) {
            Long lastEdit;
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (editor == null) {
                return;
            }
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (file2 != null && ((lastEdit = (Long)editor.getUserData(LAST_EDIT_USAGE)) == null || System.currentTimeMillis() - lastEdit > 60000L)) {
                editor.putUserData(LAST_EDIT_USAGE, (Object)System.currentTimeMillis());
                FileTypeUsageCounterCollector.triggerEdit(project, file2);
            }
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(3);
            }
            MyAnActionListener.onChange(dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector$MyAnActionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEditorTyping";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class FileTypeSchemaValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "file_type_schema".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                FileTypeSchemaValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                FileTypeSchemaValidator.$$$reportNull$$$0(1);
            }
            if (FileTypeSchemaValidator.isThirdPartyValue((String)data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    FileTypeSchemaValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            for (FileTypeUsageSchemaDescriptorEP ext : EP.getExtensionList()) {
                if (!StringUtil.equals((CharSequence)ext.schema, (CharSequence)data2)) continue;
                ValidationResultType validationResultType = PluginInfoDetectorKt.getPluginInfo(((FileTypeUsageSchemaDescriptor)ext.getInstance()).getClass()).isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    FileTypeSchemaValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                FileTypeSchemaValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector$FileTypeSchemaValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector$FileTypeSchemaValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class FileTypeUsageSchemaDescriptorEP<T>
    extends BaseKeyedLazyInstance<T>
    implements KeyedLazyInstance<T> {
        @Attribute(value="schema")
        public String schema;
        @Attribute(value="implementationClass")
        public String implementationClass;

        @Nullable
        protected String getImplementationClassName() {
            return this.implementationClass;
        }

        public String getKey() {
            return this.schema;
        }
    }
}

