/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.SettingsProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeStructureBase
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance(AbstractTreeStructureBase.class);
    protected final Project myProject;

    protected AbstractTreeStructureBase(Project project) {
        this.myProject = project;
    }

    public Object @NotNull [] getChildElements(@NotNull Object element2) {
        List<TreeStructureProvider> providers;
        if (element2 == null) {
            AbstractTreeStructureBase.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(element2 instanceof AbstractTreeNode, (Object)element2.getClass().getName());
        AbstractTreeNode treeNode = (AbstractTreeNode)element2;
        Collection elements2 = treeNode.getChildren();
        if (elements2.contains(null)) {
            LOG.error("node contains null child: " + treeNode + "; " + treeNode.getClass());
        }
        List<TreeStructureProvider> list2 = providers = Registry.is((String)"allow.tree.structure.provider.in.dumb.mode") ? this.getProviders() : this.getProvidersDumbAware();
        if (providers != null && !providers.isEmpty()) {
            ViewSettings settings = treeNode instanceof SettingsProvider ? ((SettingsProvider)treeNode).getSettings() : ViewSettings.DEFAULT;
            for (TreeStructureProvider provider : providers) {
                ProgressManager.checkCanceled();
                try {
                    if (!(elements2 = provider.modify(treeNode, elements2, settings)).contains(null)) continue;
                    LOG.error("provider creates null child: " + provider);
                }
                catch (IndexNotReadyException e) {
                    LOG.debug("TreeStructureProvider.modify requires indices", (Throwable)e);
                    throw new ProcessCanceledException((Throwable)e);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        elements2.forEach(node -> node.setParent(treeNode));
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)elements2);
        if (objectArray == null) {
            AbstractTreeStructureBase.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public boolean isValid(@NotNull Object element2) {
        if (element2 == null) {
            AbstractTreeStructureBase.$$$reportNull$$$0(2);
        }
        return element2 instanceof AbstractTreeNode;
    }

    public Object getParentElement(@NotNull Object element2) {
        if (element2 == null) {
            AbstractTreeStructureBase.$$$reportNull$$$0(3);
        }
        if (element2 instanceof AbstractTreeNode) {
            return ((AbstractTreeNode)element2).getParent();
        }
        return null;
    }

    @NotNull
    public NodeDescriptor<?> createDescriptor(@NotNull Object element2, NodeDescriptor parentDescriptor) {
        if (element2 == null) {
            AbstractTreeStructureBase.$$$reportNull$$$0(4);
        }
        NodeDescriptor nodeDescriptor = (NodeDescriptor)element2;
        if (nodeDescriptor == null) {
            AbstractTreeStructureBase.$$$reportNull$$$0(5);
        }
        return nodeDescriptor;
    }

    @Nullable
    public abstract List<TreeStructureProvider> getProviders();

    @Nullable
    public Object getDataFromProviders(@NotNull List<AbstractTreeNode<?>> selectedNodes, @NotNull String dataId) {
        List<TreeStructureProvider> providers;
        if (selectedNodes == null) {
            AbstractTreeStructureBase.$$$reportNull$$$0(6);
        }
        if (dataId == null) {
            AbstractTreeStructureBase.$$$reportNull$$$0(7);
        }
        if (!(providers = this.getProvidersDumbAware()).isEmpty()) {
            for (TreeStructureProvider treeStructureProvider : providers) {
                Object fromProvider = treeStructureProvider.getData(selectedNodes, dataId);
                if (fromProvider == null) continue;
                return fromProvider;
            }
        }
        return null;
    }

    @NotNull
    private List<TreeStructureProvider> getProvidersDumbAware() {
        if (this.myProject == null) {
            List<TreeStructureProvider> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractTreeStructureBase.$$$reportNull$$$0(8);
            }
            return list2;
        }
        List<TreeStructureProvider> providers = this.getProviders();
        if (providers == null) {
            List<TreeStructureProvider> list3 = Collections.emptyList();
            if (list3 == null) {
                AbstractTreeStructureBase.$$$reportNull$$$0(9);
            }
            return list3;
        }
        List list4 = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(providers);
        if (list4 == null) {
            AbstractTreeStructureBase.$$$reportNull$$$0(10);
        }
        return list4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/AbstractTreeStructureBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeStructureBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersDumbAware";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromProviders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

