/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.ui.ItemRemovable;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

final class FiltersTableModel
extends AbstractTableModel
implements ItemRemovable {
    private final String[] ourColumnNames = new String[]{IdeBundle.message((String)"column.todo.filters.name", (Object[])new Object[0]), IdeBundle.message((String)"column.todo.filter.patterns", (Object[])new Object[0])};
    private final Class[] ourColumnClasses = new Class[]{String.class, String.class};
    private final List<? extends TodoFilter> myFilters;

    FiltersTableModel(List<? extends TodoFilter> filters) {
        this.myFilters = filters;
    }

    @Override
    public String getColumnName(int column) {
        return this.ourColumnNames[column];
    }

    public Class getColumnClass(int column) {
        return this.ourColumnClasses[column];
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.myFilters.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        TodoFilter filter2 = this.myFilters.get(row);
        switch (column) {
            case 0: {
                return filter2.getName();
            }
            case 1: {
                StringBuilder sb = new StringBuilder();
                Iterator<TodoPattern> i2 = filter2.iterator();
                while (i2.hasNext()) {
                    TodoPattern pattern = i2.next();
                    sb.append(pattern.getPatternString());
                    if (!i2.hasNext()) continue;
                    sb.append(" | ");
                }
                return sb.toString();
            }
        }
        throw new IllegalArgumentException();
    }

    public void removeRow(int index) {
        this.myFilters.remove(index);
        this.fireTableRowsDeleted(index, index);
    }
}

