/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtendWordSelectionHandlerBase
implements ExtendWordSelectionHandler {
    private static final Logger LOG = Logger.getInstance(ExtendWordSelectionHandlerBase.class);

    public abstract boolean canSelect(@NotNull PsiElement var1);

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        TextRange originalRange;
        if (e == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(0);
        }
        if (editorText == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(2);
        }
        if ((originalRange = e.getTextRange()).getEndOffset() > editorText.length()) {
            throw new RuntimeExceptionWithAttachments("Invalid element range in " + this.getClass(), "element=" + e + "; range=" + originalRange + "; text length=" + editorText.length() + "; editor=" + editor + "; committed=" + PsiDocumentManager.getInstance((Project)e.getProject()).isCommitted(editor.getDocument()), new Attachment[]{new Attachment("editor_text.txt", editorText.toString()), new Attachment("psi_text.txt", e.getText())});
        }
        List<TextRange> ranges = ExtendWordSelectionHandlerBase.expandToWholeLine(editorText, originalRange, true);
        if (ranges.size() == 1 && ranges.contains(originalRange)) {
            return ExtendWordSelectionHandlerBase.expandToWholeLine(editorText, originalRange, false);
        }
        return ranges;
    }

    public int getMinimalTextRangeLength(@NotNull PsiElement element2, @NotNull CharSequence text, int cursorOffset) {
        if (element2 == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(3);
        }
        if (text == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(4);
        }
        return 0;
    }

    @NotNull
    public static List<TextRange> expandToWholeLine(@NotNull CharSequence text, @Nullable TextRange range2, boolean isSymmetric) {
        TextRange expanded;
        if (text == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(5);
        }
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        if (range2 == null) {
            ArrayList<TextRange> arrayList = result2;
            if (arrayList == null) {
                ExtendWordSelectionHandlerBase.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        LOG.assertTrue(range2.getEndOffset() <= text.length());
        if (!StringUtil.contains((CharSequence)text, (int)range2.getStartOffset(), (int)range2.getEndOffset(), (char)'\n')) {
            result2.add(range2);
        }
        if ((expanded = ExtendWordSelectionHandlerBase.getExpandedRange(text, range2, isSymmetric)) != null) {
            result2.add(expanded);
        } else {
            result2.add(range2);
        }
        ArrayList<TextRange> arrayList = result2;
        if (arrayList == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    private static TextRange getExpandedRange(@NotNull CharSequence text, @NotNull TextRange range2, boolean isSymmetric) {
        if (text == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(8);
        }
        if (range2 == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(9);
        }
        int startOffset = range2.getStartOffset();
        int endOffset = range2.getEndOffset();
        int index1 = CharArrayUtil.shiftBackward((CharSequence)text, (int)(startOffset - 1), (String)" \t");
        if (endOffset > startOffset && text.charAt(endOffset - 1) == '\n') {
            --endOffset;
        }
        int textLength = text.length();
        int index2 = Math.min(textLength, CharArrayUtil.shiftForward((CharSequence)text, (int)endOffset, (String)" \t"));
        if (index1 < 0 || text.charAt(index1) == '\n' || index2 == textLength || text.charAt(index2) == '\n') {
            if (!isSymmetric) {
                if (index1 < 0 || text.charAt(index1) == '\n') {
                    startOffset = index1 + 1;
                }
                if ((index2 == textLength || text.charAt(index2) == '\n') && (endOffset = index2) < textLength) {
                    ++endOffset;
                }
                return new TextRange(startOffset, endOffset);
            }
            if (!(index1 >= 0 && text.charAt(index1) != '\n' || index2 != textLength && text.charAt(index2) != '\n')) {
                startOffset = index1 + 1;
                endOffset = index2;
                if (endOffset < textLength) {
                    ++endOffset;
                }
                return new TextRange(startOffset, endOffset);
            }
        }
        return null;
    }

    @NotNull
    public static List<TextRange> expandToWholeLinesWithBlanks(@NotNull CharSequence text, @NotNull TextRange range2) {
        int blankLineEnd;
        if (text == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(10);
        }
        if (range2 == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(11);
        }
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        result2.addAll(ExtendWordSelectionHandlerBase.expandToWholeLine(text, range2, true));
        TextRange last = result2.isEmpty() ? range2 : (TextRange)result2.get(result2.size() - 1);
        int start2 = last.getStartOffset();
        int end = last.getEndOffset();
        while ((blankLineEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)end, (String)" \t")) < text.length() && text.charAt(blankLineEnd) == '\n') {
            end = blankLineEnd + 1;
        }
        if (end == last.getEndOffset()) {
            int blankLineStart;
            while (start2 > 0 && text.charAt(start2 - 1) == '\n' && (blankLineStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)(start2 - 2), (String)" \t")) > 0 && text.charAt(blankLineStart) == '\n') {
                start2 = blankLineStart + 1;
            }
        }
        if (start2 != last.getStartOffset() || end != last.getEndOffset()) {
            result2.add(new TextRange(start2, end));
        }
        ArrayList<TextRange> arrayList = result2;
        if (arrayList == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public static List<TextRange> expandToWholeLine(@NotNull CharSequence text, @Nullable TextRange range2) {
        if (text == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(13);
        }
        return ExtendWordSelectionHandlerBase.expandToWholeLine(text, range2, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/ExtendWordSelectionHandlerBase";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/ExtendWordSelectionHandlerBase";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "expandToWholeLine";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "expandToWholeLinesWithBlanks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMinimalTextRangeLength";
                break;
            }
            case 5: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "expandToWholeLine";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExpandedRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expandToWholeLinesWithBlanks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

