/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.xml.TagNameVariantCollector;
import com.intellij.psi.impl.source.xml.XmlDocumentImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlMover
extends LineMover {
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        XmlTag tag;
        XmlElement targetParent;
        TextRange valueRange;
        PsiElement parent;
        if (editor == null) {
            XmlMover.$$$reportNull$$$0(0);
        }
        if (file == null) {
            XmlMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            XmlMover.$$$reportNull$$$0(2);
        }
        if (!super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        Document document = editor.getDocument();
        int movedLineStart = document.getLineStartOffset(info.toMove.startLine);
        int movedLineEnd = document.getLineEndOffset(info.toMove.endLine - 1);
        XmlElement xmlElementAtStart = this.getSourceElement(file, movedLineStart, true);
        XmlElement xmlElementAtEnd = this.getSourceElement(file, movedLineEnd, false);
        if (xmlElementAtStart == null || xmlElementAtEnd == null) {
            return false;
        }
        if (XmlMover.checkInjections((PsiElement)xmlElementAtStart, (PsiElement)xmlElementAtEnd)) {
            return false;
        }
        XmlElement movedParent = null;
        if (xmlElementAtEnd == xmlElementAtStart) {
            movedParent = xmlElementAtEnd;
        } else if (xmlElementAtEnd instanceof XmlAttribute && xmlElementAtStart instanceof XmlTag && xmlElementAtEnd.getParent() == xmlElementAtStart) {
            movedParent = xmlElementAtStart;
        } else if (xmlElementAtStart instanceof XmlAttribute && xmlElementAtEnd instanceof XmlTag && xmlElementAtStart.getParent() == xmlElementAtEnd) {
            movedParent = xmlElementAtEnd;
        }
        if (movedParent == null) {
            return false;
        }
        TextRange textRange = movedParent.getTextRange();
        if (movedParent instanceof XmlTag) {
            XmlTag tag2 = (XmlTag)movedParent;
            parent = tag2.getParent();
            if (!(parent instanceof XmlTag) && ((XmlTag[])PsiTreeUtil.getChildrenOfType((PsiElement)parent, XmlTag.class)).length < 2) {
                return info.prohibitMove();
            }
            valueRange = this.getTagContentRange(tag2);
            int valueStart = valueRange.getStartOffset();
            if (HtmlUtil.isHtmlTag(tag2) && (HtmlUtil.isScriptTag(tag2) || "style".equals(tag2.getName()))) {
                info.toMove = new LineRange((PsiElement)tag2);
                int nextLine = down ? info.toMove.endLine : info.toMove.startLine - 1;
                info.toMove2 = new LineRange(nextLine, nextLine + 1);
            }
            if (movedLineStart < valueStart && valueStart + 1 < document.getTextLength()) {
                movedLineStart = XmlMover.updateMovedRegionEnd(document, movedLineStart, valueStart + 1, info, down);
            }
            if (movedLineStart < valueStart) {
                movedLineStart = XmlMover.updateMovedRegionStart(document, movedLineStart, tag2.getTextRange().getStartOffset(), info, down);
            }
        } else if (movedParent instanceof XmlTagChild || movedParent instanceof XmlAttribute) {
            int endOffset = textRange.getEndOffset() + 1;
            if (endOffset < document.getTextLength()) {
                movedLineStart = XmlMover.updateMovedRegionEnd(document, movedLineStart, endOffset, info, down);
            }
            movedLineStart = XmlMover.updateMovedRegionStart(document, movedLineStart, textRange.getStartOffset(), info, down);
        }
        UnfairTextRange moveDestinationRange = new UnfairTextRange(document.getLineStartOffset(info.toMove2.startLine), document.getLineEndOffset(info.toMove2.endLine - 1));
        if (movedParent instanceof XmlAttribute && (parent = ((XmlAttribute)movedParent).getParent()) != null) {
            valueRange = this.getTagContentRange((XmlTag)parent);
            if (down && moveDestinationRange.getEndOffset() >= valueRange.getStartOffset() || !down && moveDestinationRange.getStartOffset() <= parent.getTextRange().getStartOffset()) {
                return info.prohibitMove();
            }
        }
        if (down) {
            targetParent = this.getDestinationElement(file, movedParent, moveDestinationRange.getEndOffset(), false);
            if (targetParent != null) {
                if (movedParent instanceof XmlTagChild && targetParent instanceof XmlTag) {
                    if (targetParent == movedParent) {
                        return false;
                    }
                    if (movedParent instanceof XmlTag && XmlMover.moveTags(info, (XmlTag)movedParent, (XmlTag)targetParent, down)) {
                        return true;
                    }
                    tag = (XmlTag)targetParent;
                    int offset = tag.isEmpty() ? tag.getTextRange().getStartOffset() : this.getTagContentRange(tag).getStartOffset();
                    XmlMover.updatedMovedIntoEnd(document, info, offset);
                    if (tag.isEmpty()) {
                        info.toMove2 = new LineRange((PsiElement)targetParent);
                    }
                } else if (movedParent instanceof XmlTagChild && targetParent instanceof XmlTagChild || targetParent instanceof XmlAttribute) {
                    XmlMover.updatedMovedIntoEnd(document, info, targetParent.getTextRange().getEndOffset());
                }
            }
        } else {
            targetParent = this.getDestinationElement(file, movedParent, moveDestinationRange.getStartOffset(), true);
            if (targetParent != null) {
                if (movedParent instanceof XmlTagChild && targetParent instanceof XmlTag) {
                    tag = (XmlTag)targetParent;
                    TextRange tagValueRange = this.getTagContentRange(tag);
                    XmlTag[] subtags = tag.getSubTags();
                    XmlTagChild[] children = tag.getValue().getChildren();
                    if (tagValueRange.contains(movedLineStart) && (subtags.length > 0 && subtags[0] == movedParent || children.length > 0 && children[0] == movedParent) || tagValueRange.getLength() == 0 && tag.getTextRange().intersects((TextRange)moveDestinationRange)) {
                        int line = document.getLineNumber(tag.getTextRange().getStartOffset());
                        LineRange toMove2 = info.toMove2;
                        info.toMove2 = new LineRange(Math.min(line, toMove2.startLine), toMove2.endLine);
                    }
                    if (targetParent == movedParent) {
                        return false;
                    }
                    if (movedParent instanceof XmlTag && XmlMover.moveTags(info, (XmlTag)movedParent, (XmlTag)targetParent, down)) {
                        return true;
                    }
                } else if (movedParent instanceof XmlTagChild && targetParent instanceof XmlTagChild || targetParent instanceof XmlAttribute) {
                    int line = document.getLineNumber(targetParent.getTextRange().getStartOffset());
                    LineRange toMove2 = info.toMove2;
                    info.toMove2 = new LineRange(Math.min(line, toMove2.startLine), toMove2.endLine);
                }
            }
        }
        if (movedParent instanceof XmlTagChild) {
            info.toMove = new LineRange((PsiElement)movedParent);
        }
        return true;
    }

    @Nullable
    protected XmlElement getSourceElement(@NotNull PsiFile file, int offset, boolean forward) {
        if (file == null) {
            XmlMover.$$$reportNull$$$0(3);
        }
        return XmlMover.getMeaningfulElementAtOffset(file, offset, forward, (Condition<? super PsiElement>)((Condition)t -> t instanceof XmlTag || t instanceof XmlAttribute));
    }

    @Nullable
    protected XmlElement getDestinationElement(@NotNull PsiFile file, @NotNull XmlElement sourceElement, int offset, boolean forward) {
        if (file == null) {
            XmlMover.$$$reportNull$$$0(4);
        }
        if (sourceElement == null) {
            XmlMover.$$$reportNull$$$0(5);
        }
        return XmlMover.getMeaningfulElementAtOffset(file, offset, forward, (Condition<? super PsiElement>)((Condition)t -> sourceElement instanceof XmlAttribute ? t instanceof XmlAttribute : t instanceof XmlTag));
    }

    @Nullable
    protected static XmlElement getMeaningfulElementAtOffset(@NotNull PsiFile file, int offset, boolean forward, @NotNull Condition<? super PsiElement> condition) {
        PsiElement element;
        if (file == null) {
            XmlMover.$$$reportNull$$$0(6);
        }
        if (condition == null) {
            XmlMover.$$$reportNull$$$0(7);
        }
        if ((element = file.findElementAt(offset)) instanceof PsiWhiteSpace) {
            element = forward ? PsiTreeUtil.nextLeaf((PsiElement)element) : PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        return (XmlElement)ObjectUtils.tryCast((Object)PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)false, condition), XmlElement.class);
    }

    @NotNull
    protected TextRange getTagContentRange(@NotNull XmlTag parent) {
        if (parent == null) {
            XmlMover.$$$reportNull$$$0(8);
        }
        TextRange textRange = parent.getValue().getTextRange();
        if (textRange == null) {
            XmlMover.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    private static boolean moveTags(StatementUpDownMover.MoveInfo info, XmlTag moved, XmlTag target, boolean down) {
        if (target.getParent() == moved) {
            XmlTag next;
            XmlTag xmlTag = next = down ? (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)moved, XmlTag.class) : (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)moved, XmlTag.class);
            if (next == null) {
                return info.prohibitMove();
            }
            info.toMove = new LineRange((PsiElement)moved);
            info.toMove2 = new LineRange((PsiElement)next);
            return true;
        }
        if (moved.getParent() == target) {
            return false;
        }
        LineRange targetRange = new LineRange((PsiElement)target);
        LineRange lineRange = targetRange = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(target.getNode()) == null ? new LineRange(targetRange.startLine, targetRange.endLine - 1) : targetRange;
        if (targetRange.contains(info.toMove2)) {
            XmlElementDescriptor descriptor = moved.getDescriptor();
            if (descriptor == null) {
                return false;
            }
            XmlNSDescriptor nsDescriptor = descriptor.getNSDescriptor();
            if (nsDescriptor == null) {
                return false;
            }
            XmlFile descriptorFile = nsDescriptor.getDescriptorFile();
            if (descriptorFile == null || XmlDocumentImpl.isAutoGeneratedSchema(descriptorFile)) {
                return false;
            }
            if (!TagNameVariantCollector.couldContain(target, moved)) {
                info.toMove = new LineRange((PsiElement)moved);
                info.toMove2 = targetRange;
                return true;
            }
        }
        return false;
    }

    private static boolean checkInjections(PsiElement movedEndElement, PsiElement movedStartElement) {
        XmlText text = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)movedStartElement, XmlText.class);
        XmlText text2 = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)movedEndElement, XmlText.class);
        return text != null && InjectedLanguageManager.getInstance((Project)text.getProject()).getInjectedPsiFiles((PsiElement)text) != null || text2 != null && InjectedLanguageManager.getInstance((Project)text2.getProject()).getInjectedPsiFiles((PsiElement)text2) != null;
    }

    private static void updatedMovedIntoEnd(Document document, @NotNull StatementUpDownMover.MoveInfo info, int offset) {
        if (info == null) {
            XmlMover.$$$reportNull$$$0(10);
        }
        if (offset + 1 < document.getTextLength()) {
            int line = document.getLineNumber(offset + 1);
            LineRange toMove2 = info.toMove2;
            if (toMove2 == null) {
                return;
            }
            info.toMove2 = new LineRange(toMove2.startLine, MathUtil.clamp((int)line, (int)toMove2.endLine, (int)(document.getLineCount() - 1)));
        }
    }

    private static int updateMovedRegionStart(Document document, int movedLineStart, int offset, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (info == null) {
            XmlMover.$$$reportNull$$$0(11);
        }
        int line = document.getLineNumber(offset);
        LineRange toMove = info.toMove;
        int delta = toMove.startLine - line;
        info.toMove = new LineRange(Math.min(line, toMove.startLine), toMove.endLine);
        if (delta > 0 && !down) {
            LineRange toMove2 = info.toMove2;
            info.toMove2 = new LineRange(toMove2.startLine - delta, toMove2.endLine - delta);
            movedLineStart = document.getLineStartOffset(toMove.startLine);
        }
        return movedLineStart;
    }

    private static int updateMovedRegionEnd(Document document, int movedLineStart, int valueStart, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (info == null) {
            XmlMover.$$$reportNull$$$0(12);
        }
        int line = document.getLineNumber(valueStart);
        LineRange toMove = info.toMove;
        int delta = line - toMove.endLine;
        info.toMove = new LineRange(toMove.startLine, Math.max(line, toMove.endLine));
        if (delta > 0 && down) {
            LineRange toMove2 = info.toMove2;
            info.toMove2 = new LineRange(toMove2.startLine + delta, Math.min(toMove2.endLine + delta, document.getLineCount() - 1));
            movedLineStart = document.getLineStartOffset(toMove.startLine);
        }
        return movedLineStart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/moveUpDown/XmlMover";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/moveUpDown/XmlMover";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagContentRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSourceElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMeaningfulElementAtOffset";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTagContentRange";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updatedMovedIntoEnd";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateMovedRegionStart";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateMovedRegionEnd";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

