/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import moment from 'moment';

export default {
  label: '',
  xAxisLabel: '@timestamp per 10 min',
  ordered: {
    date: true,
    min: 1413544140087,
    max: 1413587340087,
    interval: 600000,
  },
  yAxisLabel: 'Count of documents',
  series: [
    {
      label: 'html',
      values: [
        {
          x: 1413543600000,
          y: 140,
        },
        {
          x: 1413544200000,
          y: 1388,
        },
        {
          x: 1413544800000,
          y: 1308,
        },
        {
          x: 1413545400000,
          y: 1356,
        },
        {
          x: 1413546000000,
          y: 1314,
        },
        {
          x: 1413546600000,
          y: 1343,
        },
        {
          x: 1413547200000,
          y: 1353,
        },
        {
          x: 1413547800000,
          y: 1353,
        },
        {
          x: 1413548400000,
          y: 1334,
        },
        {
          x: 1413549000000,
          y: 1433,
        },
        {
          x: 1413549600000,
          y: 1331,
        },
        {
          x: 1413550200000,
          y: 1349,
        },
        {
          x: 1413550800000,
          y: 1323,
        },
        {
          x: 1413551400000,
          y: 1203,
        },
        {
          x: 1413552000000,
          y: 1231,
        },
        {
          x: 1413552600000,
          y: 1227,
        },
        {
          x: 1413553200000,
          y: 1187,
        },
        {
          x: 1413553800000,
          y: 1119,
        },
        {
          x: 1413554400000,
          y: 1159,
        },
        {
          x: 1413555000000,
          y: 1117,
        },
        {
          x: 1413555600000,
          y: 1152,
        },
        {
          x: 1413556200000,
          y: 1057,
        },
        {
          x: 1413556800000,
          y: 1009,
        },
        {
          x: 1413557400000,
          y: 979,
        },
        {
          x: 1413558000000,
          y: 975,
        },
        {
          x: 1413558600000,
          y: 848,
        },
        {
          x: 1413559200000,
          y: 873,
        },
        {
          x: 1413559800000,
          y: 808,
        },
        {
          x: 1413560400000,
          y: 784,
        },
        {
          x: 1413561000000,
          y: 799,
        },
        {
          x: 1413561600000,
          y: 684,
        },
        {
          x: 1413562200000,
          y: 727,
        },
        {
          x: 1413562800000,
          y: 621,
        },
        {
          x: 1413563400000,
          y: 615,
        },
        {
          x: 1413564000000,
          y: 569,
        },
        {
          x: 1413564600000,
          y: 523,
        },
        {
          x: 1413565200000,
          y: 474,
        },
        {
          x: 1413565800000,
          y: 470,
        },
        {
          x: 1413566400000,
          y: 466,
        },
        {
          x: 1413567000000,
          y: 394,
        },
        {
          x: 1413567600000,
          y: 404,
        },
        {
          x: 1413568200000,
          y: 389,
        },
        {
          x: 1413568800000,
          y: 312,
        },
        {
          x: 1413569400000,
          y: 274,
        },
        {
          x: 1413570000000,
          y: 285,
        },
        {
          x: 1413570600000,
          y: 299,
        },
        {
          x: 1413571200000,
          y: 207,
        },
        {
          x: 1413571800000,
          y: 213,
        },
        {
          x: 1413572400000,
          y: 119,
        },
        {
          x: 1413573600000,
          y: 122,
        },
        {
          x: 1413574200000,
          y: 169,
        },
        {
          x: 1413574800000,
          y: 151,
        },
        {
          x: 1413575400000,
          y: 152,
        },
        {
          x: 1413576000000,
          y: 115,
        },
        {
          x: 1413576600000,
          y: 117,
        },
        {
          x: 1413577200000,
          y: 108,
        },
        {
          x: 1413577800000,
          y: 100,
        },
        {
          x: 1413578400000,
          y: 78,
        },
        {
          x: 1413579000000,
          y: 88,
        },
        {
          x: 1413579600000,
          y: 63,
        },
        {
          x: 1413580200000,
          y: 58,
        },
        {
          x: 1413580800000,
          y: 45,
        },
        {
          x: 1413581400000,
          y: 57,
        },
        {
          x: 1413582000000,
          y: 34,
        },
        {
          x: 1413582600000,
          y: 41,
        },
        {
          x: 1413583200000,
          y: 24,
        },
        {
          x: 1413583800000,
          y: 27,
        },
        {
          x: 1413584400000,
          y: 19,
        },
        {
          x: 1413585000000,
          y: 24,
        },
        {
          x: 1413585600000,
          y: 18,
        },
        {
          x: 1413586200000,
          y: 17,
        },
        {
          x: 1413586800000,
          y: 14,
        },
      ],
    },
    {
      label: 'php',
      values: [
        {
          x: 1413543600000,
          y: 90,
        },
        {
          x: 1413544200000,
          y: 949,
        },
        {
          x: 1413544800000,
          y: 1012,
        },
        {
          x: 1413545400000,
          y: 1027,
        },
        {
          x: 1413546000000,
          y: 1073,
        },
        {
          x: 1413546600000,
          y: 992,
        },
        {
          x: 1413547200000,
          y: 1005,
        },
        {
          x: 1413547800000,
          y: 1014,
        },
        {
          x: 1413548400000,
          y: 987,
        },
        {
          x: 1413549000000,
          y: 982,
        },
        {
          x: 1413549600000,
          y: 1086,
        },
        {
          x: 1413550200000,
          y: 998,
        },
        {
          x: 1413550800000,
          y: 935,
        },
        {
          x: 1413551400000,
          y: 995,
        },
        {
          x: 1413552000000,
          y: 926,
        },
        {
          x: 1413552600000,
          y: 897,
        },
        {
          x: 1413553200000,
          y: 873,
        },
        {
          x: 1413553800000,
          y: 885,
        },
        {
          x: 1413554400000,
          y: 859,
        },
        {
          x: 1413555000000,
          y: 852,
        },
        {
          x: 1413555600000,
          y: 779,
        },
        {
          x: 1413556200000,
          y: 739,
        },
        {
          x: 1413556800000,
          y: 783,
        },
        {
          x: 1413557400000,
          y: 784,
        },
        {
          x: 1413558000000,
          y: 687,
        },
        {
          x: 1413558600000,
          y: 660,
        },
        {
          x: 1413559200000,
          y: 672,
        },
        {
          x: 1413559800000,
          y: 600,
        },
        {
          x: 1413560400000,
          y: 659,
        },
        {
          x: 1413561000000,
          y: 540,
        },
        {
          x: 1413561600000,
          y: 539,
        },
        {
          x: 1413562200000,
          y: 481,
        },
        {
          x: 1413562800000,
          y: 498,
        },
        {
          x: 1413563400000,
          y: 444,
        },
        {
          x: 1413564000000,
          y: 452,
        },
        {
          x: 1413564600000,
          y: 408,
        },
        {
          x: 1413565200000,
          y: 358,
        },
        {
          x: 1413565800000,
          y: 321,
        },
        {
          x: 1413566400000,
          y: 305,
        },
        {
          x: 1413567000000,
          y: 292,
        },
        {
          x: 1413567600000,
          y: 289,
        },
        {
          x: 1413568200000,
          y: 239,
        },
        {
          x: 1413568800000,
          y: 256,
        },
        {
          x: 1413569400000,
          y: 220,
        },
        {
          x: 1413570000000,
          y: 205,
        },
        {
          x: 1413570600000,
          y: 201,
        },
        {
          x: 1413571200000,
          y: 183,
        },
        {
          x: 1413571800000,
          y: 172,
        },
        {
          x: 1413572400000,
          y: 73,
        },
        {
          x: 1413573600000,
          y: 90,
        },
        {
          x: 1413574200000,
          y: 130,
        },
        {
          x: 1413574800000,
          y: 104,
        },
        {
          x: 1413575400000,
          y: 108,
        },
        {
          x: 1413576000000,
          y: 92,
        },
        {
          x: 1413576600000,
          y: 79,
        },
        {
          x: 1413577200000,
          y: 90,
        },
        {
          x: 1413577800000,
          y: 72,
        },
        {
          x: 1413578400000,
          y: 68,
        },
        {
          x: 1413579000000,
          y: 52,
        },
        {
          x: 1413579600000,
          y: 60,
        },
        {
          x: 1413580200000,
          y: 51,
        },
        {
          x: 1413580800000,
          y: 32,
        },
        {
          x: 1413581400000,
          y: 37,
        },
        {
          x: 1413582000000,
          y: 30,
        },
        {
          x: 1413582600000,
          y: 29,
        },
        {
          x: 1413583200000,
          y: 24,
        },
        {
          x: 1413583800000,
          y: 16,
        },
        {
          x: 1413584400000,
          y: 15,
        },
        {
          x: 1413585000000,
          y: 15,
        },
        {
          x: 1413585600000,
          y: 10,
        },
        {
          x: 1413586200000,
          y: 9,
        },
        {
          x: 1413586800000,
          y: 9,
        },
      ],
    },
    {
      label: 'png',
      values: [
        {
          x: 1413543600000,
          y: 44,
        },
        {
          x: 1413544200000,
          y: 495,
        },
        {
          x: 1413544800000,
          y: 489,
        },
        {
          x: 1413545400000,
          y: 492,
        },
        {
          x: 1413546000000,
          y: 556,
        },
        {
          x: 1413546600000,
          y: 536,
        },
        {
          x: 1413547200000,
          y: 511,
        },
        {
          x: 1413547800000,
          y: 479,
        },
        {
          x: 1413548400000,
          y: 544,
        },
        {
          x: 1413549000000,
          y: 513,
        },
        {
          x: 1413549600000,
          y: 501,
        },
        {
          x: 1413550200000,
          y: 532,
        },
        {
          x: 1413550800000,
          y: 440,
        },
        {
          x: 1413551400000,
          y: 455,
        },
        {
          x: 1413552000000,
          y: 455,
        },
        {
          x: 1413552600000,
          y: 471,
        },
        {
          x: 1413553200000,
          y: 428,
        },
        {
          x: 1413553800000,
          y: 457,
        },
        {
          x: 1413554400000,
          y: 450,
        },
        {
          x: 1413555000000,
          y: 418,
        },
        {
          x: 1413555600000,
          y: 398,
        },
        {
          x: 1413556200000,
          y: 397,
        },
        {
          x: 1413556800000,
          y: 359,
        },
        {
          x: 1413557400000,
          y: 398,
        },
        {
          x: 1413558000000,
          y: 339,
        },
        {
          x: 1413558600000,
          y: 363,
        },
        {
          x: 1413559200000,
          y: 297,
        },
        {
          x: 1413559800000,
          y: 323,
        },
        {
          x: 1413560400000,
          y: 302,
        },
        {
          x: 1413561000000,
          y: 260,
        },
        {
          x: 1413561600000,
          y: 276,
        },
        {
          x: 1413562200000,
          y: 249,
        },
        {
          x: 1413562800000,
          y: 248,
        },
        {
          x: 1413563400000,
          y: 235,
        },
        {
          x: 1413564000000,
          y: 234,
        },
        {
          x: 1413564600000,
          y: 188,
        },
        {
          x: 1413565200000,
          y: 192,
        },
        {
          x: 1413565800000,
          y: 173,
        },
        {
          x: 1413566400000,
          y: 160,
        },
        {
          x: 1413567000000,
          y: 137,
        },
        {
          x: 1413567600000,
          y: 158,
        },
        {
          x: 1413568200000,
          y: 111,
        },
        {
          x: 1413568800000,
          y: 145,
        },
        {
          x: 1413569400000,
          y: 118,
        },
        {
          x: 1413570000000,
          y: 104,
        },
        {
          x: 1413570600000,
          y: 80,
        },
        {
          x: 1413571200000,
          y: 79,
        },
        {
          x: 1413571800000,
          y: 86,
        },
        {
          x: 1413572400000,
          y: 47,
        },
        {
          x: 1413573600000,
          y: 49,
        },
        {
          x: 1413574200000,
          y: 68,
        },
        {
          x: 1413574800000,
          y: 78,
        },
        {
          x: 1413575400000,
          y: 77,
        },
        {
          x: 1413576000000,
          y: 50,
        },
        {
          x: 1413576600000,
          y: 51,
        },
        {
          x: 1413577200000,
          y: 40,
        },
        {
          x: 1413577800000,
          y: 42,
        },
        {
          x: 1413578400000,
          y: 29,
        },
        {
          x: 1413579000000,
          y: 24,
        },
        {
          x: 1413579600000,
          y: 30,
        },
        {
          x: 1413580200000,
          y: 18,
        },
        {
          x: 1413580800000,
          y: 15,
        },
        {
          x: 1413581400000,
          y: 19,
        },
        {
          x: 1413582000000,
          y: 18,
        },
        {
          x: 1413582600000,
          y: 13,
        },
        {
          x: 1413583200000,
          y: 11,
        },
        {
          x: 1413583800000,
          y: 11,
        },
        {
          x: 1413584400000,
          y: 13,
        },
        {
          x: 1413585000000,
          y: 9,
        },
        {
          x: 1413585600000,
          y: 9,
        },
        {
          x: 1413586200000,
          y: 9,
        },
        {
          x: 1413586800000,
          y: 3,
        },
      ],
    },
    {
      label: 'css',
      values: [
        {
          x: 1413543600000,
          y: 35,
        },
        {
          x: 1413544200000,
          y: 360,
        },
        {
          x: 1413544800000,
          y: 343,
        },
        {
          x: 1413545400000,
          y: 329,
        },
        {
          x: 1413546000000,
          y: 345,
        },
        {
          x: 1413546600000,
          y: 336,
        },
        {
          x: 1413547200000,
          y: 330,
        },
        {
          x: 1413547800000,
          y: 334,
        },
        {
          x: 1413548400000,
          y: 326,
        },
        {
          x: 1413549000000,
          y: 351,
        },
        {
          x: 1413549600000,
          y: 334,
        },
        {
          x: 1413550200000,
          y: 351,
        },
        {
          x: 1413550800000,
          y: 337,
        },
        {
          x: 1413551400000,
          y: 306,
        },
        {
          x: 1413552000000,
          y: 346,
        },
        {
          x: 1413552600000,
          y: 317,
        },
        {
          x: 1413553200000,
          y: 298,
        },
        {
          x: 1413553800000,
          y: 288,
        },
        {
          x: 1413554400000,
          y: 283,
        },
        {
          x: 1413555000000,
          y: 262,
        },
        {
          x: 1413555600000,
          y: 245,
        },
        {
          x: 1413556200000,
          y: 259,
        },
        {
          x: 1413556800000,
          y: 267,
        },
        {
          x: 1413557400000,
          y: 230,
        },
        {
          x: 1413558000000,
          y: 218,
        },
        {
          x: 1413558600000,
          y: 241,
        },
        {
          x: 1413559200000,
          y: 213,
        },
        {
          x: 1413559800000,
          y: 239,
        },
        {
          x: 1413560400000,
          y: 208,
        },
        {
          x: 1413561000000,
          y: 187,
        },
        {
          x: 1413561600000,
          y: 166,
        },
        {
          x: 1413562200000,
          y: 154,
        },
        {
          x: 1413562800000,
          y: 184,
        },
        {
          x: 1413563400000,
          y: 148,
        },
        {
          x: 1413564000000,
          y: 153,
        },
        {
          x: 1413564600000,
          y: 149,
        },
        {
          x: 1413565200000,
          y: 102,
        },
        {
          x: 1413565800000,
          y: 110,
        },
        {
          x: 1413566400000,
          y: 121,
        },
        {
          x: 1413567000000,
          y: 120,
        },
        {
          x: 1413567600000,
          y: 86,
        },
        {
          x: 1413568200000,
          y: 96,
        },
        {
          x: 1413568800000,
          y: 71,
        },
        {
          x: 1413569400000,
          y: 92,
        },
        {
          x: 1413570000000,
          y: 65,
        },
        {
          x: 1413570600000,
          y: 54,
        },
        {
          x: 1413571200000,
          y: 68,
        },
        {
          x: 1413571800000,
          y: 57,
        },
        {
          x: 1413572400000,
          y: 33,
        },
        {
          x: 1413573600000,
          y: 47,
        },
        {
          x: 1413574200000,
          y: 42,
        },
        {
          x: 1413574800000,
          y: 39,
        },
        {
          x: 1413575400000,
          y: 25,
        },
        {
          x: 1413576000000,
          y: 31,
        },
        {
          x: 1413576600000,
          y: 37,
        },
        {
          x: 1413577200000,
          y: 35,
        },
        {
          x: 1413577800000,
          y: 19,
        },
        {
          x: 1413578400000,
          y: 15,
        },
        {
          x: 1413579000000,
          y: 21,
        },
        {
          x: 1413579600000,
          y: 16,
        },
        {
          x: 1413580200000,
          y: 18,
        },
        {
          x: 1413580800000,
          y: 10,
        },
        {
          x: 1413581400000,
          y: 13,
        },
        {
          x: 1413582000000,
          y: 14,
        },
        {
          x: 1413582600000,
          y: 11,
        },
        {
          x: 1413583200000,
          y: 4,
        },
        {
          x: 1413583800000,
          y: 6,
        },
        {
          x: 1413584400000,
          y: 3,
        },
        {
          x: 1413585000000,
          y: 6,
        },
        {
          x: 1413585600000,
          y: 6,
        },
        {
          x: 1413586200000,
          y: 2,
        },
        {
          x: 1413586800000,
          y: 3,
        },
      ],
    },
    {
      label: 'gif',
      values: [
        {
          x: 1413543600000,
          y: 21,
        },
        {
          x: 1413544200000,
          y: 191,
        },
        {
          x: 1413544800000,
          y: 176,
        },
        {
          x: 1413545400000,
          y: 166,
        },
        {
          x: 1413546000000,
          y: 183,
        },
        {
          x: 1413546600000,
          y: 170,
        },
        {
          x: 1413547200000,
          y: 153,
        },
        {
          x: 1413547800000,
          y: 202,
        },
        {
          x: 1413548400000,
          y: 175,
        },
        {
          x: 1413549000000,
          y: 161,
        },
        {
          x: 1413549600000,
          y: 174,
        },
        {
          x: 1413550200000,
          y: 167,
        },
        {
          x: 1413550800000,
          y: 171,
        },
        {
          x: 1413551400000,
          y: 176,
        },
        {
          x: 1413552000000,
          y: 139,
        },
        {
          x: 1413552600000,
          y: 145,
        },
        {
          x: 1413553200000,
          y: 157,
        },
        {
          x: 1413553800000,
          y: 148,
        },
        {
          x: 1413554400000,
          y: 149,
        },
        {
          x: 1413555000000,
          y: 135,
        },
        {
          x: 1413555600000,
          y: 118,
        },
        {
          x: 1413556200000,
          y: 142,
        },
        {
          x: 1413556800000,
          y: 141,
        },
        {
          x: 1413557400000,
          y: 146,
        },
        {
          x: 1413558000000,
          y: 114,
        },
        {
          x: 1413558600000,
          y: 115,
        },
        {
          x: 1413559200000,
          y: 136,
        },
        {
          x: 1413559800000,
          y: 106,
        },
        {
          x: 1413560400000,
          y: 92,
        },
        {
          x: 1413561000000,
          y: 97,
        },
        {
          x: 1413561600000,
          y: 90,
        },
        {
          x: 1413562200000,
          y: 69,
        },
        {
          x: 1413562800000,
          y: 66,
        },
        {
          x: 1413563400000,
          y: 93,
        },
        {
          x: 1413564000000,
          y: 75,
        },
        {
          x: 1413564600000,
          y: 68,
        },
        {
          x: 1413565200000,
          y: 55,
        },
        {
          x: 1413565800000,
          y: 73,
        },
        {
          x: 1413566400000,
          y: 57,
        },
        {
          x: 1413567000000,
          y: 48,
        },
        {
          x: 1413567600000,
          y: 41,
        },
        {
          x: 1413568200000,
          y: 39,
        },
        {
          x: 1413568800000,
          y: 32,
        },
        {
          x: 1413569400000,
          y: 33,
        },
        {
          x: 1413570000000,
          y: 39,
        },
        {
          x: 1413570600000,
          y: 35,
        },
        {
          x: 1413571200000,
          y: 25,
        },
        {
          x: 1413571800000,
          y: 28,
        },
        {
          x: 1413572400000,
          y: 8,
        },
        {
          x: 1413573600000,
          y: 13,
        },
        {
          x: 1413574200000,
          y: 23,
        },
        {
          x: 1413574800000,
          y: 19,
        },
        {
          x: 1413575400000,
          y: 16,
        },
        {
          x: 1413576000000,
          y: 22,
        },
        {
          x: 1413576600000,
          y: 13,
        },
        {
          x: 1413577200000,
          y: 21,
        },
        {
          x: 1413577800000,
          y: 11,
        },
        {
          x: 1413578400000,
          y: 12,
        },
        {
          x: 1413579000000,
          y: 10,
        },
        {
          x: 1413579600000,
          y: 7,
        },
        {
          x: 1413580200000,
          y: 4,
        },
        {
          x: 1413580800000,
          y: 5,
        },
        {
          x: 1413581400000,
          y: 7,
        },
        {
          x: 1413582000000,
          y: 9,
        },
        {
          x: 1413582600000,
          y: 2,
        },
        {
          x: 1413583200000,
          y: 2,
        },
        {
          x: 1413583800000,
          y: 4,
        },
        {
          x: 1413584400000,
          y: 6,
        },
        {
          x: 1413585600000,
          y: 2,
        },
        {
          x: 1413586200000,
          y: 4,
        },
        {
          x: 1413586800000,
          y: 4,
        },
      ],
    },
  ],
  hits: 108970,
  xAxisOrderedValues: [
    1413543600000,
    1413544200000,
    1413544800000,
    1413545400000,
    1413546000000,
    1413546600000,
    1413547200000,
    1413547800000,
    1413548400000,
    1413549000000,
    1413549600000,
    1413550200000,
    1413550800000,
    1413551400000,
    1413552000000,
    1413552600000,
    1413553200000,
    1413553800000,
    1413554400000,
    1413555000000,
    1413555600000,
    1413556200000,
    1413556800000,
    1413557400000,
    1413558000000,
    1413558600000,
    1413559200000,
    1413559800000,
    1413560400000,
    1413561000000,
    1413561600000,
    1413562200000,
    1413562800000,
    1413563400000,
    1413564000000,
    1413564600000,
    1413565200000,
    1413565800000,
    1413566400000,
    1413567000000,
    1413567600000,
    1413568200000,
    1413568800000,
    1413569400000,
    1413570000000,
    1413570600000,
    1413571200000,
    1413571800000,
    1413572400000,
    1413573600000,
    1413574200000,
    1413574800000,
    1413575400000,
    1413576000000,
    1413576600000,
    1413577200000,
    1413577800000,
    1413578400000,
    1413579000000,
    1413579600000,
    1413580200000,
    1413580800000,
    1413581400000,
    1413582000000,
    1413582600000,
    1413583200000,
    1413583800000,
    1413584400000,
    1413585000000,
    1413585600000,
    1413586200000,
    1413586800000,
  ],
  xAxisFormatter: function (thing) {
    return moment(thing);
  },
  tooltipFormatter: function (d) {
    return d;
  },
};
