function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import { EuiFormRow, EuiFieldText, EuiButton, EuiSwitch, EuiButtonEmpty, EuiModalHeader, EuiModalFooter, EuiModalBody, EuiModalHeaderTitle } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
export var CustomizePanelModal = /*#__PURE__*/function (_Component) {
  _inherits(CustomizePanelModal, _Component);

  var _super = _createSuper(CustomizePanelModal);

  function CustomizePanelModal(props) {
    var _this;

    _classCallCheck(this, CustomizePanelModal);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "updateTitle", function (title) {
      // An empty string will mean "use the default value", which is represented by setting
      // title to undefined (where as an empty string is actually used to indicate "hide title").
      _this.setState({
        title: title === '' ? undefined : title
      });
    });

    _defineProperty(_assertThisInitialized(_this), "reset", function () {
      _this.setState({
        title: undefined
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onHideTitleToggle", function () {
      _this.setState(function (prevState) {
        return {
          hideTitle: !prevState.hideTitle
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "save", function () {
      if (_this.state.hideTitle) {
        _this.props.updateTitle('');
      } else {
        var _newTitle = _this.state.title === '' ? undefined : _this.state.title;

        _this.props.updateTitle(_newTitle);
      }
    });

    _this.state = {
      hideTitle: props.embeddable.getOutput().title === '',
      title: props.embeddable.getInput().title
    };
    return _this;
  }

  _createClass(CustomizePanelModal, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiModalHeader, null, /*#__PURE__*/React.createElement(EuiModalHeaderTitle, {
        "data-test-subj": "customizePanelTitle"
      }, "Customize panel")), /*#__PURE__*/React.createElement(EuiModalBody, null, /*#__PURE__*/React.createElement(EuiFormRow, null, /*#__PURE__*/React.createElement(EuiSwitch, {
        checked: !this.state.hideTitle,
        "data-test-subj": "customizePanelHideTitle",
        id: "hideTitle",
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          defaultMessage: "Show panel title",
          id: "embeddableApi.customizePanel.modal.showTitle"
        }),
        onChange: this.onHideTitleToggle
      })), /*#__PURE__*/React.createElement(EuiFormRow, {
        label: i18n.translate('embeddableApi.customizePanel.modal.optionsMenuForm.panelTitleFormRowLabel', {
          defaultMessage: 'Panel title'
        })
      }, /*#__PURE__*/React.createElement(EuiFieldText, {
        id: "panelTitleInput",
        "data-test-subj": "customEmbeddablePanelTitleInput",
        name: "min",
        type: "text",
        disabled: this.state.hideTitle,
        placeholder: this.props.embeddable.getOutput().defaultTitle,
        value: this.state.title || '',
        onChange: function onChange(e) {
          return _this2.updateTitle(e.target.value);
        },
        "aria-label": i18n.translate('embeddableApi.customizePanel.modal.optionsMenuForm.panelTitleInputAriaLabel', {
          defaultMessage: 'Enter a custom title for your panel'
        }),
        append: /*#__PURE__*/React.createElement(EuiButtonEmpty, {
          "data-test-subj": "resetCustomEmbeddablePanelTitle",
          onClick: this.reset,
          disabled: this.state.hideTitle
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "embeddableApi.customizePanel.modal.optionsMenuForm.resetCustomDashboardButtonLabel",
          defaultMessage: "Reset"
        }))
      }))), /*#__PURE__*/React.createElement(EuiModalFooter, null, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        onClick: function onClick() {
          return _this2.props.updateTitle(_this2.props.embeddable.getOutput().title);
        }
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "embeddableApi.customizePanel.modal.cancel",
        defaultMessage: "Cancel"
      })), /*#__PURE__*/React.createElement(EuiButton, {
        "data-test-subj": "saveNewTitleButton",
        onClick: this.save,
        fill: true
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "embeddableApi.customizePanel.modal.saveButtonTitle",
        defaultMessage: "Save"
      }))));
    }
  }]);

  return CustomizePanelModal;
}(Component);