/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import classNames from 'classnames';
import React from 'react';
import { DocViewTableRowBtnFilterAdd } from './table_row_btn_filter_add';
import { DocViewTableRowBtnFilterRemove } from './table_row_btn_filter_remove';
import { DocViewTableRowBtnToggleColumn } from './table_row_btn_toggle_column';
import { DocViewTableRowBtnCollapse } from './table_row_btn_collapse';
import { DocViewTableRowBtnFilterExists } from './table_row_btn_filter_exists';
import { DocViewTableRowIconNoMapping } from './table_row_icon_no_mapping';
import { DocViewTableRowIconUnderscore } from './table_row_icon_underscore';
import { FieldName } from '../field_name/field_name';
export function DocViewTableRow(_ref) {
  var field = _ref.field,
      fieldMapping = _ref.fieldMapping,
      fieldType = _ref.fieldType,
      displayNoMappingWarning = _ref.displayNoMappingWarning,
      displayUnderscoreWarning = _ref.displayUnderscoreWarning,
      isCollapsible = _ref.isCollapsible,
      isCollapsed = _ref.isCollapsed,
      isColumnActive = _ref.isColumnActive,
      onFilter = _ref.onFilter,
      onToggleCollapse = _ref.onToggleCollapse,
      onToggleColumn = _ref.onToggleColumn,
      value = _ref.value,
      valueRaw = _ref.valueRaw;
  var valueClassName = classNames({
    kbnDocViewer__value: true,
    'truncate-by-height': isCollapsible && isCollapsed
  });
  return /*#__PURE__*/React.createElement("tr", {
    key: field,
    "data-test-subj": "tableDocViewRow-".concat(field)
  }, typeof onFilter === 'function' && /*#__PURE__*/React.createElement("td", {
    className: "kbnDocViewer__buttons"
  }, /*#__PURE__*/React.createElement(DocViewTableRowBtnFilterAdd, {
    disabled: !fieldMapping || !fieldMapping.filterable,
    onClick: function onClick() {
      return onFilter(fieldMapping, valueRaw, '+');
    }
  }), /*#__PURE__*/React.createElement(DocViewTableRowBtnFilterRemove, {
    disabled: !fieldMapping || !fieldMapping.filterable,
    onClick: function onClick() {
      return onFilter(fieldMapping, valueRaw, '-');
    }
  }), typeof onToggleColumn === 'function' && /*#__PURE__*/React.createElement(DocViewTableRowBtnToggleColumn, {
    active: isColumnActive,
    onClick: onToggleColumn
  }), /*#__PURE__*/React.createElement(DocViewTableRowBtnFilterExists, {
    disabled: !fieldMapping || !fieldMapping.filterable,
    onClick: function onClick() {
      return onFilter('_exists_', field, '+');
    },
    scripted: fieldMapping && fieldMapping.scripted
  })), /*#__PURE__*/React.createElement("td", {
    className: "kbnDocViewer__field"
  }, /*#__PURE__*/React.createElement(FieldName, {
    fieldName: field,
    fieldType: fieldType,
    fieldIconProps: {
      fill: 'none',
      color: 'gray'
    },
    scripted: Boolean(fieldMapping === null || fieldMapping === void 0 ? void 0 : fieldMapping.scripted)
  })), /*#__PURE__*/React.createElement("td", null, isCollapsible && /*#__PURE__*/React.createElement(DocViewTableRowBtnCollapse, {
    onClick: onToggleCollapse,
    isCollapsed: isCollapsed
  }), displayUnderscoreWarning && /*#__PURE__*/React.createElement(DocViewTableRowIconUnderscore, null), displayNoMappingWarning && /*#__PURE__*/React.createElement(DocViewTableRowIconNoMapping, null), /*#__PURE__*/React.createElement("div", {
    className: valueClassName,
    "data-test-subj": "tableDocViewRow-".concat(field, "-value")
    /*
     * Justification for dangerouslySetInnerHTML:
     * We just use values encoded by our field formatters
     */
    // eslint-disable-next-line react/no-danger
    ,
    dangerouslySetInnerHTML: {
      __html: value
    }
  })));
}