function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiFlexGroup, EuiFlexItem, EuiIcon, EuiSpacer } from '@elastic/eui';
import moment from 'moment-timezone';
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import lightEuiTheme from '@elastic/eui/dist/eui_theme_light.json';
import darkEuiTheme from '@elastic/eui/dist/eui_theme_dark.json';
import { AnnotationDomainTypes, Axis, Chart, HistogramBarSeries, LineAnnotation, Position, ScaleType, Settings, RectAnnotation, TooltipType } from '@elastic/charts';
import { i18n } from '@kbn/i18n';
import { combineLatest } from 'rxjs';
import { getServices } from '../../../kibana_services';

function findIntervalFromDuration(dateValue, esValue, esUnit, timeZone) {
  var date = moment.tz(dateValue, timeZone);
  var startOfDate = moment.tz(date, timeZone).startOf(esUnit);
  var endOfDate = moment.tz(date, timeZone).startOf(esUnit).add(esValue, esUnit);
  return endOfDate.valueOf() - startOfDate.valueOf();
}

function getIntervalInMs(value, esValue, esUnit, timeZone) {
  switch (esUnit) {
    case 's':
      return 1000 * esValue;

    case 'ms':
      return 1 * esValue;

    default:
      return findIntervalFromDuration(value, esValue, esUnit, timeZone);
  }
}

function getTimezone(uiSettings) {
  if (uiSettings.isDefault('dateFormat:tz')) {
    var detectedTimezone = moment.tz.guess();
    if (detectedTimezone) return detectedTimezone;else return moment().format('Z');
  } else {
    return uiSettings.get('dateFormat:tz', 'Browser');
  }
}

export function findMinInterval(xValues, esValue, esUnit, timeZone) {
  return xValues.reduce(function (minInterval, currentXvalue, index) {
    var currentDiff = minInterval;

    if (index > 0) {
      currentDiff = Math.abs(xValues[index - 1] - currentXvalue);
    }

    var singleUnitInterval = getIntervalInMs(currentXvalue, esValue, esUnit, timeZone);
    return Math.min(minInterval, singleUnitInterval, currentDiff);
  }, Number.MAX_SAFE_INTEGER);
}
export var DiscoverHistogram = /*#__PURE__*/function (_Component) {
  _inherits(DiscoverHistogram, _Component);

  var _super = _createSuper(DiscoverHistogram);

  function DiscoverHistogram() {
    var _this;

    _classCallCheck(this, DiscoverHistogram);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "subscription", void 0);

    _defineProperty(_assertThisInitialized(_this), "state", {
      chartsTheme: getServices().theme.chartsDefaultTheme,
      chartsBaseTheme: getServices().theme.chartsDefaultBaseTheme
    });

    _defineProperty(_assertThisInitialized(_this), "onBrushEnd", function (_ref) {
      var x = _ref.x;

      if (!x) {
        return;
      }

      var _x = _slicedToArray(x, 2),
          from = _x[0],
          to = _x[1];

      _this.props.timefilterUpdateHandler({
        from: from,
        to: to
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onElementClick", function (xInterval) {
      return function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 1),
            elementData = _ref3[0];

        var startRange = elementData[0].x;
        var range = {
          from: startRange,
          to: startRange + xInterval
        };

        _this.props.timefilterUpdateHandler(range);
      };
    });

    _defineProperty(_assertThisInitialized(_this), "formatXValue", function (val) {
      var xAxisFormat = _this.props.chartData.xAxisFormat.params.pattern;
      return moment(val).format(xAxisFormat);
    });

    _defineProperty(_assertThisInitialized(_this), "renderBarTooltip", function (xInterval, domainStart, domainEnd) {
      return function (headerData) {
        var headerDataValue = headerData.value;

        var formattedValue = _this.formatXValue(headerDataValue);

        var partialDataText = i18n.translate('discover.histogram.partialData.bucketTooltipText', {
          defaultMessage: 'The selected time range does not include this entire bucket, it may contain partial data.'
        });

        if (headerDataValue < domainStart || headerDataValue + xInterval > domainEnd) {
          return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
            alignItems: "center",
            className: "dscHistogram__header--partial",
            responsive: false,
            gutterSize: "xs"
          }, /*#__PURE__*/React.createElement(EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/React.createElement(EuiIcon, {
            type: "iInCircle"
          })), /*#__PURE__*/React.createElement(EuiFlexItem, null, partialDataText)), /*#__PURE__*/React.createElement(EuiSpacer, {
            size: "xs"
          }), /*#__PURE__*/React.createElement("p", null, formattedValue));
        }

        return formattedValue;
      };
    });

    return _this;
  }

  _createClass(DiscoverHistogram, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      this.subscription = combineLatest(getServices().theme.chartsTheme$, getServices().theme.chartsBaseTheme$).subscribe(function (_ref4) {
        var _ref5 = _slicedToArray(_ref4, 2),
            chartsTheme = _ref5[0],
            chartsBaseTheme = _ref5[1];

        return _this2.setState({
          chartsTheme: chartsTheme,
          chartsBaseTheme: chartsBaseTheme
        });
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.subscription) {
        this.subscription.unsubscribe();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _data$, _data$2;

      var uiSettings = getServices().uiSettings;
      var timeZone = getTimezone(uiSettings);
      var chartData = this.props.chartData;
      var _this$state = this.state,
          chartsTheme = _this$state.chartsTheme,
          chartsBaseTheme = _this$state.chartsBaseTheme;

      if (!chartData) {
        return null;
      }

      var data = chartData.values;
      /**
       * Deprecation: [interval] on [date_histogram] is deprecated, use [fixed_interval] or [calendar_interval].
       * see https://github.com/elastic/kibana/issues/27410
       * TODO: Once the Discover query has been update, we should change the below to use the new field
       */

      var _chartData$ordered = chartData.ordered,
          intervalESValue = _chartData$ordered.intervalESValue,
          intervalESUnit = _chartData$ordered.intervalESUnit,
          interval = _chartData$ordered.interval;
      var xInterval = interval.asMilliseconds();
      var xValues = chartData.xAxisOrderedValues;
      var lastXValue = xValues[xValues.length - 1];
      var domain = chartData.ordered;
      var domainStart = domain.min.valueOf();
      var domainEnd = domain.max.valueOf();
      var domainMin = ((_data$ = data[0]) === null || _data$ === void 0 ? void 0 : _data$.x) > domainStart ? domainStart : (_data$2 = data[0]) === null || _data$2 === void 0 ? void 0 : _data$2.x;
      var domainMax = domainEnd - xInterval > lastXValue ? domainEnd - xInterval : lastXValue;
      var xDomain = {
        min: domainMin,
        max: domainMax,
        minInterval: findMinInterval(xValues, intervalESValue, intervalESUnit, timeZone)
      }; // Domain end of 'now' will be milliseconds behind current time, so we extend time by 1 minute and check if
      // the annotation is within this range; if so, the line annotation uses the domainEnd as its value

      var now = moment();
      var isAnnotationAtEdge = moment(domainEnd).add(60000).isAfter(now) && now.isAfter(domainEnd);
      var lineAnnotationValue = isAnnotationAtEdge ? domainEnd : now;
      var lineAnnotationData = [{
        dataValue: lineAnnotationValue
      }];
      var isDarkMode = uiSettings.get('theme:darkMode');
      var lineAnnotationStyle = {
        line: {
          strokeWidth: 2,
          stroke: isDarkMode ? darkEuiTheme.euiColorDanger : lightEuiTheme.euiColorDanger,
          opacity: 0.7
        }
      };
      var rectAnnotations = [];

      if (domainStart !== domainMin) {
        rectAnnotations.push({
          coordinates: {
            x1: domainStart
          }
        });
      }

      if (domainEnd !== domainMax) {
        rectAnnotations.push({
          coordinates: {
            x0: domainEnd
          }
        });
      }

      var rectAnnotationStyle = {
        stroke: isDarkMode ? darkEuiTheme.euiColorLightShade : lightEuiTheme.euiColorDarkShade,
        strokeWidth: 0,
        opacity: isDarkMode ? 0.6 : 0.2,
        fill: isDarkMode ? darkEuiTheme.euiColorLightShade : lightEuiTheme.euiColorDarkShade
      };
      var tooltipProps = {
        headerFormatter: this.renderBarTooltip(xInterval, domainStart, domainEnd),
        type: TooltipType.VerticalCursor
      };
      return /*#__PURE__*/React.createElement(Chart, {
        size: "100%"
      }, /*#__PURE__*/React.createElement(Settings, {
        xDomain: xDomain,
        onBrushEnd: this.onBrushEnd,
        onElementClick: this.onElementClick(xInterval),
        tooltip: tooltipProps,
        theme: chartsTheme,
        baseTheme: chartsBaseTheme
      }), /*#__PURE__*/React.createElement(Axis, {
        id: "discover-histogram-left-axis",
        position: Position.Left,
        ticks: 5,
        title: chartData.yAxisLabel
      }), /*#__PURE__*/React.createElement(Axis, {
        id: "discover-histogram-bottom-axis",
        position: Position.Bottom,
        title: chartData.xAxisLabel,
        tickFormat: this.formatXValue,
        ticks: 10
      }), /*#__PURE__*/React.createElement(LineAnnotation, {
        id: "line-annotation",
        domainType: AnnotationDomainTypes.XDomain,
        dataValues: lineAnnotationData,
        hideTooltips: true,
        style: lineAnnotationStyle
      }), /*#__PURE__*/React.createElement(RectAnnotation, {
        dataValues: rectAnnotations,
        id: "rect-annotation",
        zIndex: 2,
        style: rectAnnotationStyle,
        hideTooltips: true
      }), /*#__PURE__*/React.createElement(HistogramBarSeries, {
        id: "discover-histogram",
        minBarHeight: 2,
        xScaleType: ScaleType.Time,
        yScaleType: ScaleType.Linear,
        xAccessor: "x",
        yAccessors: ['y'],
        data: data,
        timeZone: timeZone,
        name: chartData.yAxisLabel
      }));
    }
  }]);

  return DiscoverHistogram;
}(Component);

_defineProperty(DiscoverHistogram, "propTypes", {
  chartData: PropTypes.object,
  timefilterUpdateHandler: PropTypes.func
});