/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { startCase } from 'lodash';
export var makeNestedLabel = function makeNestedLabel(aggConfig, label) {
  var uppercaseLabel = startCase(label);
  var customMetric = aggConfig.getParam('customMetric');
  var metricAgg = aggConfig.getParam('metricAgg');

  if (customMetric) {
    var metricLabel = customMetric.makeLabel();

    if (metricLabel.includes("".concat(uppercaseLabel, " of "))) {
      metricLabel = metricLabel.substring("".concat(uppercaseLabel, " of ").length);
      metricLabel = "2. ".concat(label, " of ").concat(metricLabel);
    } else if (metricLabel.includes("".concat(label, " of "))) {
      metricLabel = parseInt(metricLabel.substring(0, 1), 10) + 1 + metricLabel.substring(1);
    } else {
      metricLabel = "".concat(uppercaseLabel, " of ").concat(metricLabel);
    }

    return metricLabel;
  }

  var metric = aggConfig.aggConfigs.byId(metricAgg);

  if (!metric) {
    return '';
  }

  return "".concat(uppercaseLabel, " of ").concat(metric.makeLabel());
};