/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { I18nProvider } from '@kbn/i18n/react';
import { EuiLink, EuiSpacer, EuiPageContent, EuiPageBody, EuiPage, EuiImage, EuiText, EuiButton } from '@elastic/eui';
import * as constants from './dashboard_empty_screen_constants';
export function DashboardEmptyScreen(_ref) {
  var showLinkToVisualize = _ref.showLinkToVisualize,
      onLinkClick = _ref.onLinkClick,
      onVisualizeClick = _ref.onVisualizeClick,
      uiSettings = _ref.uiSettings,
      http = _ref.http,
      isReadonlyMode = _ref.isReadonlyMode;
  var IS_DARK_THEME = uiSettings.get('theme:darkMode');
  var emptyStateGraphicURL = IS_DARK_THEME ? '/plugins/home/assets/welcome_graphic_dark_2x.png' : '/plugins/home/assets/welcome_graphic_light_2x.png';
  var linkToVisualizeParagraph = /*#__PURE__*/React.createElement("p", {
    "data-test-subj": "linkToVisualizeParagraph"
  }, /*#__PURE__*/React.createElement(EuiButton, {
    iconSide: "left",
    size: "s",
    iconType: "plusInCircle",
    onClick: onVisualizeClick,
    "data-test-subj": "addVisualizationButton",
    "aria-label": constants.createNewVisualizationButtonAriaLabel
  }, constants.createNewVisualizationButton));

  var paragraph = function paragraph(description1, description2, linkText, ariaLabel, dataTestSubj) {
    return /*#__PURE__*/React.createElement(EuiText, {
      size: "m",
      color: "subdued"
    }, /*#__PURE__*/React.createElement("p", null, description1, description1 && /*#__PURE__*/React.createElement("span", null, "\xA0"), /*#__PURE__*/React.createElement(EuiLink, {
      onClick: onLinkClick,
      "aria-label": ariaLabel,
      "data-test-subj": dataTestSubj || ''
    }, linkText), /*#__PURE__*/React.createElement("span", null, "\xA0"), description2));
  };

  var enterEditModeParagraph = paragraph(constants.howToStartWorkingOnNewDashboardDescription1, constants.howToStartWorkingOnNewDashboardDescription2, constants.howToStartWorkingOnNewDashboardEditLinkText, constants.howToStartWorkingOnNewDashboardEditLinkAriaLabel);
  var enterViewModeParagraph = paragraph(null, constants.addNewVisualizationDescription, constants.addExistingVisualizationLinkText, constants.addExistingVisualizationLinkAriaLabel);

  var page = function page(mainText, showAdditionalParagraph, additionalText) {
    return /*#__PURE__*/React.createElement(EuiPage, {
      className: "dshStartScreen",
      restrictWidth: "500px"
    }, /*#__PURE__*/React.createElement(EuiPageBody, null, /*#__PURE__*/React.createElement(EuiPageContent, {
      verticalPosition: "center",
      horizontalPosition: "center",
      paddingSize: "none",
      className: "dshStartScreen__pageContent"
    }, /*#__PURE__*/React.createElement(EuiImage, {
      url: http.basePath.prepend(emptyStateGraphicURL),
      alt: ""
    }), /*#__PURE__*/React.createElement(EuiText, {
      size: "m"
    }, /*#__PURE__*/React.createElement("p", {
      style: {
        fontWeight: 'bold'
      }
    }, mainText)), additionalText ? /*#__PURE__*/React.createElement(EuiText, {
      size: "m",
      color: "subdued"
    }, additionalText) : null, showAdditionalParagraph ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/React.createElement("div", {
      className: "dshStartScreen__panelDesc"
    }, enterEditModeParagraph)) : null)));
  };

  var readonlyMode = page(constants.emptyDashboardTitle, false, constants.emptyDashboardAdditionalPrivilege);
  var viewMode = page(constants.fillDashboardTitle, true);
  var editMode = /*#__PURE__*/React.createElement("div", {
    "data-test-subj": "emptyDashboardWidget",
    className: "dshEmptyWidget"
  }, enterViewModeParagraph, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "l"
  }), linkToVisualizeParagraph);
  var actionableMode = showLinkToVisualize ? editMode : viewMode;
  return /*#__PURE__*/React.createElement(I18nProvider, null, isReadonlyMode ? readonlyMode : actionableMode);
}