function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import uuid from 'uuid';
import _ from 'lodash';
import { IncompatibleActionError } from '../../ui_actions_plugin';
import { ViewMode } from '../../embeddable_plugin';
import { PanelNotFoundError } from '../../../../embeddable/public';
import { placePanelBeside } from '../embeddable/panel/dashboard_panel_placement';
import { DASHBOARD_CONTAINER_TYPE } from '..';
export var ACTION_CLONE_PANEL = 'clonePanel';
export var ClonePanelAction = /*#__PURE__*/function () {
  function ClonePanelAction(core) {
    _classCallCheck(this, ClonePanelAction);

    this.core = core;

    _defineProperty(this, "type", ACTION_CLONE_PANEL);

    _defineProperty(this, "id", ACTION_CLONE_PANEL);

    _defineProperty(this, "order", 45);
  }

  _createClass(ClonePanelAction, [{
    key: "getDisplayName",
    value: function getDisplayName(_ref) {
      var embeddable = _ref.embeddable;

      if (!embeddable.getRoot() || !embeddable.getRoot().isContainer) {
        throw new IncompatibleActionError();
      }

      return i18n.translate('dashboard.panel.clonePanel', {
        defaultMessage: 'Clone panel'
      });
    }
  }, {
    key: "getIconType",
    value: function getIconType(_ref2) {
      var embeddable = _ref2.embeddable;

      if (!embeddable.getRoot() || !embeddable.getRoot().isContainer) {
        throw new IncompatibleActionError();
      }

      return 'copy';
    }
  }, {
    key: "isCompatible",
    value: function () {
      var _isCompatible = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref3) {
        var _embeddable$getInput;

        var embeddable;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                embeddable = _ref3.embeddable;
                return _context.abrupt("return", Boolean(((_embeddable$getInput = embeddable.getInput()) === null || _embeddable$getInput === void 0 ? void 0 : _embeddable$getInput.viewMode) !== ViewMode.VIEW && embeddable.getRoot() && embeddable.getRoot().isContainer && embeddable.getRoot().type === DASHBOARD_CONTAINER_TYPE));

              case 2:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function isCompatible(_x) {
        return _isCompatible.apply(this, arguments);
      }

      return isCompatible;
    }()
  }, {
    key: "execute",
    value: function () {
      var _execute = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(_ref4) {
        var embeddable, dashboard, panelToClone;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                embeddable = _ref4.embeddable;

                if (!(!embeddable.getRoot() || !embeddable.getRoot().isContainer)) {
                  _context2.next = 3;
                  break;
                }

                throw new IncompatibleActionError();

              case 3:
                dashboard = embeddable.getRoot();
                panelToClone = dashboard.getInput().panels[embeddable.id];

                if (panelToClone) {
                  _context2.next = 7;
                  break;
                }

                throw new PanelNotFoundError();

              case 7:
                dashboard.showPlaceholderUntil(this.cloneEmbeddable(panelToClone, embeddable.type), placePanelBeside, {
                  width: panelToClone.gridData.w,
                  height: panelToClone.gridData.h,
                  currentPanels: dashboard.getInput().panels,
                  placeBesideId: panelToClone.explicitInput.id
                });

              case 8:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function execute(_x2) {
        return _execute.apply(this, arguments);
      }

      return execute;
    }()
  }, {
    key: "getUniqueTitle",
    value: function () {
      var _getUniqueTitle = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(rawTitle, embeddableType) {
        var clonedTag, cloneRegex, cloneNumberRegex, baseTitle, similarSavedObjects, similarBaseTitlesCount;
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                clonedTag = i18n.translate('dashboard.panel.title.clonedTag', {
                  defaultMessage: 'copy'
                });
                cloneRegex = new RegExp("\\(".concat(clonedTag, "\\)"), 'g');
                cloneNumberRegex = new RegExp("\\(".concat(clonedTag, " [0-9]+\\)"), 'g');
                baseTitle = rawTitle.replace(cloneNumberRegex, '').replace(cloneRegex, '').trim();
                _context3.next = 6;
                return this.core.savedObjects.client.find({
                  type: embeddableType,
                  perPage: 0,
                  fields: ['title'],
                  searchFields: ['title'],
                  search: "\"".concat(baseTitle, "\"")
                });

              case 6:
                similarSavedObjects = _context3.sent;
                similarBaseTitlesCount = similarSavedObjects.total - 1;
                return _context3.abrupt("return", similarBaseTitlesCount <= 0 ? baseTitle + " (".concat(clonedTag, ")") : baseTitle + " (".concat(clonedTag, " ").concat(similarBaseTitlesCount, ")"));

              case 9:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function getUniqueTitle(_x3, _x4) {
        return _getUniqueTitle.apply(this, arguments);
      }

      return getUniqueTitle;
    }()
  }, {
    key: "cloneEmbeddable",
    value: function () {
      var _cloneEmbeddable = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(panelToClone, embeddableType) {
        var panelState, newTitle, savedObjectToClone, clonedSavedObject;
        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                panelState = {
                  type: embeddableType,
                  explicitInput: _objectSpread(_objectSpread({}, panelToClone.explicitInput), {}, {
                    id: uuid.v4()
                  })
                };
                newTitle = '';

                if (!panelToClone.explicitInput.savedObjectId) {
                  _context4.next = 13;
                  break;
                }

                _context4.next = 5;
                return this.core.savedObjects.client.get(embeddableType, panelToClone.explicitInput.savedObjectId);

              case 5:
                savedObjectToClone = _context4.sent;
                _context4.next = 8;
                return this.getUniqueTitle(savedObjectToClone.attributes.title, embeddableType);

              case 8:
                newTitle = _context4.sent;
                _context4.next = 11;
                return this.core.savedObjects.client.create(embeddableType, _objectSpread(_objectSpread({}, _.cloneDeep(savedObjectToClone.attributes)), {}, {
                  title: newTitle
                }), {
                  references: _.cloneDeep(savedObjectToClone.references)
                });

              case 11:
                clonedSavedObject = _context4.sent;
                panelState.explicitInput.savedObjectId = clonedSavedObject.id;

              case 13:
                this.core.notifications.toasts.addSuccess({
                  title: i18n.translate('dashboard.panel.clonedToast', {
                    defaultMessage: 'Cloned panel'
                  }),
                  'data-test-subj': 'addObjectToContainerSuccess'
                });
                return _context4.abrupt("return", panelState);

              case 15:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function cloneEmbeddable(_x5, _x6) {
        return _cloneEmbeddable.apply(this, arguments);
      }

      return cloneEmbeddable;
    }()
  }]);

  return ClonePanelAction;
}();