/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiScreenReaderOnly } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import React, { useEffect } from 'react';
import { createReadOnlyAceEditor } from '../models/legacy_core_editor';
var exampleText = "\n# index a doc\nPUT index/_doc/1\n{\n  \"body\": \"here\"\n}\n\n# and get it ...\nGET index/_doc/1\n";
export function EditorExample(props) {
  var elemId = "help-example-".concat(props.panel);
  var inputId = "help-example-".concat(props.panel, "-input");
  useEffect(function () {
    var el = document.getElementById(elemId);
    el.textContent = exampleText.trim();
    var editor = createReadOnlyAceEditor(el);
    var textarea = el.querySelector('textarea');
    textarea.setAttribute('id', inputId);
    textarea.setAttribute('readonly', 'true');
    return function () {
      editor.destroy();
    };
  }, [elemId, inputId]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("label", {
    htmlFor: inputId
  }, i18n.translate('console.exampleOutputTextarea', {
    defaultMessage: 'Dev Tools Console editor example'
  }))), /*#__PURE__*/React.createElement("div", {
    id: elemId,
    className: "conHelp__example"
  }));
}