function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { PureComponent, Fragment } from 'react';
import classNames from 'classnames';
import { EuiFlexGroup, EuiFlexItem, EuiForm, EuiLink, EuiPanel, EuiSpacer, EuiText, EuiTextColor, EuiBottomBar, EuiButton, EuiToolTip, EuiButtonEmpty } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { isEmpty } from 'lodash';
import { i18n } from '@kbn/i18n';
import { toMountPoint } from '../../../../../kibana_react/public';
import { getCategoryName } from '../../lib';
import { Field, getEditableValue } from '../field';
var NAV_IS_LOCKED_KEY = 'core.chrome.isLocked';
export var Form = /*#__PURE__*/function (_PureComponent) {
  _inherits(Form, _PureComponent);

  var _super = _createSuper(Form);

  function Form() {
    var _this;

    _classCallCheck(this, Form);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      unsavedChanges: {},
      loading: false
    });

    _defineProperty(_assertThisInitialized(_this), "getSettingByKey", function (key) {
      return Object.values(_this.props.settings).flat().find(function (el) {
        return el.name === key;
      });
    });

    _defineProperty(_assertThisInitialized(_this), "getCountOfUnsavedChanges", function () {
      return Object.keys(_this.state.unsavedChanges).length;
    });

    _defineProperty(_assertThisInitialized(_this), "getCountOfHiddenUnsavedChanges", function () {
      var shownSettings = Object.values(_this.props.visibleSettings).flat().map(function (setting) {
        return setting.name;
      });
      return Object.keys(_this.state.unsavedChanges).filter(function (key) {
        return !shownSettings.includes(key);
      }).length;
    });

    _defineProperty(_assertThisInitialized(_this), "areChangesInvalid", function () {
      var unsavedChanges = _this.state.unsavedChanges;
      return Object.values(unsavedChanges).some(function (_ref) {
        var isInvalid = _ref.isInvalid;
        return isInvalid;
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleChange", function (key, change) {
      var setting = _this.getSettingByKey(key);

      if (!setting) {
        return;
      }

      var type = setting.type,
          defVal = setting.defVal,
          value = setting.value;
      var savedValue = getEditableValue(type, value, defVal);

      if (change.value === savedValue) {
        return _this.clearChange(key);
      }

      _this.setState({
        unsavedChanges: _objectSpread(_objectSpread({}, _this.state.unsavedChanges), {}, _defineProperty({}, key, change))
      });
    });

    _defineProperty(_assertThisInitialized(_this), "clearChange", function (key) {
      if (!_this.state.unsavedChanges[key]) {
        return;
      }

      var unsavedChanges = _objectSpread({}, _this.state.unsavedChanges);

      delete unsavedChanges[key];

      _this.setState({
        unsavedChanges: unsavedChanges
      });
    });

    _defineProperty(_assertThisInitialized(_this), "clearAllUnsaved", function () {
      _this.setState({
        unsavedChanges: {}
      });
    });

    _defineProperty(_assertThisInitialized(_this), "saveAll", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var unsavedChanges, configToSave, requiresReload;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _this.setLoading(true);

              unsavedChanges = _this.state.unsavedChanges;

              if (!isEmpty(unsavedChanges)) {
                _context.next = 4;
                break;
              }

              return _context.abrupt("return");

            case 4:
              configToSave = {};
              requiresReload = false;
              Object.entries(unsavedChanges).forEach(function (_ref3) {
                var _ref4 = _slicedToArray(_ref3, 2),
                    name = _ref4[0],
                    value = _ref4[1].value;

                var setting = _this.getSettingByKey(name);

                if (!setting) {
                  return;
                }

                var defVal = setting.defVal,
                    type = setting.type,
                    requiresPageReload = setting.requiresPageReload;
                var valueToSave = value;
                var equalsToDefault = false;

                switch (type) {
                  case 'array':
                    valueToSave = valueToSave.split(',').map(function (val) {
                      return val.trim();
                    });
                    equalsToDefault = valueToSave.join(',') === defVal.join(',');
                    break;

                  case 'json':
                    var isArray = Array.isArray(JSON.parse(defVal || '{}'));
                    valueToSave = valueToSave.trim();
                    valueToSave = valueToSave || (isArray ? '[]' : '{}');

                  default:
                    equalsToDefault = valueToSave === defVal;
                }

                if (requiresPageReload) {
                  requiresReload = true;
                }

                configToSave[name] = equalsToDefault ? null : valueToSave;
              });
              _context.prev = 7;
              _context.next = 10;
              return _this.props.save(configToSave);

            case 10:
              _this.clearAllUnsaved();

              if (requiresReload) {
                _this.renderPageReloadToast();
              }

              _context.next = 17;
              break;

            case 14:
              _context.prev = 14;
              _context.t0 = _context["catch"](7);

              _this.props.toasts.addDanger(i18n.translate('advancedSettings.form.saveErrorMessage', {
                defaultMessage: 'Unable to save'
              }));

            case 17:
              _this.setLoading(false);

            case 18:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, null, [[7, 14]]);
    })));

    _defineProperty(_assertThisInitialized(_this), "renderPageReloadToast", function () {
      _this.props.toasts.add({
        title: i18n.translate('advancedSettings.form.requiresPageReloadToastDescription', {
          defaultMessage: 'One or more settings require you to reload the page to take effect.'
        }),
        text: toMountPoint( /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
          justifyContent: "flexEnd",
          gutterSize: "s"
        }, /*#__PURE__*/React.createElement(EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/React.createElement(EuiButton, {
          size: "s",
          onClick: function onClick() {
            return window.location.reload();
          }
        }, i18n.translate('advancedSettings.form.requiresPageReloadToastButtonLabel', {
          defaultMessage: 'Reload page'
        })))))),
        color: 'success'
      });
    });

    _defineProperty(_assertThisInitialized(_this), "renderCountOfUnsaved", function () {
      var unsavedCount = _this.getCountOfUnsavedChanges();

      var hiddenUnsavedCount = _this.getCountOfHiddenUnsavedChanges();

      return /*#__PURE__*/React.createElement(EuiTextColor, {
        className: "mgtAdvancedSettingsForm__unsavedCountMessage",
        color: "ghost"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "advancedSettings.form.countOfSettingsChanged",
        defaultMessage: "{unsavedCount} unsaved {unsavedCount, plural, one {setting} other {settings} }{hiddenCount, plural, =0 {} other {, # hidden} }",
        values: {
          unsavedCount: unsavedCount,
          hiddenCount: hiddenUnsavedCount
        }
      }));
    });

    _defineProperty(_assertThisInitialized(_this), "renderBottomBar", function () {
      var areChangesInvalid = _this.areChangesInvalid(); // TODO #64541
      // Delete these classes


      var bottomBarClasses = '';

      var pageNav = _this.props.settings.general.find(function (setting) {
        return setting.name === 'pageNavigation';
      });

      if ((pageNav === null || pageNav === void 0 ? void 0 : pageNav.value) === 'legacy') {
        bottomBarClasses = classNames('mgtAdvancedSettingsForm__bottomBar', {
          'mgtAdvancedSettingsForm__bottomBar--pushForNav': localStorage.getItem(NAV_IS_LOCKED_KEY) === 'true'
        });
      }

      return /*#__PURE__*/React.createElement(EuiBottomBar, {
        className: bottomBarClasses,
        "data-test-subj": "advancedSetting-bottomBar"
      }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
        justifyContent: "spaceBetween",
        alignItems: "center",
        responsive: false,
        gutterSize: "s"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false,
        className: "mgtAdvancedSettingsForm__unsavedCount"
      }, /*#__PURE__*/React.createElement("p", {
        id: "aria-describedby.countOfUnsavedSettings"
      }, _this.renderCountOfUnsaved())), /*#__PURE__*/React.createElement(EuiFlexItem, null), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        color: "ghost",
        size: "s",
        iconType: "cross",
        onClick: _this.clearAllUnsaved,
        "aria-describedby": "aria-describedby.countOfUnsavedSettings",
        "data-test-subj": "advancedSetting-cancelButton"
      }, i18n.translate('advancedSettings.form.cancelButtonLabel', {
        defaultMessage: 'Cancel changes'
      }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiToolTip, {
        content: areChangesInvalid && i18n.translate('advancedSettings.form.saveButtonTooltipWithInvalidChanges', {
          defaultMessage: 'Fix invalid settings before saving.'
        })
      }, /*#__PURE__*/React.createElement(EuiButton, {
        className: "mgtAdvancedSettingsForm__button",
        disabled: areChangesInvalid,
        color: "secondary",
        fill: true,
        size: "s",
        iconType: "check",
        onClick: _this.saveAll,
        "aria-describedby": "aria-describedby.countOfUnsavedSettings",
        isLoading: _this.state.loading,
        "data-test-subj": "advancedSetting-saveButton"
      }, i18n.translate('advancedSettings.form.saveButtonLabel', {
        defaultMessage: 'Save changes'
      }))))));
    });

    return _this;
  }

  _createClass(Form, [{
    key: "setLoading",
    value: function setLoading(loading) {
      this.setState({
        loading: loading
      });
    }
  }, {
    key: "renderClearQueryLink",
    value: function renderClearQueryLink(totalSettings, currentSettings) {
      var clearQuery = this.props.clearQuery;

      if (totalSettings !== currentSettings) {
        return /*#__PURE__*/React.createElement(EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/React.createElement("em", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "advancedSettings.form.searchResultText",
          defaultMessage: "Search terms are hiding {settingsCount} settings {clearSearch}",
          values: {
            settingsCount: totalSettings - currentSettings,
            clearSearch: /*#__PURE__*/React.createElement(EuiLink, {
              onClick: clearQuery
            }, /*#__PURE__*/React.createElement("em", null, /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "advancedSettings.form.clearSearchResultText",
              defaultMessage: "(clear search)"
            })))
          }
        })));
      }

      return null;
    }
  }, {
    key: "renderCategory",
    value: function renderCategory(category, settings, totalSettings) {
      var _this2 = this;

      return /*#__PURE__*/React.createElement(Fragment, {
        key: category
      }, /*#__PURE__*/React.createElement(EuiPanel, {
        paddingSize: "l"
      }, /*#__PURE__*/React.createElement(EuiForm, null, /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
        alignItems: "baseline"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement("h2", null, getCategoryName(category))), this.renderClearQueryLink(totalSettings, settings.length))), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), settings.map(function (setting) {
        return /*#__PURE__*/React.createElement(Field, {
          key: setting.name,
          setting: setting,
          handleChange: _this2.handleChange,
          unsavedChanges: _this2.state.unsavedChanges[setting.name],
          clearChange: _this2.clearChange,
          enableSaving: _this2.props.enableSaving,
          dockLinks: _this2.props.dockLinks,
          toasts: _this2.props.toasts
        });
      }))), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "l"
      }));
    }
  }, {
    key: "maybeRenderNoSettings",
    value: function maybeRenderNoSettings(clearQuery) {
      if (this.props.showNoResultsMessage) {
        return /*#__PURE__*/React.createElement(EuiPanel, {
          paddingSize: "l"
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "advancedSettings.form.noSearchResultText",
          defaultMessage: "No settings found {clearSearch}",
          values: {
            clearSearch: /*#__PURE__*/React.createElement(EuiLink, {
              onClick: clearQuery
            }, /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "advancedSettings.form.clearNoSearchResultText",
              defaultMessage: "(clear search)"
            }))
          }
        }));
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var unsavedChanges = this.state.unsavedChanges;
      var _this$props = this.props,
          visibleSettings = _this$props.visibleSettings,
          categories = _this$props.categories,
          categoryCounts = _this$props.categoryCounts,
          clearQuery = _this$props.clearQuery;
      var currentCategories = [];
      categories.forEach(function (category) {
        if (visibleSettings[category] && visibleSettings[category].length) {
          currentCategories.push(category);
        }
      });
      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement("div", null, currentCategories.length ? currentCategories.map(function (category) {
        return _this3.renderCategory(category, visibleSettings[category], categoryCounts[category]);
      }) : this.maybeRenderNoSettings(clearQuery)), !isEmpty(unsavedChanges) && this.renderBottomBar());
    }
  }]);

  return Form;
}(PureComponent);