function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import ReactDOM from 'react-dom';
import { npStart } from 'ui/new_platform';
import { I18nProvider } from '@kbn/i18n/react';
var npBanners = npStart.core.overlays.banners;
/** compatibility layer for new platform */

var mountForComponent = function mountForComponent(component) {
  return function (element) {
    ReactDOM.render( /*#__PURE__*/React.createElement(I18nProvider, null, component), element);
    return function () {
      return ReactDOM.unmountComponentAtNode(element);
    };
  };
};
/**
 * Banners represents a prioritized list of displayed components.
 */


export var Banners = function Banners() {
  _classCallCheck(this, Banners);

  _defineProperty(this, "add", function (_ref) {
    var component = _ref.component,
        priority = _ref.priority;
    return npBanners.add(mountForComponent(component), priority);
  });

  _defineProperty(this, "remove", function (id) {
    return npBanners.remove(id);
  });

  _defineProperty(this, "set", function (_ref2) {
    var component = _ref2.component,
        id = _ref2.id,
        _ref2$priority = _ref2.priority,
        priority = _ref2$priority === void 0 ? 0 : _ref2$priority;
    return npBanners.replace(id, mountForComponent(component), priority);
  });
};
/**
 * A singleton instance meant to represent all Kibana banners.
 */

export var banners = new Banners();