function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { npStart } from 'ui/new_platform';
var newPlatformChrome = npStart.core.chrome;

function createBreadcrumbsApi(chrome) {
  var currentBreadcrumbs = []; // reset breadcrumbSetSinceRouteChange any time the breadcrumbs change, even
  // if it was done directly through the new platform

  newPlatformChrome.getBreadcrumbs$().subscribe({
    next: function next(nextBreadcrumbs) {
      currentBreadcrumbs = nextBreadcrumbs;
    }
  });
  return {
    breadcrumbs: {
      /**
       * Get an observerable that emits the current list of breadcrumbs
       * and emits each update to the breadcrumbs
       */
      get$: function get$() {
        return newPlatformChrome.getBreadcrumbs$();
      },

      /**
       * Replace the set of breadcrumbs with a new set
       */
      set: function set(newBreadcrumbs) {
        newPlatformChrome.setBreadcrumbs(newBreadcrumbs);
      },

      /**
       * Add a breadcrumb to the end of the list of breadcrumbs
       */
      push: function push(breadcrumb) {
        newPlatformChrome.setBreadcrumbs([].concat(_toConsumableArray(currentBreadcrumbs), [breadcrumb]));
      },

      /**
       * Filter the current set of breadcrumbs with a function. Works like Array#filter()
       */
      filter: function filter(fn) {
        newPlatformChrome.setBreadcrumbs(currentBreadcrumbs.filter(fn));
      },

      /**
       * Remove last element of the breadcrumb
       */
      pop: function pop() {
        newPlatformChrome.setBreadcrumbs(currentBreadcrumbs.slice(0, -1));
      }
    }
  };
}

export function initBreadcrumbsApi(chrome, internals) {
  var _createBreadcrumbsApi = createBreadcrumbsApi(chrome),
      breadcrumbs = _createBreadcrumbsApi.breadcrumbs;

  chrome.breadcrumbs = breadcrumbs;
}