function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { ChromeService } from './chrome';
import { FatalErrorsService } from './fatal_errors';
import { HttpService } from './http';
import { I18nService } from './i18n';
import { InjectedMetadataService } from './injected_metadata';
import { LegacyPlatformService } from './legacy';
import { NotificationsService } from './notifications';
import { OverlayService } from './overlays';
import { PluginsService } from './plugins';
import { UiSettingsService } from './ui_settings';
import { ApplicationService } from './application';
import { mapToObject, pick } from '../utils/';
import { DocLinksService } from './doc_links';
import { RenderingService } from './rendering';
import { SavedObjectsService } from './saved_objects';
import { ContextService } from './context';
import { IntegrationsService } from './integrations';
import { CoreApp } from './core_app';

/**
 * The CoreSystem is the root of the new platform, and setups all parts
 * of Kibana in the UI, including the LegacyPlatform which is managed
 * by the LegacyPlatformService. As we migrate more things to the new
 * platform the CoreSystem will get many more Services.
 *
 * @internal
 */
export var CoreSystem = /*#__PURE__*/function () {
  function CoreSystem(params) {
    var _this = this;

    _classCallCheck(this, CoreSystem);

    _defineProperty(this, "fatalErrors", void 0);

    _defineProperty(this, "injectedMetadata", void 0);

    _defineProperty(this, "legacy", void 0);

    _defineProperty(this, "notifications", void 0);

    _defineProperty(this, "http", void 0);

    _defineProperty(this, "savedObjects", void 0);

    _defineProperty(this, "uiSettings", void 0);

    _defineProperty(this, "chrome", void 0);

    _defineProperty(this, "i18n", void 0);

    _defineProperty(this, "overlay", void 0);

    _defineProperty(this, "plugins", void 0);

    _defineProperty(this, "application", void 0);

    _defineProperty(this, "docLinks", void 0);

    _defineProperty(this, "rendering", void 0);

    _defineProperty(this, "context", void 0);

    _defineProperty(this, "integrations", void 0);

    _defineProperty(this, "coreApp", void 0);

    _defineProperty(this, "rootDomElement", void 0);

    _defineProperty(this, "coreContext", void 0);

    _defineProperty(this, "fatalErrorsSetup", null);

    var rootDomElement = params.rootDomElement,
        browserSupportsCsp = params.browserSupportsCsp,
        injectedMetadata = params.injectedMetadata,
        requireLegacyFiles = params.requireLegacyFiles,
        requireLegacyBootstrapModule = params.requireLegacyBootstrapModule,
        requireNewPlatformShimModule = params.requireNewPlatformShimModule;
    this.rootDomElement = rootDomElement;
    this.i18n = new I18nService();
    this.injectedMetadata = new InjectedMetadataService({
      injectedMetadata: injectedMetadata
    });
    this.fatalErrors = new FatalErrorsService(rootDomElement, function () {
      // Stop Core before rendering any fatal errors into the DOM
      _this.stop();
    });
    this.notifications = new NotificationsService();
    this.http = new HttpService();
    this.savedObjects = new SavedObjectsService();
    this.uiSettings = new UiSettingsService();
    this.overlay = new OverlayService();
    this.chrome = new ChromeService({
      browserSupportsCsp: browserSupportsCsp
    });
    this.docLinks = new DocLinksService();
    this.rendering = new RenderingService();
    this.application = new ApplicationService();
    this.integrations = new IntegrationsService();
    this.coreContext = {
      coreId: Symbol('core'),
      env: injectedMetadata.env
    };
    this.context = new ContextService(this.coreContext);
    this.plugins = new PluginsService(this.coreContext, injectedMetadata.uiPlugins);
    this.coreApp = new CoreApp(this.coreContext);
    this.legacy = new LegacyPlatformService({
      requireLegacyFiles: requireLegacyFiles,
      requireLegacyBootstrapModule: requireLegacyBootstrapModule,
      requireNewPlatformShimModule: requireNewPlatformShimModule
    });
  }

  _createClass(CoreSystem, [{
    key: "setup",
    value: function () {
      var _setup = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var injectedMetadata, http, uiSettings, notifications, pluginDependencies, context, application, core, plugins;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                // Setup FatalErrorsService and it's dependencies first so that we're
                // able to render any errors.
                injectedMetadata = this.injectedMetadata.setup();
                this.fatalErrorsSetup = this.fatalErrors.setup({
                  injectedMetadata: injectedMetadata,
                  i18n: this.i18n.getContext()
                });
                _context.next = 5;
                return this.integrations.setup();

              case 5:
                this.docLinks.setup();
                http = this.http.setup({
                  injectedMetadata: injectedMetadata,
                  fatalErrors: this.fatalErrorsSetup
                });
                uiSettings = this.uiSettings.setup({
                  http: http,
                  injectedMetadata: injectedMetadata
                });
                notifications = this.notifications.setup({
                  uiSettings: uiSettings
                });
                pluginDependencies = this.plugins.getOpaqueIds();
                context = this.context.setup({
                  // We inject a fake "legacy plugin" with dependencies on every plugin so that legacy plugins:
                  // 1) Can access context from any NP plugin
                  // 2) Can register context providers that will only be available to other legacy plugins and will not leak into
                  //    New Platform plugins.
                  pluginDependencies: new Map([].concat(_toConsumableArray(pluginDependencies), [[this.legacy.legacyId, _toConsumableArray(pluginDependencies.keys())]]))
                });
                application = this.application.setup({
                  context: context,
                  http: http,
                  injectedMetadata: injectedMetadata
                });
                this.coreApp.setup({
                  application: application,
                  http: http
                });
                core = {
                  application: application,
                  context: context,
                  fatalErrors: this.fatalErrorsSetup,
                  http: http,
                  injectedMetadata: injectedMetadata,
                  notifications: notifications,
                  uiSettings: uiSettings
                }; // Services that do not expose contracts at setup

                _context.next = 16;
                return this.plugins.setup(core);

              case 16:
                plugins = _context.sent;
                _context.next = 19;
                return this.legacy.setup({
                  core: core,
                  plugins: mapToObject(plugins.contracts)
                });

              case 19:
                return _context.abrupt("return", {
                  fatalErrors: this.fatalErrorsSetup
                });

              case 22:
                _context.prev = 22;
                _context.t0 = _context["catch"](0);

                if (this.fatalErrorsSetup) {
                  this.fatalErrorsSetup.add(_context.t0);
                } else {
                  // If the FatalErrorsService has not yet been setup, log error to console
                  // eslint-disable-next-line no-console
                  console.log(_context.t0);
                }

              case 25:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[0, 22]]);
      }));

      function setup() {
        return _setup.apply(this, arguments);
      }

      return setup;
    }()
  }, {
    key: "start",
    value: function () {
      var _start = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
        var injectedMetadata, uiSettings, docLinks, http, savedObjects, i18n, fatalErrors, coreUiTargetDomElement, notificationsTargetDomElement, overlayTargetDomElement, overlays, notifications, application, chrome, core, plugins, rendering;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.prev = 0;
                _context2.next = 3;
                return this.injectedMetadata.start();

              case 3:
                injectedMetadata = _context2.sent;
                _context2.next = 6;
                return this.uiSettings.start();

              case 6:
                uiSettings = _context2.sent;
                docLinks = this.docLinks.start({
                  injectedMetadata: injectedMetadata
                });
                _context2.next = 10;
                return this.http.start();

              case 10:
                http = _context2.sent;
                _context2.next = 13;
                return this.savedObjects.start({
                  http: http
                });

              case 13:
                savedObjects = _context2.sent;
                _context2.next = 16;
                return this.i18n.start();

              case 16:
                i18n = _context2.sent;
                _context2.next = 19;
                return this.fatalErrors.start();

              case 19:
                fatalErrors = _context2.sent;
                _context2.next = 22;
                return this.integrations.start({
                  uiSettings: uiSettings
                });

              case 22:
                coreUiTargetDomElement = document.createElement('div');
                coreUiTargetDomElement.id = 'kibana-body';
                notificationsTargetDomElement = document.createElement('div');
                overlayTargetDomElement = document.createElement('div');
                overlays = this.overlay.start({
                  i18n: i18n,
                  targetDomElement: overlayTargetDomElement,
                  uiSettings: uiSettings
                });
                _context2.next = 29;
                return this.notifications.start({
                  i18n: i18n,
                  overlays: overlays,
                  targetDomElement: notificationsTargetDomElement
                });

              case 29:
                notifications = _context2.sent;
                _context2.next = 32;
                return this.application.start({
                  http: http,
                  overlays: overlays
                });

              case 32:
                application = _context2.sent;
                _context2.next = 35;
                return this.chrome.start({
                  application: application,
                  docLinks: docLinks,
                  http: http,
                  injectedMetadata: injectedMetadata,
                  notifications: notifications,
                  uiSettings: uiSettings
                });

              case 35:
                chrome = _context2.sent;
                this.coreApp.start({
                  application: application,
                  http: http,
                  notifications: notifications,
                  uiSettings: uiSettings
                });
                application.registerMountContext(this.coreContext.coreId, 'core', function () {
                  return {
                    application: pick(application, ['capabilities', 'navigateToApp']),
                    chrome: chrome,
                    docLinks: docLinks,
                    http: http,
                    i18n: i18n,
                    injectedMetadata: pick(injectedMetadata, ['getInjectedVar']),
                    notifications: notifications,
                    overlays: overlays,
                    savedObjects: savedObjects,
                    uiSettings: uiSettings
                  };
                });
                core = {
                  application: application,
                  chrome: chrome,
                  docLinks: docLinks,
                  http: http,
                  savedObjects: savedObjects,
                  i18n: i18n,
                  injectedMetadata: injectedMetadata,
                  notifications: notifications,
                  overlays: overlays,
                  uiSettings: uiSettings,
                  fatalErrors: fatalErrors
                };
                _context2.next = 41;
                return this.plugins.start(core);

              case 41:
                plugins = _context2.sent;
                // ensure the rootDomElement is empty
                this.rootDomElement.textContent = '';
                this.rootDomElement.classList.add('coreSystemRootDomElement');
                this.rootDomElement.appendChild(coreUiTargetDomElement);
                this.rootDomElement.appendChild(notificationsTargetDomElement);
                this.rootDomElement.appendChild(overlayTargetDomElement);
                rendering = this.rendering.start({
                  application: application,
                  chrome: chrome,
                  injectedMetadata: injectedMetadata,
                  overlays: overlays,
                  targetDomElement: coreUiTargetDomElement
                });
                _context2.next = 50;
                return this.legacy.start({
                  core: core,
                  plugins: mapToObject(plugins.contracts),
                  targetDomElement: rendering.legacyTargetDomElement
                });

              case 50:
                return _context2.abrupt("return", {
                  application: application
                });

              case 53:
                _context2.prev = 53;
                _context2.t0 = _context2["catch"](0);

                if (this.fatalErrorsSetup) {
                  this.fatalErrorsSetup.add(_context2.t0);
                } else {
                  // If the FatalErrorsService has not yet been setup, log error to console
                  // eslint-disable-next-line no-console
                  console.error(_context2.t0);
                }

              case 56:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this, [[0, 53]]);
      }));

      function start() {
        return _start.apply(this, arguments);
      }

      return start;
    }()
  }, {
    key: "stop",
    value: function stop() {
      this.legacy.stop();
      this.plugins.stop();
      this.coreApp.stop();
      this.notifications.stop();
      this.http.stop();
      this.integrations.stop();
      this.uiSettings.stop();
      this.chrome.stop();
      this.i18n.stop();
      this.application.stop();
      this.rootDomElement.textContent = '';
    }
  }]);

  return CoreSystem;
}();