function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import './collapsible_nav.scss';
import { EuiCollapsibleNav, EuiCollapsibleNavGroup, EuiFlexItem, EuiHorizontalRule, EuiListGroup, EuiListGroupItem, EuiShowFor, EuiText } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { groupBy, sortBy } from 'lodash';
import React, { Fragment, useRef } from 'react';
import { useObservable } from 'react-use';
import { createEuiListItem, createRecentNavLink, isModifiedOrPrevented } from './nav_link';

function getAllCategories(allCategorizedLinks) {
  var allCategories = {};

  for (var _i = 0, _Object$entries = Object.entries(allCategorizedLinks); _i < _Object$entries.length; _i++) {
    var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
        key = _Object$entries$_i[0],
        value = _Object$entries$_i[1];

    allCategories[key] = value[0].category;
  }

  return allCategories;
}

function getOrderedCategories(mainCategories, categoryDictionary) {
  return sortBy(Object.keys(mainCategories), function (categoryName) {
    var _categoryDictionary$c;

    return (_categoryDictionary$c = categoryDictionary[categoryName]) === null || _categoryDictionary$c === void 0 ? void 0 : _categoryDictionary$c.order;
  });
}

function getCategoryLocalStorageKey(id) {
  return "core.navGroup.".concat(id);
}

function getIsCategoryOpen(id, storage) {
  var _storage$getItem;

  var value = (_storage$getItem = storage.getItem(getCategoryLocalStorageKey(id))) !== null && _storage$getItem !== void 0 ? _storage$getItem : 'true';
  return value === 'true';
}

function setIsCategoryOpen(id, isOpen, storage) {
  storage.setItem(getCategoryLocalStorageKey(id), "".concat(isOpen));
}

export function CollapsibleNav(_ref) {
  var basePath = _ref.basePath,
      id = _ref.id,
      isLocked = _ref.isLocked,
      isOpen = _ref.isOpen,
      homeHref = _ref.homeHref,
      legacyMode = _ref.legacyMode,
      _ref$storage = _ref.storage,
      storage = _ref$storage === void 0 ? window.localStorage : _ref$storage,
      onIsLockedUpdate = _ref.onIsLockedUpdate,
      closeNav = _ref.closeNav,
      navigateToApp = _ref.navigateToApp,
      observables = _objectWithoutProperties(_ref, ["basePath", "id", "isLocked", "isOpen", "homeHref", "legacyMode", "storage", "onIsLockedUpdate", "closeNav", "navigateToApp"]);

  var navLinks = useObservable(observables.navLinks$, []).filter(function (link) {
    return !link.hidden;
  });
  var recentlyAccessed = useObservable(observables.recentlyAccessed$, []);
  var customNavLink = useObservable(observables.customNavLink$, undefined);
  var appId = useObservable(observables.appId$, '');
  var lockRef = useRef(null);
  var groupedNavLinks = groupBy(navLinks, function (link) {
    var _link$category;

    return link === null || link === void 0 ? void 0 : (_link$category = link.category) === null || _link$category === void 0 ? void 0 : _link$category.id;
  });

  var _groupedNavLinks$unde = groupedNavLinks.undefined,
      unknowns = _groupedNavLinks$unde === void 0 ? [] : _groupedNavLinks$unde,
      allCategorizedLinks = _objectWithoutProperties(groupedNavLinks, ["undefined"]);

  var categoryDictionary = getAllCategories(allCategorizedLinks);
  var orderedCategories = getOrderedCategories(allCategorizedLinks, categoryDictionary);

  var readyForEUI = function readyForEUI(link) {
    var needsIcon = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    return createEuiListItem(_objectSpread({
      link: link,
      legacyMode: legacyMode,
      appId: appId,
      dataTestSubj: 'collapsibleNavAppLink',
      navigateToApp: navigateToApp,
      onClick: closeNav
    }, needsIcon && {
      basePath: basePath
    }));
  };

  return /*#__PURE__*/React.createElement(EuiCollapsibleNav, {
    "data-test-subj": "collapsibleNav",
    id: id,
    "aria-label": i18n.translate('core.ui.primaryNav.screenReaderLabel', {
      defaultMessage: 'Primary'
    }),
    isOpen: isOpen,
    isDocked: isLocked,
    onClose: closeNav
  }, customNavLink && /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false,
    style: {
      flexShrink: 0
    }
  }, /*#__PURE__*/React.createElement(EuiCollapsibleNavGroup, {
    background: "light",
    className: "eui-yScroll",
    style: {
      maxHeight: '40vh'
    }
  }, /*#__PURE__*/React.createElement(EuiListGroup, {
    listItems: [createEuiListItem({
      link: customNavLink,
      legacyMode: legacyMode,
      basePath: basePath,
      navigateToApp: navigateToApp,
      dataTestSubj: 'collapsibleNavCustomNavLink',
      onClick: closeNav,
      externalLink: true
    })],
    maxWidth: "none",
    color: "text",
    gutterSize: "none",
    size: "s"
  }))), /*#__PURE__*/React.createElement(EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false,
    style: {
      flexShrink: 0
    }
  }, /*#__PURE__*/React.createElement(EuiCollapsibleNavGroup, {
    background: "light",
    className: "eui-yScroll",
    style: {
      maxHeight: '40vh'
    }
  }, /*#__PURE__*/React.createElement(EuiListGroup, {
    "aria-label": i18n.translate('core.ui.primaryNav.pinnedLinksAriaLabel', {
      defaultMessage: 'Pinned links'
    }),
    listItems: [{
      label: 'Home',
      iconType: 'home',
      href: homeHref,
      onClick: function onClick(event) {
        if (isModifiedOrPrevented(event)) {
          return;
        }

        event.preventDefault();
        closeNav();
        navigateToApp('home');
      }
    }],
    maxWidth: "none",
    color: "text",
    gutterSize: "none",
    size: "s"
  }))), /*#__PURE__*/React.createElement(EuiCollapsibleNavGroup, {
    key: "recentlyViewed",
    background: "light",
    title: i18n.translate('core.ui.recentlyViewed', {
      defaultMessage: 'Recently viewed'
    }),
    isCollapsible: true,
    initialIsOpen: getIsCategoryOpen('recentlyViewed', storage),
    onToggle: function onToggle(isCategoryOpen) {
      return setIsCategoryOpen('recentlyViewed', isCategoryOpen, storage);
    },
    "data-test-subj": "collapsibleNavGroup-recentlyViewed"
  }, recentlyAccessed.length > 0 ? /*#__PURE__*/React.createElement(EuiListGroup, {
    "aria-label": i18n.translate('core.ui.recentlyViewedAriaLabel', {
      defaultMessage: 'Recently viewed links'
    }),
    listItems: recentlyAccessed.map(function (link) {
      // TODO #64541
      // Can remove icon from recent links completely
      var _createRecentNavLink = createRecentNavLink(link, navLinks, basePath),
          iconType = _createRecentNavLink.iconType,
          hydratedLink = _objectWithoutProperties(_createRecentNavLink, ["iconType"]);

      return _objectSpread(_objectSpread({}, hydratedLink), {}, {
        'data-test-subj': 'collapsibleNavAppLink--recent',
        onClick: function onClick(event) {
          if (isModifiedOrPrevented(event)) {
            return;
          }

          closeNav();
        }
      });
    }),
    maxWidth: "none",
    color: "subdued",
    gutterSize: "none",
    size: "s",
    className: "kbnCollapsibleNav__recentsListGroup"
  }) : /*#__PURE__*/React.createElement(EuiText, {
    size: "s",
    color: "subdued",
    style: {
      padding: '0 8px 8px'
    }
  }, /*#__PURE__*/React.createElement("p", null, i18n.translate('core.ui.EmptyRecentlyViewed', {
    defaultMessage: 'No recently viewed items'
  })))), /*#__PURE__*/React.createElement(EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/React.createElement(EuiFlexItem, {
    className: "eui-yScroll"
  }, orderedCategories.map(function (categoryName) {
    var category = categoryDictionary[categoryName];
    return /*#__PURE__*/React.createElement(EuiCollapsibleNavGroup, {
      key: category.id,
      iconType: category.euiIconType,
      title: category.label,
      isCollapsible: true,
      initialIsOpen: getIsCategoryOpen(category.id, storage),
      onToggle: function onToggle(isCategoryOpen) {
        return setIsCategoryOpen(category.id, isCategoryOpen, storage);
      },
      "data-test-subj": "collapsibleNavGroup-".concat(category.id)
    }, /*#__PURE__*/React.createElement(EuiListGroup, {
      "aria-label": i18n.translate('core.ui.primaryNavSection.screenReaderLabel', {
        defaultMessage: 'Primary navigation links, {category}',
        values: {
          category: category.label
        }
      }),
      listItems: allCategorizedLinks[categoryName].map(function (link) {
        return readyForEUI(link);
      }),
      maxWidth: "none",
      color: "subdued",
      gutterSize: "none",
      size: "s"
    }));
  }), unknowns.map(function (link, i) {
    return /*#__PURE__*/React.createElement(EuiCollapsibleNavGroup, {
      "data-test-subj": "collapsibleNavGroup-noCategory",
      key: i
    }, /*#__PURE__*/React.createElement(EuiListGroup, {
      flush: true
    }, /*#__PURE__*/React.createElement(EuiListGroupItem, _extends({
      color: "text",
      size: "s"
    }, readyForEUI(link, true)))));
  }), /*#__PURE__*/React.createElement(EuiShowFor, {
    sizes: ['l', 'xl']
  }, /*#__PURE__*/React.createElement(EuiCollapsibleNavGroup, null, /*#__PURE__*/React.createElement(EuiListGroup, {
    flush: true
  }, /*#__PURE__*/React.createElement(EuiListGroupItem, {
    "data-test-subj": "collapsible-nav-lock",
    buttonRef: lockRef,
    size: "xs",
    color: "subdued",
    label: isLocked ? i18n.translate('core.ui.primaryNavSection.undockLabel', {
      defaultMessage: 'Undock navigation'
    }) : i18n.translate('core.ui.primaryNavSection.dockLabel', {
      defaultMessage: 'Dock navigation'
    }),
    "aria-label": isLocked ? i18n.translate('core.ui.primaryNavSection.undockAriaLabel', {
      defaultMessage: 'Undock primary navigation'
    }) : i18n.translate('core.ui.primaryNavSection.dockAriaLabel', {
      defaultMessage: 'Dock primary navigation'
    }),
    onClick: function onClick() {
      onIsLockedUpdate(!isLocked);

      if (lockRef.current) {
        lockRef.current.focus();
      }
    },
    iconType: isLocked ? 'lock' : 'lockOpen'
  }))))));
}