import _extends from "@babel/runtime/helpers/extends";
import _inheritsLoose from "@babel/runtime/helpers/inheritsLoose";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import moveFocusInside, { focusInside, constants } from 'focus-lock';
import { inlineProp } from './util';

var MoveFocusInside =
/*#__PURE__*/
function (_Component) {
  _inheritsLoose(MoveFocusInside, _Component);

  function MoveFocusInside() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _Component.call.apply(_Component, [this].concat(args)) || this;

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "setObserveNode", function (ref) {
      _this.observed = ref;

      _this.moveFocus();
    });

    return _this;
  }

  var _proto = MoveFocusInside.prototype;

  _proto.componentDidMount = function componentDidMount() {
    this.moveFocus();
  };

  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
    if (prevProps.disabled && !this.props.disabled) {
      this.moveFocus();
    }
  };

  _proto.moveFocus = function moveFocus() {
    var observed = this.observed;

    if (!this.props.disabled && observed) {
      if (!focusInside(observed)) {
        moveFocusInside(observed, null);
      }
    }
  };

  _proto.render = function render() {
    var _this$props = this.props,
        children = _this$props.children,
        disabled = _this$props.disabled,
        className = _this$props.className;
    return React.createElement("div", _extends({}, inlineProp(constants.FOCUS_AUTO, !disabled), {
      ref: this.setObserveNode,
      className: className
    }), children);
  };

  return MoveFocusInside;
}(Component);

_defineProperty(MoveFocusInside, "defaultProps", {
  disabled: false,
  className: undefined
});

export { MoveFocusInside as default };
MoveFocusInside.propTypes = process.env.NODE_ENV !== "production" ? {
  children: PropTypes.node.isRequired,
  disabled: PropTypes.bool,
  className: PropTypes.string
} : {};