"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../renderers/canvas");
var rendering_1 = require("../../rendering/rendering");
var points_1 = require("./points");
function renderBubbles(ctx, props) {
    canvas_1.withContext(ctx, function (ctx) {
        var _a;
        var bubbles = props.bubbles, sharedStyle = props.sharedStyle, highlightedLegendItem = props.highlightedLegendItem, clippings = props.clippings;
        var geometryStyles = {};
        var pointStyles = {};
        var allPoints = bubbles.reduce(function (acc, _a) {
            var seriesIdentifier = _a.seriesIdentifier, seriesPointStyle = _a.seriesPointStyle, points = _a.points;
            var geometryStyle = rendering_1.getGeometryStateStyle(seriesIdentifier, highlightedLegendItem, sharedStyle);
            geometryStyles[seriesIdentifier.key] = geometryStyle;
            pointStyles[seriesIdentifier.key] = seriesPointStyle;
            acc.push.apply(acc, __spread(points));
            return acc;
        }, []);
        canvas_1.withClip(ctx, clippings, function (ctx) {
            points_1.renderPointGroup(ctx, allPoints, pointStyles, geometryStyles);
        }, ((_a = allPoints[0]) === null || _a === void 0 ? void 0 : _a.value.mark) !== null);
    });
}
exports.renderBubbles = renderBubbles;
//# sourceMappingURL=bubbles.js.map