export class DatabaseTableView extends UI.SimpleView{constructor(database,tableName){super(Common.UIString('Database'));this.database=database;this.tableName=tableName;this.element.classList.add('storage-view','table');this._visibleColumnsSetting=self.Common.settings.createSetting('databaseTableViewVisibleColumns',{});this.refreshButton=new UI.ToolbarButton(Common.UIString('Refresh'),'largeicon-refresh');this.refreshButton.addEventListener(UI.ToolbarButton.Events.Click,this._refreshButtonClicked,this);this._visibleColumnsInput=new UI.ToolbarInput(Common.UIString('Visible columns'),'',1);this._visibleColumnsInput.addEventListener(UI.ToolbarInput.Event.TextChanged,this._onVisibleColumnsChanged,this);}
wasShown(){this.update();}
async toolbarItems(){return[this.refreshButton,this._visibleColumnsInput];}
_escapeTableName(tableName){return tableName.replace(/\"/g,'""');}
update(){this.database.executeSql('SELECT rowid, * FROM "'+this._escapeTableName(this.tableName)+'"',this._queryFinished.bind(this),this._queryError.bind(this));}
_queryFinished(columnNames,values){this.detachChildWidgets();this.element.removeChildren();this._dataGrid=DataGrid.SortableDataGrid.create(columnNames,values,ls`Database`);this._visibleColumnsInput.setVisible(!!this._dataGrid);if(!this._dataGrid){this._emptyWidget=new UI.EmptyWidget(ls`The "${this.tableName}"\ntable is empty.`);this._emptyWidget.show(this.element);return;}
this._dataGrid.setStriped(true);this._dataGrid.asWidget().show(this.element);this._dataGrid.autoSizeColumns(5);this._columnsMap=new Map();for(let i=1;i<columnNames.length;++i){this._columnsMap.set(columnNames[i],String(i));}
this._lastVisibleColumns='';const visibleColumnsText=this._visibleColumnsSetting.get()[this.tableName]||'';this._visibleColumnsInput.setValue(visibleColumnsText);this._onVisibleColumnsChanged();}
_onVisibleColumnsChanged(){if(!this._dataGrid){return;}
const text=this._visibleColumnsInput.value();const parts=text.split(/[\s,]+/);const matches=new Set();const columnsVisibility={};columnsVisibility['0']=true;for(let i=0;i<parts.length;++i){const part=parts[i];if(this._columnsMap.has(part)){matches.add(part);columnsVisibility[this._columnsMap.get(part)]=true;}}
const newVisibleColumns=matches.valuesArray().sort().join(', ');if(newVisibleColumns.length===0){for(const v of this._columnsMap.values()){columnsVisibility[v]=true;}}
if(newVisibleColumns===this._lastVisibleColumns){return;}
const visibleColumnsRegistry=this._visibleColumnsSetting.get();visibleColumnsRegistry[this.tableName]=text;this._visibleColumnsSetting.set(visibleColumnsRegistry);this._dataGrid.setColumnsVisiblity(columnsVisibility);this._lastVisibleColumns=newVisibleColumns;}
_queryError(error){this.detachChildWidgets();this.element.removeChildren();const errorMsgElement=createElement('div');errorMsgElement.className='storage-table-error';errorMsgElement.textContent=ls`An error occurred trying to\nread the "${this.tableName}" table.`;this.element.appendChild(errorMsgElement);}
_refreshButtonClicked(event){this.update();}}