(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/net/socket/api#ssocket-connect__%
    (lambda (_addr148545_ _timeo148546_)
      (let* ((_sa148548_ (std/os/socket#socket-address _addr148545_))
             (_sock148550_
              (std/os/socket#socket__0
               (std/os/_socket#sockaddr_family _sa148548_)
               std/os/_socket#SOCK_STREAM))
             (_rcon148560_
              (with-exception-catcher
               (lambda (_g148551148553_)
                 (if '#t
                     (let ((_e148556_ _g148551148553_))
                       (close-port _sock148550_)
                       (raise _e148556_))
                     (raise _g148551148553_)))
               (lambda ()
                 (std/os/socket#socket-connect _sock148550_ _sa148548_))))
             (_ssock148562_ (std/net/socket/api#make-ssocket _sock148550_)))
        (let* ((_ssock148564148573_ _ssock148562_)
               (_E148566148577_
                (lambda () (error '"No clause matching" _ssock148564148573_)))
               (_K148567148588_
                (lambda (_close148580_ _wait-out148581_)
                  (if _rcon148560_
                      '#!void
                      (if (_wait-out148581_
                           _ssock148562_
                           (std/net/socket/base#abs-timeout _timeo148546_))
                          '#!void
                          (begin
                            (_close148580_ _ssock148562_ 'inout '#f)
                            (std/error#raise-timeout
                             'ssocket-connect
                             '"connection timeout"
                             _addr148545_))))
                  (let ((_errno148586_
                         (let ((_$e148583_ _rcon148560_))
                           (if _$e148583_
                               _$e148583_
                               (std/os/socket#socket-getsockopt
                                _sock148550_
                                std/os/_socket#SOL_SOCKET
                                std/os/_socket#SO_ERROR)))))
                    (if (##fxzero? _errno148586_)
                        _ssock148562_
                        (begin
                          (_close148580_ _ssock148562_ 'inout '#f)
                          (std/os/error#raise-os-error
                           _errno148586_
                           std/net/socket/api#ssocket-connect
                           _addr148545_
                           _timeo148546_)))))))
          (if (##structure-direct-instance-of?
               _ssock148564148573_
               'std/net/socket/base#!socket::t)
              (let* ((_e148568148591_ (##vector-ref _ssock148564148573_ '1))
                     (_e148569148594_ (##vector-ref _ssock148564148573_ '2))
                     (_e148570148597_ (##vector-ref _ssock148564148573_ '3))
                     (_wait-out148600_ _e148570148597_)
                     (_e148571148602_ (##vector-ref _ssock148564148573_ '4))
                     (_close148605_ _e148571148602_))
                (_K148567148588_ _close148605_ _wait-out148600_))
              (_E148566148577_))))))
  (define std/net/socket/api#ssocket-connect__0
    (lambda (_addr148610_)
      (let ((_timeo148612_ '#f))
        (std/net/socket/api#ssocket-connect__% _addr148610_ _timeo148612_))))
  (define std/net/socket/api#ssocket-connect
    (lambda _g148617_
      (let ((_g148616_ (length _g148617_)))
        (cond ((##fx= _g148616_ 1)
               (apply std/net/socket/api#ssocket-connect__0 _g148617_))
              ((##fx= _g148616_ 2)
               (apply std/net/socket/api#ssocket-connect__% _g148617_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-connect
                _g148617_))))))
  (define std/net/socket/api#ssocket-listen__%
    (lambda (_addr148505_ _backlog148506_ _opts148507_)
      (let* ((_sa148509_ (std/os/socket#socket-address _addr148505_))
             (_sock148511_
              (std/os/socket#server-socket__0
               (std/os/_socket#sockaddr_family _sa148509_)
               std/os/_socket#SOCK_STREAM)))
        (with-exception-catcher
         (lambda (_g148513148515_)
           (if '#t
               (let ((_e148518_ _g148513148515_))
                 (close-port _sock148511_)
                 (raise _e148518_))
               (raise _g148513148515_)))
         (lambda ()
           (for-each
            (lambda (_g148521148523_)
              (std/os/socket#socket-setsockopt
               _sock148511_
               std/os/_socket#SOL_SOCKET
               _g148521148523_
               '1))
            _opts148507_)
           (std/os/socket#socket-bind _sock148511_ _sa148509_)
           (std/os/socket#socket-listen__% _sock148511_ _backlog148506_)
           (std/net/socket/api#make-ssocket _sock148511_))))))
  (define std/net/socket/api#ssocket-listen__0
    (lambda (_addr148529_)
      (let* ((_backlog148531_ '10)
             (_opts148533_ std/net/socket/api#default-listen-sockopts))
        (std/net/socket/api#ssocket-listen__%
         _addr148529_
         _backlog148531_
         _opts148533_))))
  (define std/net/socket/api#ssocket-listen__1
    (lambda (_addr148535_ _backlog148536_)
      (let ((_opts148538_ std/net/socket/api#default-listen-sockopts))
        (std/net/socket/api#ssocket-listen__%
         _addr148535_
         _backlog148536_
         _opts148538_))))
  (define std/net/socket/api#ssocket-listen
    (lambda _g148619_
      (let ((_g148618_ (length _g148619_)))
        (cond ((##fx= _g148618_ 1)
               (apply std/net/socket/api#ssocket-listen__0 _g148619_))
              ((##fx= _g148618_ 2)
               (apply std/net/socket/api#ssocket-listen__1 _g148619_))
              ((##fx= _g148618_ 3)
               (apply std/net/socket/api#ssocket-listen__% _g148619_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-listen
                _g148619_))))))
  (define std/net/socket/api#ssocket-accept__%
    (lambda (_ssock148451_ _sa148452_ _timeo148453_)
      (let* ((_ssock148454148460_ _ssock148451_)
             (_E148456148464_
              (lambda () (error '"No clause matching" _ssock148454148460_)))
             (_K148457148478_
              (lambda (_sock148467_)
                (let ((_timeo148469_
                       (std/net/socket/base#abs-timeout _timeo148453_)))
                  (let _lp148471_ ()
                    (let ((_wait-in148474_
                           (##direct-structure-ref
                            _ssock148451_
                            '2
                            std/net/socket/base#!socket::t
                            '#f)))
                      (if _wait-in148474_
                          (let ((_cli148476_
                                 (std/os/socket#socket-accept__%
                                  _sock148467_
                                  _sa148452_)))
                            (if _cli148476_
                                (std/net/socket/api#make-ssocket _cli148476_)
                                (if (_wait-in148474_
                                     _ssock148451_
                                     _timeo148469_)
                                    (_lp148471_)
                                    (std/error#raise-timeout
                                     'ssocket-accept
                                     '"accept timeout"
                                     _ssock148451_))))
                          (std/error#raise-io-error
                           'ssocket-accept
                           '"Socket is not open for input"
                           _ssock148451_))))))))
        (if (##structure-direct-instance-of?
             _ssock148454148460_
             'std/net/socket/base#!socket::t)
            (let* ((_e148458148481_ (##vector-ref _ssock148454148460_ '1))
                   (_sock148484_ _e148458148481_))
              (_K148457148478_ _sock148484_))
            (_E148456148464_)))))
  (define std/net/socket/api#ssocket-accept__0
    (lambda (_ssock148489_)
      (let* ((_sa148491_ '#f) (_timeo148493_ '#f))
        (std/net/socket/api#ssocket-accept__%
         _ssock148489_
         _sa148491_
         _timeo148493_))))
  (define std/net/socket/api#ssocket-accept__1
    (lambda (_ssock148495_ _sa148496_)
      (let ((_timeo148498_ '#f))
        (std/net/socket/api#ssocket-accept__%
         _ssock148495_
         _sa148496_
         _timeo148498_))))
  (define std/net/socket/api#ssocket-accept
    (lambda _g148621_
      (let ((_g148620_ (length _g148621_)))
        (cond ((##fx= _g148620_ 1)
               (apply std/net/socket/api#ssocket-accept__0 _g148621_))
              ((##fx= _g148620_ 2)
               (apply std/net/socket/api#ssocket-accept__1 _g148621_))
              ((##fx= _g148620_ 3)
               (apply std/net/socket/api#ssocket-accept__% _g148621_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-accept
                _g148621_))))))
  (define std/net/socket/api#ssocket-send__%
    (lambda (_ssock148377_ _buf148378_ _start148379_ _end148380_ _timeo148381_)
      (let* ((_ssock148382148388_ _ssock148377_)
             (_E148384148392_
              (lambda () (error '"No clause matching" _ssock148382148388_)))
             (_K148385148409_
              (lambda (_sock148395_)
                (let ((_timeo148397_
                       (std/net/socket/base#abs-timeout _timeo148381_)))
                  (let _lp148399_ ()
                    (let ((_wait-out148402_
                           (##direct-structure-ref
                            _ssock148377_
                            '3
                            std/net/socket/base#!socket::t
                            '#f)))
                      (if _wait-out148402_
                          (let* ((_r148404_
                                  (std/os/socket#socket-send__2
                                   _sock148395_
                                   _buf148378_
                                   _start148379_
                                   _end148380_))
                                 (_$e148406_ _r148404_))
                            (if _$e148406_
                                _$e148406_
                                (if (_wait-out148402_
                                     _ssock148377_
                                     _timeo148397_)
                                    (_lp148399_)
                                    (std/error#raise-timeout
                                     'ssocket-send
                                     '"send timeout"
                                     _ssock148377_))))
                          (std/error#raise-io-error
                           'ssocket-send
                           '"Socket is not open for output"
                           _ssock148377_))))))))
        (if (##structure-direct-instance-of?
             _ssock148382148388_
             'std/net/socket/base#!socket::t)
            (let* ((_e148386148412_ (##vector-ref _ssock148382148388_ '1))
                   (_sock148415_ _e148386148412_))
              (_K148385148409_ _sock148415_))
            (_E148384148392_)))))
  (define std/net/socket/api#ssocket-send__0
    (lambda (_ssock148420_ _buf148421_)
      (let* ((_start148423_ '0)
             (_end148425_ (u8vector-length _buf148421_))
             (_timeo148427_ '#f))
        (std/net/socket/api#ssocket-send__%
         _ssock148420_
         _buf148421_
         _start148423_
         _end148425_
         _timeo148427_))))
  (define std/net/socket/api#ssocket-send__1
    (lambda (_ssock148429_ _buf148430_ _start148431_)
      (let* ((_end148433_ (u8vector-length _buf148430_)) (_timeo148435_ '#f))
        (std/net/socket/api#ssocket-send__%
         _ssock148429_
         _buf148430_
         _start148431_
         _end148433_
         _timeo148435_))))
  (define std/net/socket/api#ssocket-send__2
    (lambda (_ssock148437_ _buf148438_ _start148439_ _end148440_)
      (let ((_timeo148442_ '#f))
        (std/net/socket/api#ssocket-send__%
         _ssock148437_
         _buf148438_
         _start148439_
         _end148440_
         _timeo148442_))))
  (define std/net/socket/api#ssocket-send
    (lambda _g148623_
      (let ((_g148622_ (length _g148623_)))
        (cond ((##fx= _g148622_ 2)
               (apply std/net/socket/api#ssocket-send__0 _g148623_))
              ((##fx= _g148622_ 3)
               (apply std/net/socket/api#ssocket-send__1 _g148623_))
              ((##fx= _g148622_ 4)
               (apply std/net/socket/api#ssocket-send__2 _g148623_))
              ((##fx= _g148622_ 5)
               (apply std/net/socket/api#ssocket-send__% _g148623_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-send
                _g148623_))))))
  (define std/net/socket/api#ssocket-send-all__%
    (lambda (_ssock148304_ _buf148305_ _start148306_ _end148307_ _timeo148308_)
      (let* ((_ssock148309148315_ _ssock148304_)
             (_E148311148319_
              (lambda () (error '"No clause matching" _ssock148309148315_)))
             (_K148312148335_
              (lambda (_sock148322_)
                (let ((_timeo148324_
                       (std/net/socket/base#abs-timeout _timeo148308_)))
                  (let _lp148326_ ((_count148328_ '0)
                                   (_start148329_ _start148306_))
                    (let ((_wait-out148331_
                           (##direct-structure-ref
                            _ssock148304_
                            '3
                            std/net/socket/base#!socket::t
                            '#f)))
                      (if _wait-out148331_
                          (if (##fx< _start148329_ _end148307_)
                              (let ((_r148333_
                                     (std/os/socket#socket-send__2
                                      _sock148322_
                                      _buf148305_
                                      _start148329_
                                      _end148307_)))
                                (if _r148333_
                                    (_lp148326_
                                     (##fx+ _count148328_ _r148333_)
                                     (##fx+ _start148329_ _r148333_))
                                    (if (_wait-out148331_
                                         _ssock148304_
                                         _timeo148324_)
                                        (_lp148326_
                                         _count148328_
                                         _start148329_)
                                        (std/error#raise-timeout
                                         'ssocket-send-all
                                         '"send timeout"
                                         _ssock148304_))))
                              _count148328_)
                          (std/error#raise-io-error
                           'ssocket-send-all
                           '"Socket is not open for output"
                           _ssock148304_))))))))
        (if (##structure-direct-instance-of?
             _ssock148309148315_
             'std/net/socket/base#!socket::t)
            (let* ((_e148313148338_ (##vector-ref _ssock148309148315_ '1))
                   (_sock148341_ _e148313148338_))
              (_K148312148335_ _sock148341_))
            (_E148311148319_)))))
  (define std/net/socket/api#ssocket-send-all__0
    (lambda (_ssock148346_ _buf148347_)
      (let* ((_start148349_ '0)
             (_end148351_ (u8vector-length _buf148347_))
             (_timeo148353_ '#f))
        (std/net/socket/api#ssocket-send-all__%
         _ssock148346_
         _buf148347_
         _start148349_
         _end148351_
         _timeo148353_))))
  (define std/net/socket/api#ssocket-send-all__1
    (lambda (_ssock148355_ _buf148356_ _start148357_)
      (let* ((_end148359_ (u8vector-length _buf148356_)) (_timeo148361_ '#f))
        (std/net/socket/api#ssocket-send-all__%
         _ssock148355_
         _buf148356_
         _start148357_
         _end148359_
         _timeo148361_))))
  (define std/net/socket/api#ssocket-send-all__2
    (lambda (_ssock148363_ _buf148364_ _start148365_ _end148366_)
      (let ((_timeo148368_ '#f))
        (std/net/socket/api#ssocket-send-all__%
         _ssock148363_
         _buf148364_
         _start148365_
         _end148366_
         _timeo148368_))))
  (define std/net/socket/api#ssocket-send-all
    (lambda _g148625_
      (let ((_g148624_ (length _g148625_)))
        (cond ((##fx= _g148624_ 2)
               (apply std/net/socket/api#ssocket-send-all__0 _g148625_))
              ((##fx= _g148624_ 3)
               (apply std/net/socket/api#ssocket-send-all__1 _g148625_))
              ((##fx= _g148624_ 4)
               (apply std/net/socket/api#ssocket-send-all__2 _g148625_))
              ((##fx= _g148624_ 5)
               (apply std/net/socket/api#ssocket-send-all__% _g148625_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-send-all
                _g148625_))))))
  (define std/net/socket/api#ssocket-recv__%
    (lambda (_ssock148230_ _buf148231_ _start148232_ _end148233_ _timeo148234_)
      (let* ((_ssock148235148241_ _ssock148230_)
             (_E148237148245_
              (lambda () (error '"No clause matching" _ssock148235148241_)))
             (_K148238148262_
              (lambda (_sock148248_)
                (let ((_timeo148250_
                       (std/net/socket/base#abs-timeout _timeo148234_)))
                  (let _lp148252_ ()
                    (let ((_wait-in148255_
                           (##direct-structure-ref
                            _ssock148230_
                            '2
                            std/net/socket/base#!socket::t
                            '#f)))
                      (if _wait-in148255_
                          (let* ((_r148257_
                                  (std/os/socket#socket-recv__2
                                   _sock148248_
                                   _buf148231_
                                   _start148232_
                                   _end148233_))
                                 (_$e148259_ _r148257_))
                            (if _$e148259_
                                _$e148259_
                                (if (_wait-in148255_
                                     _ssock148230_
                                     _timeo148250_)
                                    (_lp148252_)
                                    (std/error#raise-timeout
                                     'ssocket-recv
                                     '"receive timeout"
                                     _ssock148230_))))
                          (std/error#raise-io-error
                           'ssocket-recv
                           '"Socket is not open for input"
                           _ssock148230_))))))))
        (if (##structure-direct-instance-of?
             _ssock148235148241_
             'std/net/socket/base#!socket::t)
            (let* ((_e148239148265_ (##vector-ref _ssock148235148241_ '1))
                   (_sock148268_ _e148239148265_))
              (_K148238148262_ _sock148268_))
            (_E148237148245_)))))
  (define std/net/socket/api#ssocket-recv__0
    (lambda (_ssock148273_ _buf148274_)
      (let* ((_start148276_ '0)
             (_end148278_ (u8vector-length _buf148274_))
             (_timeo148280_ '#f))
        (std/net/socket/api#ssocket-recv__%
         _ssock148273_
         _buf148274_
         _start148276_
         _end148278_
         _timeo148280_))))
  (define std/net/socket/api#ssocket-recv__1
    (lambda (_ssock148282_ _buf148283_ _start148284_)
      (let* ((_end148286_ (u8vector-length _buf148283_)) (_timeo148288_ '#f))
        (std/net/socket/api#ssocket-recv__%
         _ssock148282_
         _buf148283_
         _start148284_
         _end148286_
         _timeo148288_))))
  (define std/net/socket/api#ssocket-recv__2
    (lambda (_ssock148290_ _buf148291_ _start148292_ _end148293_)
      (let ((_timeo148295_ '#f))
        (std/net/socket/api#ssocket-recv__%
         _ssock148290_
         _buf148291_
         _start148292_
         _end148293_
         _timeo148295_))))
  (define std/net/socket/api#ssocket-recv
    (lambda _g148627_
      (let ((_g148626_ (length _g148627_)))
        (cond ((##fx= _g148626_ 2)
               (apply std/net/socket/api#ssocket-recv__0 _g148627_))
              ((##fx= _g148626_ 3)
               (apply std/net/socket/api#ssocket-recv__1 _g148627_))
              ((##fx= _g148626_ 4)
               (apply std/net/socket/api#ssocket-recv__2 _g148627_))
              ((##fx= _g148626_ 5)
               (apply std/net/socket/api#ssocket-recv__% _g148627_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-recv
                _g148627_))))))
  (define std/net/socket/api#ssocket-recv-all__%
    (lambda (_ssock148157_ _buf148158_ _start148159_ _end148160_ _timeo148161_)
      (let* ((_ssock148162148168_ _ssock148157_)
             (_E148164148172_
              (lambda () (error '"No clause matching" _ssock148162148168_)))
             (_K148165148188_
              (lambda (_sock148175_)
                (let ((_timeo148177_
                       (std/net/socket/base#abs-timeout _timeo148161_)))
                  (let _lp148179_ ((_count148181_ '0)
                                   (_start148182_ _start148159_))
                    (let ((_wait-in148184_
                           (##direct-structure-ref
                            _ssock148157_
                            '2
                            std/net/socket/base#!socket::t
                            '#f)))
                      (if _wait-in148184_
                          (if (##fx>= _start148182_ _end148160_)
                              _count148181_
                              (let ((_r148186_
                                     (std/os/socket#socket-recv__2
                                      _sock148175_
                                      _buf148158_
                                      _start148182_
                                      _end148160_)))
                                (if (not _r148186_)
                                    (if (_wait-in148184_
                                         _ssock148157_
                                         _timeo148177_)
                                        (_lp148179_
                                         _count148181_
                                         _start148182_)
                                        (std/error#raise-timeout
                                         'ssocket-recv-all
                                         '"receive timeout"
                                         _ssock148157_))
                                    (if (##fxzero? _r148186_)
                                        _count148181_
                                        (_lp148179_
                                         (##fx+ _count148181_ _r148186_)
                                         (##fx+ _start148182_ _r148186_))))))
                          (std/error#raise-io-error
                           'ssocket-recv-all
                           '"Socket is not open for input"
                           _ssock148157_))))))))
        (if (##structure-direct-instance-of?
             _ssock148162148168_
             'std/net/socket/base#!socket::t)
            (let* ((_e148166148191_ (##vector-ref _ssock148162148168_ '1))
                   (_sock148194_ _e148166148191_))
              (_K148165148188_ _sock148194_))
            (_E148164148172_)))))
  (define std/net/socket/api#ssocket-recv-all__0
    (lambda (_ssock148199_ _buf148200_)
      (let* ((_start148202_ '0)
             (_end148204_ (u8vector-length _buf148200_))
             (_timeo148206_ '#f))
        (std/net/socket/api#ssocket-recv-all__%
         _ssock148199_
         _buf148200_
         _start148202_
         _end148204_
         _timeo148206_))))
  (define std/net/socket/api#ssocket-recv-all__1
    (lambda (_ssock148208_ _buf148209_ _start148210_)
      (let* ((_end148212_ (u8vector-length _buf148209_)) (_timeo148214_ '#f))
        (std/net/socket/api#ssocket-recv-all__%
         _ssock148208_
         _buf148209_
         _start148210_
         _end148212_
         _timeo148214_))))
  (define std/net/socket/api#ssocket-recv-all__2
    (lambda (_ssock148216_ _buf148217_ _start148218_ _end148219_)
      (let ((_timeo148221_ '#f))
        (std/net/socket/api#ssocket-recv-all__%
         _ssock148216_
         _buf148217_
         _start148218_
         _end148219_
         _timeo148221_))))
  (define std/net/socket/api#ssocket-recv-all
    (lambda _g148629_
      (let ((_g148628_ (length _g148629_)))
        (cond ((##fx= _g148628_ 2)
               (apply std/net/socket/api#ssocket-recv-all__0 _g148629_))
              ((##fx= _g148628_ 3)
               (apply std/net/socket/api#ssocket-recv-all__1 _g148629_))
              ((##fx= _g148628_ 4)
               (apply std/net/socket/api#ssocket-recv-all__2 _g148629_))
              ((##fx= _g148628_ 5)
               (apply std/net/socket/api#ssocket-recv-all__% _g148629_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-recv-all
                _g148629_))))))
  (define std/net/socket/api#ssocket-socket
    (lambda (_ssock148154_)
      (##direct-structure-ref
       _ssock148154_
       '1
       std/net/socket/base#!socket::t
       '#f)))
  (define std/net/socket/api#ssocket-close
    (lambda (_ssock148152_)
      ((##direct-structure-ref
        _ssock148152_
        '4
        std/net/socket/base#!socket::t
        '#f)
       _ssock148152_
       'inout
       '#f)))
  (define std/net/socket/api#ssocket-close-input__%
    (lambda (_ssock148139_ _shutdown148140_)
      ((##direct-structure-ref
        _ssock148139_
        '4
        std/net/socket/base#!socket::t
        '#f)
       _ssock148139_
       'in
       (if _shutdown148140_ std/os/_socket#SHUT_RD '#f))))
  (define std/net/socket/api#ssocket-close-input__0
    (lambda (_ssock148145_)
      (let ((_shutdown148147_ '#f))
        (std/net/socket/api#ssocket-close-input__%
         _ssock148145_
         _shutdown148147_))))
  (define std/net/socket/api#ssocket-close-input
    (lambda _g148631_
      (let ((_g148630_ (length _g148631_)))
        (cond ((##fx= _g148630_ 1)
               (apply std/net/socket/api#ssocket-close-input__0 _g148631_))
              ((##fx= _g148630_ 2)
               (apply std/net/socket/api#ssocket-close-input__% _g148631_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-close-input
                _g148631_))))))
  (define std/net/socket/api#ssocket-close-output__%
    (lambda (_ssock148125_ _shutdown148126_)
      ((##direct-structure-ref
        _ssock148125_
        '4
        std/net/socket/base#!socket::t
        '#f)
       _ssock148125_
       'out
       (if _shutdown148126_ std/os/_socket#SHUT_WR '#f))))
  (define std/net/socket/api#ssocket-close-output__0
    (lambda (_ssock148131_)
      (let ((_shutdown148133_ '#f))
        (std/net/socket/api#ssocket-close-output__%
         _ssock148131_
         _shutdown148133_))))
  (define std/net/socket/api#ssocket-close-output
    (lambda _g148633_
      (let ((_g148632_ (length _g148633_)))
        (cond ((##fx= _g148632_ 1)
               (apply std/net/socket/api#ssocket-close-output__0 _g148633_))
              ((##fx= _g148632_ 2)
               (apply std/net/socket/api#ssocket-close-output__% _g148633_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-close-output
                _g148633_))))))
  (define std/net/socket/api#!socket::destroy std/net/socket/api#ssocket-close)
  (bind-method!
   std/net/socket/base#!socket::t
   'destroy
   std/net/socket/api#!socket::destroy
   '#f)
  (define std/net/socket/api#default-listen-sockopts
    (cons std/os/_socket#SO_REUSEADDR '()))
  (define std/net/socket/api#make-ssocket
    (lambda (_sock147990_)
      (let ((_$e147992_ (std/net/socket/base#current-socket-server)))
        (if _$e147992_
            ((lambda (_srv147995_)
               (let ((_token147997_ (##structure std/actor/proto#!token::t))
                     (_dest147999_ _srv147995_))
                 (std/actor/message#send-message__%
                  _dest147999_
                  (##structure
                   std/actor/proto#!call::t
                   (##structure
                    std/net/socket/base#socket-server.add::t
                    _sock147990_)
                   _token147997_)
                  '#f
                  '#t)
                 (std/actor/proto#!!call-recv _token147997_ _dest147999_)))
             _$e147992_)
            (std/net/socket/basic-socket#basic-socket _sock147990_))))))
