/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.range.BinaryRangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.IpRangeAggregatorSupplier;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

public class BinaryRangeAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final List<BinaryRangeAggregator.Range> ranges;
    private final boolean keyed;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("ip_range", CoreValuesSourceType.IP, BinaryRangeAggregator::new);
    }

    public BinaryRangeAggregatorFactory(String name, ValuesSourceConfig config, List<BinaryRangeAggregator.Range> ranges, boolean keyed, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.ranges = ranges;
        this.keyed = keyed;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new BinaryRangeAggregator(this.name, this.factories, null, this.config.format(), this.ranges, this.keyed, searchContext, parent, CardinalityUpperBound.NONE, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config, "ip_range");
        if (!(aggregatorSupplier instanceof IpRangeAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected IpRangeAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((IpRangeAggregatorSupplier)aggregatorSupplier).build(this.name, this.factories, this.config.getValuesSource(), this.config.format(), this.ranges, this.keyed, searchContext, parent, cardinality, metadata);
    }
}

