/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;

public class InternalVariableWidthHistogram
extends InternalMultiBucketAggregation<InternalVariableWidthHistogram, Bucket>
implements Histogram,
HistogramFactory {
    private List<Bucket> buckets;
    private final DocValueFormat format;
    private final int targetNumBuckets;
    final EmptyBucketInfo emptyBucketInfo;

    InternalVariableWidthHistogram(String name, List<Bucket> buckets, EmptyBucketInfo emptyBucketInfo, int targetNumBuckets, DocValueFormat formatter, Map<String, Object> metaData) {
        super(name, metaData);
        this.buckets = buckets;
        this.emptyBucketInfo = emptyBucketInfo;
        this.format = formatter;
        this.targetNumBuckets = targetNumBuckets;
    }

    public InternalVariableWidthHistogram(StreamInput in) throws IOException {
        super(in);
        this.emptyBucketInfo = new EmptyBucketInfo(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.buckets = in.readList(stream -> new Bucket(stream, this.format));
        this.targetNumBuckets = in.readVInt();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        this.emptyBucketInfo.writeTo(out);
        out.writeNamedWriteable(this.format);
        out.writeList(this.buckets);
        out.writeVInt(this.targetNumBuckets);
    }

    @Override
    public String getWriteableName() {
        return "variable_width_histogram";
    }

    @Override
    public List<Bucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    DocValueFormat getFormatter() {
        return this.format;
    }

    public int getTargetBuckets() {
        return this.targetNumBuckets;
    }

    public EmptyBucketInfo getEmptyBucketInfo() {
        return this.emptyBucketInfo;
    }

    @Override
    public InternalVariableWidthHistogram create(List<Bucket> buckets) {
        return new InternalVariableWidthHistogram(this.name, buckets, this.emptyBucketInfo, this.targetNumBuckets, this.format, this.metadata);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.centroid, prototype.bounds, prototype.docCount, prototype.format, aggregations);
    }

    @Override
    public Bucket createBucket(Number key, long docCount, InternalAggregations aggregations) {
        return new Bucket(key.doubleValue(), new Bucket.BucketBounds(key.doubleValue(), key.doubleValue()), docCount, this.format, aggregations);
    }

    @Override
    public Number getKey(MultiBucketsAggregation.Bucket bucket) {
        return ((Bucket)bucket).centroid;
    }

    @Override
    public Number nextKey(Number key) {
        return this.nextKey(key.doubleValue());
    }

    private double nextKey(double key) {
        return key + 1.0;
    }

    @Override
    protected Bucket reduceBucket(List<Bucket> buckets, InternalAggregation.ReduceContext context) {
        ArrayList<InternalAggregations> aggregations = new ArrayList<InternalAggregations>(buckets.size());
        long docCount = 0L;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double sum = 0.0;
        for (Bucket bucket : buckets) {
            docCount += bucket.docCount;
            min = Math.min(min, ((Bucket)bucket).bounds.min);
            max = Math.max(max, ((Bucket)bucket).bounds.max);
            sum += (double)bucket.docCount * bucket.centroid;
            aggregations.add((InternalAggregations)bucket.getAggregations());
        }
        InternalAggregations aggs = InternalAggregations.reduce(aggregations, context);
        double centroid = sum / (double)docCount;
        Bucket.BucketBounds bounds = new Bucket.BucketBounds(min, max);
        return new Bucket(centroid, bounds, docCount, this.format, aggs);
    }

    public List<Bucket> reduceBuckets(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        PriorityQueue<IteratorAndCurrent> pq = new PriorityQueue<IteratorAndCurrent>(aggregations.size()){

            protected boolean lessThan(IteratorAndCurrent a, IteratorAndCurrent b) {
                return Double.compare(a.current.centroid, b.current.centroid) < 0;
            }
        };
        for (InternalAggregation aggregation : aggregations) {
            InternalVariableWidthHistogram histogram = (InternalVariableWidthHistogram)aggregation;
            if (histogram.buckets.isEmpty()) continue;
            pq.add((Object)new IteratorAndCurrent(histogram.buckets.iterator()));
        }
        ArrayList<Bucket> reducedBuckets = new ArrayList<Bucket>();
        if (pq.size() > 0) {
            double key = ((IteratorAndCurrent)pq.top()).current.centroid();
            ArrayList<Bucket> currentBuckets = new ArrayList<Bucket>();
            do {
                IteratorAndCurrent top;
                if (Double.compare((top = (IteratorAndCurrent)pq.top()).current.centroid(), key) != 0) {
                    InternalMultiBucketAggregation.InternalBucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                    reduceContext.consumeBucketsAndMaybeBreak(1);
                    reducedBuckets.add((Bucket)reduced);
                    currentBuckets.clear();
                    key = top.current.centroid();
                }
                currentBuckets.add(top.current);
                if (top.iterator.hasNext()) {
                    Bucket next = (Bucket)top.iterator.next();
                    assert (next.compareKey(top.current) >= 0) : "shards must return data sorted by centroid";
                    top.current = next;
                    pq.updateTop();
                    continue;
                }
                pq.pop();
            } while (pq.size() > 0);
            if (!currentBuckets.isEmpty()) {
                InternalMultiBucketAggregation.InternalBucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                reduceContext.consumeBucketsAndMaybeBreak(1);
                reducedBuckets.add((Bucket)reduced);
            }
        }
        this.mergeBucketsIfNeeded(reducedBuckets, this.targetNumBuckets, reduceContext);
        return reducedBuckets;
    }

    private void mergeBucketsWithPlan(List<Bucket> buckets, List<BucketRange> plan, InternalAggregation.ReduceContext reduceContext) {
        for (int i = plan.size() - 1; i >= 0; --i) {
            BucketRange range = plan.get(i);
            int startIdx = range.startIdx;
            int endIdx = range.endIdx;
            if (startIdx == endIdx) continue;
            ArrayList<Bucket> toMerge = new ArrayList<Bucket>();
            for (int idx = endIdx; idx > startIdx; --idx) {
                toMerge.add(buckets.get(idx));
                buckets.remove(idx);
            }
            toMerge.add(buckets.get(startIdx));
            reduceContext.consumeBucketsAndMaybeBreak(-(toMerge.size() - 1));
            InternalMultiBucketAggregation.InternalBucket merged_bucket = this.reduceBucket(toMerge, reduceContext);
            buckets.set(startIdx, (Bucket)merged_bucket);
        }
    }

    private void mergeBucketsIfNeeded(List<Bucket> buckets, int targetNumBuckets, InternalAggregation.ReduceContext reduceContext) {
        ArrayList<BucketRange> ranges = new ArrayList<BucketRange>();
        int i = 0;
        while (i < buckets.size()) {
            BucketRange range = new BucketRange();
            range.centroid = buckets.get(i).centroid;
            range.docCount = buckets.get(i).getDocCount();
            range.startIdx = i;
            range.endIdx = i++;
            ranges.add(range);
        }
        while (ranges.size() > targetNumBuckets) {
            int closestIdx = 0;
            double smallest_distance = Double.POSITIVE_INFINITY;
            for (int i2 = 0; i2 < ranges.size() - 1; ++i2) {
                double new_distance = ((BucketRange)ranges.get((int)(i2 + 1))).centroid - ((BucketRange)ranges.get((int)i2)).centroid;
                if (!(new_distance < smallest_distance)) continue;
                closestIdx = i2;
                smallest_distance = new_distance;
            }
            ((BucketRange)ranges.get(closestIdx)).mergeWith((BucketRange)ranges.get(closestIdx + 1));
            ranges.remove(closestIdx + 1);
        }
        this.mergeBucketsWithPlan(buckets, ranges, reduceContext);
    }

    private void mergeBucketsWithSameMin(List<Bucket> buckets, InternalAggregation.ReduceContext reduceContext) {
        BucketRange range;
        ArrayList<BucketRange> ranges = new ArrayList<BucketRange>();
        int i = 0;
        while (i < buckets.size()) {
            range = new BucketRange();
            range.min = buckets.get(i).min();
            range.startIdx = i;
            range.endIdx = i++;
            ranges.add(range);
        }
        i = 0;
        while (i < ranges.size() - 1) {
            range = (BucketRange)ranges.get(i);
            BucketRange nextRange = (BucketRange)ranges.get(i + 1);
            if (range.min == nextRange.min) {
                range.mergeWith(nextRange);
                ranges.remove(i + 1);
                continue;
            }
            ++i;
        }
        this.mergeBucketsWithPlan(buckets, ranges, reduceContext);
    }

    private void adjustBoundsForOverlappingBuckets(List<Bucket> buckets, InternalAggregation.ReduceContext reduceContext) {
        for (int i = 1; i < buckets.size(); ++i) {
            Bucket curBucket = buckets.get(i);
            Bucket prevBucket = buckets.get(i - 1);
            if (!(((Bucket)curBucket).bounds.min < ((Bucket)prevBucket).bounds.max)) continue;
            ((Bucket)prevBucket).bounds.max = ((Bucket)curBucket).bounds.min = (((Bucket)prevBucket).bounds.max + ((Bucket)curBucket).bounds.min) / 2.0;
        }
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        List<Bucket> reducedBuckets = this.reduceBuckets(aggregations, reduceContext);
        if (reduceContext.isFinalReduce()) {
            this.buckets.sort(Comparator.comparing(Bucket::min));
            this.mergeBucketsWithSameMin(reducedBuckets, reduceContext);
            this.adjustBoundsForOverlappingBuckets(reducedBuckets, reduceContext);
        }
        return new InternalVariableWidthHistogram(this.getName(), reducedBuckets, this.emptyBucketInfo, this.targetNumBuckets, this.format, this.metadata);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    @Override
    public InternalAggregation createAggregation(List<MultiBucketsAggregation.Bucket> buckets) {
        List<Bucket> buckets2 = new ArrayList(buckets.size());
        for (MultiBucketsAggregation.Bucket b : buckets) {
            buckets2.add((Bucket)b);
        }
        buckets2 = Collections.unmodifiableList(buckets2);
        return new InternalVariableWidthHistogram(this.name, buckets2, this.emptyBucketInfo, this.targetNumBuckets, this.format, this.getMetadata());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalVariableWidthHistogram that = (InternalVariableWidthHistogram)obj;
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.format, that.format) && Objects.equals(this.emptyBucketInfo, that.emptyBucketInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.format, this.emptyBucketInfo);
    }

    static class EmptyBucketInfo {
        final InternalAggregations subAggregations;

        EmptyBucketInfo(InternalAggregations subAggregations) {
            this.subAggregations = subAggregations;
        }

        EmptyBucketInfo(StreamInput in) throws IOException {
            this(InternalAggregations.readFrom(in));
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.subAggregations.writeTo(out);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EmptyBucketInfo that = (EmptyBucketInfo)obj;
            return Objects.equals(this.subAggregations, that.subAggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.subAggregations);
        }
    }

    public static class Bucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements Histogram.Bucket,
    KeyComparable<Bucket> {
        private final BucketBounds bounds;
        private long docCount;
        private InternalAggregations aggregations;
        protected final transient DocValueFormat format;
        private double centroid;

        public Bucket(double centroid, BucketBounds bounds, long docCount, DocValueFormat format, InternalAggregations aggregations) {
            this.format = format;
            this.centroid = centroid;
            this.bounds = bounds;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        public Bucket(StreamInput in, DocValueFormat format) throws IOException {
            this.format = format;
            this.centroid = in.readDouble();
            this.docCount = in.readVLong();
            this.bounds = new BucketBounds(in);
            this.aggregations = InternalAggregations.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.centroid);
            out.writeVLong(this.docCount);
            this.bounds.writeTo(out);
            this.aggregations.writeTo(out);
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != Bucket.class) {
                return false;
            }
            Bucket that = (Bucket)obj;
            return this.centroid == that.centroid && this.bounds.equals(that.bounds) && this.docCount == that.docCount && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.centroid, this.bounds, this.docCount, this.aggregations);
        }

        @Override
        public String getKeyAsString() {
            return this.format.format((Double)this.getKey()).toString();
        }

        @Override
        public Object getKey() {
            return this.centroid;
        }

        public double min() {
            return this.bounds.min;
        }

        public double max() {
            return this.bounds.max;
        }

        public double centroid() {
            return this.centroid;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            String keyAsString = this.format.format((Double)this.getKey()).toString();
            builder.startObject();
            builder.field(Aggregation.CommonFields.MIN.getPreferredName(), this.min());
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.MIN_AS_STRING.getPreferredName(), this.format.format(this.min()));
            }
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.getKey());
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), keyAsString);
            }
            builder.field(Aggregation.CommonFields.MAX.getPreferredName(), this.max());
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.MAX_AS_STRING.getPreferredName(), this.format.format(this.max()));
            }
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        @Override
        public int compareKey(Bucket other) {
            return Double.compare(this.centroid, other.centroid);
        }

        public DocValueFormat getFormatter() {
            return this.format;
        }

        public static class BucketBounds {
            public double min;
            public double max;

            public BucketBounds(double min, double max) {
                assert (min <= max);
                this.min = min;
                this.max = max;
            }

            public BucketBounds(StreamInput in) throws IOException {
                this(in.readDouble(), in.readDouble());
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeDouble(this.min);
                out.writeDouble(this.max);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                BucketBounds that = (BucketBounds)obj;
                return this.min == that.min && this.max == that.max;
            }

            public int hashCode() {
                return Objects.hash(this.getClass(), this.min, this.max);
            }
        }
    }

    private static class IteratorAndCurrent {
        private final Iterator<Bucket> iterator;
        private Bucket current;

        IteratorAndCurrent(Iterator<Bucket> iterator) {
            this.iterator = iterator;
            this.current = iterator.next();
        }
    }

    class BucketRange {
        int startIdx;
        int endIdx;
        double min;
        double max;
        double centroid;
        long docCount;

        BucketRange() {
        }

        public void mergeWith(BucketRange other) {
            this.startIdx = Math.min(this.startIdx, other.startIdx);
            this.endIdx = Math.max(this.endIdx, other.endIdx);
            if (this.docCount + other.docCount > 0L) {
                this.centroid = (this.centroid * (double)this.docCount + other.centroid * (double)other.docCount) / (double)(this.docCount + other.docCount);
                this.docCount += other.docCount;
            }
            this.min = Math.min(this.min, other.min);
            this.max = Math.max(this.max, other.max);
        }
    }
}

