/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

public class S3ClientOptions {
    public static final boolean DEFAULT_PATH_STYLE_ACCESS = false;
    public static final boolean DEFAULT_CHUNKED_ENCODING_DISABLED = false;
    public static final boolean DEFAULT_PAYLOAD_SIGNING_ENABLED = false;
    public static final boolean DEFAULT_ACCELERATE_MODE_ENABLED = false;
    public static final boolean DEFAULT_DUALSTACK_ENABLED = false;
    public static final boolean DEFAULT_FORCE_GLOBAL_BUCKET_ACCESS_ENABLED = false;
    private boolean pathStyleAccess;
    private boolean chunkedEncodingDisabled;
    private final boolean accelerateModeEnabled;
    private final boolean payloadSigningEnabled;
    private final boolean dualstackEnabled;
    private final boolean forceGlobalBucketAccessEnabled;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public S3ClientOptions() {
        this.pathStyleAccess = false;
        this.chunkedEncodingDisabled = false;
        this.accelerateModeEnabled = false;
        this.payloadSigningEnabled = false;
        this.dualstackEnabled = false;
        this.forceGlobalBucketAccessEnabled = false;
    }

    @Deprecated
    public S3ClientOptions(S3ClientOptions other) {
        this.pathStyleAccess = other.pathStyleAccess;
        this.chunkedEncodingDisabled = other.chunkedEncodingDisabled;
        this.accelerateModeEnabled = other.accelerateModeEnabled;
        this.payloadSigningEnabled = other.payloadSigningEnabled;
        this.dualstackEnabled = other.dualstackEnabled;
        this.forceGlobalBucketAccessEnabled = other.forceGlobalBucketAccessEnabled;
    }

    private S3ClientOptions(boolean pathStyleAccess, boolean chunkedEncodingDisabled, boolean accelerateModeEnabled, boolean payloadSigningEnabled, boolean dualstackEnabled, boolean forceGlobalBucketAccessEnabled) {
        this.pathStyleAccess = pathStyleAccess;
        this.chunkedEncodingDisabled = chunkedEncodingDisabled;
        this.accelerateModeEnabled = accelerateModeEnabled;
        this.payloadSigningEnabled = payloadSigningEnabled;
        this.dualstackEnabled = dualstackEnabled;
        this.forceGlobalBucketAccessEnabled = forceGlobalBucketAccessEnabled;
    }

    public boolean isPathStyleAccess() {
        return this.pathStyleAccess;
    }

    public boolean isChunkedEncodingDisabled() {
        return this.chunkedEncodingDisabled;
    }

    public boolean isAccelerateModeEnabled() {
        return this.accelerateModeEnabled;
    }

    public boolean isPayloadSigningEnabled() {
        return this.payloadSigningEnabled;
    }

    public boolean isDualstackEnabled() {
        return this.dualstackEnabled;
    }

    public boolean isForceGlobalBucketAccessEnabled() {
        return this.forceGlobalBucketAccessEnabled;
    }

    @Deprecated
    public void setPathStyleAccess(boolean pathStyleAccess) {
        this.pathStyleAccess = pathStyleAccess;
    }

    @Deprecated
    public S3ClientOptions withPathStyleAccess(boolean pathStyleAccess) {
        this.setPathStyleAccess(pathStyleAccess);
        return this;
    }

    @Deprecated
    public void setChunkedEncodingDisabled(boolean chunkedEncodingDisabled) {
        this.chunkedEncodingDisabled = chunkedEncodingDisabled;
    }

    @Deprecated
    public S3ClientOptions withChunkedEncodingDisabled(boolean chunkedEncodingDisabled) {
        this.setChunkedEncodingDisabled(chunkedEncodingDisabled);
        return this;
    }

    @Deprecated
    public S3ClientOptions disableChunkedEncoding() {
        return this.withChunkedEncodingDisabled(true);
    }

    public static class Builder {
        private boolean pathStyleAccess = false;
        private boolean chunkedEncodingDisabled = false;
        private boolean accelerateModeEnabled = false;
        private boolean payloadSigningEnabled = false;
        private boolean dualstackEnabled = false;
        private boolean forceGlobalBucketAccessEnabled = false;

        private Builder() {
        }

        public S3ClientOptions build() {
            return new S3ClientOptions(this.pathStyleAccess, this.chunkedEncodingDisabled, this.accelerateModeEnabled, this.payloadSigningEnabled, this.dualstackEnabled, this.forceGlobalBucketAccessEnabled);
        }

        public Builder setPathStyleAccess(boolean pathStyleAccess) {
            this.pathStyleAccess = pathStyleAccess;
            return this;
        }

        public Builder setAccelerateModeEnabled(boolean accelerateModeEnabled) {
            this.accelerateModeEnabled = accelerateModeEnabled;
            return this;
        }

        public Builder setPayloadSigningEnabled(boolean payloadSigningEnabled) {
            this.payloadSigningEnabled = payloadSigningEnabled;
            return this;
        }

        public Builder disableChunkedEncoding() {
            this.chunkedEncodingDisabled = true;
            return this;
        }

        public Builder enableDualstack() {
            this.dualstackEnabled = true;
            return this;
        }

        public Builder enableForceGlobalBucketAccess() {
            this.forceGlobalBucketAccessEnabled = true;
            return this;
        }
    }
}

