/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleFileException;

public class DBCacheEntry {
    private String dbname;
    private String sql;
    private int hashCode;

    public DBCacheEntry(String dbname, String sql) {
        this.dbname = dbname;
        this.sql = sql;
    }

    public DBCacheEntry() {
        this(null, null);
    }

    public boolean sameDB(String otherDb) {
        if (this.dbname == otherDb) {
            return true;
        }
        if (null != this.dbname) {
            return this.dbname.equalsIgnoreCase(otherDb);
        }
        return false;
    }

    public int hashCode() {
        if (0 >= this.hashCode && null != this.dbname && null != this.sql) {
            this.hashCode = this.dbname.toLowerCase().hashCode() ^ this.sql.toLowerCase().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (null != o && o instanceof DBCacheEntry) {
            DBCacheEntry obj = (DBCacheEntry)o;
            boolean retval = this.dbname.equalsIgnoreCase(obj.dbname) && this.sql.equalsIgnoreCase(obj.sql);
            return retval;
        }
        return false;
    }

    public DBCacheEntry(DataInputStream dis) throws KettleFileException {
        try {
            this.dbname = dis.readUTF();
            this.sql = dis.readUTF();
        }
        catch (EOFException eof) {
            throw new KettleEOFException("End of file reached", eof);
        }
        catch (Exception e) {
            throw new KettleFileException("Unable to read cache entry from data input stream", e);
        }
    }

    public boolean write(DataOutputStream dos) {
        try {
            dos.writeUTF(this.dbname);
            dos.writeUTF(this.sql);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

