/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.perceptron;

import java.util.Arrays;
import opennlp.tools.ml.ArrayMath;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.EvalParameters;

public class PerceptronModel
extends AbstractModel {
    public PerceptronModel(Context[] params, String[] predLabels, String[] outcomeNames) {
        super(params, predLabels, outcomeNames);
        this.modelType = AbstractModel.ModelType.Perceptron;
    }

    @Override
    public double[] eval(String[] context) {
        return this.eval(context, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public double[] eval(String[] context, float[] values) {
        return this.eval(context, values, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public double[] eval(String[] context, double[] probs) {
        return this.eval(context, null, probs);
    }

    public double[] eval(String[] context, float[] values, double[] outsums) {
        Context[] scontexts = new Context[context.length];
        Arrays.fill(outsums, 0.0);
        for (int i = 0; i < context.length; ++i) {
            scontexts[i] = (Context)this.pmap.get(context[i]);
        }
        return PerceptronModel.eval(scontexts, values, outsums, this.evalParams, true);
    }

    public static double[] eval(int[] context, double[] prior, EvalParameters model) {
        return PerceptronModel.eval(context, null, prior, model, true);
    }

    static double[] eval(int[] context, float[] values, double[] prior, EvalParameters model, boolean normalize) {
        Context[] scontexts = new Context[context.length];
        for (int i = 0; i < context.length; ++i) {
            scontexts[i] = model.getParams()[context[i]];
        }
        return PerceptronModel.eval(scontexts, values, prior, model, normalize);
    }

    static double[] eval(Context[] context, float[] values, double[] prior, EvalParameters model, boolean normalize) {
        ArrayMath.sumFeatures(context, values, prior);
        if (normalize) {
            int oid;
            int numOutcomes = model.getNumOutcomes();
            double maxPrior = 1.0;
            for (int oid2 = 0; oid2 < numOutcomes; ++oid2) {
                if (!(maxPrior < Math.abs(prior[oid2]))) continue;
                maxPrior = Math.abs(prior[oid2]);
            }
            double normal = 0.0;
            for (oid = 0; oid < numOutcomes; ++oid) {
                prior[oid] = Math.exp(prior[oid] / maxPrior);
                normal += prior[oid];
            }
            oid = 0;
            while (oid < numOutcomes) {
                int n = oid++;
                prior[n] = prior[n] / normal;
            }
        }
        return prior;
    }
}

