/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.rule;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class Rule {
    public static final String WILD_CARD = "*";
    public static final String WILD_WILD_CARD = "**";
    static final Condition SHARD_DEFAULT = new Condition("shard", "**");
    static final Condition REPLICA_DEFAULT = new Condition("replica", "*");
    Condition shard;
    Condition replica;
    Condition tag;

    public Rule(Map m) {
        Iterator iterator = m.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            Condition condition = new Condition(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            if (condition.name.equals("shard")) {
                this.shard = condition;
                continue;
            }
            if (condition.name.equals("replica")) {
                this.replica = condition;
                continue;
            }
            if (this.tag != null) {
                throw new RuntimeException("There can be only one and only one tag other than 'shard' and 'replica' in rule " + m);
            }
            this.tag = condition;
        }
        if (this.shard == null) {
            this.shard = SHARD_DEFAULT;
        }
        if (this.replica == null) {
            this.replica = REPLICA_DEFAULT;
        }
        if (this.tag == null) {
            throw new RuntimeException("There should be a tag other than 'shard' and 'replica'");
        }
        if (this.replica.isWildCard() && this.tag.isWildCard()) {
            throw new RuntimeException("Both replica and tag cannot be wild cards");
        }
    }

    static Object parseObj(Object o, Class typ) {
        if (o == null) {
            return o;
        }
        if (typ == String.class) {
            return String.valueOf(o);
        }
        if (typ == Integer.class) {
            Double v = Double.parseDouble(String.valueOf(o));
            return v.intValue();
        }
        return o;
    }

    public static Map parseRule(String s) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        s = s.trim();
        List keyVals = StrUtils.splitSmart((String)s, (char)',');
        for (String kv : keyVals) {
            List keyVal = StrUtils.splitSmart((String)kv, (char)':');
            if (keyVal.size() != 2) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid rule. should have only key and val in : " + kv);
            }
            if (((String)keyVal.get(0)).trim().length() == 0 || ((String)keyVal.get(1)).trim().length() == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid rule. should have key and val in : " + kv);
            }
            result.put(((String)keyVal.get(0)).trim(), ((String)keyVal.get(1)).trim());
        }
        return result;
    }

    public String toString() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (this.shard != SHARD_DEFAULT) {
            map.put(this.shard.name, this.shard.operand.toStr(this.shard.val));
        }
        if (this.replica != REPLICA_DEFAULT) {
            map.put(this.replica.name, this.replica.operand.toStr(this.replica.val));
        }
        map.put(this.tag.name, this.tag.operand.toStr(this.tag.val));
        return Utils.toJSONString(map);
    }

    MatchStatus tryAssignNodeToShard(String testNode, Map<String, Map<String, Integer>> shardVsNodeSet, Map<String, Map<String, Object>> nodeVsTags, String shardName, Phase phase) {
        if (this.tag.isWildCard()) {
            if (!this.shard.isWildCard() && shardName.equals(this.shard.val)) {
                return MatchStatus.NOT_APPLICABLE;
            }
            Object tagValueForThisNode = nodeVsTags.get(testNode).get(this.tag.name);
            int v = this.getNumberOfNodesWithSameTagVal(this.shard, nodeVsTags, shardVsNodeSet, shardName, new Condition(this.tag.name, tagValueForThisNode, Operand.EQUAL), phase);
            if (phase == Phase.ASSIGN || phase == Phase.FUZZY_ASSIGN) {
                ++v;
            }
            return this.replica.canMatch(v, phase) ? MatchStatus.NODE_CAN_BE_ASSIGNED : MatchStatus.CANNOT_ASSIGN_FAIL;
        }
        if (!this.shard.isWildCard() && !shardName.equals(this.shard.val)) {
            return MatchStatus.NOT_APPLICABLE;
        }
        if (this.replica.isWildCard()) {
            Map<String, Object> tags = nodeVsTags.get(testNode);
            if (this.tag.canMatch(tags == null ? null : tags.get(this.tag.name), phase)) {
                return MatchStatus.NODE_CAN_BE_ASSIGNED;
            }
            return MatchStatus.CANNOT_ASSIGN_FAIL;
        }
        int v = this.getNumberOfNodesWithSameTagVal(this.shard, nodeVsTags, shardVsNodeSet, shardName, this.tag, phase);
        return this.replica.canMatch(v, phase) ? MatchStatus.NODE_CAN_BE_ASSIGNED : MatchStatus.CANNOT_ASSIGN_FAIL;
    }

    private int getNumberOfNodesWithSameTagVal(Condition shardCondition, Map<String, Map<String, Object>> nodeVsTags, Map<String, Map<String, Integer>> shardVsNodeSet, String shardName, Condition tagCondition, Phase phase) {
        int countMatchingThisTagValue = 0;
        for (Map.Entry<String, Map<String, Integer>> entry : shardVsNodeSet.entrySet()) {
            Map<String, Integer> nodesInThisShard;
            if (!shardCondition.val.equals(WILD_WILD_CARD) && !entry.getKey().equals(shardName) || (nodesInThisShard = shardVsNodeSet.get(shardCondition.val.equals(WILD_WILD_CARD) ? entry.getKey() : shardName)) == null) continue;
            for (Map.Entry<String, Integer> aNode : nodesInThisShard.entrySet()) {
                Object obj;
                Map<String, Object> tagValues = nodeVsTags.get(aNode.getKey());
                if (tagValues == null || !tagCondition.canMatch(obj = tagValues.get(this.tag.name), phase)) continue;
                countMatchingThisTagValue += aNode.getValue().intValue();
            }
        }
        return countMatchingThisTagValue;
    }

    public int compare(String n1, String n2, Map<String, Map<String, Object>> nodeVsTags, Map<String, Map<String, Integer>> currentState) {
        return this.tag.compare(n1, n2, nodeVsTags);
    }

    public boolean isFuzzy() {
        return this.shard.fuzzy || this.replica.fuzzy || this.tag.fuzzy;
    }

    public static class Condition {
        public final String name;
        final Object val;
        public final Operand operand;
        final boolean fuzzy;

        Condition(String name, Object val, Operand op) {
            this.name = name;
            this.val = val;
            this.operand = op;
            this.fuzzy = false;
        }

        Condition(String key, Object val) {
            Object expectedVal;
            boolean fuzzy;
            block12: {
                fuzzy = false;
                if (val == null) {
                    throw new RuntimeException("value of  a tag cannot be null for key " + key);
                }
                try {
                    this.name = key.trim();
                    String value = val.toString().trim();
                    if (value.endsWith("~")) {
                        fuzzy = true;
                        value = value.substring(0, value.length() - 1);
                    }
                    if ((expectedVal = Operand.NOT_EQUAL.match(value)) != null) {
                        this.operand = Operand.NOT_EQUAL;
                    } else {
                        expectedVal = Operand.GREATER_THAN.match(value);
                        if (expectedVal != null) {
                            this.operand = Operand.GREATER_THAN;
                        } else {
                            expectedVal = Operand.LESS_THAN.match(value);
                            if (expectedVal != null) {
                                this.operand = Operand.LESS_THAN;
                            } else {
                                this.operand = Operand.EQUAL;
                                expectedVal = value;
                            }
                        }
                    }
                    if (!this.name.equals("replica") || Rule.WILD_CARD.equals(expectedVal)) break block12;
                    try {
                        expectedVal = Integer.parseInt(expectedVal.toString());
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("The replica tag value can only be '*' or an integer");
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid condition : " + key + ":" + val, e);
                }
            }
            this.val = expectedVal;
            this.fuzzy = fuzzy;
        }

        public boolean isWildCard() {
            return this.val.equals(Rule.WILD_CARD) || this.val.equals(Rule.WILD_WILD_CARD);
        }

        boolean canMatch(Object testVal, Phase phase) {
            if (phase == Phase.FUZZY_ASSIGN || phase == Phase.FUZZY_VERIFY) {
                return true;
            }
            if (phase == Phase.ASSIGN && (this.name.equals("replica") || this.name.equals("cores")) && (this.operand == Operand.GREATER_THAN || this.operand == Operand.NOT_EQUAL)) {
                return true;
            }
            return this.operand.canMatch(this.val, testVal);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Condition) {
                Condition that = (Condition)obj;
                return Objects.equals(this.name, that.name) && Objects.equals((Object)this.operand, (Object)that.operand) && Objects.equals(this.val, that.val);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.operand});
        }

        public String toString() {
            return this.name + ":" + this.operand.toStr(this.val) + (this.fuzzy ? "~" : "");
        }

        public Integer getInt() {
            return (Integer)this.val;
        }

        public int compare(String n1, String n2, Map<String, Map<String, Object>> nodeVsTags) {
            Object n2Val;
            Map<String, Object> tags = nodeVsTags.get(n1);
            Object n1Val = tags == null ? null : tags.get(this.name);
            tags = nodeVsTags.get(n2);
            Object object = n2Val = tags == null ? null : tags.get(this.name);
            if (n1Val == null || n2Val == null) {
                return -1;
            }
            return this.isWildCard() ? 0 : this.operand.compare(n1Val, n2Val);
        }
    }

    static enum Phase {
        ASSIGN,
        VERIFY,
        FUZZY_ASSIGN,
        FUZZY_VERIFY;

    }

    static enum MatchStatus {
        NODE_CAN_BE_ASSIGNED,
        CANNOT_ASSIGN_GO_AHEAD,
        NOT_APPLICABLE,
        CANNOT_ASSIGN_FAIL;

    }

    public static enum Operand {
        EQUAL(""),
        NOT_EQUAL("!"){

            @Override
            public boolean canMatch(Object ruleVal, Object testVal) {
                return !super.canMatch(ruleVal, testVal);
            }
        }
        ,
        GREATER_THAN(">"){

            @Override
            public Object match(String val) {
                return this.checkNumeric(super.match(val));
            }

            @Override
            public boolean canMatch(Object ruleVal, Object testVal) {
                return testVal != null && this.compareNum(ruleVal, testVal) == 1;
            }
        }
        ,
        LESS_THAN("<"){

            @Override
            public int compare(Object n1Val, Object n2Val) {
                return GREATER_THAN.compare(n1Val, n2Val) * -1;
            }

            @Override
            public boolean canMatch(Object ruleVal, Object testVal) {
                return testVal != null && this.compareNum(ruleVal, testVal) == -1;
            }

            @Override
            public Object match(String val) {
                return this.checkNumeric(super.match(val));
            }
        };

        public final String operand;

        private Operand(String val) {
            this.operand = val;
        }

        public String toStr(Object expectedVal) {
            return this.operand + expectedVal.toString();
        }

        Object checkNumeric(Object val) {
            if (val == null) {
                return null;
            }
            try {
                return Integer.parseInt(val.toString());
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("for operand " + this.operand + " the value must be numeric");
            }
        }

        public Object match(String val) {
            if (this.operand.isEmpty()) {
                return val;
            }
            return val.startsWith(this.operand) ? val.substring(1) : null;
        }

        public boolean canMatch(Object ruleVal, Object testVal) {
            return Objects.equals(String.valueOf(ruleVal), String.valueOf(testVal));
        }

        public int compare(Object n1Val, Object n2Val) {
            return 0;
        }

        public int compareNum(Object n1Val, Object n2Val) {
            Integer n1 = (Integer)Rule.parseObj(n1Val, Integer.class);
            Integer n2 = (Integer)Rule.parseObj(n2Val, Integer.class);
            return n1 > n2 ? -1 : (Objects.equals(n1, n2) ? 0 : 1);
        }
    }
}

