/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.util.Set;
import org.apache.solr.common.SolrCloseableLatch;
import org.apache.solr.common.cloud.CollectionStateWatcher;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;

public class LeaderRecoveryWatcher
implements CollectionStateWatcher {
    String collectionId;
    String shardId;
    String replicaId;
    String targetCore;
    SolrCloseableLatch latch;

    LeaderRecoveryWatcher(String collectionId, String shardId, String replicaId, String targetCore, SolrCloseableLatch latch) {
        this.collectionId = collectionId;
        this.shardId = shardId;
        this.replicaId = replicaId;
        this.targetCore = targetCore;
        this.latch = latch;
    }

    public boolean onStateChanged(Set<String> liveNodes, DocCollection collectionState) {
        if (collectionState == null) {
            this.latch.countDown();
            return true;
        }
        Slice slice = collectionState.getSlice(this.shardId);
        if (slice == null) {
            this.latch.countDown();
            return true;
        }
        for (Replica replica : slice.getReplicas()) {
            if (replica.getName().equals(this.replicaId) || replica.getType().equals((Object)Replica.Type.PULL)) continue;
            String coreName = replica.getStr("core");
            if (this.targetCore != null && !this.targetCore.equals(coreName) || !replica.isActive(liveNodes)) continue;
            this.latch.countDown();
            return true;
        }
        return false;
    }
}

