/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.MutablePointValues;
import org.apache.lucene.codecs.simpletext.SimpleTextPointsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.bkd.BKDRadixSelector;
import org.apache.lucene.util.bkd.HeapPointWriter;
import org.apache.lucene.util.bkd.MutablePointsReaderUtils;
import org.apache.lucene.util.bkd.OfflinePointWriter;
import org.apache.lucene.util.bkd.PointValue;
import org.apache.lucene.util.bkd.PointWriter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class SimpleTextBKDWriter
implements Closeable {
    public static final String CODEC_NAME = "BKD";
    public static final int VERSION_START = 0;
    public static final int VERSION_COMPRESSED_DOC_IDS = 1;
    public static final int VERSION_COMPRESSED_VALUES = 2;
    public static final int VERSION_IMPLICIT_SPLIT_DIM_1D = 3;
    public static final int VERSION_CURRENT = 3;
    private final int bytesPerDoc;
    public static final int DEFAULT_MAX_POINTS_IN_LEAF_NODE = 1024;
    public static final float DEFAULT_MAX_MB_SORT_IN_HEAP = 16.0f;
    public static final int MAX_DIMS = 16;
    public static final int MAX_INDEX_DIMS = 8;
    protected final int numDataDims;
    protected final int numIndexDims;
    protected final int bytesPerDim;
    protected final int packedBytesLength;
    protected final int packedIndexBytesLength;
    final BytesRefBuilder scratch = new BytesRefBuilder();
    final TrackingDirectoryWrapper tempDir;
    final String tempFileNamePrefix;
    final double maxMBSortInHeap;
    final byte[] scratchDiff;
    final byte[] scratch1;
    final byte[] scratch2;
    final BytesRef scratchBytesRef1 = new BytesRef();
    final BytesRef scratchBytesRef2 = new BytesRef();
    final int[] commonPrefixLengths;
    protected final FixedBitSet docsSeen;
    private PointWriter pointWriter;
    private boolean finished;
    private IndexOutput tempInput;
    protected final int maxPointsInLeafNode;
    private final int maxPointsSortInHeap;
    protected final byte[] minPackedValue;
    protected final byte[] maxPackedValue;
    protected long pointCount;
    private final long totalPointCount;
    private final int maxDoc;

    public SimpleTextBKDWriter(int maxDoc, Directory tempDir, String tempFileNamePrefix, int numDataDims, int numIndexDims, int bytesPerDim, int maxPointsInLeafNode, double maxMBSortInHeap, long totalPointCount) throws IOException {
        SimpleTextBKDWriter.verifyParams(numDataDims, numIndexDims, maxPointsInLeafNode, maxMBSortInHeap, totalPointCount);
        this.tempDir = new TrackingDirectoryWrapper(tempDir);
        this.tempFileNamePrefix = tempFileNamePrefix;
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.numDataDims = numDataDims;
        this.numIndexDims = numIndexDims;
        this.bytesPerDim = bytesPerDim;
        this.totalPointCount = totalPointCount;
        this.maxDoc = maxDoc;
        this.docsSeen = new FixedBitSet(maxDoc);
        this.packedBytesLength = numDataDims * bytesPerDim;
        this.packedIndexBytesLength = numIndexDims * bytesPerDim;
        this.scratchDiff = new byte[bytesPerDim];
        this.scratch1 = new byte[this.packedBytesLength];
        this.scratch2 = new byte[this.packedBytesLength];
        this.commonPrefixLengths = new int[numDataDims];
        this.minPackedValue = new byte[this.packedIndexBytesLength];
        this.maxPackedValue = new byte[this.packedIndexBytesLength];
        this.bytesPerDoc = this.packedBytesLength + 4;
        this.maxPointsSortInHeap = (int)(maxMBSortInHeap * 1024.0 * 1024.0 / (double)(this.bytesPerDoc * numDataDims));
        if (this.maxPointsSortInHeap < maxPointsInLeafNode) {
            throw new IllegalArgumentException("maxMBSortInHeap=" + maxMBSortInHeap + " only allows for maxPointsSortInHeap=" + this.maxPointsSortInHeap + ", but this is less than maxPointsInLeafNode=" + maxPointsInLeafNode + "; either increase maxMBSortInHeap or decrease maxPointsInLeafNode");
        }
        this.maxMBSortInHeap = maxMBSortInHeap;
    }

    public static void verifyParams(int numDims, int numIndexDims, int maxPointsInLeafNode, double maxMBSortInHeap, long totalPointCount) {
        if (numDims < 1 || numDims > 16) {
            throw new IllegalArgumentException("numDims must be 1 .. 16 (got: " + numDims + ")");
        }
        if (numIndexDims < 1 || numIndexDims > 8) {
            throw new IllegalArgumentException("numIndexDims must be 1 .. 8 (got: " + numIndexDims + ")");
        }
        if (numIndexDims > numDims) {
            throw new IllegalArgumentException("numIndexDims cannot exceed numDims (" + numDims + ") (got: " + numIndexDims + ")");
        }
        if (maxPointsInLeafNode <= 0) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be > 0; got " + maxPointsInLeafNode);
        }
        if (maxPointsInLeafNode > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be <= ArrayUtil.MAX_ARRAY_LENGTH (= " + ArrayUtil.MAX_ARRAY_LENGTH + "); got " + maxPointsInLeafNode);
        }
        if (maxMBSortInHeap < 0.0) {
            throw new IllegalArgumentException("maxMBSortInHeap must be >= 0.0 (got: " + maxMBSortInHeap + ")");
        }
        if (totalPointCount < 0L) {
            throw new IllegalArgumentException("totalPointCount must be >=0 (got: " + totalPointCount + ")");
        }
    }

    public void add(byte[] packedValue, int docID) throws IOException {
        if (packedValue.length != this.packedBytesLength) {
            throw new IllegalArgumentException("packedValue should be length=" + this.packedBytesLength + " (got: " + packedValue.length + ")");
        }
        if (this.pointCount >= this.totalPointCount) {
            throw new IllegalStateException("totalPointCount=" + this.totalPointCount + " was passed when we were created, but we just hit " + (this.pointCount + 1L) + " values");
        }
        if (this.pointCount == 0L) {
            assert (this.pointWriter == null) : "Point writer is already initialized";
            if (this.totalPointCount > (long)this.maxPointsSortInHeap) {
                this.pointWriter = new OfflinePointWriter((Directory)this.tempDir, this.tempFileNamePrefix, this.packedBytesLength, "spill", 0L);
                this.tempInput = ((OfflinePointWriter)this.pointWriter).out;
            } else {
                this.pointWriter = new HeapPointWriter(Math.toIntExact(this.totalPointCount), this.packedBytesLength);
            }
            System.arraycopy(packedValue, 0, this.minPackedValue, 0, this.packedIndexBytesLength);
            System.arraycopy(packedValue, 0, this.maxPackedValue, 0, this.packedIndexBytesLength);
        } else {
            for (int dim = 0; dim < this.numIndexDims; ++dim) {
                int offset = dim * this.bytesPerDim;
                if (Arrays.compareUnsigned(packedValue, offset, offset + this.bytesPerDim, this.minPackedValue, offset, offset + this.bytesPerDim) < 0) {
                    System.arraycopy(packedValue, offset, this.minPackedValue, offset, this.bytesPerDim);
                }
                if (Arrays.compareUnsigned(packedValue, offset, offset + this.bytesPerDim, this.maxPackedValue, offset, offset + this.bytesPerDim) <= 0) continue;
                System.arraycopy(packedValue, offset, this.maxPackedValue, offset, this.bytesPerDim);
            }
        }
        this.pointWriter.append(packedValue, docID);
        ++this.pointCount;
        this.docsSeen.set(docID);
    }

    public long getPointCount() {
        return this.pointCount;
    }

    public long writeField(IndexOutput out, String fieldName, MutablePointValues reader) throws IOException {
        if (this.numIndexDims == 1) {
            return this.writeField1Dim(out, fieldName, reader);
        }
        return this.writeFieldNDims(out, fieldName, reader);
    }

    private long writeFieldNDims(IndexOutput out, String fieldName, MutablePointValues values) throws IOException {
        if (this.pointCount != 0L) {
            throw new IllegalStateException("cannot mix add and writeField");
        }
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        long countPerLeaf = this.pointCount = values.size();
        long innerNodeCount = 1L;
        while (countPerLeaf > (long)this.maxPointsInLeafNode) {
            countPerLeaf = (countPerLeaf + 1L) / 2L;
            innerNodeCount *= 2L;
        }
        int numLeaves = Math.toIntExact(innerNodeCount);
        this.checkMaxLeafNodeCount(numLeaves);
        byte[] splitPackedValues = new byte[numLeaves * (this.bytesPerDim + 1)];
        long[] leafBlockFPs = new long[numLeaves];
        Arrays.fill(this.minPackedValue, (byte)-1);
        Arrays.fill(this.maxPackedValue, (byte)0);
        for (int i = 0; i < Math.toIntExact(this.pointCount); ++i) {
            values.getValue(i, this.scratchBytesRef1);
            for (int dim = 0; dim < this.numIndexDims; ++dim) {
                int offset = dim * this.bytesPerDim;
                if (Arrays.compareUnsigned(this.scratchBytesRef1.bytes, this.scratchBytesRef1.offset + offset, this.scratchBytesRef1.offset + offset + this.bytesPerDim, this.minPackedValue, offset, offset + this.bytesPerDim) < 0) {
                    System.arraycopy(this.scratchBytesRef1.bytes, this.scratchBytesRef1.offset + offset, this.minPackedValue, offset, this.bytesPerDim);
                }
                if (Arrays.compareUnsigned(this.scratchBytesRef1.bytes, this.scratchBytesRef1.offset + offset, this.scratchBytesRef1.offset + offset + this.bytesPerDim, this.maxPackedValue, offset, offset + this.bytesPerDim) <= 0) continue;
                System.arraycopy(this.scratchBytesRef1.bytes, this.scratchBytesRef1.offset + offset, this.maxPackedValue, offset, this.bytesPerDim);
            }
            this.docsSeen.set(values.getDocID(i));
        }
        this.build(1, numLeaves, values, 0, Math.toIntExact(this.pointCount), out, this.minPackedValue, this.maxPackedValue, splitPackedValues, leafBlockFPs, new int[this.maxPointsInLeafNode]);
        long indexFP = out.getFilePointer();
        this.writeIndex(out, leafBlockFPs, splitPackedValues);
        return indexFP;
    }

    private long writeField1Dim(IndexOutput out, String fieldName, MutablePointValues reader) throws IOException {
        MutablePointsReaderUtils.sort((int)this.maxDoc, (int)this.packedIndexBytesLength, (MutablePointValues)reader, (int)0, (int)Math.toIntExact(reader.size()));
        final OneDimensionBKDWriter oneDimWriter = new OneDimensionBKDWriter(out);
        reader.intersect(new PointValues.IntersectVisitor(){

            public void visit(int docID, byte[] packedValue) throws IOException {
                oneDimWriter.add(packedValue, docID);
            }

            public void visit(int docID) throws IOException {
                throw new IllegalStateException();
            }

            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
        });
        return oneDimWriter.finish();
    }

    private void rotateToTree(int nodeID, int offset, int count, byte[] index, List<byte[]> leafBlockStartValues) {
        if (count == 1) {
            System.arraycopy(leafBlockStartValues.get(offset), 0, index, nodeID * (1 + this.bytesPerDim) + 1, this.bytesPerDim);
        } else {
            if (count > 1) {
                int countAtLevel = 1;
                int totalCount = 0;
                while (true) {
                    int countLeft;
                    if ((countLeft = count - totalCount) <= countAtLevel) {
                        int lastLeftCount = Math.min(countAtLevel / 2, countLeft);
                        assert (lastLeftCount >= 0);
                        int leftHalf = (totalCount - 1) / 2 + lastLeftCount;
                        int rootOffset = offset + leftHalf;
                        System.arraycopy(leafBlockStartValues.get(rootOffset), 0, index, nodeID * (1 + this.bytesPerDim) + 1, this.bytesPerDim);
                        this.rotateToTree(2 * nodeID, offset, leftHalf, index, leafBlockStartValues);
                        this.rotateToTree(2 * nodeID + 1, rootOffset + 1, count - leftHalf - 1, index, leafBlockStartValues);
                        return;
                    }
                    totalCount += countAtLevel;
                    countAtLevel *= 2;
                }
            }
            assert (count == 0);
        }
    }

    private void checkMaxLeafNodeCount(int numLeaves) {
        if ((long)(1 + this.bytesPerDim) * (long)numLeaves > (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalStateException("too many nodes; increase maxPointsInLeafNode (currently " + this.maxPointsInLeafNode + ") and reindex");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long finish(IndexOutput out) throws IOException {
        if (this.pointCount == 0L) {
            throw new IllegalStateException("must index at least one point");
        }
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        this.pointWriter.close();
        BKDRadixSelector.PathSlice points = new BKDRadixSelector.PathSlice(this.pointWriter, 0L, this.pointCount);
        this.tempInput = null;
        this.pointWriter = null;
        long countPerLeaf = this.pointCount;
        long innerNodeCount = 1L;
        while (countPerLeaf > (long)this.maxPointsInLeafNode) {
            countPerLeaf = (countPerLeaf + 1L) / 2L;
            innerNodeCount *= 2L;
        }
        int numLeaves = (int)innerNodeCount;
        this.checkMaxLeafNodeCount(numLeaves);
        byte[] splitPackedValues = new byte[Math.toIntExact(numLeaves * (1 + this.bytesPerDim))];
        long[] leafBlockFPs = new long[numLeaves];
        assert (this.pointCount / (long)numLeaves <= (long)this.maxPointsInLeafNode) : "pointCount=" + this.pointCount + " numLeaves=" + numLeaves + " maxPointsInLeafNode=" + this.maxPointsInLeafNode;
        BKDRadixSelector radixSelector = new BKDRadixSelector(this.numDataDims, this.numIndexDims, this.bytesPerDim, this.maxPointsSortInHeap, (Directory)this.tempDir, this.tempFileNamePrefix);
        boolean success = false;
        try {
            this.build(1, numLeaves, points, out, radixSelector, this.minPackedValue, this.maxPackedValue, splitPackedValues, leafBlockFPs, new int[this.maxPointsInLeafNode]);
            assert (this.tempDir.getCreatedFiles().isEmpty());
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.deleteFilesIgnoringExceptions((Directory)this.tempDir, (Collection)this.tempDir.getCreatedFiles());
            }
        }
        long indexFP = out.getFilePointer();
        this.writeIndex(out, leafBlockFPs, splitPackedValues);
        return indexFP;
    }

    private void writeIndex(IndexOutput out, long[] leafBlockFPs, byte[] splitPackedValues) throws IOException {
        this.write(out, SimpleTextPointsWriter.NUM_DATA_DIMS);
        this.writeInt(out, this.numDataDims);
        this.newline(out);
        this.write(out, SimpleTextPointsWriter.NUM_INDEX_DIMS);
        this.writeInt(out, this.numIndexDims);
        this.newline(out);
        this.write(out, SimpleTextPointsWriter.BYTES_PER_DIM);
        this.writeInt(out, this.bytesPerDim);
        this.newline(out);
        this.write(out, SimpleTextPointsWriter.MAX_LEAF_POINTS);
        this.writeInt(out, this.maxPointsInLeafNode);
        this.newline(out);
        this.write(out, SimpleTextPointsWriter.INDEX_COUNT);
        this.writeInt(out, leafBlockFPs.length);
        this.newline(out);
        this.write(out, SimpleTextPointsWriter.MIN_VALUE);
        BytesRef br = new BytesRef(this.minPackedValue, 0, this.minPackedValue.length);
        this.write(out, br.toString());
        this.newline(out);
        this.write(out, SimpleTextPointsWriter.MAX_VALUE);
        br = new BytesRef(this.maxPackedValue, 0, this.maxPackedValue.length);
        this.write(out, br.toString());
        this.newline(out);
        this.write(out, SimpleTextPointsWriter.POINT_COUNT);
        this.writeLong(out, this.pointCount);
        this.newline(out);
        this.write(out, SimpleTextPointsWriter.DOC_COUNT);
        this.writeInt(out, this.docsSeen.cardinality());
        this.newline(out);
        for (int i = 0; i < leafBlockFPs.length; ++i) {
            this.write(out, SimpleTextPointsWriter.BLOCK_FP);
            this.writeLong(out, leafBlockFPs[i]);
            this.newline(out);
        }
        assert (splitPackedValues.length % (1 + this.bytesPerDim) == 0);
        int count = splitPackedValues.length / (1 + this.bytesPerDim);
        assert (count == leafBlockFPs.length);
        this.write(out, SimpleTextPointsWriter.SPLIT_COUNT);
        this.writeInt(out, count);
        this.newline(out);
        for (int i = 0; i < count; ++i) {
            this.write(out, SimpleTextPointsWriter.SPLIT_DIM);
            this.writeInt(out, splitPackedValues[i * (1 + this.bytesPerDim)] & 0xFF);
            this.newline(out);
            this.write(out, SimpleTextPointsWriter.SPLIT_VALUE);
            br = new BytesRef(splitPackedValues, 1 + i * (1 + this.bytesPerDim), this.bytesPerDim);
            this.write(out, br.toString());
            this.newline(out);
        }
    }

    protected void writeLeafBlockDocs(IndexOutput out, int[] docIDs, int start, int count) throws IOException {
        this.write(out, SimpleTextPointsWriter.BLOCK_COUNT);
        this.writeInt(out, count);
        this.newline(out);
        for (int i = 0; i < count; ++i) {
            this.write(out, SimpleTextPointsWriter.BLOCK_DOC_ID);
            this.writeInt(out, docIDs[start + i]);
            this.newline(out);
        }
    }

    protected void writeLeafBlockPackedValues(IndexOutput out, int[] commonPrefixLengths, int count, int sortedDim, IntFunction<BytesRef> packedValues) throws IOException {
        for (int i = 0; i < count; ++i) {
            BytesRef packedValue = packedValues.apply(i);
            this.write(out, SimpleTextPointsWriter.BLOCK_VALUE);
            this.write(out, packedValue.toString());
            this.newline(out);
        }
    }

    private void writeLeafBlockPackedValuesRange(IndexOutput out, int[] commonPrefixLengths, int start, int end, IntFunction<BytesRef> packedValues) throws IOException {
        for (int i = start; i < end; ++i) {
            BytesRef ref = packedValues.apply(i);
            assert (ref.length == this.packedBytesLength);
            for (int dim = 0; dim < this.numDataDims; ++dim) {
                int prefix = commonPrefixLengths[dim];
                out.writeBytes(ref.bytes, ref.offset + dim * this.bytesPerDim + prefix, this.bytesPerDim - prefix);
            }
        }
    }

    private static int runLen(IntFunction<BytesRef> packedValues, int start, int end, int byteOffset) {
        BytesRef first = packedValues.apply(start);
        byte b = first.bytes[first.offset + byteOffset];
        for (int i = start + 1; i < end; ++i) {
            BytesRef ref = packedValues.apply(i);
            byte b2 = ref.bytes[ref.offset + byteOffset];
            assert (Byte.toUnsignedInt(b2) >= Byte.toUnsignedInt(b));
            if (b == b2) continue;
            return i - start;
        }
        return end - start;
    }

    @Override
    public void close() throws IOException {
        if (this.tempInput != null) {
            try {
                this.tempInput.close();
            }
            finally {
                this.tempDir.deleteFile(this.tempInput.getName());
                this.tempInput = null;
            }
        }
    }

    private Error verifyChecksum(Throwable priorException, PointWriter writer) throws IOException {
        assert (priorException != null);
        if (writer instanceof OfflinePointWriter) {
            String tempFileName = ((OfflinePointWriter)writer).name;
            try (ChecksumIndexInput in = this.tempDir.openChecksumInput(tempFileName, IOContext.READONCE);){
                CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorException);
            }
        }
        throw IOUtils.rethrowAlways((Throwable)priorException);
    }

    private boolean valueInBounds(BytesRef packedValue, byte[] minPackedValue, byte[] maxPackedValue) {
        for (int dim = 0; dim < this.numIndexDims; ++dim) {
            int offset = this.bytesPerDim * dim;
            if (Arrays.compareUnsigned(packedValue.bytes, packedValue.offset + offset, packedValue.offset + offset + this.bytesPerDim, minPackedValue, offset, offset + this.bytesPerDim) < 0) {
                return false;
            }
            if (Arrays.compareUnsigned(packedValue.bytes, packedValue.offset + offset, packedValue.offset + offset + this.bytesPerDim, maxPackedValue, offset, offset + this.bytesPerDim) <= 0) continue;
            return false;
        }
        return true;
    }

    protected int split(byte[] minPackedValue, byte[] maxPackedValue) {
        int splitDim = -1;
        for (int dim = 0; dim < this.numIndexDims; ++dim) {
            NumericUtils.subtract((int)this.bytesPerDim, (int)dim, (byte[])maxPackedValue, (byte[])minPackedValue, (byte[])this.scratchDiff);
            if (splitDim != -1 && Arrays.compareUnsigned(this.scratchDiff, 0, this.bytesPerDim, this.scratch1, 0, this.bytesPerDim) <= 0) continue;
            System.arraycopy(this.scratchDiff, 0, this.scratch1, 0, this.bytesPerDim);
            splitDim = dim;
        }
        return splitDim;
    }

    /*
     * Exception decompiling
     */
    private HeapPointWriter switchToHeap(PointWriter source) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void build(int nodeID, int leafNodeOffset, final MutablePointValues reader, final int from, int to, IndexOutput out, byte[] minPackedValue, byte[] maxPackedValue, byte[] splitPackedValues, long[] leafBlockFPs, int[] spareDocIds) throws IOException {
        if (nodeID >= leafNodeOffset) {
            int dim;
            int count = to - from;
            assert (count <= this.maxPointsInLeafNode);
            Arrays.fill(this.commonPrefixLengths, this.bytesPerDim);
            reader.getValue(from, this.scratchBytesRef1);
            for (int i = from + 1; i < to; ++i) {
                reader.getValue(i, this.scratchBytesRef2);
                block1: for (dim = 0; dim < this.numDataDims; ++dim) {
                    int offset = dim * this.bytesPerDim;
                    for (int j = 0; j < this.commonPrefixLengths[dim]; ++j) {
                        if (this.scratchBytesRef1.bytes[this.scratchBytesRef1.offset + offset + j] == this.scratchBytesRef2.bytes[this.scratchBytesRef2.offset + offset + j]) continue;
                        this.commonPrefixLengths[dim] = j;
                        continue block1;
                    }
                }
            }
            FixedBitSet[] usedBytes = new FixedBitSet[this.numDataDims];
            for (dim = 0; dim < this.numDataDims; ++dim) {
                if (this.commonPrefixLengths[dim] >= this.bytesPerDim) continue;
                usedBytes[dim] = new FixedBitSet(256);
            }
            for (int i = from + 1; i < to; ++i) {
                for (int dim2 = 0; dim2 < this.numDataDims; ++dim2) {
                    if (usedBytes[dim2] == null) continue;
                    byte b = reader.getByteAt(i, dim2 * this.bytesPerDim + this.commonPrefixLengths[dim2]);
                    usedBytes[dim2].set(Byte.toUnsignedInt(b));
                }
            }
            int sortedDim = 0;
            int sortedDimCardinality = Integer.MAX_VALUE;
            for (int dim3 = 0; dim3 < this.numDataDims; ++dim3) {
                int cardinality;
                if (usedBytes[dim3] == null || (cardinality = usedBytes[dim3].cardinality()) >= sortedDimCardinality) continue;
                sortedDim = dim3;
                sortedDimCardinality = cardinality;
            }
            MutablePointsReaderUtils.sortByDim((int)this.numDataDims, (int)this.numIndexDims, (int)sortedDim, (int)this.bytesPerDim, (int[])this.commonPrefixLengths, (MutablePointValues)reader, (int)from, (int)to, (BytesRef)this.scratchBytesRef1, (BytesRef)this.scratchBytesRef2);
            leafBlockFPs[nodeID - leafNodeOffset] = out.getFilePointer();
            int[] docIDs = spareDocIds;
            for (int i = from; i < to; ++i) {
                docIDs[i - from] = reader.getDocID(i);
            }
            this.writeLeafBlockDocs(out, docIDs, 0, count);
            reader.getValue(from, this.scratchBytesRef1);
            System.arraycopy(this.scratchBytesRef1.bytes, this.scratchBytesRef1.offset, this.scratch1, 0, this.packedBytesLength);
            IntFunction<BytesRef> packedValues = new IntFunction<BytesRef>(){

                @Override
                public BytesRef apply(int i) {
                    reader.getValue(from + i, SimpleTextBKDWriter.this.scratchBytesRef1);
                    return SimpleTextBKDWriter.this.scratchBytesRef1;
                }
            };
            assert (this.valuesInOrderAndBounds(count, sortedDim, minPackedValue, maxPackedValue, packedValues, docIDs, 0));
            this.writeLeafBlockPackedValues(out, this.commonPrefixLengths, count, sortedDim, packedValues);
        } else {
            int splitDim = this.split(minPackedValue, maxPackedValue);
            int mid = from + to + 1 >>> 1;
            int commonPrefixLen = this.bytesPerDim;
            for (int i = 0; i < this.bytesPerDim; ++i) {
                if (minPackedValue[splitDim * this.bytesPerDim + i] == maxPackedValue[splitDim * this.bytesPerDim + i]) continue;
                commonPrefixLen = i;
                break;
            }
            MutablePointsReaderUtils.partition((int)this.numDataDims, (int)this.numIndexDims, (int)this.maxDoc, (int)splitDim, (int)this.bytesPerDim, (int)commonPrefixLen, (MutablePointValues)reader, (int)from, (int)to, (int)mid, (BytesRef)this.scratchBytesRef1, (BytesRef)this.scratchBytesRef2);
            int address = nodeID * (1 + this.bytesPerDim);
            splitPackedValues[address] = (byte)splitDim;
            reader.getValue(mid, this.scratchBytesRef1);
            System.arraycopy(this.scratchBytesRef1.bytes, this.scratchBytesRef1.offset + splitDim * this.bytesPerDim, splitPackedValues, address + 1, this.bytesPerDim);
            byte[] minSplitPackedValue = ArrayUtil.copyOfSubArray((byte[])minPackedValue, (int)0, (int)this.packedIndexBytesLength);
            byte[] maxSplitPackedValue = ArrayUtil.copyOfSubArray((byte[])maxPackedValue, (int)0, (int)this.packedIndexBytesLength);
            System.arraycopy(this.scratchBytesRef1.bytes, this.scratchBytesRef1.offset + splitDim * this.bytesPerDim, minSplitPackedValue, splitDim * this.bytesPerDim, this.bytesPerDim);
            System.arraycopy(this.scratchBytesRef1.bytes, this.scratchBytesRef1.offset + splitDim * this.bytesPerDim, maxSplitPackedValue, splitDim * this.bytesPerDim, this.bytesPerDim);
            this.build(nodeID * 2, leafNodeOffset, reader, from, mid, out, minPackedValue, maxSplitPackedValue, splitPackedValues, leafBlockFPs, spareDocIds);
            this.build(nodeID * 2 + 1, leafNodeOffset, reader, mid, to, out, minSplitPackedValue, maxPackedValue, splitPackedValues, leafBlockFPs, spareDocIds);
        }
    }

    private void build(int nodeID, int leafNodeOffset, BKDRadixSelector.PathSlice points, IndexOutput out, BKDRadixSelector radixSelector, byte[] minPackedValue, byte[] maxPackedValue, byte[] splitPackedValues, long[] leafBlockFPs, int[] spareDocIds) throws IOException {
        if (nodeID >= leafNodeOffset) {
            int dim;
            final HeapPointWriter heapSource = !(points.writer instanceof HeapPointWriter) ? this.switchToHeap(points.writer) : (HeapPointWriter)points.writer;
            final int from = Math.toIntExact(points.start);
            int to = Math.toIntExact(points.start + points.count);
            this.computeCommonPrefixLength(heapSource, this.scratch1);
            int sortedDim = 0;
            int sortedDimCardinality = Integer.MAX_VALUE;
            FixedBitSet[] usedBytes = new FixedBitSet[this.numDataDims];
            for (dim = 0; dim < this.numDataDims; ++dim) {
                if (this.commonPrefixLengths[dim] >= this.bytesPerDim) continue;
                usedBytes[dim] = new FixedBitSet(256);
            }
            for (dim = 0; dim < this.numDataDims; ++dim) {
                int prefix = this.commonPrefixLengths[dim];
                if (prefix >= this.bytesPerDim) continue;
                int offset = dim * this.bytesPerDim;
                int i = 0;
                while ((long)i < heapSource.count()) {
                    PointValue value = heapSource.getPackedValueSlice(i);
                    BytesRef packedValue = value.packedValue();
                    int bucket = packedValue.bytes[packedValue.offset + offset + prefix] & 0xFF;
                    usedBytes[dim].set(bucket);
                    ++i;
                }
                int cardinality = usedBytes[dim].cardinality();
                if (cardinality >= sortedDimCardinality) continue;
                sortedDim = dim;
                sortedDimCardinality = cardinality;
            }
            radixSelector.heapRadixSort(heapSource, from, to, sortedDim, this.commonPrefixLengths[sortedDim]);
            leafBlockFPs[nodeID - leafNodeOffset] = out.getFilePointer();
            int count = to - from;
            assert (count > 0) : "nodeID=" + nodeID + " leafNodeOffset=" + leafNodeOffset;
            int[] docIDs = spareDocIds;
            for (int i = 0; i < count; ++i) {
                docIDs[i] = heapSource.getPackedValueSlice(from + i).docID();
            }
            this.writeLeafBlockDocs(out, spareDocIds, 0, count);
            IntFunction<BytesRef> packedValues = new IntFunction<BytesRef>(){
                final BytesRef scratch = new BytesRef();
                {
                    this.scratch.length = SimpleTextBKDWriter.this.packedBytesLength;
                }

                @Override
                public BytesRef apply(int i) {
                    PointValue value = heapSource.getPackedValueSlice(from + i);
                    return value.packedValue();
                }
            };
            assert (this.valuesInOrderAndBounds(count, sortedDim, minPackedValue, maxPackedValue, packedValues, docIDs, 0));
            this.writeLeafBlockPackedValues(out, this.commonPrefixLengths, count, sortedDim, packedValues);
        } else {
            int splitDim = this.numIndexDims > 1 ? this.split(minPackedValue, maxPackedValue) : 0;
            assert (nodeID < splitPackedValues.length) : "nodeID=" + nodeID + " splitValues.length=" + splitPackedValues.length;
            long rightCount = points.count / 2L;
            long leftCount = points.count - rightCount;
            int commonPrefixLen = Arrays.mismatch(minPackedValue, splitDim * this.bytesPerDim, splitDim * this.bytesPerDim + this.bytesPerDim, maxPackedValue, splitDim * this.bytesPerDim, splitDim * this.bytesPerDim + this.bytesPerDim);
            if (commonPrefixLen == -1) {
                commonPrefixLen = this.bytesPerDim;
            }
            BKDRadixSelector.PathSlice[] pathSlices = new BKDRadixSelector.PathSlice[2];
            byte[] splitValue = radixSelector.select(points, pathSlices, points.start, points.start + points.count, points.start + leftCount, splitDim, commonPrefixLen);
            int address = nodeID * (1 + this.bytesPerDim);
            splitPackedValues[address] = (byte)splitDim;
            System.arraycopy(splitValue, 0, splitPackedValues, address + 1, this.bytesPerDim);
            byte[] minSplitPackedValue = new byte[this.packedIndexBytesLength];
            System.arraycopy(minPackedValue, 0, minSplitPackedValue, 0, this.packedIndexBytesLength);
            byte[] maxSplitPackedValue = new byte[this.packedIndexBytesLength];
            System.arraycopy(maxPackedValue, 0, maxSplitPackedValue, 0, this.packedIndexBytesLength);
            System.arraycopy(splitValue, 0, minSplitPackedValue, splitDim * this.bytesPerDim, this.bytesPerDim);
            System.arraycopy(splitValue, 0, maxSplitPackedValue, splitDim * this.bytesPerDim, this.bytesPerDim);
            this.build(2 * nodeID, leafNodeOffset, pathSlices[0], out, radixSelector, minPackedValue, maxSplitPackedValue, splitPackedValues, leafBlockFPs, spareDocIds);
            this.build(2 * nodeID + 1, leafNodeOffset, pathSlices[1], out, radixSelector, minSplitPackedValue, maxPackedValue, splitPackedValues, leafBlockFPs, spareDocIds);
        }
    }

    private void computeCommonPrefixLength(HeapPointWriter heapPointWriter, byte[] commonPrefix) {
        Arrays.fill(this.commonPrefixLengths, this.bytesPerDim);
        PointValue value = heapPointWriter.getPackedValueSlice(0);
        BytesRef packedValue = value.packedValue();
        for (int dim = 0; dim < this.numDataDims; ++dim) {
            System.arraycopy(packedValue.bytes, packedValue.offset + dim * this.bytesPerDim, commonPrefix, dim * this.bytesPerDim, this.bytesPerDim);
        }
        int i = 1;
        while ((long)i < heapPointWriter.count()) {
            value = heapPointWriter.getPackedValueSlice(i);
            packedValue = value.packedValue();
            for (int dim = 0; dim < this.numDataDims; ++dim) {
                int j;
                if (this.commonPrefixLengths[dim] == 0 || (j = Arrays.mismatch(commonPrefix, dim * this.bytesPerDim, dim * this.bytesPerDim + this.commonPrefixLengths[dim], packedValue.bytes, packedValue.offset + dim * this.bytesPerDim, packedValue.offset + dim * this.bytesPerDim + this.commonPrefixLengths[dim])) == -1) continue;
                this.commonPrefixLengths[dim] = j;
            }
            ++i;
        }
    }

    private boolean valuesInOrderAndBounds(int count, int sortedDim, byte[] minPackedValue, byte[] maxPackedValue, IntFunction<BytesRef> values, int[] docs, int docsOffset) throws IOException {
        byte[] lastPackedValue = new byte[this.packedBytesLength];
        int lastDoc = -1;
        for (int i = 0; i < count; ++i) {
            BytesRef packedValue = values.apply(i);
            assert (packedValue.length == this.packedBytesLength);
            assert (this.valueInOrder(i, sortedDim, lastPackedValue, packedValue.bytes, packedValue.offset, docs[docsOffset + i], lastDoc));
            lastDoc = docs[docsOffset + i];
            assert (this.valueInBounds(packedValue, minPackedValue, maxPackedValue));
        }
        return true;
    }

    private boolean valueInOrder(long ord, int sortedDim, byte[] lastPackedValue, byte[] packedValue, int packedValueOffset, int doc, int lastDoc) {
        int dimOffset = sortedDim * this.bytesPerDim;
        if (ord > 0L) {
            int dataOffset;
            int cmp = Arrays.compareUnsigned(lastPackedValue, dimOffset, dimOffset + this.bytesPerDim, packedValue, packedValueOffset + dimOffset, packedValueOffset + dimOffset + this.bytesPerDim);
            if (cmp > 0) {
                throw new AssertionError((Object)("values out of order: last value=" + new BytesRef(lastPackedValue) + " current value=" + new BytesRef(packedValue, packedValueOffset, this.packedBytesLength) + " ord=" + ord + " sortedDim=" + sortedDim));
            }
            if (cmp == 0 && this.numDataDims > this.numIndexDims && (cmp = Arrays.compareUnsigned(lastPackedValue, dataOffset = this.numIndexDims * this.bytesPerDim, this.packedBytesLength, packedValue, packedValueOffset + dataOffset, packedValueOffset + this.packedBytesLength)) > 0) {
                throw new AssertionError((Object)("data values out of order: last value=" + new BytesRef(lastPackedValue) + " current value=" + new BytesRef(packedValue, packedValueOffset, this.packedBytesLength) + " ord=" + ord));
            }
            if (cmp == 0 && doc < lastDoc) {
                throw new AssertionError((Object)("docs out of order: last doc=" + lastDoc + " current doc=" + doc + " ord=" + ord + " sortedDim=" + sortedDim));
            }
        }
        System.arraycopy(packedValue, packedValueOffset, lastPackedValue, 0, this.packedBytesLength);
        return true;
    }

    private void write(IndexOutput out, String s) throws IOException {
        SimpleTextUtil.write((DataOutput)out, s, this.scratch);
    }

    private void writeInt(IndexOutput out, int x) throws IOException {
        SimpleTextUtil.write((DataOutput)out, Integer.toString(x), this.scratch);
    }

    private void writeLong(IndexOutput out, long x) throws IOException {
        SimpleTextUtil.write((DataOutput)out, Long.toString(x), this.scratch);
    }

    private void write(IndexOutput out, BytesRef b) throws IOException {
        SimpleTextUtil.write((DataOutput)out, b);
    }

    private void newline(IndexOutput out) throws IOException {
        SimpleTextUtil.writeNewline((DataOutput)out);
    }

    private class OneDimensionBKDWriter {
        final IndexOutput out;
        final List<Long> leafBlockFPs = new ArrayList<Long>();
        final List<byte[]> leafBlockStartValues = new ArrayList<byte[]>();
        final byte[] leafValues;
        final int[] leafDocs;
        long valueCount;
        int leafCount;
        final byte[] lastPackedValue;
        int lastDocID;

        OneDimensionBKDWriter(IndexOutput out) {
            this.leafValues = new byte[SimpleTextBKDWriter.this.maxPointsInLeafNode * SimpleTextBKDWriter.this.packedBytesLength];
            this.leafDocs = new int[SimpleTextBKDWriter.this.maxPointsInLeafNode];
            if (SimpleTextBKDWriter.this.numIndexDims != 1) {
                throw new UnsupportedOperationException("numIndexDims must be 1 but got " + SimpleTextBKDWriter.this.numIndexDims);
            }
            if (SimpleTextBKDWriter.this.pointCount != 0L) {
                throw new IllegalStateException("cannot mix add and merge");
            }
            if (SimpleTextBKDWriter.this.finished) {
                throw new IllegalStateException("already finished");
            }
            SimpleTextBKDWriter.this.finished = true;
            this.out = out;
            this.lastPackedValue = new byte[SimpleTextBKDWriter.this.packedBytesLength];
        }

        void add(byte[] packedValue, int docID) throws IOException {
            assert (SimpleTextBKDWriter.this.valueInOrder(this.valueCount + (long)this.leafCount, 0, this.lastPackedValue, packedValue, 0, docID, this.lastDocID));
            System.arraycopy(packedValue, 0, this.leafValues, this.leafCount * SimpleTextBKDWriter.this.packedBytesLength, SimpleTextBKDWriter.this.packedBytesLength);
            this.leafDocs[this.leafCount] = docID;
            SimpleTextBKDWriter.this.docsSeen.set(docID);
            ++this.leafCount;
            if (this.valueCount > SimpleTextBKDWriter.this.totalPointCount) {
                throw new IllegalStateException("totalPointCount=" + SimpleTextBKDWriter.this.totalPointCount + " was passed when we were created, but we just hit " + SimpleTextBKDWriter.this.pointCount + " values");
            }
            if (this.leafCount == SimpleTextBKDWriter.this.maxPointsInLeafNode) {
                this.writeLeafBlock();
                this.leafCount = 0;
            }
            assert ((this.lastDocID = docID) >= 0);
        }

        public long finish() throws IOException {
            if (this.leafCount > 0) {
                this.writeLeafBlock();
                this.leafCount = 0;
            }
            if (this.valueCount == 0L) {
                return -1L;
            }
            SimpleTextBKDWriter.this.pointCount = this.valueCount;
            long indexFP = this.out.getFilePointer();
            int numInnerNodes = this.leafBlockStartValues.size();
            byte[] index = new byte[(1 + numInnerNodes) * (1 + SimpleTextBKDWriter.this.bytesPerDim)];
            SimpleTextBKDWriter.this.rotateToTree(1, 0, numInnerNodes, index, this.leafBlockStartValues);
            long[] arr = new long[this.leafBlockFPs.size()];
            for (int i = 0; i < this.leafBlockFPs.size(); ++i) {
                arr[i] = this.leafBlockFPs.get(i);
            }
            SimpleTextBKDWriter.this.writeIndex(this.out, arr, index);
            return indexFP;
        }

        private void writeLeafBlock() throws IOException {
            assert (this.leafCount != 0);
            if (this.valueCount == 0L) {
                System.arraycopy(this.leafValues, 0, SimpleTextBKDWriter.this.minPackedValue, 0, SimpleTextBKDWriter.this.packedIndexBytesLength);
            }
            System.arraycopy(this.leafValues, (this.leafCount - 1) * SimpleTextBKDWriter.this.packedBytesLength, SimpleTextBKDWriter.this.maxPackedValue, 0, SimpleTextBKDWriter.this.packedIndexBytesLength);
            this.valueCount += (long)this.leafCount;
            if (this.leafBlockFPs.size() > 0) {
                this.leafBlockStartValues.add(ArrayUtil.copyOfSubArray((byte[])this.leafValues, (int)0, (int)SimpleTextBKDWriter.this.packedBytesLength));
            }
            this.leafBlockFPs.add(this.out.getFilePointer());
            SimpleTextBKDWriter.this.checkMaxLeafNodeCount(this.leafBlockFPs.size());
            Arrays.fill(SimpleTextBKDWriter.this.commonPrefixLengths, SimpleTextBKDWriter.this.bytesPerDim);
            block0: for (int dim = 0; dim < SimpleTextBKDWriter.this.numDataDims; ++dim) {
                int offset1 = dim * SimpleTextBKDWriter.this.bytesPerDim;
                int offset2 = (this.leafCount - 1) * SimpleTextBKDWriter.this.packedBytesLength + offset1;
                for (int j = 0; j < SimpleTextBKDWriter.this.commonPrefixLengths[dim]; ++j) {
                    if (this.leafValues[offset1 + j] == this.leafValues[offset2 + j]) continue;
                    SimpleTextBKDWriter.this.commonPrefixLengths[dim] = j;
                    continue block0;
                }
            }
            SimpleTextBKDWriter.this.writeLeafBlockDocs(this.out, this.leafDocs, 0, this.leafCount);
            IntFunction<BytesRef> packedValues = new IntFunction<BytesRef>(){
                final BytesRef scratch = new BytesRef();
                {
                    this.scratch.length = SimpleTextBKDWriter.this.packedBytesLength;
                    this.scratch.bytes = OneDimensionBKDWriter.this.leafValues;
                }

                @Override
                public BytesRef apply(int i) {
                    this.scratch.offset = SimpleTextBKDWriter.this.packedBytesLength * i;
                    return this.scratch;
                }
            };
            assert (SimpleTextBKDWriter.this.valuesInOrderAndBounds(this.leafCount, 0, ArrayUtil.copyOfSubArray((byte[])this.leafValues, (int)0, (int)SimpleTextBKDWriter.this.packedBytesLength), ArrayUtil.copyOfSubArray((byte[])this.leafValues, (int)((this.leafCount - 1) * SimpleTextBKDWriter.this.packedBytesLength), (int)(this.leafCount * SimpleTextBKDWriter.this.packedBytesLength)), packedValues, this.leafDocs, 0));
            SimpleTextBKDWriter.this.writeLeafBlockPackedValues(this.out, SimpleTextBKDWriter.this.commonPrefixLengths, this.leafCount, 0, packedValues);
        }
    }
}

