/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.carrot2.util.StringUtils;
import org.slf4j.LoggerFactory;

public enum LanguageCode {
    ARABIC("ar"),
    BULGARIAN("bg"),
    CZECH("cs"),
    CHINESE_SIMPLIFIED("zh_cn"),
    CROATIAN("hr"),
    DANISH("da"),
    DUTCH("nl"),
    ENGLISH("en"),
    ESTONIAN("et"),
    FINNISH("fi"),
    FRENCH("fr"),
    GERMAN("de"),
    GREEK("el"),
    HUNGARIAN("hu"),
    HINDI("hi"),
    ITALIAN("it"),
    IRISH("ga"),
    JAPANESE("ja"),
    KOREAN("ko"),
    LATVIAN("lv"),
    LITHUANIAN("lt"),
    MALTESE("mt"),
    NORWEGIAN("no"),
    POLISH("pl"),
    PORTUGUESE("pt"),
    ROMANIAN("ro"),
    RUSSIAN("ru"),
    SLOVAK("sk"),
    SLOVENE("sl"),
    SPANISH("es"),
    SWEDISH("sv"),
    THAI("th"),
    TURKISH("tr");

    private final String isoCode;
    private final Locale locale;
    private static final Map<String, AtomicBoolean> wrongCodes;
    private static final Map<String, LanguageCode> isoToLangCode;
    private static final Set<LanguageCode> noSpaceLanguages;

    private LanguageCode(String isoCode) {
        this.isoCode = isoCode;
        this.locale = new Locale(isoCode);
    }

    public String getIsoCode() {
        return this.isoCode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static LanguageCode forISOCode(String language) {
        if (wrongCodes.containsKey(language = language.toLowerCase()) && !wrongCodes.get(language).getAndSet(true)) {
            LoggerFactory.getLogger(LanguageCode.class).warn("This language code was incorrect in C2 (see issue CARROT-1129), correct it to a proper ISO639-1: " + language);
        }
        return isoToLangCode.get(language);
    }

    public boolean usesSpaceDelimiters() {
        return !noSpaceLanguages.contains((Object)this);
    }

    public String toString() {
        return StringUtils.identifierToHumanReadable(this.name());
    }

    static {
        isoToLangCode = new HashMap<String, LanguageCode>();
        for (LanguageCode langCode : LanguageCode.values()) {
            isoToLangCode.put(langCode.getIsoCode(), langCode);
        }
        wrongCodes = new HashMap<String, AtomicBoolean>();
        wrongCodes.put("gr", new AtomicBoolean());
        wrongCodes.put("cz", new AtomicBoolean());
        wrongCodes.put("ee", new AtomicBoolean());
        wrongCodes.put("ie", new AtomicBoolean());
        isoToLangCode.put("gr", GREEK);
        isoToLangCode.put("cz", CZECH);
        isoToLangCode.put("ee", ESTONIAN);
        isoToLangCode.put("ie", IRISH);
        noSpaceLanguages = EnumSet.of(CHINESE_SIMPLIFIED, JAPANESE);
    }
}

