#-----------------------------------------------------------------------------
# Copyright (c) 2012 - 2019, Anaconda, Inc., and Bokeh Contributors.
# All rights reserved.
#
# The full license is in the file LICENSE.txt, distributed with this software.
#-----------------------------------------------------------------------------
###############################################################################
#                                                                             #
#                                                                             #
#                                                                             #
#                       *******************************                       #
#                       ****** !!! IMPORTANT !!! ******                       #
#                       *******************************                       #
#                                                                             #
#                                                                             #
#                                                                             #
#     ANY update to this file MUST be accompanied by the "PROTOCOL" tag.      #
#                                                                             #
#                                                                             #
#                                                                             #
#                                                                             #
###############################################################################

#-----------------------------------------------------------------------------
# Boilerplate
#-----------------------------------------------------------------------------
from __future__ import absolute_import, division, print_function, unicode_literals

import pytest ; pytest

#-----------------------------------------------------------------------------
# Imports
#-----------------------------------------------------------------------------

# Standard library imports

# External imports

# Bokeh imports

# Module under test
import bokeh.protocol.versions as versions

#-----------------------------------------------------------------------------
# Setup
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# General API
#-----------------------------------------------------------------------------

def test_available_versions():
    assert set(versions.spec.keys()) == {'1.0'}

def test_version_1_0():
    assert versions.spec['1.0'] == (
        ("ACK", 1),
        ("OK", 1),
        ("ERROR", 1),
        ("EVENT", 1),
        ('SERVER-INFO-REPLY', 1),
        ('SERVER-INFO-REQ', 1),
        ('PULL-DOC-REQ', 1),
        ('PULL-DOC-REPLY', 1),
        ('PUSH-DOC', 1),
        ('PATCH-DOC', 1)
    )

#-----------------------------------------------------------------------------
# Dev API
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# Private API
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# Code
#-----------------------------------------------------------------------------
