/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.ColourAdapter;
import jalview.ColourProperties;
import jalview.DrawableAlignment;
import jalview.Popup;
import jalview.ResidueColourScheme;
import jalview.Sequence;
import jalview.SequenceGroup;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.io.PrintStream;
import java.util.Vector;

public class GroupPopup
extends Popup {
    PrintStream o = System.out;
    List groupList;
    Label groupLabel;
    List memberList;
    Label memberLabel;
    List ungroupedList;
    Label ungroupedLabel;
    Button add;
    Button del;
    Button addAll;
    Button delAll;
    Label groupProperties;
    Choice colourScheme;
    Label colourSchemeLabel;
    Checkbox boxes;
    Checkbox text;
    Checkbox colourText;
    Checkbox display;
    Button addGroup;
    Button delGroup;
    Button addSelected;
    DrawableAlignment da;

    public GroupPopup(Frame frame, String string, DrawableAlignment drawableAlignment) {
        super(frame, string);
        this.da = drawableAlignment;
        this.groupList = new List(9, false);
        this.groupLabel = new Label("Groups");
        this.memberList = new List(9, false);
        this.memberList.setMultipleSelections(true);
        this.memberLabel = new Label("Group members");
        this.ungroupedList = new List(9, false);
        this.ungroupedList.setMultipleSelections(true);
        this.ungroupedLabel = new Label("Ungrouped sequences");
        this.add = new Button("<- Add");
        this.del = new Button("Delete ->");
        this.addAll = new Button("<- Add all");
        this.delAll = new Button("Delete all ->");
        this.groupProperties = new Label("Group properties");
        this.colourScheme = new Choice();
        int n = 0;
        while (n < ColourProperties.colourSchemes.size()) {
            this.colourScheme.addItem((String)ColourProperties.colourSchemes.elementAt(n));
            ++n;
        }
        this.colourSchemeLabel = new Label("Colour scheme");
        this.boxes = new Checkbox("Display boxes");
        this.boxes.setState(true);
        this.text = new Checkbox("Display text");
        this.text.setState(true);
        this.colourText = new Checkbox("Colour text");
        this.colourText.setState(false);
        this.display = new Checkbox("Display group");
        this.display.setState(true);
        this.addGroup = new Button("Add new group");
        this.delGroup = new Button("Delete selected group");
        this.addSelected = new Button("Add selected IDs");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 4, 10, 5));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(4, 1, 5, 5));
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(6, 1, 5, 5));
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(3, 1, 5, 5));
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(2, 2, 2, 2);
        panel.add(this.groupList);
        panel.add(this.memberList);
        panel2.add(this.add);
        panel2.add(this.del);
        panel2.add(this.addAll);
        panel2.add(this.delAll);
        panel.add(panel2);
        panel.add(this.ungroupedList);
        panel3.add(this.groupProperties);
        panel3.add(this.colourScheme);
        panel3.add(this.boxes);
        panel3.add(this.text);
        panel3.add(this.colourText);
        panel4.add(this.addGroup);
        panel4.add(this.delGroup);
        panel4.add(this.addSelected);
        this.add(panel, this.gb, this.gbc, 0, 0, 2, 3);
        this.add(panel3, this.gb, this.gbc, 0, 3, 1, 1);
        this.add(panel4, this.gb, this.gbc, 1, 3, 1, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 4, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 4, 1, 1);
        this.pack();
        this.show();
        this.listGroups();
        this.showUngrouped();
    }

    public void listGroups() {
        if (this.groupList.countItems() > 0) {
            this.groupList.clear();
        }
        Vector vector = this.da.groups;
        int n = 0;
        while (n < vector.size()) {
            SequenceGroup sequenceGroup = (SequenceGroup)vector.elementAt(n);
            this.groupList.addItem(String.valueOf(n) + " (" + sequenceGroup.sequences.size() + " sequences)");
            ++n;
        }
    }

    public void showUngrouped() {
        if (this.ungroupedList.countItems() > 0) {
            this.ungroupedList.clear();
        }
        int n = 0;
        while (n < this.da.size) {
            Sequence sequence = this.da.sequences[n];
            if (this.da.findGroup(sequence) == null) {
                this.ungroupedList.addItem(sequence.name);
            }
            ++n;
        }
    }

    public void showGroup(SequenceGroup sequenceGroup) {
        if (this.memberList.countItems() > 0) {
            this.memberList.clear();
        }
        int n = 0;
        while (n < sequenceGroup.sequences.size()) {
            Sequence sequence = (Sequence)sequenceGroup.sequences.elementAt(n);
            this.memberList.addItem(sequence.name);
            ++n;
        }
        this.displayProperties(sequenceGroup);
    }

    public void setProperties(SequenceGroup sequenceGroup) {
        int n = this.colourScheme.getSelectedIndex();
        sequenceGroup.colourScheme = ColourAdapter.get(n);
        if (sequenceGroup.colourScheme instanceof ResidueColourScheme) {
            System.out.println("setting consensus to " + this.da.cons);
            ((ResidueColourScheme)sequenceGroup.colourScheme).cons = this.da.cons;
        }
        this.da.setColourScheme(sequenceGroup);
        sequenceGroup.displayBoxes = this.boxes.getState();
        sequenceGroup.displayText = this.text.getState();
        sequenceGroup.colourText = this.colourText.getState();
        this.da.displayBoxes(sequenceGroup);
        this.da.displayText(sequenceGroup);
        this.da.colourText(sequenceGroup);
    }

    public void displayProperties(SequenceGroup sequenceGroup) {
        int n = ColourAdapter.get(sequenceGroup.colourScheme);
        String string = (String)ColourProperties.colourSchemes.elementAt(n);
        this.colourScheme.select(string);
        this.boxes.setState(sequenceGroup.displayBoxes);
        this.text.setState(sequenceGroup.displayText);
        this.colourText.setState(sequenceGroup.colourText);
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.groupList && event.id == 701) {
            System.out.println(event);
            Vector vector = this.da.groups;
            if (this.groupList.getSelectedIndex() >= 0) {
                this.showGroup((SequenceGroup)vector.elementAt(this.groupList.getSelectedIndex()));
            }
            return true;
        }
        if (event.target == this.addGroup && event.id == 1001) {
            SequenceGroup sequenceGroup = this.da.addGroup();
            this.setProperties(sequenceGroup);
            this.da.setColourScheme(sequenceGroup);
            this.listGroups();
            this.groupList.select(this.da.groups.size() - 1);
            if (this.memberList.countItems() > 0) {
                this.memberList.clear();
            }
            return true;
        }
        if (event.target == this.delGroup && event.id == 1001) {
            this.delGroup.requestFocus();
            int n = this.groupList.getSelectedIndex();
            if (n >= 0) {
                this.da.deleteGroup((SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex()));
                this.listGroups();
                if (this.memberList.countItems() > 0) {
                    this.memberList.clear();
                }
                this.showUngrouped();
            }
            return true;
        }
        if (event.target == this.add && event.id == 1001) {
            this.add.requestFocus();
            int n = this.groupList.getSelectedIndex();
            if (n >= 0) {
                SequenceGroup sequenceGroup = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                String[] stringArray = this.ungroupedList.getSelectedItems();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    this.da.addToGroup(sequenceGroup, this.da.findName(stringArray[n2]));
                    ++n2;
                }
                this.listGroups();
                this.groupList.select(n);
                this.showGroup(sequenceGroup);
                this.showUngrouped();
            }
            return true;
        }
        if (event.target == this.addAll && event.id == 1001) {
            this.addAll.requestFocus();
            int n = this.groupList.getSelectedIndex();
            if (n >= 0) {
                SequenceGroup sequenceGroup = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                int n3 = 0;
                while (n3 < this.ungroupedList.countItems()) {
                    this.da.addToGroup(sequenceGroup, this.da.findName(this.ungroupedList.getItem(n3)));
                    ++n3;
                }
                this.listGroups();
                this.groupList.select(n);
                this.showGroup(sequenceGroup);
                this.showUngrouped();
            }
            return true;
        }
        if (event.target == this.delAll && event.id == 1001) {
            this.delAll.requestFocus();
            int n = this.groupList.getSelectedIndex();
            if (n >= 0) {
                SequenceGroup sequenceGroup = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                int n4 = 0;
                while (n4 < this.memberList.countItems()) {
                    this.da.removeFromGroup(sequenceGroup, this.da.findName(this.memberList.getItem(n4)));
                    ++n4;
                }
                this.listGroups();
                this.groupList.select(n);
                this.showGroup(sequenceGroup);
                this.showUngrouped();
            }
            return true;
        }
        if (event.target == this.del && event.id == 1001) {
            this.del.requestFocus();
            int n = this.groupList.getSelectedIndex();
            if (n >= 0) {
                SequenceGroup sequenceGroup = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                if (this.memberList.getSelectedItems() != null) {
                    String[] stringArray = this.memberList.getSelectedItems();
                    int n5 = 0;
                    while (n5 < stringArray.length) {
                        this.da.removeFromGroup(sequenceGroup, this.da.findName(stringArray[n5]));
                        ++n5;
                    }
                }
                this.listGroups();
                this.groupList.select(n);
                this.showGroup(sequenceGroup);
                this.showUngrouped();
            }
            return true;
        }
        if (event.target == this.addSelected && event.id == 1001) {
            int n;
            this.addSelected.requestFocus();
            if (this.parent instanceof AlignFrame && (n = this.groupList.getSelectedIndex()) >= 0) {
                SequenceGroup sequenceGroup = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                Vector vector = ((AlignFrame)this.parent).ap.sel;
                int n6 = 0;
                while (n6 < vector.size()) {
                    SequenceGroup sequenceGroup2 = this.da.findGroup((Sequence)vector.elementAt(n6));
                    this.da.removeFromGroup(sequenceGroup2, (Sequence)vector.elementAt(n6));
                    if (sequenceGroup2.sequences.size() == 0) {
                        this.da.groups.removeElement(sequenceGroup2);
                    }
                    this.da.addToGroup(sequenceGroup, (Sequence)vector.elementAt(n6));
                    ++n6;
                }
                this.listGroups();
                this.groupList.select(n);
                this.showGroup(sequenceGroup);
                this.showUngrouped();
            }
            return true;
        }
        if (event.target == this.boxes) {
            int n = this.groupList.getSelectedIndex();
            if (n >= 0) {
                SequenceGroup sequenceGroup = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                sequenceGroup.displayBoxes = this.boxes.getState();
                this.da.displayBoxes(sequenceGroup);
            }
            return true;
        }
        if (event.target == this.text) {
            int n = this.groupList.getSelectedIndex();
            if (n >= 0) {
                SequenceGroup sequenceGroup = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                sequenceGroup.displayText = this.text.getState();
                this.da.displayText(sequenceGroup);
            }
            return true;
        }
        if (event.target == this.colourText) {
            int n = this.groupList.getSelectedIndex();
            if (n >= 0) {
                SequenceGroup sequenceGroup = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                sequenceGroup.colourText = this.colourText.getState();
                this.da.colourText(sequenceGroup);
            }
            return true;
        }
        if (event.target == this.colourScheme) {
            int n = this.groupList.getSelectedIndex();
            if (n >= 0) {
                SequenceGroup sequenceGroup = (SequenceGroup)this.da.groups.elementAt(this.groupList.getSelectedIndex());
                int n7 = this.colourScheme.getSelectedIndex();
                sequenceGroup.colourScheme = ColourAdapter.get(n7);
                if (sequenceGroup.colourScheme instanceof ResidueColourScheme) {
                    System.out.println("setting consensus to " + this.da.cons);
                    ((ResidueColourScheme)sequenceGroup.colourScheme).cons = this.da.cons;
                }
                this.da.setColourScheme(sequenceGroup);
            }
            return true;
        }
        if (event.target == this.apply && event.id == 1001) {
            this.applyCommand();
        } else {
            super.handleEvent(event);
        }
        return super.handleEvent(event);
    }

    public void applyCommand() {
        if (this.parent instanceof AlignFrame) {
            AlignFrame cfr_ignored_0 = (AlignFrame)this.parent;
            ((AlignFrame)this.parent).updateFont();
        }
    }
}

