/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssTime;

public class CssUnitsCSS2 {
    private static final String[] relative_length_units = new String[]{"em", "ex", "px"};
    private static final String[] absolute_length_units = new String[]{"in", "cm", "mm", "pt", "pc"};
    private static final String[] angle_units = new String[]{"deg", "grad", "rad"};
    private static final BigDecimal[] angle_mult = new BigDecimal[angle_units.length];
    private static final String[] time_units;
    private static BigDecimal[] time_mult;
    private static final String[] frequency_units;
    private static BigDecimal[] frequency_mult;

    protected static String getRelativeLengthUnit(String unit) {
        for (String s : relative_length_units) {
            if (!s.equals(unit)) continue;
            return s;
        }
        return null;
    }

    protected static String getAbsoluteLengthUnit(String unit) {
        for (String s : absolute_length_units) {
            if (!s.equals(unit)) continue;
            return s;
        }
        return null;
    }

    protected static void parseLengthUnit(String unit, CssLength length, ApplContext ac) throws InvalidParamException {
        String matchedUnit = CssUnitsCSS2.getRelativeLengthUnit(unit);
        if (matchedUnit != null) {
            length.absolute = false;
        } else {
            matchedUnit = CssUnitsCSS2.getAbsoluteLengthUnit(unit);
            if (matchedUnit == null) {
                throw new InvalidParamException("unit", unit, ac);
            }
            length.absolute = true;
        }
        length.unit = matchedUnit;
    }

    protected static void parseAngleUnit(String unit, CssAngle angle, ApplContext ac) throws InvalidParamException {
        String matchedUnit = null;
        for (int i = 0; i < angle_units.length; ++i) {
            if (!angle_units[i].equals(unit)) continue;
            matchedUnit = angle_units[i];
            angle.factor = angle_mult[i];
            break;
        }
        if (matchedUnit == null) {
            throw new InvalidParamException("unit", unit, ac);
        }
        angle.unit = matchedUnit;
    }

    protected static void parseFrequencyUnit(String unit, CssFrequency frequency, ApplContext ac) throws InvalidParamException {
        String matchedUnit = null;
        for (int i = 0; i < frequency_units.length; ++i) {
            if (!frequency_units[i].equals(unit)) continue;
            matchedUnit = frequency_units[i];
            frequency.factor = frequency_mult[i];
            break;
        }
        if (matchedUnit == null) {
            throw new InvalidParamException("unit", unit, ac);
        }
        frequency.unit = matchedUnit;
    }

    protected static void parseTimeUnit(String unit, CssTime time, ApplContext ac) throws InvalidParamException {
        String matchedUnit = null;
        for (int i = 0; i < time_units.length; ++i) {
            if (!time_units[i].equals(unit)) continue;
            matchedUnit = time_units[i];
            time.factor = time_mult[i];
            break;
        }
        if (matchedUnit == null) {
            throw new InvalidParamException("unit", unit, ac);
        }
        time.unit = matchedUnit;
    }

    static {
        CssUnitsCSS2.angle_mult[0] = BigDecimal.ONE;
        CssUnitsCSS2.angle_mult[1] = BigDecimal.valueOf(0.9);
        CssUnitsCSS2.angle_mult[2] = BigDecimal.valueOf(57.29577951308232);
        time_units = new String[]{"ms", "s"};
        time_mult = new BigDecimal[time_units.length];
        CssUnitsCSS2.time_mult[0] = BigDecimal.valueOf(0.001);
        CssUnitsCSS2.time_mult[1] = BigDecimal.ONE;
        frequency_units = new String[]{"khz", "hz"};
        frequency_mult = new BigDecimal[frequency_units.length];
        CssUnitsCSS2.frequency_mult[0] = BigDecimal.valueOf(1000L);
        CssUnitsCSS2.frequency_mult[1] = BigDecimal.ONE;
    }
}

