/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class SuntechProtocolDecoder
extends BaseProtocolDecoder {
    private String prefix;
    private int protocolType;
    private boolean hbm;
    private boolean includeAdc;
    private boolean includeRpm;
    private boolean includeTemp;

    public SuntechProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setProtocolType(int protocolType) {
        this.protocolType = protocolType;
    }

    public int getProtocolType(long deviceId) {
        return Context.getIdentityManager().lookupAttributeInteger(deviceId, this.getProtocolName() + ".protocolType", this.protocolType, false, true);
    }

    public void setHbm(boolean hbm) {
        this.hbm = hbm;
    }

    public boolean isHbm(long deviceId) {
        return Context.getIdentityManager().lookupAttributeBoolean(deviceId, this.getProtocolName() + ".hbm", this.hbm, false, true);
    }

    public void setIncludeAdc(boolean includeAdc) {
        this.includeAdc = includeAdc;
    }

    public boolean isIncludeAdc(long deviceId) {
        return Context.getIdentityManager().lookupAttributeBoolean(deviceId, this.getProtocolName() + ".includeAdc", this.includeAdc, false, true);
    }

    public void setIncludeRpm(boolean includeRpm) {
        this.includeRpm = includeRpm;
    }

    public boolean isIncludeRpm(long deviceId) {
        return Context.getIdentityManager().lookupAttributeBoolean(deviceId, this.getProtocolName() + ".includeRpm", this.includeRpm, false, true);
    }

    public void setIncludeTemp(boolean includeTemp) {
        this.includeTemp = includeTemp;
    }

    public boolean isIncludeTemp(long deviceId) {
        return Context.getIdentityManager().lookupAttributeBoolean(deviceId, this.getProtocolName() + ".includeTemp", this.includeTemp, false, true);
    }

    private Position decode9(Channel channel, SocketAddress remoteAddress, String[] values) throws ParseException {
        DeviceSession deviceSession;
        String type;
        int index = 1;
        if (!((type = values[index++]).equals("Location") || type.equals("Emergency") || type.equals("Alert"))) {
            return null;
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, values[index++])) == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (type.equals("Emergency") || type.equals("Alert")) {
            position.set("alarm", "general");
        }
        if (!type.equals("Alert") || this.getProtocolType(deviceSession.getDeviceId()) == 0) {
            position.set("versionFw", values[index++]);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        position.setTime(dateFormat.parse(values[index++] + values[index++]));
        if (this.getProtocolType(deviceSession.getDeviceId()) == 1) {
            // empty if block
        }
        int n = ++index;
        position.setLatitude(Double.parseDouble(values[n]));
        int n2 = ++index;
        position.setLongitude(Double.parseDouble(values[n2]));
        int n3 = ++index;
        position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[n3])));
        int n4 = ++index;
        position.setCourse(Double.parseDouble(values[n4]));
        int n5 = ++index;
        ++index;
        position.setValid(values[n5].equals("1"));
        if (this.getProtocolType(deviceSession.getDeviceId()) == 1) {
            position.set("odometer", Integer.parseInt(values[index++]));
        }
        return position;
    }

    private String decodeEmergency(int value) {
        switch (value) {
            case 1: {
                return "sos";
            }
            case 2: {
                return "parking";
            }
            case 3: {
                return "powerCut";
            }
            case 5: 
            case 6: {
                return "door";
            }
            case 7: {
                return "movement";
            }
            case 8: {
                return "shock";
            }
        }
        return null;
    }

    private String decodeAlert(int value) {
        switch (value) {
            case 1: {
                return "overspeed";
            }
            case 5: {
                return "geofenceExit";
            }
            case 6: {
                return "geofenceEnter";
            }
            case 14: {
                return "lowBattery";
            }
            case 15: {
                return "shock";
            }
            case 16: {
                return "accident";
            }
            case 46: {
                return "hardAcceleration";
            }
            case 47: {
                return "hardBraking";
            }
            case 48: {
                return "accident";
            }
            case 50: {
                return "jamming";
            }
        }
        return null;
    }

    private Position decode4(Channel channel, SocketAddress remoteAddress, String[] values) throws ParseException {
        DeviceSession deviceSession;
        String type;
        int index = 0;
        if (!(type = values[index++].substring(5)).equals("STT") && !type.equals("ALT")) {
            return null;
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, values[index++])) == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("type", type);
        position.set("versionFw", values[index++]);
        ++index;
        Network network = new Network();
        for (int i = 0; i < 7; ++i) {
            int lac;
            int rssi;
            int cid = Integer.parseInt(values[index++]);
            int mcc = Integer.parseInt(values[index++]);
            int mnc = Integer.parseInt(values[index++]);
            if (i == 0) {
                rssi = Integer.parseInt(values[index++]);
                lac = Integer.parseInt(values[index++]);
            } else {
                lac = Integer.parseInt(values[index++]);
                rssi = Integer.parseInt(values[index++]);
            }
            ++index;
            if (cid <= 0) continue;
            network.addCellTower(CellTower.from(mcc, mnc, lac, cid, rssi));
        }
        position.setNetwork(network);
        position.set("battery", Double.parseDouble(values[index++]));
        position.set("archive", values[index++].equals("0") ? Boolean.valueOf(true) : null);
        position.set("index", Integer.parseInt(values[index++]));
        position.set("status", Integer.parseInt(values[index++]));
        if (values[index].length() == 3) {
            // empty if block
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        int n = ++index;
        int n2 = ++index;
        position.setTime(dateFormat.parse(values[n] + values[n2]));
        int n3 = ++index;
        position.setLatitude(Double.parseDouble(values[n3]));
        int n4 = ++index;
        position.setLongitude(Double.parseDouble(values[n4]));
        int n5 = ++index;
        position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[n5])));
        int n6 = ++index;
        position.setCourse(Double.parseDouble(values[n6]));
        int n7 = ++index;
        position.set("sat", Integer.parseInt(values[n7]));
        int n8 = ++index;
        ++index;
        position.setValid(values[n8].equals("1"));
        return position;
    }

    private Position decode2356(Channel channel, SocketAddress remoteAddress, String protocol, String[] values) throws ParseException {
        DeviceSession deviceSession;
        String type;
        int index = 0;
        if (!((type = values[index++].substring(5)).equals("STT") || type.equals("EMG") || type.equals("EVT") || type.equals("ALT") || type.equals("UEX"))) {
            return null;
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, values[index++])) == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("type", type);
        if (protocol.startsWith("ST3") || protocol.equals("ST500") || protocol.equals("ST600")) {
            // empty if block
        }
        int n = ++index;
        position.set("versionFw", values[n]);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        int n2 = ++index;
        int n3 = ++index;
        ++index;
        position.setTime(dateFormat.parse(values[n2] + values[n3]));
        if (!protocol.equals("ST500")) {
            long cid = Long.parseLong(values[index++], 16);
            if (protocol.equals("ST600")) {
                position.setNetwork(new Network(CellTower.from(Integer.parseInt(values[index++]), Integer.parseInt(values[index++]), Integer.parseInt(values[index++], 16), cid, Integer.parseInt(values[index++]))));
            }
        }
        position.setLatitude(Double.parseDouble(values[index++]));
        position.setLongitude(Double.parseDouble(values[index++]));
        position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[index++])));
        position.setCourse(Double.parseDouble(values[index++]));
        position.set("sat", Integer.parseInt(values[index++]));
        position.setValid(values[index++].equals("1"));
        position.set("odometer", Integer.parseInt(values[index++]));
        position.set("power", Double.parseDouble(values[index++]));
        String io = values[index++];
        if (io.length() >= 6) {
            position.set("ignition", io.charAt(0) == '1');
            position.set("in1", io.charAt(1) == '1');
            position.set("in2", io.charAt(2) == '1');
            position.set("in3", io.charAt(3) == '1');
            position.set("out1", io.charAt(4) == '1');
            position.set("out2", io.charAt(5) == '1');
        }
        switch (type) {
            case "STT": {
                position.set("status", Integer.parseInt(values[index++]));
                position.set("index", Integer.parseInt(values[index++]));
                break;
            }
            case "EMG": {
                position.set("alarm", this.decodeEmergency(Integer.parseInt(values[index++])));
                break;
            }
            case "EVT": {
                position.set("event", Integer.parseInt(values[index++]));
                break;
            }
            case "ALT": {
                position.set("alarm", this.decodeAlert(Integer.parseInt(values[index++])));
                break;
            }
            case "UEX": {
                String attribute;
                block19: for (int remaining = Integer.parseInt(values[index++]); remaining > 0; remaining -= attribute.length() + 1) {
                    if ((attribute = values[index++]).startsWith("CabAVL")) {
                        double fuel2;
                        String[] data = attribute.split(",");
                        double fuel1 = Double.parseDouble(data[2]);
                        if (fuel1 > 0.0) {
                            position.set("fuel1", fuel1);
                        }
                        if (!((fuel2 = Double.parseDouble(data[3])) > 0.0)) continue;
                        position.set("fuel2", fuel2);
                        continue;
                    }
                    String[] pair = attribute.split("=");
                    if (pair.length < 2) continue;
                    String value = pair[1].trim();
                    if (value.contains(".")) {
                        value = value.substring(0, value.indexOf(46));
                    }
                    switch (pair[0].charAt(0)) {
                        case 't': {
                            position.set("temp" + pair[0].charAt(2), Integer.parseInt(value, 16));
                            continue block19;
                        }
                        case 'N': {
                            position.set("fuel" + pair[0].charAt(2), Integer.parseInt(value, 16));
                            continue block19;
                        }
                        case 'Q': {
                            position.set("drivingQuality", Integer.parseInt(value, 16));
                            continue block19;
                        }
                    }
                }
                ++index;
                break;
            }
        }
        if (this.isHbm(deviceSession.getDeviceId())) {
            if (index < values.length) {
                position.set("hours", UnitsConverter.msFromMinutes(Integer.parseInt(values[index++])));
            }
            if (index < values.length) {
                position.set("battery", Double.parseDouble(values[index++]));
            }
            if (index < values.length && values[index++].equals("0")) {
                position.set("archive", true);
            }
            if (this.isIncludeAdc(deviceSession.getDeviceId())) {
                for (int i = 1; i <= 3; ++i) {
                    if (values[index++].isEmpty()) continue;
                    position.set("adc" + i, Double.parseDouble(values[index - 1]));
                }
            }
            if (this.isIncludeRpm(deviceSession.getDeviceId()) && index < values.length) {
                position.set("rpm", Integer.parseInt(values[index++]));
            }
            if (values.length - index >= 2) {
                String driverUniqueId = values[index++];
                if (values[index++].equals("1") && !driverUniqueId.isEmpty()) {
                    position.set("driverUniqueId", driverUniqueId);
                }
            }
            if (this.isIncludeTemp(deviceSession.getDeviceId())) {
                for (int i = 1; i <= 3; ++i) {
                    String temperature;
                    String value;
                    if ((value = (temperature = values[index++]).substring(temperature.indexOf(58) + 1)).isEmpty()) continue;
                    position.set("temp" + i, Double.parseDouble(value));
                }
            }
        }
        return position;
    }

    private Position decodeUniversal(Channel channel, SocketAddress remoteAddress, String[] values) throws ParseException {
        DeviceSession deviceSession;
        String type;
        int index = 0;
        if (!(type = values[index++]).equals("STT") && !type.equals("ALT")) {
            return null;
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, values[index++])) == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("type", type);
        int mask = Integer.parseInt(values[index++], 16);
        if (BitUtil.check(mask, 1)) {
            ++index;
        }
        if (BitUtil.check(mask, 2)) {
            position.set("versionFw", values[index++]);
        }
        if (BitUtil.check(mask, 3) && values[index++].equals("0")) {
            position.set("archive", true);
        }
        if (BitUtil.check(mask, 4) && BitUtil.check(mask, 5)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            position.setTime(dateFormat.parse(values[index++] + values[index++]));
        }
        if (BitUtil.check(mask, 6)) {
            ++index;
        }
        if (BitUtil.check(mask, 7)) {
            ++index;
        }
        if (BitUtil.check(mask, 8)) {
            ++index;
        }
        if (BitUtil.check(mask, 9)) {
            ++index;
        }
        if (BitUtil.check(mask, 10)) {
            position.set("rssi", Integer.parseInt(values[index++]));
        }
        if (BitUtil.check(mask, 11)) {
            position.setLatitude(Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 12)) {
            position.setLongitude(Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 13)) {
            position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[index++])));
        }
        if (BitUtil.check(mask, 14)) {
            position.setCourse(Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(mask, 15)) {
            position.set("sat", Integer.parseInt(values[index++]));
        }
        if (BitUtil.check(mask, 16)) {
            position.setValid(values[index++].equals("1"));
        }
        return position;
    }

    private Position decodeBinary(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        long value;
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, ByteBufUtil.hexDump((ByteBuf)buf.readSlice(5)));
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        int mask = buf.readUnsignedMedium();
        if (BitUtil.check(mask, 1)) {
            buf.readUnsignedByte();
        }
        if (BitUtil.check(mask, 2)) {
            position.set("versionFw", String.format("%d.%d.%d", buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()));
        }
        if (BitUtil.check(mask, 3) && buf.readUnsignedByte() == 0) {
            position.set("archive", true);
        }
        if (BitUtil.check(mask, 4) && BitUtil.check(mask, 5)) {
            position.setTime(new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).getDate());
        }
        if (BitUtil.check(mask, 6)) {
            buf.readUnsignedInt();
        }
        if (BitUtil.check(mask, 7)) {
            buf.readUnsignedShort();
        }
        if (BitUtil.check(mask, 8)) {
            buf.readUnsignedShort();
        }
        if (BitUtil.check(mask, 9)) {
            buf.readUnsignedShort();
        }
        if (BitUtil.check(mask, 10)) {
            position.set("rssi", buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 11)) {
            value = buf.readUnsignedInt();
            if (BitUtil.check(value, 31)) {
                value = -BitUtil.to(value, 31);
            }
            position.setLatitude((double)value / 1000000.0);
        }
        if (BitUtil.check(mask, 12)) {
            value = buf.readUnsignedInt();
            if (BitUtil.check(value, 31)) {
                value = -BitUtil.to(value, 31);
            }
            position.setLongitude((double)value / 1000000.0);
        }
        if (BitUtil.check(mask, 13)) {
            position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShort() / 100.0));
        }
        if (BitUtil.check(mask, 14)) {
            position.setCourse((double)buf.readUnsignedShort() / 100.0);
        }
        if (BitUtil.check(mask, 15)) {
            position.set("sat", buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 16)) {
            position.setValid(buf.readUnsignedByte() > 0);
        }
        if (BitUtil.check(mask, 17)) {
            short input = buf.readUnsignedByte();
            position.set("ignition", BitUtil.check(input, 0));
            position.set("input", Integer.valueOf(input));
        }
        if (BitUtil.check(mask, 18)) {
            position.set("output", buf.readUnsignedByte());
        }
        short alertId = 0;
        if (BitUtil.check(mask, 19)) {
            alertId = buf.readUnsignedByte();
            if (type == 130) {
                position.set("alarm", this.decodeAlert(alertId));
            }
        }
        if (BitUtil.check(mask, 20)) {
            buf.readUnsignedShort();
        }
        if (BitUtil.check(mask, 21) && alertId == 59) {
            position.set("driverUniqueId", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)));
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getByte(buf.readerIndex() + 1) == 0) {
            return this.decodeBinary(channel, remoteAddress, buf);
        }
        String[] values = buf.toString(StandardCharsets.US_ASCII).split(";");
        this.prefix = values[0];
        if (this.prefix.length() < 5) {
            return this.decodeUniversal(channel, remoteAddress, values);
        }
        if (this.prefix.startsWith("ST9")) {
            return this.decode9(channel, remoteAddress, values);
        }
        if (this.prefix.startsWith("ST4")) {
            return this.decode4(channel, remoteAddress, values);
        }
        return this.decode2356(channel, remoteAddress, this.prefix.substring(0, 5), values);
    }
}

