/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public class ExOleObjAtom
extends RecordAtom {
    private static final int[] DRAWASPECT_MASKS = new int[]{1, 2, 4, 8};
    private static final String[] DRAWASPECT_NAMES = new String[]{"CONTENT", "THUMBNAIL", "ICON", "DOCPRINT"};
    private static final int MAX_RECORD_LENGTH = 0xA00000;
    public static final int DRAW_ASPECT_VISIBLE = 1;
    public static final int DRAW_ASPECT_THUMBNAIL = 2;
    public static final int DRAW_ASPECT_ICON = 4;
    public static final int DRAW_ASPECT_DOCPRINT = 8;
    public static final int TYPE_EMBEDDED = 0;
    public static final int TYPE_LINKED = 1;
    public static final int TYPE_CONTROL = 2;
    public static final int SUBTYPE_DEFAULT = 0;
    public static final int SUBTYPE_CLIPART_GALLERY = 1;
    public static final int SUBTYPE_WORD_TABLE = 2;
    public static final int SUBTYPE_EXCEL = 3;
    public static final int SUBTYPE_GRAPH = 4;
    public static final int SUBTYPE_ORGANIZATION_CHART = 5;
    public static final int SUBTYPE_EQUATION = 6;
    public static final int SUBTYPE_WORDART = 7;
    public static final int SUBTYPE_SOUND = 8;
    public static final int SUBTYPE_IMAGE = 9;
    public static final int SUBTYPE_POWERPOINT_PRESENTATION = 10;
    public static final int SUBTYPE_POWERPOINT_SLIDE = 11;
    public static final int SUBTYPE_PROJECT = 12;
    public static final int SUBTYPE_NOTEIT = 13;
    public static final int SUBTYPE_EXCEL_CHART = 14;
    public static final int SUBTYPE_MEDIA_PLAYER = 15;
    private byte[] _header = new byte[8];
    private byte[] _data;

    public ExOleObjAtom() {
        this._data = new byte[24];
        LittleEndian.putShort((byte[])this._header, (int)0, (short)1);
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    protected ExOleObjAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = IOUtils.safelyAllocate((long)(len - 8), (int)0xA00000);
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
        if (this._data.length < 24) {
            throw new IllegalArgumentException("The length of the data for a ExOleObjAtom must be at least 24 bytes, but was only " + this._data.length);
        }
    }

    public int getDrawAspect() {
        return LittleEndian.getInt((byte[])this._data, (int)0);
    }

    public void setDrawAspect(int aspect) {
        LittleEndian.putInt((byte[])this._data, (int)0, (int)aspect);
    }

    public int getType() {
        return LittleEndian.getInt((byte[])this._data, (int)4);
    }

    public void setType(int type) {
        LittleEndian.putInt((byte[])this._data, (int)4, (int)type);
    }

    public int getObjID() {
        return LittleEndian.getInt((byte[])this._data, (int)8);
    }

    public void setObjID(int id) {
        LittleEndian.putInt((byte[])this._data, (int)8, (int)id);
    }

    public int getSubType() {
        return LittleEndian.getInt((byte[])this._data, (int)12);
    }

    public void setSubType(int type) {
        LittleEndian.putInt((byte[])this._data, (int)12, (int)type);
    }

    public int getObjStgDataRef() {
        return LittleEndian.getInt((byte[])this._data, (int)16);
    }

    public void setObjStgDataRef(int ref) {
        LittleEndian.putInt((byte[])this._data, (int)16, (int)ref);
    }

    public boolean getIsBlank() {
        return LittleEndian.getInt((byte[])this._data, (int)20) != 0;
    }

    public int getOptions() {
        return LittleEndian.getInt((byte[])this._data, (int)20);
    }

    public void setOptions(int opts) {
        LittleEndian.putInt((byte[])this._data, (int)20, (int)opts);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.ExOleObjAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ExOleObjAtom\n");
        buf.append("  drawAspect: " + this.getDrawAspect() + "\n");
        buf.append("  type: " + this.getType() + "\n");
        buf.append("  objID: " + this.getObjID() + "\n");
        buf.append("  subType: " + this.getSubType() + "\n");
        buf.append("  objStgDataRef: " + this.getObjStgDataRef() + "\n");
        buf.append("  options: " + this.getOptions() + "\n");
        return buf.toString();
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties((String)"drawAspect", (Supplier)GenericRecordUtil.getBitsAsString(this::getDrawAspect, (int[])DRAWASPECT_MASKS, (String[])DRAWASPECT_NAMES), (String)"type", (Supplier)GenericRecordUtil.safeEnum((Enum[])OleType.values(), this::getType), (String)"objID", this::getObjID, (String)"subType", (Supplier)GenericRecordUtil.safeEnum((Enum[])Subtype.values(), this::getSubType), (String)"objStgDataRef", this::getObjStgDataRef, (String)"options", this::getOptions);
    }

    public static enum Subtype {
        DEFAULT,
        CLIPART_GALLERY,
        WORD_TABLE,
        EXCEL,
        GRAPH,
        ORGANIZATION_CHART,
        EQUATION,
        WORDART,
        SOUND,
        IMAGE,
        POWERPOINT_PRESENTATION,
        POWERPOINT_SLIDE,
        PROJECT,
        NOTEIT,
        EXCEL_CHART,
        MEDIA_PLAYER;

    }

    public static enum OleType {
        EMBEDDED,
        LINKED,
        CONTROL;

    }
}

