/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;
import org.junit.Assert;

public abstract class CollationTestBase
extends LuceneTestCase {
    protected String firstRangeBeginningOriginal = "\u062f";
    protected String firstRangeEndOriginal = "\u0698";
    protected String secondRangeBeginningOriginal = "\u0633";
    protected String secondRangeEndOriginal = "\u0638";

    public void testFarsiRangeFilterCollating(Analyzer analyzer, BytesRef firstBeg, BytesRef firstEnd, BytesRef secondBeg, BytesRef secondEnd) throws Exception {
        BaseDirectoryWrapper dir = CollationTestBase.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)dir, new IndexWriterConfig(analyzer));
        Document doc = new Document();
        doc.add((IndexableField)new TextField("content", "\u0633\u0627\u0628", Field.Store.YES));
        doc.add((IndexableField)new StringField("body", "body", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        TermQuery query = new TermQuery(new Term("body", "body"));
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.add((Query)query, BooleanClause.Occur.MUST);
        bq.add((Query)new TermRangeQuery("content", firstBeg, firstEnd, true, true), BooleanClause.Occur.FILTER);
        ScoreDoc[] result = searcher.search((Query)bq.build(), (int)1).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should not be included.", (long)0L, (long)result.length);
        bq = new BooleanQuery.Builder();
        bq.add((Query)query, BooleanClause.Occur.MUST);
        bq.add((Query)new TermRangeQuery("content", secondBeg, secondEnd, true, true), BooleanClause.Occur.FILTER);
        result = searcher.search((Query)bq.build(), (int)1).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should be included.", (long)1L, (long)result.length);
        reader.close();
        dir.close();
    }

    public void testFarsiRangeQueryCollating(Analyzer analyzer, BytesRef firstBeg, BytesRef firstEnd, BytesRef secondBeg, BytesRef secondEnd) throws Exception {
        BaseDirectoryWrapper dir = CollationTestBase.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)dir, new IndexWriterConfig(analyzer));
        Document doc = new Document();
        doc.add((IndexableField)new TextField("content", "\u0633\u0627\u0628", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        TermRangeQuery query = new TermRangeQuery("content", firstBeg, firstEnd, true, true);
        ScoreDoc[] hits = searcher.search((Query)query, (int)1000).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should not be included.", (long)0L, (long)hits.length);
        query = new TermRangeQuery("content", secondBeg, secondEnd, true, true);
        hits = searcher.search((Query)query, (int)1000).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should be included.", (long)1L, (long)hits.length);
        reader.close();
        dir.close();
    }

    public void testFarsiTermRangeQuery(Analyzer analyzer, BytesRef firstBeg, BytesRef firstEnd, BytesRef secondBeg, BytesRef secondEnd) throws Exception {
        BaseDirectoryWrapper farsiIndex = CollationTestBase.newDirectory();
        IndexWriter writer = new IndexWriter((Directory)farsiIndex, new IndexWriterConfig(analyzer));
        Document doc = new Document();
        doc.add((IndexableField)new TextField("content", "\u0633\u0627\u0628", Field.Store.YES));
        doc.add((IndexableField)new StringField("body", "body", Field.Store.YES));
        writer.addDocument((Iterable)doc);
        writer.close();
        DirectoryReader reader = DirectoryReader.open((Directory)farsiIndex);
        IndexSearcher search = CollationTestBase.newSearcher((IndexReader)reader);
        TermRangeQuery csrq = new TermRangeQuery("content", firstBeg, firstEnd, true, true);
        ScoreDoc[] result = search.search((Query)csrq, (int)1000).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should not be included.", (long)0L, (long)result.length);
        csrq = new TermRangeQuery("content", secondBeg, secondEnd, true, true);
        result = search.search((Query)csrq, (int)1000).scoreDocs;
        CollationTestBase.assertEquals((String)"The index Term should be included.", (long)1L, (long)result.length);
        reader.close();
        farsiIndex.close();
    }

    private void assertMatches(IndexSearcher searcher, Query query, Sort sort, String expectedResult) throws IOException {
        ScoreDoc[] result = searcher.search((Query)query, (int)1000, (Sort)sort).scoreDocs;
        StringBuilder buff = new StringBuilder(10);
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            Document doc = searcher.doc(result[i].doc);
            IndexableField[] v = doc.getFields("tracer");
            for (int j = 0; j < v.length; ++j) {
                buff.append(v[j].stringValue());
            }
        }
        CollationTestBase.assertEquals((Object)expectedResult, (Object)buff.toString());
    }

    public void assertThreadSafe(final Analyzer analyzer) throws Exception {
        int i;
        int numTestPoints = 100;
        int numThreads = TestUtil.nextInt(CollationTestBase.random(), 3, 5);
        final HashMap<String, BytesRef> map = new HashMap<String, BytesRef>();
        for (int i2 = 0; i2 < numTestPoints; ++i2) {
            String term = TestUtil.randomSimpleString(CollationTestBase.random());
            try (TokenStream ts = analyzer.tokenStream("fake", term);){
                TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)ts.addAttribute(TermToBytesRefAttribute.class);
                ts.reset();
                CollationTestBase.assertTrue((boolean)ts.incrementToken());
                map.put(term, BytesRef.deepCopyOf((BytesRef)termAtt.getBytesRef()));
                CollationTestBase.assertFalse((boolean)ts.incrementToken());
                ts.end();
                continue;
            }
        }
        Thread[] threads = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        for (Map.Entry mapping : map.entrySet()) {
                            String term = (String)mapping.getKey();
                            BytesRef expected = (BytesRef)mapping.getValue();
                            TokenStream ts = analyzer.tokenStream("fake", term);
                            Throwable throwable = null;
                            try {
                                TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)ts.addAttribute(TermToBytesRefAttribute.class);
                                ts.reset();
                                Assert.assertTrue((boolean)ts.incrementToken());
                                Assert.assertEquals((Object)expected, (Object)termAtt.getBytesRef());
                                Assert.assertFalse((boolean)ts.incrementToken());
                                ts.end();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (ts == null) continue;
                                if (throwable != null) {
                                    try {
                                        ts.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                ts.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
    }
}

