/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;

public class SolrLogPostTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("");
            System.out.println("postlogs is a simple tool for indexing Solr logs.");
            System.out.println("");
            System.out.println("parameters:");
            System.out.println("");
            System.out.println("-- baseUrl: Example http://localhost:8983/solr/collection1");
            System.out.println("-- rootDir: All files found at or below the root will be indexed.");
            System.out.println("");
            System.out.println("Sample syntax 1: ./bin/postlogs http://localhost:8983/solr/collection1 /user/foo/logs/solr.log");
            System.out.println("Sample syntax 2: ./bin/postlogs http://localhost:8983/solr/collection1 /user/foo/logs");
            System.out.println("");
            return;
        }
        String baseUrl = args[0];
        String root = args[1];
        HttpSolrClient.Builder builder = new HttpSolrClient.Builder();
        try (HttpSolrClient client = null;){
            client = builder.withBaseSolrUrl(baseUrl).build();
            File rf = new File(root);
            ArrayList<File> files = new ArrayList<File>();
            SolrLogPostTool.gatherFiles(rf, files);
            int rec = 0;
            UpdateRequest request = new UpdateRequest();
            block8: for (File file : files) {
                try (BufferedReader bufferedReader = null;){
                    bufferedReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset()));
                    LogRecordReader recordReader = new LogRecordReader(bufferedReader);
                    SolrInputDocument doc = null;
                    String fileName = file.getName();
                    while (true) {
                        try {
                            doc = recordReader.readRecord();
                        }
                        catch (Throwable t) {
                            System.err.println("Error reading log record:" + ((LineNumberReader)bufferedReader).getLineNumber() + " from file:" + fileName);
                            System.err.println(t.getMessage());
                            continue;
                        }
                        if (doc == null) continue block8;
                        ++rec;
                        UUID id = UUID.randomUUID();
                        doc.addField("id", (Object)id.toString());
                        doc.addField("file_s", (Object)fileName);
                        request.add(doc);
                        if (rec != 300) continue;
                        System.out.println("Sending batch of 300 log records...");
                        request.process((SolrClient)client);
                        System.out.println("Batch sent");
                        request = new UpdateRequest();
                        rec = 0;
                    }
                }
            }
            if (rec > 0) {
                System.out.println("Sending last batch ...");
                request.process((SolrClient)client);
                client.commit();
                System.out.println("Committed");
            }
        }
    }

    static void gatherFiles(File rootFile, List<File> files) {
        if (rootFile.isFile()) {
            files.add(rootFile);
        } else {
            File[] subFiles;
            for (File f : subFiles = rootFile.listFiles()) {
                if (f.isFile()) {
                    files.add(f);
                    continue;
                }
                SolrLogPostTool.gatherFiles(f, files);
            }
        }
    }

    public static class LogRecordReader {
        private BufferedReader bufferedReader;
        private String pushedBack = null;
        private boolean finished = false;
        private String cause;
        private Pattern p = Pattern.compile("^(\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d[\\s|T]\\d\\d:\\d\\d\\:\\d\\d.\\d\\d\\d)");

        public LogRecordReader(BufferedReader bufferedReader) throws IOException {
            this.bufferedReader = bufferedReader;
        }

        public SolrInputDocument readRecord() throws IOException {
            block7: {
                String line;
                do {
                    line = null;
                    if (this.finished) {
                        return null;
                    }
                    if (this.pushedBack != null) {
                        line = this.pushedBack;
                        this.pushedBack = null;
                    } else {
                        line = this.bufferedReader.readLine();
                    }
                    if (line == null) break block7;
                    if (line.contains("Registered new searcher")) {
                        return this.parseNewSearch(line);
                    }
                    if (line.contains("path=/update")) {
                        return this.parseUpdate(line);
                    }
                    if (line.contains(" ERROR ")) {
                        this.cause = null;
                        return this.parseError(line, this.readTrace());
                    }
                    if (!line.contains("start commit")) continue;
                    return this.parseCommit(line);
                } while (!line.contains("QTime="));
                return this.parseQueryRecord(line);
            }
            return null;
        }

        private String readTrace() throws IOException {
            String line;
            StringBuilder buf = new StringBuilder();
            buf.append("%html ");
            while (true) {
                if ((line = this.bufferedReader.readLine()) == null) {
                    this.finished = true;
                    return buf.toString();
                }
                Matcher m = this.p.matcher(line);
                if (m.find() || buf.length() >= 10000) break;
                buf.append(line.replace("\t", "    ") + "<br/>");
                if (!line.startsWith("Caused by:")) continue;
                this.cause = line;
            }
            this.pushedBack = line;
            return buf.toString();
        }

        private String parseDate(String line) {
            Matcher m = this.p.matcher(line);
            if (m.find()) {
                String date = m.group(1);
                return date.replace(" ", "T");
            }
            return null;
        }

        private SolrInputDocument parseError(String line, String trace) throws IOException {
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            doc.addField("date_dt", (Object)this.parseDate(line));
            doc.addField("type_s", (Object)"error");
            doc.addField("line_t", (Object)line);
            if (trace != null && trace.length() > 6) {
                doc.addField("stack_t", (Object)trace);
            }
            if (this.cause != null) {
                doc.addField("root_cause_t", (Object)this.cause.replace("Caused by:", "").trim());
            }
            doc.addField("collection_s", (Object)this.parseCollection(line));
            doc.addField("core_s", (Object)this.parseCore(line));
            doc.addField("shard_s", (Object)this.parseShard(line));
            doc.addField("replica_s", (Object)this.parseReplica(line));
            return doc;
        }

        private SolrInputDocument parseCommit(String line) throws IOException {
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            doc.addField("date_dt", (Object)this.parseDate(line));
            doc.addField("type_s", (Object)"commit");
            doc.addField("line_t", (Object)line);
            if (line.contains("softCommit=true")) {
                doc.addField("soft_commit_s", (Object)"true");
            } else {
                doc.addField("soft_commit_s", (Object)"false");
            }
            if (line.contains("openSearcher=true")) {
                doc.addField("open_searcher_s", (Object)"true");
            } else {
                doc.addField("open_searcher_s", (Object)"false");
            }
            doc.addField("collection_s", (Object)this.parseCollection(line));
            doc.addField("core_s", (Object)this.parseCore(line));
            doc.addField("shard_s", (Object)this.parseShard(line));
            doc.addField("replica_s", (Object)this.parseReplica(line));
            return doc;
        }

        private SolrInputDocument parseQueryRecord(String line) throws IOException {
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            doc.addField("date_dt", (Object)this.parseDate(line));
            doc.addField("qtime_i", (Object)this.parseQTime(line));
            doc.addField("status_s", (Object)this.parseStatus(line));
            if (line.contains("hits=")) {
                doc.addField("hits_l", (Object)this.parseHits(line));
            }
            String params = this.parseParams(line);
            doc.addField("params_t", (Object)params);
            this.addParams(doc, params);
            doc.addField("collection_s", (Object)this.parseCollection(line));
            doc.addField("core_s", (Object)this.parseCore(line));
            doc.addField("node_s", (Object)this.parseNode(line));
            doc.addField("shard_s", (Object)this.parseShard(line));
            doc.addField("replica_s", (Object)this.parseReplica(line));
            String path = this.parsePath(line);
            doc.addField("path_s", (Object)path);
            if (path != null && path.contains("/admin")) {
                doc.addField("type_s", (Object)"admin");
            } else if (path != null && params.contains("/replication")) {
                doc.addField("type_s", (Object)"replication");
            } else {
                doc.addField("type_s", (Object)"query");
            }
            return doc;
        }

        private SolrInputDocument parseNewSearch(String line) {
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            doc.addField("date_dt", (Object)this.parseDate(line));
            doc.addField("core_s", (Object)this.parseNewSearcherCore(line));
            doc.addField("type_s", (Object)"newSearcher");
            doc.addField("line_t", (Object)line);
            return doc;
        }

        private String parseCollection(String line) {
            char[] ca = new char[]{' ', ']', ','};
            String[] parts = line.split("c:");
            if (parts.length >= 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private SolrInputDocument parseUpdate(String line) {
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            doc.addField("date_dt", (Object)this.parseDate(line));
            if (line.contains("deleteByQuery=")) {
                doc.addField("type_s", (Object)"deleteByQuery");
            } else if (line.contains("delete=")) {
                doc.addField("type_s", (Object)"delete");
            } else {
                doc.addField("type_s", (Object)"update");
            }
            doc.addField("collection_s", (Object)this.parseCollection(line));
            doc.addField("core_s", (Object)this.parseCore(line));
            doc.addField("shard_s", (Object)this.parseShard(line));
            doc.addField("replica_s", (Object)this.parseReplica(line));
            doc.addField("line_t", (Object)line);
            return doc;
        }

        private String parseNewSearcherCore(String line) {
            char[] ca = new char[]{']'};
            String[] parts = line.split("\\[");
            if (parts.length > 3) {
                return this.readUntil(parts[2], ca);
            }
            return null;
        }

        private String parseCore(String line) {
            char[] ca = new char[]{' ', ']', '}', ','};
            String[] parts = line.split("x:");
            if (parts.length >= 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseShard(String line) {
            char[] ca = new char[]{' ', ']', '}', ','};
            String[] parts = line.split("s:");
            if (parts.length >= 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseReplica(String line) {
            char[] ca = new char[]{' ', ']', '}', ','};
            String[] parts = line.split("r:");
            if (parts.length >= 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parsePath(String line) {
            char[] ca = new char[]{' '};
            String[] parts = line.split(" path=");
            if (parts.length == 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseQTime(String line) {
            char[] ca = new char[]{'\n', '\r'};
            String[] parts = line.split(" QTime=");
            if (parts.length == 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseNode(String line) {
            char[] ca = new char[]{' ', ']', '}', ','};
            String[] parts = line.split("node_name=n:");
            if (parts.length >= 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseStatus(String line) {
            char[] ca = new char[]{' ', '\n', '\r'};
            String[] parts = line.split(" status=");
            if (parts.length == 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseHits(String line) {
            char[] ca = new char[]{' '};
            String[] parts = line.split(" hits=");
            if (parts.length == 2) {
                return this.readUntil(parts[1], ca);
            }
            return null;
        }

        private String parseParams(String line) {
            char[] ca = new char[]{' '};
            String[] parts = line.split(" params=");
            if (parts.length == 2) {
                String p = this.readUntil(parts[1].substring(1), ca);
                return p.substring(0, p.length() - 1);
            }
            return null;
        }

        private String readUntil(String s, char[] chars) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                char a = s.charAt(i);
                for (char c : chars) {
                    if (a != c) continue;
                    return builder.toString();
                }
                builder.append(a);
            }
            return builder.toString();
        }

        private void addParams(SolrInputDocument doc, String params) throws IOException {
            String[] pairs;
            for (String pair : pairs = params.split("&")) {
                String[] parts = pair.split("=");
                if (parts.length == 2 && parts[0].equals("q")) {
                    String dq = URLDecoder.decode(parts[1], "UTF-8");
                    doc.addField("q_s", (Object)dq);
                    doc.addField("q_t", (Object)dq);
                }
                try {
                    String dr;
                    if (parts[0].equals("rows")) {
                        dr = URLDecoder.decode(parts[1], "UTF-8");
                        doc.addField("rows_i", (Object)dr);
                    }
                    if (parts[0].equals("distrib")) {
                        dr = URLDecoder.decode(parts[1], "UTF-8");
                        doc.addField("distrib_s", (Object)dr);
                    }
                    if (parts[0].equals("isShard")) {
                        dr = URLDecoder.decode(parts[1], "UTF-8");
                        doc.addField("isShard_s", (Object)dr);
                    }
                    if (parts[0].equals("shards")) {
                        doc.addField("shards_s", (Object)"true");
                    }
                    if (parts[0].equals("ids")) {
                        doc.addField("ids_s", (Object)"true");
                    }
                    if (parts[0].equals("wt")) {
                        dr = URLDecoder.decode(parts[1], "UTF-8");
                        doc.addField("wt_s", (Object)dr);
                    }
                    if (!parts[0].equals("facet")) continue;
                    dr = URLDecoder.decode(parts[1], "UTF-8");
                    doc.addField("facet_s", (Object)dr);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            if (doc.getField("distrib_s") == null) {
                doc.addField("distrib_s", (Object)"true");
            }
            if (doc.getField("shards_s") == null) {
                doc.addField("shards_s", (Object)"false");
            }
            if (doc.getField("ids_s") == null) {
                doc.addField("ids_s", (Object)"false");
            }
        }
    }
}

