/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.MultiValuedIntFieldSource;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.EnumFieldValue;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.AbstractEnumField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumFieldType
extends AbstractEnumField {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        return null;
    }

    @Override
    protected Query getSpecializedRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        Integer minValue = this.enumMapping.stringValueToIntValue(min);
        Integer maxValue = this.enumMapping.stringValueToIntValue(max);
        if (field.indexed()) {
            BytesRef minBytes = null;
            if (min != null) {
                byte[] bytes = new byte[4];
                NumericUtils.intToSortableBytes((int)minValue, (byte[])bytes, (int)0);
                minBytes = new BytesRef(bytes);
            }
            BytesRef maxBytes = null;
            if (max != null) {
                byte[] bytes = new byte[4];
                NumericUtils.intToSortableBytes((int)maxValue, (byte[])bytes, (int)0);
                maxBytes = new BytesRef(bytes);
            }
            return new TermRangeQuery(field.getName(), minBytes, maxBytes, minInclusive, maxInclusive);
        }
        long lowerValue = Long.MIN_VALUE;
        long upperValue = Long.MAX_VALUE;
        if (minValue != null) {
            lowerValue = minValue.longValue();
            if (!minInclusive) {
                ++lowerValue;
            }
        }
        if (maxValue != null) {
            upperValue = maxValue.longValue();
            if (!maxInclusive) {
                --upperValue;
            }
        }
        if (field.multiValued()) {
            return new ConstantScoreQuery(SortedNumericDocValuesField.newSlowRangeQuery((String)field.getName(), (long)lowerValue, (long)upperValue));
        }
        return new ConstantScoreQuery(NumericDocValuesField.newSlowRangeQuery((String)field.getName(), (long)lowerValue, (long)upperValue));
    }

    @Override
    public void readableToIndexed(CharSequence val, BytesRefBuilder result) {
        String s = val.toString();
        if (s == null) {
            return;
        }
        result.grow(4);
        result.setLength(4);
        Integer intValue = this.enumMapping.stringValueToIntValue(s);
        NumericUtils.intToSortableBytes((int)intValue, (byte[])result.bytes(), (int)0);
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        if (indexedForm == null) {
            return null;
        }
        BytesRef bytesRef = new BytesRef((CharSequence)indexedForm);
        Integer intValue = NumericUtils.sortableBytesToInt((byte[])bytesRef.bytes, (int)0);
        return this.enumMapping.intValueToStringValue(intValue);
    }

    @Override
    public CharsRef indexedToReadable(BytesRef input, CharsRefBuilder output) {
        Integer intValue = NumericUtils.sortableBytesToInt((byte[])input.bytes, (int)0);
        String stringValue = this.enumMapping.intValueToStringValue(intValue);
        output.grow(stringValue.length());
        output.setLength(stringValue.length());
        stringValue.getChars(0, output.length(), output.chars(), 0);
        return output.get();
    }

    public EnumFieldValue toObject(SchemaField sf, BytesRef term) {
        Integer intValue = NumericUtils.sortableBytesToInt((byte[])term.bytes, (int)0);
        String stringValue = this.enumMapping.intValueToStringValue(intValue);
        return new EnumFieldValue(intValue, stringValue);
    }

    @Override
    public String storedToIndexed(IndexableField f) {
        Number val = f.numericValue();
        if (val == null) {
            return null;
        }
        BytesRefBuilder bytes = new BytesRefBuilder();
        bytes.grow(4);
        bytes.setLength(4);
        NumericUtils.intToSortableBytes((int)val.intValue(), (byte[])bytes.bytes(), (int)0);
        return bytes.get().utf8ToString();
    }

    @Override
    public IndexableField createField(SchemaField field, Object value) {
        Integer intValue = this.enumMapping.stringValueToIntValue(value.toString());
        if (intValue == null || intValue.equals(AbstractEnumField.EnumMapping.DEFAULT_VALUE)) {
            String exceptionMessage = String.format(Locale.ENGLISH, "Unknown value for enum field: %s, value: %s", field.getName(), value.toString());
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, exceptionMessage);
        }
        FieldType newType = new FieldType();
        newType.setTokenized(false);
        newType.setStored(field.stored());
        newType.setOmitNorms(field.omitNorms());
        newType.setIndexOptions(field.indexOptions());
        newType.setStoreTermVectors(field.storeTermVector());
        newType.setStoreTermVectorOffsets(field.storeTermOffsets());
        newType.setStoreTermVectorPositions(field.storeTermPositions());
        newType.setStoreTermVectorPayloads(field.storeTermPayloads());
        byte[] bytes = new byte[4];
        NumericUtils.intToSortableBytes((int)intValue, (byte[])bytes, (int)0);
        return new Field(field.getName(), bytes, (IndexableFieldType)newType){

            public Number numericValue() {
                return NumericUtils.sortableBytesToInt((byte[])((BytesRef)this.fieldsData).bytes, (int)0);
            }
        };
    }

    @Override
    public List<IndexableField> createFields(SchemaField sf, Object value) {
        if (!sf.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, this.getClass().getSimpleName() + " requires docValues=\"true\".");
        }
        IndexableField field = this.createField(sf, value);
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
        fields.add(field);
        long longValue = field.numericValue().longValue();
        if (sf.multiValued()) {
            fields.add((IndexableField)new SortedNumericDocValuesField(sf.getName(), longValue));
        } else {
            fields.add((IndexableField)new NumericDocValuesField(sf.getName(), longValue));
        }
        return fields;
    }

    @Override
    public final ValueSource getSingleValueSource(FieldType.MultiValueSelector choice, SchemaField field, QParser parser) {
        if (!field.multiValued()) {
            return this.getValueSource(field, parser);
        }
        SortedNumericSelector.Type selectorType = choice.getSortedNumericSelectorType();
        if (null == selectorType) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, choice.toString() + " is not a supported option for picking a single value from the multivalued field: " + field.getName() + " (type: " + this.getTypeName() + ")");
        }
        return new MultiValuedIntFieldSource(field.getName(), selectorType);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        SortField result = this.getNumericSort(field, NumberType.INTEGER, top);
        if (null == result.getMissingValue()) {
            result.setMissingValue((Object)Integer.MIN_VALUE);
        }
        return result;
    }
}

