/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.cloud.ActiveReplicaWatcher;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.SolrCloseableLatch;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionStateWatcher;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddReplicaCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SKIP_NODE_ASSIGNMENT = "skipNodeAssignment";
    private final OverseerCollectionMessageHandler ocmh;

    public AddReplicaCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        this.addReplica(state, message, results, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<ZkNodeProps> addReplica(ClusterState clusterState, ZkNodeProps message, NamedList results, Runnable onComplete) throws IOException, InterruptedException, KeeperException {
        List createReplicas;
        int totalReplicas;
        boolean parallel;
        int timeout;
        String asyncId;
        boolean skipCreateReplicaInClusterState;
        boolean waitForFinalState;
        DocCollection coll;
        String collectionName;
        block16: {
            log.debug("addReplica() : {}", (Object)Utils.toJSONString((Object)message));
            String extCollectionName = message.getStr("collection");
            boolean followAliases = message.getBool("followAliases", false);
            String shard = message.getStr("shard");
            collectionName = followAliases ? this.ocmh.cloudManager.getClusterStateProvider().resolveSimpleAlias(extCollectionName) : extCollectionName;
            coll = clusterState.getCollection(collectionName);
            if (coll == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collectionName + " does not exist");
            }
            if (coll.getSlice(shard) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collectionName + " shard: " + shard + " does not exist");
            }
            waitForFinalState = message.getBool("waitForFinalState", false);
            skipCreateReplicaInClusterState = message.getBool("skipCreateReplicaInClusterState", false);
            asyncId = message.getStr("async");
            String node = message.getStr("node");
            String createNodeSetStr = message.getStr("createNodeSet");
            if (node != null && createNodeSetStr != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Both 'node' and 'createNodeSet' parameters cannot be specified together.");
            }
            timeout = message.getInt("timeout", Integer.valueOf(600));
            parallel = message.getBool("parallel", false);
            Replica.Type replicaType = Replica.Type.valueOf((String)message.getStr("type", Replica.Type.NRT.name()).toUpperCase(Locale.ROOT));
            EnumMap<Replica.Type, Integer> replicaTypesVsCount = new EnumMap<Replica.Type, Integer>(Replica.Type.class);
            replicaTypesVsCount.put(Replica.Type.NRT, message.getInt("nrtReplicas", Integer.valueOf(replicaType == Replica.Type.NRT ? 1 : 0)));
            replicaTypesVsCount.put(Replica.Type.TLOG, message.getInt("tlogReplicas", Integer.valueOf(replicaType == Replica.Type.TLOG ? 1 : 0)));
            replicaTypesVsCount.put(Replica.Type.PULL, message.getInt("pullReplicas", Integer.valueOf(replicaType == Replica.Type.PULL ? 1 : 0)));
            totalReplicas = 0;
            for (Map.Entry entry : replicaTypesVsCount.entrySet()) {
                totalReplicas += ((Integer)entry.getValue()).intValue();
            }
            if (totalReplicas > 1) {
                if (message.getStr("name") != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create " + totalReplicas + " replicas if 'name' parameter is specified");
                }
                if (message.getStr("coreNodeName") != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create " + totalReplicas + " replicas if 'coreNodeName' parameter is specified");
                }
            }
            AtomicReference<PolicyHelper.SessionWrapper> sessionWrapper = new AtomicReference<PolicyHelper.SessionWrapper>();
            try {
                createReplicas = AddReplicaCmd.buildReplicaPositions(this.ocmh.cloudManager, clusterState, collectionName, message, replicaTypesVsCount, sessionWrapper).stream().map(replicaPosition -> AddReplicaCmd.assignReplicaDetails(this.ocmh.cloudManager, clusterState, message, replicaPosition)).collect(Collectors.toList());
                if (sessionWrapper.get() == null) break block16;
            }
            catch (Throwable throwable) {
                if (sessionWrapper.get() == null) throw throwable;
                ((PolicyHelper.SessionWrapper)sessionWrapper.get()).release();
                throw throwable;
            }
            sessionWrapper.get().release();
        }
        ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler();
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        OverseerCollectionMessageHandler.ShardRequestTracker shardRequestTracker = this.ocmh.asyncRequestTracker(asyncId);
        for (CreateReplica createReplica2 : createReplicas) {
            assert (createReplica2.coreName != null);
            ModifiableSolrParams params = this.getReplicaParams(clusterState, message, results, collectionName, coll, skipCreateReplicaInClusterState, asyncId, shardHandler, createReplica2);
            shardRequestTracker.sendShardRequest(createReplica2.node, params, shardHandler);
        }
        Runnable runnable = () -> {
            shardRequestTracker.processResponses((NamedList<Object>)results, shardHandler, true, "ADDREPLICA failed to create replica");
            for (CreateReplica replica : createReplicas) {
                this.ocmh.waitForCoreNodeName(collectionName, replica.node, replica.coreName);
            }
            if (onComplete != null) {
                onComplete.run();
            }
        };
        if (parallel && !waitForFinalState) {
            this.ocmh.tpe.submit(runnable);
            return createReplicas.stream().map(createReplica -> new ZkNodeProps(new String[]{"collection", createReplica.collectionName, "shard", createReplica.sliceName, "core", createReplica.coreName, "node_name", createReplica.node})).collect(Collectors.toList());
        }
        if (!waitForFinalState) {
            runnable.run();
            return createReplicas.stream().map(createReplica -> new ZkNodeProps(new String[]{"collection", createReplica.collectionName, "shard", createReplica.sliceName, "core", createReplica.coreName, "node_name", createReplica.node})).collect(Collectors.toList());
        }
        SolrCloseableLatch latch = new SolrCloseableLatch(totalReplicas, (SolrCloseable)this.ocmh);
        ActiveReplicaWatcher watcher = new ActiveReplicaWatcher(collectionName, null, createReplicas.stream().map(createReplica -> createReplica.coreName).collect(Collectors.toList()), latch);
        try {
            zkStateReader.registerCollectionStateWatcher(collectionName, (CollectionStateWatcher)watcher);
            runnable.run();
            if (latch.await((long)timeout, TimeUnit.SECONDS)) return createReplicas.stream().map(createReplica -> new ZkNodeProps(new String[]{"collection", createReplica.collectionName, "shard", createReplica.sliceName, "core", createReplica.coreName, "node_name", createReplica.node})).collect(Collectors.toList());
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Timeout waiting " + timeout + " seconds for replica to become active.");
        }
        finally {
            zkStateReader.removeCollectionStateWatcher(collectionName, (CollectionStateWatcher)watcher);
        }
    }

    private ModifiableSolrParams getReplicaParams(ClusterState clusterState, ZkNodeProps message, NamedList results, String collectionName, DocCollection coll, boolean skipCreateReplicaInClusterState, String asyncId, ShardHandler shardHandler, CreateReplica createReplica) throws IOException, InterruptedException, KeeperException {
        if (coll.getStr("withCollection") != null) {
            String withCollectionName = coll.getStr("withCollection");
            DocCollection withCollection = clusterState.getCollection(withCollectionName);
            if (withCollection.getActiveSlices().size() > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The `withCollection` must have only one shard, found: " + withCollection.getActiveSlices().size());
            }
            String withCollectionShard = ((Slice)withCollection.getActiveSlices().iterator().next()).getName();
            List replicas = withCollection.getReplicas(createReplica.node);
            if (replicas == null || replicas.isEmpty()) {
                ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toString(), "collection", withCollectionName, "shard", withCollectionShard, "node", createReplica.node, SKIP_NODE_ASSIGNMENT, "true", "waitForFinalState", Boolean.TRUE.toString()});
                this.addReplica(clusterState, props, results, null);
            }
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        if (!Overseer.isLegacy(zkStateReader)) {
            if (!skipCreateReplicaInClusterState) {
                ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toLower(), "collection", collectionName, "shard", createReplica.sliceName, "core", createReplica.coreName, "state", Replica.State.DOWN.toString(), "base_url", zkStateReader.getBaseUrlForNodeName(createReplica.node), "node_name", createReplica.node, "type", createReplica.replicaType.name()});
                if (createReplica.coreNodeName != null) {
                    props = props.plus("core_node_name", (Object)createReplica.coreNodeName);
                }
                try {
                    this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)props));
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception updating Overseer state queue", (Throwable)e);
                }
            }
            params.set("coreNodeName", new String[]{this.ocmh.waitToSeeReplicasInState(collectionName, Collections.singletonList(createReplica.coreName)).get(createReplica.coreName).getName()});
        }
        String configName = zkStateReader.readConfigName(collectionName);
        String routeKey = message.getStr("_route_");
        String dataDir = message.getStr("dataDir");
        String ulogDir = message.getStr("ulogDir");
        String instanceDir = message.getStr("instanceDir");
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
        params.set("name", new String[]{createReplica.coreName});
        params.set("collection.configName", new String[]{configName});
        params.set("collection", new String[]{collectionName});
        params.set("replicaType", new String[]{createReplica.replicaType.name()});
        if (createReplica.sliceName != null) {
            params.set("shard", new String[]{createReplica.sliceName});
        } else if (routeKey != null) {
            Collection slices = coll.getRouter().getSearchSlicesSingle(routeKey, null, coll);
            if (slices.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active shard serving _route_=" + routeKey + " found");
            }
            params.set("shard", new String[]{((Slice)slices.iterator().next()).getName()});
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specify either 'shard' or _route_ param");
        }
        if (dataDir != null) {
            params.set("dataDir", new String[]{dataDir});
        }
        if (ulogDir != null) {
            params.set("ulogDir", new String[]{ulogDir});
        }
        if (instanceDir != null) {
            params.set("instanceDir", new String[]{instanceDir});
        }
        if (createReplica.coreNodeName != null) {
            params.set("coreNodeName", new String[]{createReplica.coreNodeName});
        }
        this.ocmh.addPropertyParams(message, params);
        return params;
    }

    public static CreateReplica assignReplicaDetails(SolrCloudManager cloudManager, ClusterState clusterState, ZkNodeProps message, ReplicaPosition replicaPosition) {
        boolean skipCreateReplicaInClusterState = message.getBool("skipCreateReplicaInClusterState", false);
        String collection = message.getStr("collection");
        String node = replicaPosition.node;
        String shard = message.getStr("shard");
        String coreName = message.getStr("name");
        String coreNodeName = message.getStr("coreNodeName");
        Replica.Type replicaType = replicaPosition.type;
        if (StringUtils.isBlank((CharSequence)coreName)) {
            coreName = message.getStr("property.name");
        }
        log.info("Node Identified {} for creating new replica of shard {} for collection {}", new Object[]{node, shard, collection});
        if (!clusterState.liveNodesContain(node)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Node: " + node + " is not live");
        }
        DocCollection coll = clusterState.getCollection(collection);
        if (coreName == null) {
            coreName = Assign.buildSolrCoreName(cloudManager.getDistribStateManager(), coll, shard, replicaType);
        } else if (!skipCreateReplicaInClusterState) {
            for (Slice slice : coll.getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    String replicaCoreName = replica.getStr("core");
                    if (!coreName.equals(replicaCoreName)) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Another replica with the same core name already exists for this collection");
                }
            }
        }
        log.info("Returning CreateReplica command.");
        return new CreateReplica(collection, shard, node, replicaType, coreName, coreNodeName);
    }

    public static List<ReplicaPosition> buildReplicaPositions(SolrCloudManager cloudManager, ClusterState clusterState, String collectionName, ZkNodeProps message, EnumMap<Replica.Type, Integer> replicaTypeVsCount, AtomicReference<PolicyHelper.SessionWrapper> sessionWrapper) throws IOException, InterruptedException {
        boolean skipCreateReplicaInClusterState = message.getBool("skipCreateReplicaInClusterState", false);
        boolean skipNodeAssignment = message.getBool(SKIP_NODE_ASSIGNMENT, false);
        String sliceName = message.getStr("shard");
        DocCollection collection = clusterState.getCollection(collectionName);
        int numNrtReplicas = replicaTypeVsCount.get(Replica.Type.NRT);
        int numPullReplicas = replicaTypeVsCount.get(Replica.Type.PULL);
        int numTlogReplicas = replicaTypeVsCount.get(Replica.Type.TLOG);
        int totalReplicas = numNrtReplicas + numPullReplicas + numTlogReplicas;
        String node = message.getStr("node");
        Object createNodeSetStr = message.get("createNodeSet");
        if (createNodeSetStr == null && node != null) {
            message.getProperties().put("createNodeSet", node);
            createNodeSetStr = node;
        }
        List<Object> positions = null;
        if (!skipCreateReplicaInClusterState && !skipNodeAssignment) {
            positions = Assign.getNodesForNewReplicas(clusterState, collection.getName(), sliceName, numNrtReplicas, numTlogReplicas, numPullReplicas, createNodeSetStr, cloudManager);
            sessionWrapper.set(PolicyHelper.getLastSessionWrapper((boolean)true));
        }
        if (positions == null) {
            assert (node != null);
            if (node == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "A node should have been identified to add replica but wasn't. Please inform solr developers at SOLR-9317");
            }
            positions = new ArrayList(totalReplicas);
            int i = 0;
            for (Map.Entry<Replica.Type, Integer> entry : replicaTypeVsCount.entrySet()) {
                for (int j = 0; j < entry.getValue(); ++j) {
                    positions.add(new ReplicaPosition(sliceName, i++, entry.getKey(), node));
                }
            }
        }
        return positions;
    }

    public static class CreateReplica {
        public final String collectionName;
        public final String sliceName;
        public final String node;
        public final Replica.Type replicaType;
        public String coreName;
        public String coreNodeName;

        CreateReplica(String collectionName, String sliceName, String node, Replica.Type replicaType, String coreName, String coreNodeName) {
            this.collectionName = collectionName;
            this.sliceName = sliceName;
            this.node = node;
            this.replicaType = replicaType;
            this.coreName = coreName;
            this.coreNodeName = coreNodeName;
        }
    }
}

