#!/usr/bin/env python
#
# printpackets:
# prints out packets from a pcap dump file with ether and ip header info
# and ip payload
#
# Usage: printpackets <pcap file>
#
# Copyright (C) 2007 Electronic Frontier Foundation
# Written November 2007 by Seth Schoen <schoen@eff.org>
#   and Steven Lucy <slucy@parallactic.com>
# Thanks to Peter Eckersley <pde@eff.org> and Fyodor
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 or version 3 of the
# License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

import pcapy, sys, binascii
from pcapdiff_helper import *

try:
    pcap_local = pcapy.open_offline(sys.argv[1])
except IndexError:
    print "Usage: %s <pcap file>" % sys.argv[0]
    sys.exit(1)

while 1:
    try:
	packet = pcap_local.next()
    except pcapy.PcapError:
	break
    
    print "------------------\n%s" % packet_to_string(parse_and_save(packet))
