"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_legend_items_1 = require("./get_legend_items");
var canvas_text_bbox_calculator_1 = require("../../utils/bbox/canvas_text_bbox_calculator");
var get_settings_specs_1 = require("./get_settings_specs");
var axis_utils_1 = require("../../chart_types/xy_chart/utils/axis_utils");
var get_chart_theme_1 = require("./get_chart_theme");
var legend_1 = require("../../chart_types/xy_chart/legend/legend");
var get_chart_id_1 = require("./get_chart_id");
var getParentDimensionSelector = function (state) { return state.parentDimensions; };
var legendItemLabelsSelector = re_reselect_1.default([get_settings_specs_1.getSettingsSpecSelector, get_legend_items_1.getLegendItemsSelector], function (settings, legendItems) {
    var labels = [];
    var showLegendDisplayValue = settings.showLegendDisplayValue;
    legendItems.forEach(function (item) {
        var labelY1 = legend_1.getItemLabel(item, 'y1');
        if (item.displayValue.formatted.y1 !== null) {
            labels.push("" + labelY1 + (showLegendDisplayValue ? item.displayValue.formatted.y1 : ''));
        }
        else {
            labels.push(labelY1);
        }
        if (item.banded) {
            var labelY0 = legend_1.getItemLabel(item, 'y0');
            if (item.displayValue.formatted.y0 !== null) {
                labels.push("" + labelY0 + (showLegendDisplayValue ? item.displayValue.formatted.y0 : ''));
            }
            else {
                labels.push(labelY0);
            }
        }
    });
    return labels;
})(get_chart_id_1.getChartIdSelector);
var MARKER_WIDTH = 16;
// const MARKER_HEIGHT = 16;
var MARKER_LEFT_MARGIN = 4;
var VALUE_LEFT_MARGIN = 4;
var VERTICAL_PADDING = 4;
exports.getLegendSizeSelector = re_reselect_1.default([get_settings_specs_1.getSettingsSpecSelector, get_chart_theme_1.getChartThemeSelector, getParentDimensionSelector, legendItemLabelsSelector], function (settings, theme, parentDimensions, labels) {
    var bboxCalculator = new canvas_text_bbox_calculator_1.CanvasTextBBoxCalculator();
    var bbox = labels.reduce(function (acc, label) {
        var bbox = bboxCalculator.compute(label, 1, 12, '"Inter UI", -apple-system, BlinkMacSystemFont, "Segoe UI", Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol"', 1.5, 400);
        if (acc.height < bbox.height) {
            acc.height = bbox.height;
        }
        if (acc.width < bbox.width) {
            acc.width = bbox.width;
        }
        return acc;
    }, { width: 0, height: 0 });
    bboxCalculator.destroy();
    var showLegend = settings.showLegend, showLegendDisplayValue = settings.showLegendDisplayValue, legendPosition = settings.legendPosition;
    var _a = theme.legend, verticalWidth = _a.verticalWidth, spacingBuffer = _a.spacingBuffer;
    if (!showLegend) {
        return { width: 0, height: 0 };
    }
    var legendItemWidth = MARKER_WIDTH + MARKER_LEFT_MARGIN + bbox.width + (showLegendDisplayValue ? VALUE_LEFT_MARGIN : 0);
    if (axis_utils_1.isVerticalAxis(legendPosition)) {
        var legendItemHeight = bbox.height + VERTICAL_PADDING * 2;
        return {
            width: Math.floor(Math.min(legendItemWidth + spacingBuffer, verticalWidth)),
            height: legendItemHeight,
        };
    }
    else {
        var isSingleLine = (parentDimensions.width - 20) / 200 > labels.length;
        return {
            height: isSingleLine ? bbox.height + 16 : bbox.height * 2 + 24,
            width: Math.floor(Math.min(legendItemWidth + spacingBuffer, verticalWidth)),
        };
    }
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_legend_size.js.map